package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RegistrationAuthMethod;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "authMethods", 
    "isCapable", 
    "isEnabled", 
    "isMfaRegistered", 
    "isRegistered", 
    "userDisplayName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class CredentialUserRegistrationDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.credentialUserRegistrationDetails";
    }

    @JsonProperty("authMethods")
    protected List<RegistrationAuthMethod> authMethods;

    @JsonProperty("authMethods@nextLink")
    protected String authMethodsNextLink;

    @JsonProperty("isCapable")
    protected Boolean isCapable;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("isMfaRegistered")
    protected Boolean isMfaRegistered;

    @JsonProperty("isRegistered")
    protected Boolean isRegistered;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected CredentialUserRegistrationDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCredentialUserRegistrationDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<RegistrationAuthMethod> authMethods;
        private String authMethodsNextLink;
        private Boolean isCapable;
        private Boolean isEnabled;
        private Boolean isMfaRegistered;
        private Boolean isRegistered;
        private String userDisplayName;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authMethods(List<RegistrationAuthMethod> authMethods) {
            this.authMethods = authMethods;
            this.changedFields = changedFields.add("authMethods");
            return this;
        }

        public Builder authMethods(RegistrationAuthMethod... authMethods) {
            return authMethods(Arrays.asList(authMethods));
        }

        public Builder authMethodsNextLink(String authMethodsNextLink) {
            this.authMethodsNextLink = authMethodsNextLink;
            this.changedFields = changedFields.add("authMethods");
            return this;
        }

        public Builder isCapable(Boolean isCapable) {
            this.isCapable = isCapable;
            this.changedFields = changedFields.add("isCapable");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder isMfaRegistered(Boolean isMfaRegistered) {
            this.isMfaRegistered = isMfaRegistered;
            this.changedFields = changedFields.add("isMfaRegistered");
            return this;
        }

        public Builder isRegistered(Boolean isRegistered) {
            this.isRegistered = isRegistered;
            this.changedFields = changedFields.add("isRegistered");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public CredentialUserRegistrationDetails build() {
            CredentialUserRegistrationDetails _x = new CredentialUserRegistrationDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.credentialUserRegistrationDetails";
            _x.id = id;
            _x.authMethods = authMethods;
            _x.authMethodsNextLink = authMethodsNextLink;
            _x.isCapable = isCapable;
            _x.isEnabled = isEnabled;
            _x.isMfaRegistered = isMfaRegistered;
            _x.isRegistered = isRegistered;
            _x.userDisplayName = userDisplayName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authMethods")
    @JsonIgnore
    public CollectionPage<RegistrationAuthMethod> getAuthMethods() {
        return new CollectionPage<RegistrationAuthMethod>(contextPath, RegistrationAuthMethod.class, this.authMethods, Optional.ofNullable(authMethodsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public CredentialUserRegistrationDetails withAuthMethods(List<RegistrationAuthMethod> authMethods) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("authMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.authMethods = authMethods;
        return _x;
    }

    @Property(name="authMethods")
    @JsonIgnore
    public CollectionPage<RegistrationAuthMethod> getAuthMethods(HttpRequestOptions options) {
        return new CollectionPage<RegistrationAuthMethod>(contextPath, RegistrationAuthMethod.class, this.authMethods, Optional.ofNullable(authMethodsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isCapable")
    @JsonIgnore
    public Optional<Boolean> getIsCapable() {
        return Optional.ofNullable(isCapable);
    }

    public CredentialUserRegistrationDetails withIsCapable(Boolean isCapable) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("isCapable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.isCapable = isCapable;
        return _x;
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public CredentialUserRegistrationDetails withIsEnabled(Boolean isEnabled) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="isMfaRegistered")
    @JsonIgnore
    public Optional<Boolean> getIsMfaRegistered() {
        return Optional.ofNullable(isMfaRegistered);
    }

    public CredentialUserRegistrationDetails withIsMfaRegistered(Boolean isMfaRegistered) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("isMfaRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.isMfaRegistered = isMfaRegistered;
        return _x;
    }

    @Property(name="isRegistered")
    @JsonIgnore
    public Optional<Boolean> getIsRegistered() {
        return Optional.ofNullable(isRegistered);
    }

    public CredentialUserRegistrationDetails withIsRegistered(Boolean isRegistered) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("isRegistered");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.isRegistered = isRegistered;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public CredentialUserRegistrationDetails withUserDisplayName(String userDisplayName) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public CredentialUserRegistrationDetails withUserPrincipalName(String userPrincipalName) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUserRegistrationDetails");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public CredentialUserRegistrationDetails withUnmappedField(String name, Object value) {
        CredentialUserRegistrationDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUserRegistrationDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUserRegistrationDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CredentialUserRegistrationDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CredentialUserRegistrationDetails _copy() {
        CredentialUserRegistrationDetails _x = new CredentialUserRegistrationDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authMethods = authMethods;
        _x.isCapable = isCapable;
        _x.isEnabled = isEnabled;
        _x.isMfaRegistered = isMfaRegistered;
        _x.isRegistered = isRegistered;
        _x.userDisplayName = userDisplayName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CredentialUserRegistrationDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authMethods=");
        b.append(this.authMethods);
        b.append(", ");
        b.append("isCapable=");
        b.append(this.isCapable);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("isMfaRegistered=");
        b.append(this.isMfaRegistered);
        b.append(", ");
        b.append("isRegistered=");
        b.append(this.isRegistered);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
