package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.FeatureType;
import odata.msgraph.client.beta.enums.UsageAuthMethod;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "authMethod", 
    "failureActivityCount", 
    "feature", 
    "successfulActivityCount"})
@JsonInclude(Include.NON_NULL)
public class CredentialUsageSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.credentialUsageSummary";
    }

    @JsonProperty("authMethod")
    protected UsageAuthMethod authMethod;

    @JsonProperty("failureActivityCount")
    protected Long failureActivityCount;

    @JsonProperty("feature")
    protected FeatureType feature;

    @JsonProperty("successfulActivityCount")
    protected Long successfulActivityCount;

    protected CredentialUsageSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCredentialUsageSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UsageAuthMethod authMethod;
        private Long failureActivityCount;
        private FeatureType feature;
        private Long successfulActivityCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authMethod(UsageAuthMethod authMethod) {
            this.authMethod = authMethod;
            this.changedFields = changedFields.add("authMethod");
            return this;
        }

        public Builder failureActivityCount(Long failureActivityCount) {
            this.failureActivityCount = failureActivityCount;
            this.changedFields = changedFields.add("failureActivityCount");
            return this;
        }

        public Builder feature(FeatureType feature) {
            this.feature = feature;
            this.changedFields = changedFields.add("feature");
            return this;
        }

        public Builder successfulActivityCount(Long successfulActivityCount) {
            this.successfulActivityCount = successfulActivityCount;
            this.changedFields = changedFields.add("successfulActivityCount");
            return this;
        }

        public CredentialUsageSummary build() {
            CredentialUsageSummary _x = new CredentialUsageSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.credentialUsageSummary";
            _x.id = id;
            _x.authMethod = authMethod;
            _x.failureActivityCount = failureActivityCount;
            _x.feature = feature;
            _x.successfulActivityCount = successfulActivityCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="authMethod")
    @JsonIgnore
    public Optional<UsageAuthMethod> getAuthMethod() {
        return Optional.ofNullable(authMethod);
    }

    public CredentialUsageSummary withAuthMethod(UsageAuthMethod authMethod) {
        CredentialUsageSummary _x = _copy();
        _x.changedFields = changedFields.add("authMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUsageSummary");
        _x.authMethod = authMethod;
        return _x;
    }

    @Property(name="failureActivityCount")
    @JsonIgnore
    public Optional<Long> getFailureActivityCount() {
        return Optional.ofNullable(failureActivityCount);
    }

    public CredentialUsageSummary withFailureActivityCount(Long failureActivityCount) {
        CredentialUsageSummary _x = _copy();
        _x.changedFields = changedFields.add("failureActivityCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUsageSummary");
        _x.failureActivityCount = failureActivityCount;
        return _x;
    }

    @Property(name="feature")
    @JsonIgnore
    public Optional<FeatureType> getFeature() {
        return Optional.ofNullable(feature);
    }

    public CredentialUsageSummary withFeature(FeatureType feature) {
        CredentialUsageSummary _x = _copy();
        _x.changedFields = changedFields.add("feature");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUsageSummary");
        _x.feature = feature;
        return _x;
    }

    @Property(name="successfulActivityCount")
    @JsonIgnore
    public Optional<Long> getSuccessfulActivityCount() {
        return Optional.ofNullable(successfulActivityCount);
    }

    public CredentialUsageSummary withSuccessfulActivityCount(Long successfulActivityCount) {
        CredentialUsageSummary _x = _copy();
        _x.changedFields = changedFields.add("successfulActivityCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.credentialUsageSummary");
        _x.successfulActivityCount = successfulActivityCount;
        return _x;
    }

    public CredentialUsageSummary withUnmappedField(String name, Object value) {
        CredentialUsageSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUsageSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CredentialUsageSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CredentialUsageSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CredentialUsageSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CredentialUsageSummary _copy() {
        CredentialUsageSummary _x = new CredentialUsageSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authMethod = authMethod;
        _x.failureActivityCount = failureActivityCount;
        _x.feature = feature;
        _x.successfulActivityCount = successfulActivityCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CredentialUsageSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authMethod=");
        b.append(this.authMethod);
        b.append(", ");
        b.append("failureActivityCount=");
        b.append(this.failureActivityCount);
        b.append(", ");
        b.append("feature=");
        b.append(this.feature);
        b.append(", ");
        b.append("successfulActivityCount=");
        b.append(this.successfulActivityCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
