package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CountryLookupMethodType;

@JsonPropertyOrder({
    "@odata.type", 
    "countriesAndRegions", 
    "countryLookupMethod", 
    "includeUnknownCountriesAndRegions"})
@JsonInclude(Include.NON_NULL)
public class CountryNamedLocation extends NamedLocation implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.countryNamedLocation";
    }

    @JsonProperty("countriesAndRegions")
    protected List<String> countriesAndRegions;

    @JsonProperty("countriesAndRegions@nextLink")
    protected String countriesAndRegionsNextLink;

    @JsonProperty("countryLookupMethod")
    protected CountryLookupMethodType countryLookupMethod;

    @JsonProperty("includeUnknownCountriesAndRegions")
    protected Boolean includeUnknownCountriesAndRegions;

    protected CountryNamedLocation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCountryNamedLocation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime modifiedDateTime;
        private List<String> countriesAndRegions;
        private String countriesAndRegionsNextLink;
        private CountryLookupMethodType countryLookupMethod;
        private Boolean includeUnknownCountriesAndRegions;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder countriesAndRegions(List<String> countriesAndRegions) {
            this.countriesAndRegions = countriesAndRegions;
            this.changedFields = changedFields.add("countriesAndRegions");
            return this;
        }

        public Builder countriesAndRegions(String... countriesAndRegions) {
            return countriesAndRegions(Arrays.asList(countriesAndRegions));
        }

        public Builder countriesAndRegionsNextLink(String countriesAndRegionsNextLink) {
            this.countriesAndRegionsNextLink = countriesAndRegionsNextLink;
            this.changedFields = changedFields.add("countriesAndRegions");
            return this;
        }

        public Builder countryLookupMethod(CountryLookupMethodType countryLookupMethod) {
            this.countryLookupMethod = countryLookupMethod;
            this.changedFields = changedFields.add("countryLookupMethod");
            return this;
        }

        public Builder includeUnknownCountriesAndRegions(Boolean includeUnknownCountriesAndRegions) {
            this.includeUnknownCountriesAndRegions = includeUnknownCountriesAndRegions;
            this.changedFields = changedFields.add("includeUnknownCountriesAndRegions");
            return this;
        }

        public CountryNamedLocation build() {
            CountryNamedLocation _x = new CountryNamedLocation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.countryNamedLocation";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.modifiedDateTime = modifiedDateTime;
            _x.countriesAndRegions = countriesAndRegions;
            _x.countriesAndRegionsNextLink = countriesAndRegionsNextLink;
            _x.countryLookupMethod = countryLookupMethod;
            _x.includeUnknownCountriesAndRegions = includeUnknownCountriesAndRegions;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="countriesAndRegions")
    @JsonIgnore
    public CollectionPage<String> getCountriesAndRegions() {
        return new CollectionPage<String>(contextPath, String.class, this.countriesAndRegions, Optional.ofNullable(countriesAndRegionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public CountryNamedLocation withCountriesAndRegions(List<String> countriesAndRegions) {
        CountryNamedLocation _x = _copy();
        _x.changedFields = changedFields.add("countriesAndRegions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.countryNamedLocation");
        _x.countriesAndRegions = countriesAndRegions;
        return _x;
    }

    @Property(name="countriesAndRegions")
    @JsonIgnore
    public CollectionPage<String> getCountriesAndRegions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.countriesAndRegions, Optional.ofNullable(countriesAndRegionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="countryLookupMethod")
    @JsonIgnore
    public Optional<CountryLookupMethodType> getCountryLookupMethod() {
        return Optional.ofNullable(countryLookupMethod);
    }

    public CountryNamedLocation withCountryLookupMethod(CountryLookupMethodType countryLookupMethod) {
        CountryNamedLocation _x = _copy();
        _x.changedFields = changedFields.add("countryLookupMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.countryNamedLocation");
        _x.countryLookupMethod = countryLookupMethod;
        return _x;
    }

    @Property(name="includeUnknownCountriesAndRegions")
    @JsonIgnore
    public Optional<Boolean> getIncludeUnknownCountriesAndRegions() {
        return Optional.ofNullable(includeUnknownCountriesAndRegions);
    }

    public CountryNamedLocation withIncludeUnknownCountriesAndRegions(Boolean includeUnknownCountriesAndRegions) {
        CountryNamedLocation _x = _copy();
        _x.changedFields = changedFields.add("includeUnknownCountriesAndRegions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.countryNamedLocation");
        _x.includeUnknownCountriesAndRegions = includeUnknownCountriesAndRegions;
        return _x;
    }

    public CountryNamedLocation withUnmappedField(String name, Object value) {
        CountryNamedLocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CountryNamedLocation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CountryNamedLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CountryNamedLocation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CountryNamedLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CountryNamedLocation _copy() {
        CountryNamedLocation _x = new CountryNamedLocation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.modifiedDateTime = modifiedDateTime;
        _x.countriesAndRegions = countriesAndRegions;
        _x.countryLookupMethod = countryLookupMethod;
        _x.includeUnknownCountriesAndRegions = includeUnknownCountriesAndRegions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CountryNamedLocation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("countriesAndRegions=");
        b.append(this.countriesAndRegions);
        b.append(", ");
        b.append("countryLookupMethod=");
        b.append(this.countryLookupMethod);
        b.append(", ");
        b.append("includeUnknownCountriesAndRegions=");
        b.append(this.includeUnknownCountriesAndRegions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
