package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ConversationThreadCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "hasAttachments", 
    "lastDeliveredDateTime", 
    "preview", 
    "topic", 
    "uniqueSenders", 
    "threads"})
@JsonInclude(Include.NON_NULL)
public class Conversation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conversation";
    }

    @JsonProperty("hasAttachments")
    protected Boolean hasAttachments;

    @JsonProperty("lastDeliveredDateTime")
    protected OffsetDateTime lastDeliveredDateTime;

    @JsonProperty("preview")
    protected String preview;

    @JsonProperty("topic")
    protected String topic;

    @JsonProperty("uniqueSenders")
    protected List<String> uniqueSenders;

    @JsonProperty("uniqueSenders@nextLink")
    protected String uniqueSendersNextLink;

    @JsonProperty("threads")
    protected List<ConversationThread> threads;

    protected Conversation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConversation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean hasAttachments;
        private OffsetDateTime lastDeliveredDateTime;
        private String preview;
        private String topic;
        private List<String> uniqueSenders;
        private String uniqueSendersNextLink;
        private List<ConversationThread> threads;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("hasAttachments");
            return this;
        }

        public Builder lastDeliveredDateTime(OffsetDateTime lastDeliveredDateTime) {
            this.lastDeliveredDateTime = lastDeliveredDateTime;
            this.changedFields = changedFields.add("lastDeliveredDateTime");
            return this;
        }

        public Builder preview(String preview) {
            this.preview = preview;
            this.changedFields = changedFields.add("preview");
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            this.changedFields = changedFields.add("topic");
            return this;
        }

        public Builder uniqueSenders(List<String> uniqueSenders) {
            this.uniqueSenders = uniqueSenders;
            this.changedFields = changedFields.add("uniqueSenders");
            return this;
        }

        public Builder uniqueSenders(String... uniqueSenders) {
            return uniqueSenders(Arrays.asList(uniqueSenders));
        }

        public Builder uniqueSendersNextLink(String uniqueSendersNextLink) {
            this.uniqueSendersNextLink = uniqueSendersNextLink;
            this.changedFields = changedFields.add("uniqueSenders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param threads
         *            value of {@code threads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder threads(List<ConversationThread> threads) {
            this.threads = threads;
            this.changedFields = changedFields.add("threads");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param threads
         *            value of {@code threads} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder threads(ConversationThread... threads) {
            return threads(Arrays.asList(threads));
        }

        public Conversation build() {
            Conversation _x = new Conversation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conversation";
            _x.id = id;
            _x.hasAttachments = hasAttachments;
            _x.lastDeliveredDateTime = lastDeliveredDateTime;
            _x.preview = preview;
            _x.topic = topic;
            _x.uniqueSenders = uniqueSenders;
            _x.uniqueSendersNextLink = uniqueSendersNextLink;
            _x.threads = threads;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="hasAttachments")
    @JsonIgnore
    public Optional<Boolean> getHasAttachments() {
        return Optional.ofNullable(hasAttachments);
    }

    public Conversation withHasAttachments(Boolean hasAttachments) {
        Conversation _x = _copy();
        _x.changedFields = changedFields.add("hasAttachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversation");
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Property(name="lastDeliveredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDeliveredDateTime() {
        return Optional.ofNullable(lastDeliveredDateTime);
    }

    public Conversation withLastDeliveredDateTime(OffsetDateTime lastDeliveredDateTime) {
        Conversation _x = _copy();
        _x.changedFields = changedFields.add("lastDeliveredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversation");
        _x.lastDeliveredDateTime = lastDeliveredDateTime;
        return _x;
    }

    @Property(name="preview")
    @JsonIgnore
    public Optional<String> getPreview() {
        return Optional.ofNullable(preview);
    }

    public Conversation withPreview(String preview) {
        Conversation _x = _copy();
        _x.changedFields = changedFields.add("preview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversation");
        _x.preview = preview;
        return _x;
    }

    @Property(name="topic")
    @JsonIgnore
    public Optional<String> getTopic() {
        return Optional.ofNullable(topic);
    }

    public Conversation withTopic(String topic) {
        Conversation _x = _copy();
        _x.changedFields = changedFields.add("topic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversation");
        _x.topic = topic;
        return _x;
    }

    @Property(name="uniqueSenders")
    @JsonIgnore
    public CollectionPage<String> getUniqueSenders() {
        return new CollectionPage<String>(contextPath, String.class, this.uniqueSenders, Optional.ofNullable(uniqueSendersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Conversation withUniqueSenders(List<String> uniqueSenders) {
        Conversation _x = _copy();
        _x.changedFields = changedFields.add("uniqueSenders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversation");
        _x.uniqueSenders = uniqueSenders;
        return _x;
    }

    @Property(name="uniqueSenders")
    @JsonIgnore
    public CollectionPage<String> getUniqueSenders(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.uniqueSenders, Optional.ofNullable(uniqueSendersNextLink), Collections.emptyList(), options);
    }

    public Conversation withUnmappedField(String name, Object value) {
        Conversation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property threads
     */
    @NavigationProperty(name="threads")
    @JsonIgnore
    public ConversationThreadCollectionRequest getThreads() {
        return new ConversationThreadCollectionRequest(
                        contextPath.addSegment("threads"), Optional.ofNullable(threads));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code threads} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param threads
     *            new value of {@code threads} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code threads} field changed
     */
    public Conversation withThreads(List<ConversationThread> threads) {
        Conversation _x = _copy();
        _x.changedFields = changedFields.add("threads");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversation");
        _x.threads = threads;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Conversation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Conversation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Conversation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Conversation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Conversation _copy() {
        Conversation _x = new Conversation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.hasAttachments = hasAttachments;
        _x.lastDeliveredDateTime = lastDeliveredDateTime;
        _x.preview = preview;
        _x.topic = topic;
        _x.uniqueSenders = uniqueSenders;
        _x.threads = threads;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Conversation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("hasAttachments=");
        b.append(this.hasAttachments);
        b.append(", ");
        b.append("lastDeliveredDateTime=");
        b.append(this.lastDeliveredDateTime);
        b.append(", ");
        b.append("preview=");
        b.append(this.preview);
        b.append(", ");
        b.append("topic=");
        b.append(this.topic);
        b.append(", ");
        b.append("uniqueSenders=");
        b.append(this.uniqueSenders);
        b.append(", ");
        b.append("threads=");
        b.append(this.threads);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
