package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "contractType", 
    "customerId", 
    "defaultDomainName", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class Contract extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contract";
    }

    @JsonProperty("contractType")
    protected String contractType;

    @JsonProperty("customerId")
    protected UUID customerId;

    @JsonProperty("defaultDomainName")
    protected String defaultDomainName;

    @JsonProperty("displayName")
    protected String displayName;

    protected Contract() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContract() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String contractType;
        private UUID customerId;
        private String defaultDomainName;
        private String displayName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder contractType(String contractType) {
            this.contractType = contractType;
            this.changedFields = changedFields.add("contractType");
            return this;
        }

        public Builder customerId(UUID customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder defaultDomainName(String defaultDomainName) {
            this.defaultDomainName = defaultDomainName;
            this.changedFields = changedFields.add("defaultDomainName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Contract build() {
            Contract _x = new Contract();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.contract";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.contractType = contractType;
            _x.customerId = customerId;
            _x.defaultDomainName = defaultDomainName;
            _x.displayName = displayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="contractType")
    @JsonIgnore
    public Optional<String> getContractType() {
        return Optional.ofNullable(contractType);
    }

    public Contract withContractType(String contractType) {
        Contract _x = _copy();
        _x.changedFields = changedFields.add("contractType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contract");
        _x.contractType = contractType;
        return _x;
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<UUID> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public Contract withCustomerId(UUID customerId) {
        Contract _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contract");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="defaultDomainName")
    @JsonIgnore
    public Optional<String> getDefaultDomainName() {
        return Optional.ofNullable(defaultDomainName);
    }

    public Contract withDefaultDomainName(String defaultDomainName) {
        Contract _x = _copy();
        _x.changedFields = changedFields.add("defaultDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contract");
        _x.defaultDomainName = defaultDomainName;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Contract withDisplayName(String displayName) {
        Contract _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contract");
        _x.displayName = displayName;
        return _x;
    }

    public Contract withUnmappedField(String name, Object value) {
        Contract _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Contract patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Contract _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Contract put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Contract _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Contract _copy() {
        Contract _x = new Contract();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.contractType = contractType;
        _x.customerId = customerId;
        _x.defaultDomainName = defaultDomainName;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Contract[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("contractType=");
        b.append(this.contractType);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("defaultDomainName=");
        b.append(this.defaultDomainName);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
