package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PublicError;
import odata.msgraph.client.beta.enums.ConnectionOperationStatus;


/**
 * <p>
 * <b>Org.OData.Core.V1.Revisions</b>
 */@JsonPropertyOrder({
    "@odata.type", 
    "error", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ConnectionOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.connectionOperation";
    }

    @JsonProperty("error")
    protected PublicError error;

    @JsonProperty("status")
    protected ConnectionOperationStatus status;

    protected ConnectionOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnectionOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PublicError error;
        private ConnectionOperationStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder error(PublicError error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder status(ConnectionOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ConnectionOperation build() {
            ConnectionOperation _x = new ConnectionOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.connectionOperation";
            _x.id = id;
            _x.error = error;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<PublicError> getError() {
        return Optional.ofNullable(error);
    }

    public ConnectionOperation withError(PublicError error) {
        ConnectionOperation _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectionOperation");
        _x.error = error;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ConnectionOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ConnectionOperation withStatus(ConnectionOperationStatus status) {
        ConnectionOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectionOperation");
        _x.status = status;
        return _x;
    }

    public ConnectionOperation withUnmappedField(String name, Object value) {
        ConnectionOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConnectionOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ConnectionOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConnectionOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ConnectionOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ConnectionOperation _copy() {
        ConnectionOperation _x = new ConnectionOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.error = error;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConnectionOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
