package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“A ConfigManager defined collection of devices or users.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "collectionIdentifier", 
    "createdDateTime", 
    "displayName", 
    "hierarchyIdentifier", 
    "hierarchyName", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class ConfigManagerCollection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configManagerCollection";
    }

    @JsonProperty("collectionIdentifier")
    protected String collectionIdentifier;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("hierarchyIdentifier")
    protected String hierarchyIdentifier;

    @JsonProperty("hierarchyName")
    protected String hierarchyName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected ConfigManagerCollection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConfigManagerCollection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String collectionIdentifier;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private String hierarchyIdentifier;
        private String hierarchyName;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The collection identifier in SCCM.”</i>
         * 
         * @param collectionIdentifier
         *            value of {@code collectionIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder collectionIdentifier(String collectionIdentifier) {
            this.collectionIdentifier = collectionIdentifier;
            this.changedFields = changedFields.add("collectionIdentifier");
            return this;
        }

        /**
         * <i>“The created date.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The DisplayName.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The Hierarchy Identifier.”</i>
         * 
         * @param hierarchyIdentifier
         *            value of {@code hierarchyIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hierarchyIdentifier(String hierarchyIdentifier) {
            this.hierarchyIdentifier = hierarchyIdentifier;
            this.changedFields = changedFields.add("hierarchyIdentifier");
            return this;
        }

        /**
         * <i>“The HierarchyName.”</i>
         * 
         * @param hierarchyName
         *            value of {@code hierarchyName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hierarchyName(String hierarchyName) {
            this.hierarchyName = hierarchyName;
            this.changedFields = changedFields.add("hierarchyName");
            return this;
        }

        /**
         * <i>“The last modified date.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public ConfigManagerCollection build() {
            ConfigManagerCollection _x = new ConfigManagerCollection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.configManagerCollection";
            _x.id = id;
            _x.collectionIdentifier = collectionIdentifier;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.hierarchyIdentifier = hierarchyIdentifier;
            _x.hierarchyName = hierarchyName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The collection identifier in SCCM.”</i>
     * 
     * @return property collectionIdentifier
     */
    @Property(name="collectionIdentifier")
    @JsonIgnore
    public Optional<String> getCollectionIdentifier() {
        return Optional.ofNullable(collectionIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * collectionIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The collection identifier in SCCM.”</i>
     * 
     * @param collectionIdentifier
     *            new value of {@code collectionIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code collectionIdentifier} field changed
     */
    public ConfigManagerCollection withCollectionIdentifier(String collectionIdentifier) {
        ConfigManagerCollection _x = _copy();
        _x.changedFields = changedFields.add("collectionIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerCollection");
        _x.collectionIdentifier = collectionIdentifier;
        return _x;
    }

    /**
     * <i>“The created date.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The created date.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public ConfigManagerCollection withCreatedDateTime(OffsetDateTime createdDateTime) {
        ConfigManagerCollection _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerCollection");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The DisplayName.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The DisplayName.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public ConfigManagerCollection withDisplayName(String displayName) {
        ConfigManagerCollection _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerCollection");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The Hierarchy Identifier.”</i>
     * 
     * @return property hierarchyIdentifier
     */
    @Property(name="hierarchyIdentifier")
    @JsonIgnore
    public Optional<String> getHierarchyIdentifier() {
        return Optional.ofNullable(hierarchyIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * hierarchyIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The Hierarchy Identifier.”</i>
     * 
     * @param hierarchyIdentifier
     *            new value of {@code hierarchyIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hierarchyIdentifier} field changed
     */
    public ConfigManagerCollection withHierarchyIdentifier(String hierarchyIdentifier) {
        ConfigManagerCollection _x = _copy();
        _x.changedFields = changedFields.add("hierarchyIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerCollection");
        _x.hierarchyIdentifier = hierarchyIdentifier;
        return _x;
    }

    /**
     * <i>“The HierarchyName.”</i>
     * 
     * @return property hierarchyName
     */
    @Property(name="hierarchyName")
    @JsonIgnore
    public Optional<String> getHierarchyName() {
        return Optional.ofNullable(hierarchyName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hierarchyName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The HierarchyName.”</i>
     * 
     * @param hierarchyName
     *            new value of {@code hierarchyName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hierarchyName} field changed
     */
    public ConfigManagerCollection withHierarchyName(String hierarchyName) {
        ConfigManagerCollection _x = _copy();
        _x.changedFields = changedFields.add("hierarchyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerCollection");
        _x.hierarchyName = hierarchyName;
        return _x;
    }

    /**
     * <i>“The last modified date.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The last modified date.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ConfigManagerCollection withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ConfigManagerCollection _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configManagerCollection");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    public ConfigManagerCollection withUnmappedField(String name, Object value) {
        ConfigManagerCollection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConfigManagerCollection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ConfigManagerCollection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConfigManagerCollection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ConfigManagerCollection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ConfigManagerCollection _copy() {
        ConfigManagerCollection _x = new ConfigManagerCollection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.collectionIdentifier = collectionIdentifier;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.hierarchyIdentifier = hierarchyIdentifier;
        _x.hierarchyName = hierarchyName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConfigManagerCollection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("collectionIdentifier=");
        b.append(this.collectionIdentifier);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("hierarchyIdentifier=");
        b.append(this.hierarchyIdentifier);
        b.append(", ");
        b.append("hierarchyName=");
        b.append(this.hierarchyName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
