package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AuthenticationContextClassReferenceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NamedLocationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationContextClassReferences", 
    "namedLocations", 
    "policies"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessRoot extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessRoot";
    }

    @JsonProperty("authenticationContextClassReferences")
    protected List<AuthenticationContextClassReference> authenticationContextClassReferences;

    @JsonProperty("namedLocations")
    protected List<NamedLocation> namedLocations;

    @JsonProperty("policies")
    protected List<ConditionalAccessPolicy> policies;

    protected ConditionalAccessRoot() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConditionalAccessRoot() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AuthenticationContextClassReference> authenticationContextClassReferences;
        private List<NamedLocation> namedLocations;
        private List<ConditionalAccessPolicy> policies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder authenticationContextClassReferences(List<AuthenticationContextClassReference> authenticationContextClassReferences) {
            this.authenticationContextClassReferences = authenticationContextClassReferences;
            this.changedFields = changedFields.add("authenticationContextClassReferences");
            return this;
        }

        public Builder authenticationContextClassReferences(AuthenticationContextClassReference... authenticationContextClassReferences) {
            return authenticationContextClassReferences(Arrays.asList(authenticationContextClassReferences));
        }

        public Builder namedLocations(List<NamedLocation> namedLocations) {
            this.namedLocations = namedLocations;
            this.changedFields = changedFields.add("namedLocations");
            return this;
        }

        public Builder namedLocations(NamedLocation... namedLocations) {
            return namedLocations(Arrays.asList(namedLocations));
        }

        public Builder policies(List<ConditionalAccessPolicy> policies) {
            this.policies = policies;
            this.changedFields = changedFields.add("policies");
            return this;
        }

        public Builder policies(ConditionalAccessPolicy... policies) {
            return policies(Arrays.asList(policies));
        }

        public ConditionalAccessRoot build() {
            ConditionalAccessRoot _x = new ConditionalAccessRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessRoot";
            _x.id = id;
            _x.authenticationContextClassReferences = authenticationContextClassReferences;
            _x.namedLocations = namedLocations;
            _x.policies = policies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public ConditionalAccessRoot withUnmappedField(String name, Object value) {
        ConditionalAccessRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="authenticationContextClassReferences")
    @JsonIgnore
    public AuthenticationContextClassReferenceCollectionRequest getAuthenticationContextClassReferences() {
        return new AuthenticationContextClassReferenceCollectionRequest(
                        contextPath.addSegment("authenticationContextClassReferences"), Optional.ofNullable(authenticationContextClassReferences));
    }

    @NavigationProperty(name="namedLocations")
    @JsonIgnore
    public NamedLocationCollectionRequest getNamedLocations() {
        return new NamedLocationCollectionRequest(
                        contextPath.addSegment("namedLocations"), Optional.ofNullable(namedLocations));
    }

    @NavigationProperty(name="policies")
    @JsonIgnore
    public ConditionalAccessPolicyCollectionRequest getPolicies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("policies"), Optional.ofNullable(policies));
    }

    public ConditionalAccessRoot withAuthenticationContextClassReferences(List<AuthenticationContextClassReference> authenticationContextClassReferences) {
        ConditionalAccessRoot _x = _copy();
        _x.changedFields = changedFields.add("authenticationContextClassReferences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessRoot");
        _x.authenticationContextClassReferences = authenticationContextClassReferences;
        return _x;
    }

    public ConditionalAccessRoot withNamedLocations(List<NamedLocation> namedLocations) {
        ConditionalAccessRoot _x = _copy();
        _x.changedFields = changedFields.add("namedLocations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessRoot");
        _x.namedLocations = namedLocations;
        return _x;
    }

    public ConditionalAccessRoot withPolicies(List<ConditionalAccessPolicy> policies) {
        ConditionalAccessRoot _x = _copy();
        _x.changedFields = changedFields.add("policies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessRoot");
        _x.policies = policies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConditionalAccessRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ConditionalAccessRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConditionalAccessRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ConditionalAccessRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ConditionalAccessRoot _copy() {
        ConditionalAccessRoot _x = new ConditionalAccessRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.authenticationContextClassReferences = authenticationContextClassReferences;
        _x.namedLocations = namedLocations;
        _x.policies = policies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessRoot[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("authenticationContextClassReferences=");
        b.append(this.authenticationContextClassReferences);
        b.append(", ");
        b.append("namedLocations=");
        b.append(this.namedLocations);
        b.append(", ");
        b.append("policies=");
        b.append(this.policies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
