package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ConditionalAccessConditionSet;
import odata.msgraph.client.beta.complex.ConditionalAccessGrantControls;
import odata.msgraph.client.beta.complex.ConditionalAccessSessionControls;
import odata.msgraph.client.beta.enums.ConditionalAccessPolicyState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "conditions", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "grantControls", 
    "modifiedDateTime", 
    "sessionControls", 
    "state"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessPolicy";
    }

    @JsonProperty("conditions")
    protected ConditionalAccessConditionSet conditions;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("grantControls")
    protected ConditionalAccessGrantControls grantControls;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("sessionControls")
    protected ConditionalAccessSessionControls sessionControls;

    @JsonProperty("state")
    protected ConditionalAccessPolicyState state;

    protected ConditionalAccessPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConditionalAccessPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ConditionalAccessConditionSet conditions;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private ConditionalAccessGrantControls grantControls;
        private OffsetDateTime modifiedDateTime;
        private ConditionalAccessSessionControls sessionControls;
        private ConditionalAccessPolicyState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder conditions(ConditionalAccessConditionSet conditions) {
            this.conditions = conditions;
            this.changedFields = changedFields.add("conditions");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder grantControls(ConditionalAccessGrantControls grantControls) {
            this.grantControls = grantControls;
            this.changedFields = changedFields.add("grantControls");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder sessionControls(ConditionalAccessSessionControls sessionControls) {
            this.sessionControls = sessionControls;
            this.changedFields = changedFields.add("sessionControls");
            return this;
        }

        public Builder state(ConditionalAccessPolicyState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public ConditionalAccessPolicy build() {
            ConditionalAccessPolicy _x = new ConditionalAccessPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.conditionalAccessPolicy";
            _x.id = id;
            _x.conditions = conditions;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.grantControls = grantControls;
            _x.modifiedDateTime = modifiedDateTime;
            _x.sessionControls = sessionControls;
            _x.state = state;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="conditions")
    @JsonIgnore
    public Optional<ConditionalAccessConditionSet> getConditions() {
        return Optional.ofNullable(conditions);
    }

    public ConditionalAccessPolicy withConditions(ConditionalAccessConditionSet conditions) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("conditions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.conditions = conditions;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ConditionalAccessPolicy withCreatedDateTime(OffsetDateTime createdDateTime) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ConditionalAccessPolicy withDescription(String description) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ConditionalAccessPolicy withDisplayName(String displayName) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="grantControls")
    @JsonIgnore
    public Optional<ConditionalAccessGrantControls> getGrantControls() {
        return Optional.ofNullable(grantControls);
    }

    public ConditionalAccessPolicy withGrantControls(ConditionalAccessGrantControls grantControls) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("grantControls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.grantControls = grantControls;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public ConditionalAccessPolicy withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Property(name="sessionControls")
    @JsonIgnore
    public Optional<ConditionalAccessSessionControls> getSessionControls() {
        return Optional.ofNullable(sessionControls);
    }

    public ConditionalAccessPolicy withSessionControls(ConditionalAccessSessionControls sessionControls) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("sessionControls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.sessionControls = sessionControls;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<ConditionalAccessPolicyState> getState() {
        return Optional.ofNullable(state);
    }

    public ConditionalAccessPolicy withState(ConditionalAccessPolicyState state) {
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessPolicy");
        _x.state = state;
        return _x;
    }

    public ConditionalAccessPolicy withUnmappedField(String name, Object value) {
        ConditionalAccessPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConditionalAccessPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConditionalAccessPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ConditionalAccessPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ConditionalAccessPolicy _copy() {
        ConditionalAccessPolicy _x = new ConditionalAccessPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.conditions = conditions;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.grantControls = grantControls;
        _x.modifiedDateTime = modifiedDateTime;
        _x.sessionControls = sessionControls;
        _x.state = state;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("conditions=");
        b.append(this.conditions);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("grantControls=");
        b.append(this.grantControls);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("sessionControls=");
        b.append(this.sessionControls);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
