package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PostalAddressType;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "currencyCode", 
    "currentFiscalYearStartDate", 
    "displayName", 
    "email", 
    "faxNumber", 
    "industry", 
    "lastModifiedDateTime", 
    "phoneNumber", 
    "picture", 
    "taxRegistrationNumber", 
    "website"})
@JsonInclude(Include.NON_NULL)
public class CompanyInformation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.companyInformation";
    }

    @JsonProperty("address")
    protected PostalAddressType address;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("currentFiscalYearStartDate")
    protected LocalDate currentFiscalYearStartDate;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("faxNumber")
    protected String faxNumber;

    @JsonProperty("industry")
    protected String industry;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("picture")
    protected String picture;

    @JsonProperty("taxRegistrationNumber")
    protected String taxRegistrationNumber;

    @JsonProperty("website")
    protected String website;

    protected CompanyInformation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCompanyInformation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private PostalAddressType address;
        private String currencyCode;
        private LocalDate currentFiscalYearStartDate;
        private String displayName;
        private String email;
        private String faxNumber;
        private String industry;
        private OffsetDateTime lastModifiedDateTime;
        private String phoneNumber;
        private String picture;
        private String taxRegistrationNumber;
        private String website;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder address(PostalAddressType address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder currentFiscalYearStartDate(LocalDate currentFiscalYearStartDate) {
            this.currentFiscalYearStartDate = currentFiscalYearStartDate;
            this.changedFields = changedFields.add("currentFiscalYearStartDate");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder faxNumber(String faxNumber) {
            this.faxNumber = faxNumber;
            this.changedFields = changedFields.add("faxNumber");
            return this;
        }

        public Builder industry(String industry) {
            this.industry = industry;
            this.changedFields = changedFields.add("industry");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder picture(String picture) {
            this.picture = picture;
            this.changedFields = changedFields.add("picture");
            return this;
        }

        public Builder taxRegistrationNumber(String taxRegistrationNumber) {
            this.taxRegistrationNumber = taxRegistrationNumber;
            this.changedFields = changedFields.add("taxRegistrationNumber");
            return this;
        }

        public Builder website(String website) {
            this.website = website;
            this.changedFields = changedFields.add("website");
            return this;
        }

        public CompanyInformation build() {
            CompanyInformation _x = new CompanyInformation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.companyInformation";
            _x.id = id;
            _x.address = address;
            _x.currencyCode = currencyCode;
            _x.currentFiscalYearStartDate = currentFiscalYearStartDate;
            _x.displayName = displayName;
            _x.email = email;
            _x.faxNumber = faxNumber;
            _x.industry = industry;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.phoneNumber = phoneNumber;
            _x.picture = picture;
            _x.taxRegistrationNumber = taxRegistrationNumber;
            _x.website = website;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PostalAddressType> getAddress() {
        return Optional.ofNullable(address);
    }

    public CompanyInformation withAddress(PostalAddressType address) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.address = address;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public CompanyInformation withCurrencyCode(String currencyCode) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="currentFiscalYearStartDate")
    @JsonIgnore
    public Optional<LocalDate> getCurrentFiscalYearStartDate() {
        return Optional.ofNullable(currentFiscalYearStartDate);
    }

    public CompanyInformation withCurrentFiscalYearStartDate(LocalDate currentFiscalYearStartDate) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("currentFiscalYearStartDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.currentFiscalYearStartDate = currentFiscalYearStartDate;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CompanyInformation withDisplayName(String displayName) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public CompanyInformation withEmail(String email) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.email = email;
        return _x;
    }

    @Property(name="faxNumber")
    @JsonIgnore
    public Optional<String> getFaxNumber() {
        return Optional.ofNullable(faxNumber);
    }

    public CompanyInformation withFaxNumber(String faxNumber) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("faxNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.faxNumber = faxNumber;
        return _x;
    }

    @Property(name="industry")
    @JsonIgnore
    public Optional<String> getIndustry() {
        return Optional.ofNullable(industry);
    }

    public CompanyInformation withIndustry(String industry) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("industry");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.industry = industry;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CompanyInformation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public CompanyInformation withPhoneNumber(String phoneNumber) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="picture")
    @JsonIgnore
    public Optional<StreamProvider> getPicture() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "picture", picture);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code picture} property, using HTTP POST.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="picture")
    public Optional<StreamUploaderSingleCall> postPicture() {
        return postPicture(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code picture} property, using HTTP POST.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="picture")
    public Optional<StreamUploaderChunked> postChunkedPicture() {
        return postPicture(UploadStrategy.chunked());
    }

    @Property(name="picture")
    public <T extends StreamUploader<T>> Optional<T> postPicture(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("picture"), this, "picture", HttpMethod.POST);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code picture} property, using HTTP PATCH.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="picture")
    public Optional<StreamUploaderSingleCall> patchPicture() {
        return patchPicture(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code picture} property, using HTTP PATCH.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="picture")
    public Optional<StreamUploaderChunked> patchChunkedPicture() {
        return patchPicture(UploadStrategy.chunked());
    }

    @Property(name="picture")
    public <T extends StreamUploader<T>> Optional<T> patchPicture(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("picture"), this, "picture", HttpMethod.PATCH);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code picture} property, using HTTP PUT.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="picture")
    public Optional<StreamUploaderSingleCall> putPicture() {
        return putPicture(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code picture} property, using HTTP PUT.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="picture")
    public Optional<StreamUploaderChunked> putChunkedPicture() {
        return putPicture(UploadStrategy.chunked());
    }

    @Property(name="picture")
    public <T extends StreamUploader<T>> Optional<T> putPicture(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("picture"), this, "picture", HttpMethod.PUT);
    }

    @Property(name="taxRegistrationNumber")
    @JsonIgnore
    public Optional<String> getTaxRegistrationNumber() {
        return Optional.ofNullable(taxRegistrationNumber);
    }

    public CompanyInformation withTaxRegistrationNumber(String taxRegistrationNumber) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("taxRegistrationNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.taxRegistrationNumber = taxRegistrationNumber;
        return _x;
    }

    @Property(name="website")
    @JsonIgnore
    public Optional<String> getWebsite() {
        return Optional.ofNullable(website);
    }

    public CompanyInformation withWebsite(String website) {
        CompanyInformation _x = _copy();
        _x.changedFields = changedFields.add("website");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.companyInformation");
        _x.website = website;
        return _x;
    }

    public CompanyInformation withUnmappedField(String name, Object value) {
        CompanyInformation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CompanyInformation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CompanyInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CompanyInformation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CompanyInformation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CompanyInformation _copy() {
        CompanyInformation _x = new CompanyInformation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.address = address;
        _x.currencyCode = currencyCode;
        _x.currentFiscalYearStartDate = currentFiscalYearStartDate;
        _x.displayName = displayName;
        _x.email = email;
        _x.faxNumber = faxNumber;
        _x.industry = industry;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.phoneNumber = phoneNumber;
        _x.picture = picture;
        _x.taxRegistrationNumber = taxRegistrationNumber;
        _x.website = website;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CompanyInformation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("currentFiscalYearStartDate=");
        b.append(this.currentFiscalYearStartDate);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("faxNumber=");
        b.append(this.faxNumber);
        b.append(", ");
        b.append("industry=");
        b.append(this.industry);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("picture=");
        b.append(this.picture);
        b.append(", ");
        b.append("taxRegistrationNumber=");
        b.append(this.taxRegistrationNumber);
        b.append(", ");
        b.append("website=");
        b.append(this.website);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
