package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgedAccountsPayableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgedAccountsReceivableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CompanyInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CountryRegionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CurrencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentJournalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DimensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DimensionValueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmployeeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GeneralLedgerEntryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JournalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JournalLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PaymentMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PaymentTermCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ShipmentMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TaxAreaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TaxGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnitOfMeasureCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.VendorCollectionRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "businessProfileId", 
    "displayName", 
    "name", 
    "systemVersion", 
    "accounts", 
    "agedAccountsPayable", 
    "agedAccountsReceivable", 
    "companyInformation", 
    "countriesRegions", 
    "currencies", 
    "customerPaymentJournals", 
    "customerPayments", 
    "customers", 
    "dimensions", 
    "dimensionValues", 
    "employees", 
    "generalLedgerEntries", 
    "itemCategories", 
    "items", 
    "journalLines", 
    "journals", 
    "paymentMethods", 
    "paymentTerms", 
    "picture", 
    "purchaseInvoiceLines", 
    "purchaseInvoices", 
    "salesCreditMemoLines", 
    "salesCreditMemos", 
    "salesInvoiceLines", 
    "salesInvoices", 
    "salesOrderLines", 
    "salesOrders", 
    "salesQuoteLines", 
    "salesQuotes", 
    "shipmentMethods", 
    "taxAreas", 
    "taxGroups", 
    "unitsOfMeasure", 
    "vendors"})
@JsonInclude(Include.NON_NULL)
public class Company extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.company";
    }

    @JsonProperty("businessProfileId")
    protected String businessProfileId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("systemVersion")
    protected String systemVersion;

    @JsonProperty("accounts")
    protected List<Account> accounts;

    @JsonProperty("agedAccountsPayable")
    protected List<AgedAccountsPayable> agedAccountsPayable;

    @JsonProperty("agedAccountsReceivable")
    protected List<AgedAccountsReceivable> agedAccountsReceivable;

    @JsonProperty("companyInformation")
    protected List<CompanyInformation> companyInformation;

    @JsonProperty("countriesRegions")
    protected List<CountryRegion> countriesRegions;

    @JsonProperty("currencies")
    protected List<Currency> currencies;

    @JsonProperty("customerPaymentJournals")
    protected List<CustomerPaymentJournal> customerPaymentJournals;

    @JsonProperty("customerPayments")
    protected List<CustomerPayment> customerPayments;

    @JsonProperty("customers")
    protected List<Customer> customers;

    @JsonProperty("dimensions")
    protected List<Dimension> dimensions;

    @JsonProperty("dimensionValues")
    protected List<DimensionValue> dimensionValues;

    @JsonProperty("employees")
    protected List<Employee> employees;

    @JsonProperty("generalLedgerEntries")
    protected List<GeneralLedgerEntry> generalLedgerEntries;

    @JsonProperty("itemCategories")
    protected List<ItemCategory> itemCategories;

    @JsonProperty("items")
    protected List<Item> items;

    @JsonProperty("journalLines")
    protected List<JournalLine> journalLines;

    @JsonProperty("journals")
    protected List<Journal> journals;

    @JsonProperty("paymentMethods")
    protected List<PaymentMethod> paymentMethods;

    @JsonProperty("paymentTerms")
    protected List<PaymentTerm> paymentTerms;

    @JsonProperty("picture")
    protected List<Picture> picture;

    @JsonProperty("purchaseInvoiceLines")
    protected List<PurchaseInvoiceLine> purchaseInvoiceLines;

    @JsonProperty("purchaseInvoices")
    protected List<PurchaseInvoice> purchaseInvoices;

    @JsonProperty("salesCreditMemoLines")
    protected List<SalesCreditMemoLine> salesCreditMemoLines;

    @JsonProperty("salesCreditMemos")
    protected List<SalesCreditMemo> salesCreditMemos;

    @JsonProperty("salesInvoiceLines")
    protected List<SalesInvoiceLine> salesInvoiceLines;

    @JsonProperty("salesInvoices")
    protected List<SalesInvoice> salesInvoices;

    @JsonProperty("salesOrderLines")
    protected List<SalesOrderLine> salesOrderLines;

    @JsonProperty("salesOrders")
    protected List<SalesOrder> salesOrders;

    @JsonProperty("salesQuoteLines")
    protected List<SalesQuoteLine> salesQuoteLines;

    @JsonProperty("salesQuotes")
    protected List<SalesQuote> salesQuotes;

    @JsonProperty("shipmentMethods")
    protected List<ShipmentMethod> shipmentMethods;

    @JsonProperty("taxAreas")
    protected List<TaxArea> taxAreas;

    @JsonProperty("taxGroups")
    protected List<TaxGroup> taxGroups;

    @JsonProperty("unitsOfMeasure")
    protected List<UnitOfMeasure> unitsOfMeasure;

    @JsonProperty("vendors")
    protected List<Vendor> vendors;

    protected Company() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCompany() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String businessProfileId;
        private String displayName;
        private String name;
        private String systemVersion;
        private List<Account> accounts;
        private List<AgedAccountsPayable> agedAccountsPayable;
        private List<AgedAccountsReceivable> agedAccountsReceivable;
        private List<CompanyInformation> companyInformation;
        private List<CountryRegion> countriesRegions;
        private List<Currency> currencies;
        private List<CustomerPaymentJournal> customerPaymentJournals;
        private List<CustomerPayment> customerPayments;
        private List<Customer> customers;
        private List<Dimension> dimensions;
        private List<DimensionValue> dimensionValues;
        private List<Employee> employees;
        private List<GeneralLedgerEntry> generalLedgerEntries;
        private List<ItemCategory> itemCategories;
        private List<Item> items;
        private List<JournalLine> journalLines;
        private List<Journal> journals;
        private List<PaymentMethod> paymentMethods;
        private List<PaymentTerm> paymentTerms;
        private List<Picture> picture;
        private List<PurchaseInvoiceLine> purchaseInvoiceLines;
        private List<PurchaseInvoice> purchaseInvoices;
        private List<SalesCreditMemoLine> salesCreditMemoLines;
        private List<SalesCreditMemo> salesCreditMemos;
        private List<SalesInvoiceLine> salesInvoiceLines;
        private List<SalesInvoice> salesInvoices;
        private List<SalesOrderLine> salesOrderLines;
        private List<SalesOrder> salesOrders;
        private List<SalesQuoteLine> salesQuoteLines;
        private List<SalesQuote> salesQuotes;
        private List<ShipmentMethod> shipmentMethods;
        private List<TaxArea> taxAreas;
        private List<TaxGroup> taxGroups;
        private List<UnitOfMeasure> unitsOfMeasure;
        private List<Vendor> vendors;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder businessProfileId(String businessProfileId) {
            this.businessProfileId = businessProfileId;
            this.changedFields = changedFields.add("businessProfileId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            this.changedFields = changedFields.add("systemVersion");
            return this;
        }

        public Builder accounts(List<Account> accounts) {
            this.accounts = accounts;
            this.changedFields = changedFields.add("accounts");
            return this;
        }

        public Builder accounts(Account... accounts) {
            return accounts(Arrays.asList(accounts));
        }

        public Builder agedAccountsPayable(List<AgedAccountsPayable> agedAccountsPayable) {
            this.agedAccountsPayable = agedAccountsPayable;
            this.changedFields = changedFields.add("agedAccountsPayable");
            return this;
        }

        public Builder agedAccountsPayable(AgedAccountsPayable... agedAccountsPayable) {
            return agedAccountsPayable(Arrays.asList(agedAccountsPayable));
        }

        public Builder agedAccountsReceivable(List<AgedAccountsReceivable> agedAccountsReceivable) {
            this.agedAccountsReceivable = agedAccountsReceivable;
            this.changedFields = changedFields.add("agedAccountsReceivable");
            return this;
        }

        public Builder agedAccountsReceivable(AgedAccountsReceivable... agedAccountsReceivable) {
            return agedAccountsReceivable(Arrays.asList(agedAccountsReceivable));
        }

        public Builder companyInformation(List<CompanyInformation> companyInformation) {
            this.companyInformation = companyInformation;
            this.changedFields = changedFields.add("companyInformation");
            return this;
        }

        public Builder companyInformation(CompanyInformation... companyInformation) {
            return companyInformation(Arrays.asList(companyInformation));
        }

        public Builder countriesRegions(List<CountryRegion> countriesRegions) {
            this.countriesRegions = countriesRegions;
            this.changedFields = changedFields.add("countriesRegions");
            return this;
        }

        public Builder countriesRegions(CountryRegion... countriesRegions) {
            return countriesRegions(Arrays.asList(countriesRegions));
        }

        public Builder currencies(List<Currency> currencies) {
            this.currencies = currencies;
            this.changedFields = changedFields.add("currencies");
            return this;
        }

        public Builder currencies(Currency... currencies) {
            return currencies(Arrays.asList(currencies));
        }

        public Builder customerPaymentJournals(List<CustomerPaymentJournal> customerPaymentJournals) {
            this.customerPaymentJournals = customerPaymentJournals;
            this.changedFields = changedFields.add("customerPaymentJournals");
            return this;
        }

        public Builder customerPaymentJournals(CustomerPaymentJournal... customerPaymentJournals) {
            return customerPaymentJournals(Arrays.asList(customerPaymentJournals));
        }

        public Builder customerPayments(List<CustomerPayment> customerPayments) {
            this.customerPayments = customerPayments;
            this.changedFields = changedFields.add("customerPayments");
            return this;
        }

        public Builder customerPayments(CustomerPayment... customerPayments) {
            return customerPayments(Arrays.asList(customerPayments));
        }

        public Builder customers(List<Customer> customers) {
            this.customers = customers;
            this.changedFields = changedFields.add("customers");
            return this;
        }

        public Builder customers(Customer... customers) {
            return customers(Arrays.asList(customers));
        }

        public Builder dimensions(List<Dimension> dimensions) {
            this.dimensions = dimensions;
            this.changedFields = changedFields.add("dimensions");
            return this;
        }

        public Builder dimensions(Dimension... dimensions) {
            return dimensions(Arrays.asList(dimensions));
        }

        public Builder dimensionValues(List<DimensionValue> dimensionValues) {
            this.dimensionValues = dimensionValues;
            this.changedFields = changedFields.add("dimensionValues");
            return this;
        }

        public Builder dimensionValues(DimensionValue... dimensionValues) {
            return dimensionValues(Arrays.asList(dimensionValues));
        }

        public Builder employees(List<Employee> employees) {
            this.employees = employees;
            this.changedFields = changedFields.add("employees");
            return this;
        }

        public Builder employees(Employee... employees) {
            return employees(Arrays.asList(employees));
        }

        public Builder generalLedgerEntries(List<GeneralLedgerEntry> generalLedgerEntries) {
            this.generalLedgerEntries = generalLedgerEntries;
            this.changedFields = changedFields.add("generalLedgerEntries");
            return this;
        }

        public Builder generalLedgerEntries(GeneralLedgerEntry... generalLedgerEntries) {
            return generalLedgerEntries(Arrays.asList(generalLedgerEntries));
        }

        public Builder itemCategories(List<ItemCategory> itemCategories) {
            this.itemCategories = itemCategories;
            this.changedFields = changedFields.add("itemCategories");
            return this;
        }

        public Builder itemCategories(ItemCategory... itemCategories) {
            return itemCategories(Arrays.asList(itemCategories));
        }

        public Builder items(List<Item> items) {
            this.items = items;
            this.changedFields = changedFields.add("items");
            return this;
        }

        public Builder items(Item... items) {
            return items(Arrays.asList(items));
        }

        public Builder journalLines(List<JournalLine> journalLines) {
            this.journalLines = journalLines;
            this.changedFields = changedFields.add("journalLines");
            return this;
        }

        public Builder journalLines(JournalLine... journalLines) {
            return journalLines(Arrays.asList(journalLines));
        }

        public Builder journals(List<Journal> journals) {
            this.journals = journals;
            this.changedFields = changedFields.add("journals");
            return this;
        }

        public Builder journals(Journal... journals) {
            return journals(Arrays.asList(journals));
        }

        public Builder paymentMethods(List<PaymentMethod> paymentMethods) {
            this.paymentMethods = paymentMethods;
            this.changedFields = changedFields.add("paymentMethods");
            return this;
        }

        public Builder paymentMethods(PaymentMethod... paymentMethods) {
            return paymentMethods(Arrays.asList(paymentMethods));
        }

        public Builder paymentTerms(List<PaymentTerm> paymentTerms) {
            this.paymentTerms = paymentTerms;
            this.changedFields = changedFields.add("paymentTerms");
            return this;
        }

        public Builder paymentTerms(PaymentTerm... paymentTerms) {
            return paymentTerms(Arrays.asList(paymentTerms));
        }

        public Builder picture(List<Picture> picture) {
            this.picture = picture;
            this.changedFields = changedFields.add("picture");
            return this;
        }

        public Builder picture(Picture... picture) {
            return picture(Arrays.asList(picture));
        }

        public Builder purchaseInvoiceLines(List<PurchaseInvoiceLine> purchaseInvoiceLines) {
            this.purchaseInvoiceLines = purchaseInvoiceLines;
            this.changedFields = changedFields.add("purchaseInvoiceLines");
            return this;
        }

        public Builder purchaseInvoiceLines(PurchaseInvoiceLine... purchaseInvoiceLines) {
            return purchaseInvoiceLines(Arrays.asList(purchaseInvoiceLines));
        }

        public Builder purchaseInvoices(List<PurchaseInvoice> purchaseInvoices) {
            this.purchaseInvoices = purchaseInvoices;
            this.changedFields = changedFields.add("purchaseInvoices");
            return this;
        }

        public Builder purchaseInvoices(PurchaseInvoice... purchaseInvoices) {
            return purchaseInvoices(Arrays.asList(purchaseInvoices));
        }

        public Builder salesCreditMemoLines(List<SalesCreditMemoLine> salesCreditMemoLines) {
            this.salesCreditMemoLines = salesCreditMemoLines;
            this.changedFields = changedFields.add("salesCreditMemoLines");
            return this;
        }

        public Builder salesCreditMemoLines(SalesCreditMemoLine... salesCreditMemoLines) {
            return salesCreditMemoLines(Arrays.asList(salesCreditMemoLines));
        }

        public Builder salesCreditMemos(List<SalesCreditMemo> salesCreditMemos) {
            this.salesCreditMemos = salesCreditMemos;
            this.changedFields = changedFields.add("salesCreditMemos");
            return this;
        }

        public Builder salesCreditMemos(SalesCreditMemo... salesCreditMemos) {
            return salesCreditMemos(Arrays.asList(salesCreditMemos));
        }

        public Builder salesInvoiceLines(List<SalesInvoiceLine> salesInvoiceLines) {
            this.salesInvoiceLines = salesInvoiceLines;
            this.changedFields = changedFields.add("salesInvoiceLines");
            return this;
        }

        public Builder salesInvoiceLines(SalesInvoiceLine... salesInvoiceLines) {
            return salesInvoiceLines(Arrays.asList(salesInvoiceLines));
        }

        public Builder salesInvoices(List<SalesInvoice> salesInvoices) {
            this.salesInvoices = salesInvoices;
            this.changedFields = changedFields.add("salesInvoices");
            return this;
        }

        public Builder salesInvoices(SalesInvoice... salesInvoices) {
            return salesInvoices(Arrays.asList(salesInvoices));
        }

        public Builder salesOrderLines(List<SalesOrderLine> salesOrderLines) {
            this.salesOrderLines = salesOrderLines;
            this.changedFields = changedFields.add("salesOrderLines");
            return this;
        }

        public Builder salesOrderLines(SalesOrderLine... salesOrderLines) {
            return salesOrderLines(Arrays.asList(salesOrderLines));
        }

        public Builder salesOrders(List<SalesOrder> salesOrders) {
            this.salesOrders = salesOrders;
            this.changedFields = changedFields.add("salesOrders");
            return this;
        }

        public Builder salesOrders(SalesOrder... salesOrders) {
            return salesOrders(Arrays.asList(salesOrders));
        }

        public Builder salesQuoteLines(List<SalesQuoteLine> salesQuoteLines) {
            this.salesQuoteLines = salesQuoteLines;
            this.changedFields = changedFields.add("salesQuoteLines");
            return this;
        }

        public Builder salesQuoteLines(SalesQuoteLine... salesQuoteLines) {
            return salesQuoteLines(Arrays.asList(salesQuoteLines));
        }

        public Builder salesQuotes(List<SalesQuote> salesQuotes) {
            this.salesQuotes = salesQuotes;
            this.changedFields = changedFields.add("salesQuotes");
            return this;
        }

        public Builder salesQuotes(SalesQuote... salesQuotes) {
            return salesQuotes(Arrays.asList(salesQuotes));
        }

        public Builder shipmentMethods(List<ShipmentMethod> shipmentMethods) {
            this.shipmentMethods = shipmentMethods;
            this.changedFields = changedFields.add("shipmentMethods");
            return this;
        }

        public Builder shipmentMethods(ShipmentMethod... shipmentMethods) {
            return shipmentMethods(Arrays.asList(shipmentMethods));
        }

        public Builder taxAreas(List<TaxArea> taxAreas) {
            this.taxAreas = taxAreas;
            this.changedFields = changedFields.add("taxAreas");
            return this;
        }

        public Builder taxAreas(TaxArea... taxAreas) {
            return taxAreas(Arrays.asList(taxAreas));
        }

        public Builder taxGroups(List<TaxGroup> taxGroups) {
            this.taxGroups = taxGroups;
            this.changedFields = changedFields.add("taxGroups");
            return this;
        }

        public Builder taxGroups(TaxGroup... taxGroups) {
            return taxGroups(Arrays.asList(taxGroups));
        }

        public Builder unitsOfMeasure(List<UnitOfMeasure> unitsOfMeasure) {
            this.unitsOfMeasure = unitsOfMeasure;
            this.changedFields = changedFields.add("unitsOfMeasure");
            return this;
        }

        public Builder unitsOfMeasure(UnitOfMeasure... unitsOfMeasure) {
            return unitsOfMeasure(Arrays.asList(unitsOfMeasure));
        }

        public Builder vendors(List<Vendor> vendors) {
            this.vendors = vendors;
            this.changedFields = changedFields.add("vendors");
            return this;
        }

        public Builder vendors(Vendor... vendors) {
            return vendors(Arrays.asList(vendors));
        }

        public Company build() {
            Company _x = new Company();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.company";
            _x.id = id;
            _x.businessProfileId = businessProfileId;
            _x.displayName = displayName;
            _x.name = name;
            _x.systemVersion = systemVersion;
            _x.accounts = accounts;
            _x.agedAccountsPayable = agedAccountsPayable;
            _x.agedAccountsReceivable = agedAccountsReceivable;
            _x.companyInformation = companyInformation;
            _x.countriesRegions = countriesRegions;
            _x.currencies = currencies;
            _x.customerPaymentJournals = customerPaymentJournals;
            _x.customerPayments = customerPayments;
            _x.customers = customers;
            _x.dimensions = dimensions;
            _x.dimensionValues = dimensionValues;
            _x.employees = employees;
            _x.generalLedgerEntries = generalLedgerEntries;
            _x.itemCategories = itemCategories;
            _x.items = items;
            _x.journalLines = journalLines;
            _x.journals = journals;
            _x.paymentMethods = paymentMethods;
            _x.paymentTerms = paymentTerms;
            _x.picture = picture;
            _x.purchaseInvoiceLines = purchaseInvoiceLines;
            _x.purchaseInvoices = purchaseInvoices;
            _x.salesCreditMemoLines = salesCreditMemoLines;
            _x.salesCreditMemos = salesCreditMemos;
            _x.salesInvoiceLines = salesInvoiceLines;
            _x.salesInvoices = salesInvoices;
            _x.salesOrderLines = salesOrderLines;
            _x.salesOrders = salesOrders;
            _x.salesQuoteLines = salesQuoteLines;
            _x.salesQuotes = salesQuotes;
            _x.shipmentMethods = shipmentMethods;
            _x.taxAreas = taxAreas;
            _x.taxGroups = taxGroups;
            _x.unitsOfMeasure = unitsOfMeasure;
            _x.vendors = vendors;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="businessProfileId")
    @JsonIgnore
    public Optional<String> getBusinessProfileId() {
        return Optional.ofNullable(businessProfileId);
    }

    public Company withBusinessProfileId(String businessProfileId) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("businessProfileId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.businessProfileId = businessProfileId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Company withDisplayName(String displayName) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Company withName(String name) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.name = name;
        return _x;
    }

    @Property(name="systemVersion")
    @JsonIgnore
    public Optional<String> getSystemVersion() {
        return Optional.ofNullable(systemVersion);
    }

    public Company withSystemVersion(String systemVersion) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("systemVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.systemVersion = systemVersion;
        return _x;
    }

    public Company withUnmappedField(String name, Object value) {
        Company _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accounts")
    @JsonIgnore
    public AccountCollectionRequest getAccounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("accounts"), Optional.ofNullable(accounts));
    }

    @NavigationProperty(name="agedAccountsPayable")
    @JsonIgnore
    public AgedAccountsPayableCollectionRequest getAgedAccountsPayable() {
        return new AgedAccountsPayableCollectionRequest(
                        contextPath.addSegment("agedAccountsPayable"), Optional.ofNullable(agedAccountsPayable));
    }

    @NavigationProperty(name="agedAccountsReceivable")
    @JsonIgnore
    public AgedAccountsReceivableCollectionRequest getAgedAccountsReceivable() {
        return new AgedAccountsReceivableCollectionRequest(
                        contextPath.addSegment("agedAccountsReceivable"), Optional.ofNullable(agedAccountsReceivable));
    }

    @NavigationProperty(name="companyInformation")
    @JsonIgnore
    public CompanyInformationCollectionRequest getCompanyInformation() {
        return new CompanyInformationCollectionRequest(
                        contextPath.addSegment("companyInformation"), Optional.ofNullable(companyInformation));
    }

    @NavigationProperty(name="countriesRegions")
    @JsonIgnore
    public CountryRegionCollectionRequest getCountriesRegions() {
        return new CountryRegionCollectionRequest(
                        contextPath.addSegment("countriesRegions"), Optional.ofNullable(countriesRegions));
    }

    @NavigationProperty(name="currencies")
    @JsonIgnore
    public CurrencyCollectionRequest getCurrencies() {
        return new CurrencyCollectionRequest(
                        contextPath.addSegment("currencies"), Optional.ofNullable(currencies));
    }

    @NavigationProperty(name="customerPaymentJournals")
    @JsonIgnore
    public CustomerPaymentJournalCollectionRequest getCustomerPaymentJournals() {
        return new CustomerPaymentJournalCollectionRequest(
                        contextPath.addSegment("customerPaymentJournals"), Optional.ofNullable(customerPaymentJournals));
    }

    @NavigationProperty(name="customerPayments")
    @JsonIgnore
    public CustomerPaymentCollectionRequest getCustomerPayments() {
        return new CustomerPaymentCollectionRequest(
                        contextPath.addSegment("customerPayments"), Optional.ofNullable(customerPayments));
    }

    @NavigationProperty(name="customers")
    @JsonIgnore
    public CustomerCollectionRequest getCustomers() {
        return new CustomerCollectionRequest(
                        contextPath.addSegment("customers"), Optional.ofNullable(customers));
    }

    @NavigationProperty(name="dimensions")
    @JsonIgnore
    public DimensionCollectionRequest getDimensions() {
        return new DimensionCollectionRequest(
                        contextPath.addSegment("dimensions"), Optional.ofNullable(dimensions));
    }

    @NavigationProperty(name="dimensionValues")
    @JsonIgnore
    public DimensionValueCollectionRequest getDimensionValues() {
        return new DimensionValueCollectionRequest(
                        contextPath.addSegment("dimensionValues"), Optional.ofNullable(dimensionValues));
    }

    @NavigationProperty(name="employees")
    @JsonIgnore
    public EmployeeCollectionRequest getEmployees() {
        return new EmployeeCollectionRequest(
                        contextPath.addSegment("employees"), Optional.ofNullable(employees));
    }

    @NavigationProperty(name="generalLedgerEntries")
    @JsonIgnore
    public GeneralLedgerEntryCollectionRequest getGeneralLedgerEntries() {
        return new GeneralLedgerEntryCollectionRequest(
                        contextPath.addSegment("generalLedgerEntries"), Optional.ofNullable(generalLedgerEntries));
    }

    @NavigationProperty(name="itemCategories")
    @JsonIgnore
    public ItemCategoryCollectionRequest getItemCategories() {
        return new ItemCategoryCollectionRequest(
                        contextPath.addSegment("itemCategories"), Optional.ofNullable(itemCategories));
    }

    @NavigationProperty(name="items")
    @JsonIgnore
    public ItemCollectionRequest getItems() {
        return new ItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.ofNullable(items));
    }

    @NavigationProperty(name="journalLines")
    @JsonIgnore
    public JournalLineCollectionRequest getJournalLines() {
        return new JournalLineCollectionRequest(
                        contextPath.addSegment("journalLines"), Optional.ofNullable(journalLines));
    }

    @NavigationProperty(name="journals")
    @JsonIgnore
    public JournalCollectionRequest getJournals() {
        return new JournalCollectionRequest(
                        contextPath.addSegment("journals"), Optional.ofNullable(journals));
    }

    @NavigationProperty(name="paymentMethods")
    @JsonIgnore
    public PaymentMethodCollectionRequest getPaymentMethods() {
        return new PaymentMethodCollectionRequest(
                        contextPath.addSegment("paymentMethods"), Optional.ofNullable(paymentMethods));
    }

    @NavigationProperty(name="paymentTerms")
    @JsonIgnore
    public PaymentTermCollectionRequest getPaymentTerms() {
        return new PaymentTermCollectionRequest(
                        contextPath.addSegment("paymentTerms"), Optional.ofNullable(paymentTerms));
    }

    @NavigationProperty(name="picture")
    @JsonIgnore
    public PictureCollectionRequest getPicture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.ofNullable(picture));
    }

    @NavigationProperty(name="purchaseInvoiceLines")
    @JsonIgnore
    public PurchaseInvoiceLineCollectionRequest getPurchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(
                        contextPath.addSegment("purchaseInvoiceLines"), Optional.ofNullable(purchaseInvoiceLines));
    }

    @NavigationProperty(name="purchaseInvoices")
    @JsonIgnore
    public PurchaseInvoiceCollectionRequest getPurchaseInvoices() {
        return new PurchaseInvoiceCollectionRequest(
                        contextPath.addSegment("purchaseInvoices"), Optional.ofNullable(purchaseInvoices));
    }

    @NavigationProperty(name="salesCreditMemoLines")
    @JsonIgnore
    public SalesCreditMemoLineCollectionRequest getSalesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(
                        contextPath.addSegment("salesCreditMemoLines"), Optional.ofNullable(salesCreditMemoLines));
    }

    @NavigationProperty(name="salesCreditMemos")
    @JsonIgnore
    public SalesCreditMemoCollectionRequest getSalesCreditMemos() {
        return new SalesCreditMemoCollectionRequest(
                        contextPath.addSegment("salesCreditMemos"), Optional.ofNullable(salesCreditMemos));
    }

    @NavigationProperty(name="salesInvoiceLines")
    @JsonIgnore
    public SalesInvoiceLineCollectionRequest getSalesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(
                        contextPath.addSegment("salesInvoiceLines"), Optional.ofNullable(salesInvoiceLines));
    }

    @NavigationProperty(name="salesInvoices")
    @JsonIgnore
    public SalesInvoiceCollectionRequest getSalesInvoices() {
        return new SalesInvoiceCollectionRequest(
                        contextPath.addSegment("salesInvoices"), Optional.ofNullable(salesInvoices));
    }

    @NavigationProperty(name="salesOrderLines")
    @JsonIgnore
    public SalesOrderLineCollectionRequest getSalesOrderLines() {
        return new SalesOrderLineCollectionRequest(
                        contextPath.addSegment("salesOrderLines"), Optional.ofNullable(salesOrderLines));
    }

    @NavigationProperty(name="salesOrders")
    @JsonIgnore
    public SalesOrderCollectionRequest getSalesOrders() {
        return new SalesOrderCollectionRequest(
                        contextPath.addSegment("salesOrders"), Optional.ofNullable(salesOrders));
    }

    @NavigationProperty(name="salesQuoteLines")
    @JsonIgnore
    public SalesQuoteLineCollectionRequest getSalesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(
                        contextPath.addSegment("salesQuoteLines"), Optional.ofNullable(salesQuoteLines));
    }

    @NavigationProperty(name="salesQuotes")
    @JsonIgnore
    public SalesQuoteCollectionRequest getSalesQuotes() {
        return new SalesQuoteCollectionRequest(
                        contextPath.addSegment("salesQuotes"), Optional.ofNullable(salesQuotes));
    }

    @NavigationProperty(name="shipmentMethods")
    @JsonIgnore
    public ShipmentMethodCollectionRequest getShipmentMethods() {
        return new ShipmentMethodCollectionRequest(
                        contextPath.addSegment("shipmentMethods"), Optional.ofNullable(shipmentMethods));
    }

    @NavigationProperty(name="taxAreas")
    @JsonIgnore
    public TaxAreaCollectionRequest getTaxAreas() {
        return new TaxAreaCollectionRequest(
                        contextPath.addSegment("taxAreas"), Optional.ofNullable(taxAreas));
    }

    @NavigationProperty(name="taxGroups")
    @JsonIgnore
    public TaxGroupCollectionRequest getTaxGroups() {
        return new TaxGroupCollectionRequest(
                        contextPath.addSegment("taxGroups"), Optional.ofNullable(taxGroups));
    }

    @NavigationProperty(name="unitsOfMeasure")
    @JsonIgnore
    public UnitOfMeasureCollectionRequest getUnitsOfMeasure() {
        return new UnitOfMeasureCollectionRequest(
                        contextPath.addSegment("unitsOfMeasure"), Optional.ofNullable(unitsOfMeasure));
    }

    @NavigationProperty(name="vendors")
    @JsonIgnore
    public VendorCollectionRequest getVendors() {
        return new VendorCollectionRequest(
                        contextPath.addSegment("vendors"), Optional.ofNullable(vendors));
    }

    public Company withAccounts(List<Account> accounts) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("accounts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.accounts = accounts;
        return _x;
    }

    public Company withAgedAccountsPayable(List<AgedAccountsPayable> agedAccountsPayable) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("agedAccountsPayable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.agedAccountsPayable = agedAccountsPayable;
        return _x;
    }

    public Company withAgedAccountsReceivable(List<AgedAccountsReceivable> agedAccountsReceivable) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("agedAccountsReceivable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.agedAccountsReceivable = agedAccountsReceivable;
        return _x;
    }

    public Company withCompanyInformation(List<CompanyInformation> companyInformation) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("companyInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.companyInformation = companyInformation;
        return _x;
    }

    public Company withCountriesRegions(List<CountryRegion> countriesRegions) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("countriesRegions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.countriesRegions = countriesRegions;
        return _x;
    }

    public Company withCurrencies(List<Currency> currencies) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("currencies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.currencies = currencies;
        return _x;
    }

    public Company withCustomerPaymentJournals(List<CustomerPaymentJournal> customerPaymentJournals) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("customerPaymentJournals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.customerPaymentJournals = customerPaymentJournals;
        return _x;
    }

    public Company withCustomerPayments(List<CustomerPayment> customerPayments) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("customerPayments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.customerPayments = customerPayments;
        return _x;
    }

    public Company withCustomers(List<Customer> customers) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("customers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.customers = customers;
        return _x;
    }

    public Company withDimensions(List<Dimension> dimensions) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("dimensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.dimensions = dimensions;
        return _x;
    }

    public Company withDimensionValues(List<DimensionValue> dimensionValues) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("dimensionValues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.dimensionValues = dimensionValues;
        return _x;
    }

    public Company withEmployees(List<Employee> employees) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("employees");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.employees = employees;
        return _x;
    }

    public Company withGeneralLedgerEntries(List<GeneralLedgerEntry> generalLedgerEntries) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("generalLedgerEntries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.generalLedgerEntries = generalLedgerEntries;
        return _x;
    }

    public Company withItemCategories(List<ItemCategory> itemCategories) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("itemCategories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.itemCategories = itemCategories;
        return _x;
    }

    public Company withItems(List<Item> items) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("items");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.items = items;
        return _x;
    }

    public Company withJournalLines(List<JournalLine> journalLines) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("journalLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.journalLines = journalLines;
        return _x;
    }

    public Company withJournals(List<Journal> journals) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("journals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.journals = journals;
        return _x;
    }

    public Company withPaymentMethods(List<PaymentMethod> paymentMethods) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("paymentMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.paymentMethods = paymentMethods;
        return _x;
    }

    public Company withPaymentTerms(List<PaymentTerm> paymentTerms) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("paymentTerms");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.paymentTerms = paymentTerms;
        return _x;
    }

    public Company withPicture(List<Picture> picture) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("picture");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.picture = picture;
        return _x;
    }

    public Company withPurchaseInvoiceLines(List<PurchaseInvoiceLine> purchaseInvoiceLines) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("purchaseInvoiceLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.purchaseInvoiceLines = purchaseInvoiceLines;
        return _x;
    }

    public Company withPurchaseInvoices(List<PurchaseInvoice> purchaseInvoices) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("purchaseInvoices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.purchaseInvoices = purchaseInvoices;
        return _x;
    }

    public Company withSalesCreditMemoLines(List<SalesCreditMemoLine> salesCreditMemoLines) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesCreditMemoLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesCreditMemoLines = salesCreditMemoLines;
        return _x;
    }

    public Company withSalesCreditMemos(List<SalesCreditMemo> salesCreditMemos) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesCreditMemos");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesCreditMemos = salesCreditMemos;
        return _x;
    }

    public Company withSalesInvoiceLines(List<SalesInvoiceLine> salesInvoiceLines) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesInvoiceLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesInvoiceLines = salesInvoiceLines;
        return _x;
    }

    public Company withSalesInvoices(List<SalesInvoice> salesInvoices) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesInvoices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesInvoices = salesInvoices;
        return _x;
    }

    public Company withSalesOrderLines(List<SalesOrderLine> salesOrderLines) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesOrderLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesOrderLines = salesOrderLines;
        return _x;
    }

    public Company withSalesOrders(List<SalesOrder> salesOrders) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesOrders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesOrders = salesOrders;
        return _x;
    }

    public Company withSalesQuoteLines(List<SalesQuoteLine> salesQuoteLines) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesQuoteLines");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesQuoteLines = salesQuoteLines;
        return _x;
    }

    public Company withSalesQuotes(List<SalesQuote> salesQuotes) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("salesQuotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.salesQuotes = salesQuotes;
        return _x;
    }

    public Company withShipmentMethods(List<ShipmentMethod> shipmentMethods) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("shipmentMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.shipmentMethods = shipmentMethods;
        return _x;
    }

    public Company withTaxAreas(List<TaxArea> taxAreas) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("taxAreas");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.taxAreas = taxAreas;
        return _x;
    }

    public Company withTaxGroups(List<TaxGroup> taxGroups) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("taxGroups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.taxGroups = taxGroups;
        return _x;
    }

    public Company withUnitsOfMeasure(List<UnitOfMeasure> unitsOfMeasure) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("unitsOfMeasure");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.unitsOfMeasure = unitsOfMeasure;
        return _x;
    }

    public Company withVendors(List<Vendor> vendors) {
        Company _x = _copy();
        _x.changedFields = changedFields.add("vendors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.company");
        _x.vendors = vendors;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Company patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Company _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Company put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Company _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Company _copy() {
        Company _x = new Company();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.businessProfileId = businessProfileId;
        _x.displayName = displayName;
        _x.name = name;
        _x.systemVersion = systemVersion;
        _x.accounts = accounts;
        _x.agedAccountsPayable = agedAccountsPayable;
        _x.agedAccountsReceivable = agedAccountsReceivable;
        _x.companyInformation = companyInformation;
        _x.countriesRegions = countriesRegions;
        _x.currencies = currencies;
        _x.customerPaymentJournals = customerPaymentJournals;
        _x.customerPayments = customerPayments;
        _x.customers = customers;
        _x.dimensions = dimensions;
        _x.dimensionValues = dimensionValues;
        _x.employees = employees;
        _x.generalLedgerEntries = generalLedgerEntries;
        _x.itemCategories = itemCategories;
        _x.items = items;
        _x.journalLines = journalLines;
        _x.journals = journals;
        _x.paymentMethods = paymentMethods;
        _x.paymentTerms = paymentTerms;
        _x.picture = picture;
        _x.purchaseInvoiceLines = purchaseInvoiceLines;
        _x.purchaseInvoices = purchaseInvoices;
        _x.salesCreditMemoLines = salesCreditMemoLines;
        _x.salesCreditMemos = salesCreditMemos;
        _x.salesInvoiceLines = salesInvoiceLines;
        _x.salesInvoices = salesInvoices;
        _x.salesOrderLines = salesOrderLines;
        _x.salesOrders = salesOrders;
        _x.salesQuoteLines = salesQuoteLines;
        _x.salesQuotes = salesQuotes;
        _x.shipmentMethods = shipmentMethods;
        _x.taxAreas = taxAreas;
        _x.taxGroups = taxGroups;
        _x.unitsOfMeasure = unitsOfMeasure;
        _x.vendors = vendors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Company[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("businessProfileId=");
        b.append(this.businessProfileId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("systemVersion=");
        b.append(this.systemVersion);
        b.append(", ");
        b.append("accounts=");
        b.append(this.accounts);
        b.append(", ");
        b.append("agedAccountsPayable=");
        b.append(this.agedAccountsPayable);
        b.append(", ");
        b.append("agedAccountsReceivable=");
        b.append(this.agedAccountsReceivable);
        b.append(", ");
        b.append("companyInformation=");
        b.append(this.companyInformation);
        b.append(", ");
        b.append("countriesRegions=");
        b.append(this.countriesRegions);
        b.append(", ");
        b.append("currencies=");
        b.append(this.currencies);
        b.append(", ");
        b.append("customerPaymentJournals=");
        b.append(this.customerPaymentJournals);
        b.append(", ");
        b.append("customerPayments=");
        b.append(this.customerPayments);
        b.append(", ");
        b.append("customers=");
        b.append(this.customers);
        b.append(", ");
        b.append("dimensions=");
        b.append(this.dimensions);
        b.append(", ");
        b.append("dimensionValues=");
        b.append(this.dimensionValues);
        b.append(", ");
        b.append("employees=");
        b.append(this.employees);
        b.append(", ");
        b.append("generalLedgerEntries=");
        b.append(this.generalLedgerEntries);
        b.append(", ");
        b.append("itemCategories=");
        b.append(this.itemCategories);
        b.append(", ");
        b.append("items=");
        b.append(this.items);
        b.append(", ");
        b.append("journalLines=");
        b.append(this.journalLines);
        b.append(", ");
        b.append("journals=");
        b.append(this.journals);
        b.append(", ");
        b.append("paymentMethods=");
        b.append(this.paymentMethods);
        b.append(", ");
        b.append("paymentTerms=");
        b.append(this.paymentTerms);
        b.append(", ");
        b.append("picture=");
        b.append(this.picture);
        b.append(", ");
        b.append("purchaseInvoiceLines=");
        b.append(this.purchaseInvoiceLines);
        b.append(", ");
        b.append("purchaseInvoices=");
        b.append(this.purchaseInvoices);
        b.append(", ");
        b.append("salesCreditMemoLines=");
        b.append(this.salesCreditMemoLines);
        b.append(", ");
        b.append("salesCreditMemos=");
        b.append(this.salesCreditMemos);
        b.append(", ");
        b.append("salesInvoiceLines=");
        b.append(this.salesInvoiceLines);
        b.append(", ");
        b.append("salesInvoices=");
        b.append(this.salesInvoices);
        b.append(", ");
        b.append("salesOrderLines=");
        b.append(this.salesOrderLines);
        b.append(", ");
        b.append("salesOrders=");
        b.append(this.salesOrders);
        b.append(", ");
        b.append("salesQuoteLines=");
        b.append(this.salesQuoteLines);
        b.append(", ");
        b.append("salesQuotes=");
        b.append(this.salesQuotes);
        b.append(", ");
        b.append("shipmentMethods=");
        b.append(this.shipmentMethods);
        b.append(", ");
        b.append("taxAreas=");
        b.append(this.taxAreas);
        b.append(", ");
        b.append("taxGroups=");
        b.append(this.taxGroups);
        b.append(", ");
        b.append("unitsOfMeasure=");
        b.append(this.unitsOfMeasure);
        b.append(", ");
        b.append("vendors=");
        b.append(this.vendors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
