package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.CallCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "calls", 
    "onlineMeetings"})
@JsonInclude(Include.NON_NULL)
public class CommsApplication implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.commsApplication";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("calls")
    protected List<Call> calls;

    @JsonProperty("onlineMeetings")
    protected List<OnlineMeeting> onlineMeetings;

    protected CommsApplication() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Call> calls;
        private List<OnlineMeeting> onlineMeetings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder calls(List<Call> calls) {
            this.calls = calls;
            this.changedFields = changedFields.add("calls");
            return this;
        }

        public Builder calls(Call... calls) {
            return calls(Arrays.asList(calls));
        }

        public Builder onlineMeetings(List<OnlineMeeting> onlineMeetings) {
            this.onlineMeetings = onlineMeetings;
            this.changedFields = changedFields.add("onlineMeetings");
            return this;
        }

        public Builder onlineMeetings(OnlineMeeting... onlineMeetings) {
            return onlineMeetings(Arrays.asList(onlineMeetings));
        }

        public CommsApplication build() {
            CommsApplication _x = new CommsApplication();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.commsApplication";
            _x.calls = calls;
            _x.onlineMeetings = onlineMeetings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public CommsApplication withUnmappedField(String name, Object value) {
        CommsApplication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="calls")
    @JsonIgnore
    public CallCollectionRequest getCalls() {
        return new CallCollectionRequest(
                        contextPath.addSegment("calls"), Optional.ofNullable(calls));
    }

    @NavigationProperty(name="onlineMeetings")
    @JsonIgnore
    public OnlineMeetingCollectionRequest getOnlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"), Optional.ofNullable(onlineMeetings));
    }

    public CommsApplication withCalls(List<Call> calls) {
        CommsApplication _x = _copy();
        _x.changedFields = changedFields.add("calls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.commsApplication");
        _x.calls = calls;
        return _x;
    }

    public CommsApplication withOnlineMeetings(List<OnlineMeeting> onlineMeetings) {
        CommsApplication _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.commsApplication");
        _x.onlineMeetings = onlineMeetings;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CommsApplication patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CommsApplication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CommsApplication put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CommsApplication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CommsApplication _copy() {
        CommsApplication _x = new CommsApplication();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.calls = calls;
        _x.onlineMeetings = onlineMeetings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommsApplication[");
        b.append("calls=");
        b.append(this.calls);
        b.append(", ");
        b.append("onlineMeetings=");
        b.append(this.onlineMeetings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
