package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcRestorePointSetting;
import odata.msgraph.client.beta.entity.collection.request.CloudPcUserSettingAssignmentCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "lastModifiedDateTime", 
    "localAdminEnabled", 
    "restorePointSetting", 
    "selfServiceEnabled", 
    "assignments"})
@JsonInclude(Include.NON_NULL)
public class CloudPcUserSetting extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcUserSetting";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("localAdminEnabled")
    protected Boolean localAdminEnabled;

    @JsonProperty("restorePointSetting")
    protected CloudPcRestorePointSetting restorePointSetting;

    @JsonProperty("selfServiceEnabled")
    protected Boolean selfServiceEnabled;

    @JsonProperty("assignments")
    protected List<CloudPcUserSettingAssignment> assignments;

    protected CloudPcUserSetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcUserSetting() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean localAdminEnabled;
        private CloudPcRestorePointSetting restorePointSetting;
        private Boolean selfServiceEnabled;
        private List<CloudPcUserSettingAssignment> assignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder localAdminEnabled(Boolean localAdminEnabled) {
            this.localAdminEnabled = localAdminEnabled;
            this.changedFields = changedFields.add("localAdminEnabled");
            return this;
        }

        public Builder restorePointSetting(CloudPcRestorePointSetting restorePointSetting) {
            this.restorePointSetting = restorePointSetting;
            this.changedFields = changedFields.add("restorePointSetting");
            return this;
        }

        public Builder selfServiceEnabled(Boolean selfServiceEnabled) {
            this.selfServiceEnabled = selfServiceEnabled;
            this.changedFields = changedFields.add("selfServiceEnabled");
            return this;
        }

        public Builder assignments(List<CloudPcUserSettingAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(CloudPcUserSettingAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public CloudPcUserSetting build() {
            CloudPcUserSetting _x = new CloudPcUserSetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcUserSetting";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.localAdminEnabled = localAdminEnabled;
            _x.restorePointSetting = restorePointSetting;
            _x.selfServiceEnabled = selfServiceEnabled;
            _x.assignments = assignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public CloudPcUserSetting withCreatedDateTime(OffsetDateTime createdDateTime) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcUserSetting withDisplayName(String displayName) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CloudPcUserSetting withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="localAdminEnabled")
    @JsonIgnore
    public Optional<Boolean> getLocalAdminEnabled() {
        return Optional.ofNullable(localAdminEnabled);
    }

    public CloudPcUserSetting withLocalAdminEnabled(Boolean localAdminEnabled) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("localAdminEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.localAdminEnabled = localAdminEnabled;
        return _x;
    }

    @Property(name="restorePointSetting")
    @JsonIgnore
    public Optional<CloudPcRestorePointSetting> getRestorePointSetting() {
        return Optional.ofNullable(restorePointSetting);
    }

    public CloudPcUserSetting withRestorePointSetting(CloudPcRestorePointSetting restorePointSetting) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("restorePointSetting");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.restorePointSetting = restorePointSetting;
        return _x;
    }

    @Property(name="selfServiceEnabled")
    @JsonIgnore
    public Optional<Boolean> getSelfServiceEnabled() {
        return Optional.ofNullable(selfServiceEnabled);
    }

    public CloudPcUserSetting withSelfServiceEnabled(Boolean selfServiceEnabled) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("selfServiceEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.selfServiceEnabled = selfServiceEnabled;
        return _x;
    }

    public CloudPcUserSetting withUnmappedField(String name, Object value) {
        CloudPcUserSetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="assignments")
    @JsonIgnore
    public CloudPcUserSettingAssignmentCollectionRequest getAssignments() {
        return new CloudPcUserSettingAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    public CloudPcUserSetting withAssignments(List<CloudPcUserSettingAssignment> assignments) {
        CloudPcUserSetting _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSetting");
        _x.assignments = assignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcUserSetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcUserSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcUserSetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcUserSetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcUserSetting _copy() {
        CloudPcUserSetting _x = new CloudPcUserSetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.localAdminEnabled = localAdminEnabled;
        _x.restorePointSetting = restorePointSetting;
        _x.selfServiceEnabled = selfServiceEnabled;
        _x.assignments = assignments;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<CloudPcUserSettingAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.cloudPcUserSettingAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcUserSetting[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("localAdminEnabled=");
        b.append(this.localAdminEnabled);
        b.append(", ");
        b.append("restorePointSetting=");
        b.append(this.restorePointSetting);
        b.append(", ");
        b.append("selfServiceEnabled=");
        b.append(this.selfServiceEnabled);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
