package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcServicePlanType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "ramInGB", 
    "storageInGB", 
    "type", 
    "userProfileInGB", 
    "vCpuCount"})
@JsonInclude(Include.NON_NULL)
public class CloudPcServicePlan extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcServicePlan";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("ramInGB")
    protected Integer ramInGB;

    @JsonProperty("storageInGB")
    protected Integer storageInGB;

    @JsonProperty("type")
    protected CloudPcServicePlanType type;

    @JsonProperty("userProfileInGB")
    protected Integer userProfileInGB;

    @JsonProperty("vCpuCount")
    protected Integer vCpuCount;

    protected CloudPcServicePlan() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcServicePlan() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Integer ramInGB;
        private Integer storageInGB;
        private CloudPcServicePlanType type;
        private Integer userProfileInGB;
        private Integer vCpuCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder ramInGB(Integer ramInGB) {
            this.ramInGB = ramInGB;
            this.changedFields = changedFields.add("ramInGB");
            return this;
        }

        public Builder storageInGB(Integer storageInGB) {
            this.storageInGB = storageInGB;
            this.changedFields = changedFields.add("storageInGB");
            return this;
        }

        public Builder type(CloudPcServicePlanType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder userProfileInGB(Integer userProfileInGB) {
            this.userProfileInGB = userProfileInGB;
            this.changedFields = changedFields.add("userProfileInGB");
            return this;
        }

        public Builder vCpuCount(Integer vCpuCount) {
            this.vCpuCount = vCpuCount;
            this.changedFields = changedFields.add("vCpuCount");
            return this;
        }

        public CloudPcServicePlan build() {
            CloudPcServicePlan _x = new CloudPcServicePlan();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcServicePlan";
            _x.id = id;
            _x.displayName = displayName;
            _x.ramInGB = ramInGB;
            _x.storageInGB = storageInGB;
            _x.type = type;
            _x.userProfileInGB = userProfileInGB;
            _x.vCpuCount = vCpuCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcServicePlan withDisplayName(String displayName) {
        CloudPcServicePlan _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcServicePlan");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="ramInGB")
    @JsonIgnore
    public Optional<Integer> getRamInGB() {
        return Optional.ofNullable(ramInGB);
    }

    public CloudPcServicePlan withRamInGB(Integer ramInGB) {
        CloudPcServicePlan _x = _copy();
        _x.changedFields = changedFields.add("ramInGB");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcServicePlan");
        _x.ramInGB = ramInGB;
        return _x;
    }

    @Property(name="storageInGB")
    @JsonIgnore
    public Optional<Integer> getStorageInGB() {
        return Optional.ofNullable(storageInGB);
    }

    public CloudPcServicePlan withStorageInGB(Integer storageInGB) {
        CloudPcServicePlan _x = _copy();
        _x.changedFields = changedFields.add("storageInGB");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcServicePlan");
        _x.storageInGB = storageInGB;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<CloudPcServicePlanType> getType() {
        return Optional.ofNullable(type);
    }

    public CloudPcServicePlan withType(CloudPcServicePlanType type) {
        CloudPcServicePlan _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcServicePlan");
        _x.type = type;
        return _x;
    }

    @Property(name="userProfileInGB")
    @JsonIgnore
    public Optional<Integer> getUserProfileInGB() {
        return Optional.ofNullable(userProfileInGB);
    }

    public CloudPcServicePlan withUserProfileInGB(Integer userProfileInGB) {
        CloudPcServicePlan _x = _copy();
        _x.changedFields = changedFields.add("userProfileInGB");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcServicePlan");
        _x.userProfileInGB = userProfileInGB;
        return _x;
    }

    @Property(name="vCpuCount")
    @JsonIgnore
    public Optional<Integer> getVCpuCount() {
        return Optional.ofNullable(vCpuCount);
    }

    public CloudPcServicePlan withVCpuCount(Integer vCpuCount) {
        CloudPcServicePlan _x = _copy();
        _x.changedFields = changedFields.add("vCpuCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcServicePlan");
        _x.vCpuCount = vCpuCount;
        return _x;
    }

    public CloudPcServicePlan withUnmappedField(String name, Object value) {
        CloudPcServicePlan _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcServicePlan patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcServicePlan _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcServicePlan put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcServicePlan _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcServicePlan _copy() {
        CloudPcServicePlan _x = new CloudPcServicePlan();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.ramInGB = ramInGB;
        _x.storageInGB = storageInGB;
        _x.type = type;
        _x.userProfileInGB = userProfileInGB;
        _x.vCpuCount = vCpuCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcServicePlan[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("ramInGB=");
        b.append(this.ramInGB);
        b.append(", ");
        b.append("storageInGB=");
        b.append(this.storageInGB);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("userProfileInGB=");
        b.append(this.userProfileInGB);
        b.append(", ");
        b.append("vCpuCount=");
        b.append(this.vCpuCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
