package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcDomainJoinConfiguration;
import odata.msgraph.client.beta.complex.MicrosoftManagedDesktop;
import odata.msgraph.client.beta.entity.collection.request.CloudPcProvisioningPolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.enums.CloudPcProvisioningPolicyImageType;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "domainJoinConfiguration", 
    "imageDisplayName", 
    "imageId", 
    "imageType", 
    "microsoftManagedDesktop", 
    "onPremisesConnectionId", 
    "assignments"})
@JsonInclude(Include.NON_NULL)
public class CloudPcProvisioningPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcProvisioningPolicy";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("domainJoinConfiguration")
    protected CloudPcDomainJoinConfiguration domainJoinConfiguration;

    @JsonProperty("imageDisplayName")
    protected String imageDisplayName;

    @JsonProperty("imageId")
    protected String imageId;

    @JsonProperty("imageType")
    protected CloudPcProvisioningPolicyImageType imageType;

    @JsonProperty("microsoftManagedDesktop")
    protected MicrosoftManagedDesktop microsoftManagedDesktop;

    @JsonProperty("onPremisesConnectionId")
    protected String onPremisesConnectionId;

    @JsonProperty("assignments")
    protected List<CloudPcProvisioningPolicyAssignment> assignments;

    protected CloudPcProvisioningPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcProvisioningPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private CloudPcDomainJoinConfiguration domainJoinConfiguration;
        private String imageDisplayName;
        private String imageId;
        private CloudPcProvisioningPolicyImageType imageType;
        private MicrosoftManagedDesktop microsoftManagedDesktop;
        private String onPremisesConnectionId;
        private List<CloudPcProvisioningPolicyAssignment> assignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder domainJoinConfiguration(CloudPcDomainJoinConfiguration domainJoinConfiguration) {
            this.domainJoinConfiguration = domainJoinConfiguration;
            this.changedFields = changedFields.add("domainJoinConfiguration");
            return this;
        }

        public Builder imageDisplayName(String imageDisplayName) {
            this.imageDisplayName = imageDisplayName;
            this.changedFields = changedFields.add("imageDisplayName");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.changedFields = changedFields.add("imageId");
            return this;
        }

        public Builder imageType(CloudPcProvisioningPolicyImageType imageType) {
            this.imageType = imageType;
            this.changedFields = changedFields.add("imageType");
            return this;
        }

        public Builder microsoftManagedDesktop(MicrosoftManagedDesktop microsoftManagedDesktop) {
            this.microsoftManagedDesktop = microsoftManagedDesktop;
            this.changedFields = changedFields.add("microsoftManagedDesktop");
            return this;
        }

        public Builder onPremisesConnectionId(String onPremisesConnectionId) {
            this.onPremisesConnectionId = onPremisesConnectionId;
            this.changedFields = changedFields.add("onPremisesConnectionId");
            return this;
        }

        public Builder assignments(List<CloudPcProvisioningPolicyAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(CloudPcProvisioningPolicyAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public CloudPcProvisioningPolicy build() {
            CloudPcProvisioningPolicy _x = new CloudPcProvisioningPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcProvisioningPolicy";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.domainJoinConfiguration = domainJoinConfiguration;
            _x.imageDisplayName = imageDisplayName;
            _x.imageId = imageId;
            _x.imageType = imageType;
            _x.microsoftManagedDesktop = microsoftManagedDesktop;
            _x.onPremisesConnectionId = onPremisesConnectionId;
            _x.assignments = assignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public CloudPcProvisioningPolicy withDescription(String description) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcProvisioningPolicy withDisplayName(String displayName) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="domainJoinConfiguration")
    @JsonIgnore
    public Optional<CloudPcDomainJoinConfiguration> getDomainJoinConfiguration() {
        return Optional.ofNullable(domainJoinConfiguration);
    }

    public CloudPcProvisioningPolicy withDomainJoinConfiguration(CloudPcDomainJoinConfiguration domainJoinConfiguration) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("domainJoinConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.domainJoinConfiguration = domainJoinConfiguration;
        return _x;
    }

    @Property(name="imageDisplayName")
    @JsonIgnore
    public Optional<String> getImageDisplayName() {
        return Optional.ofNullable(imageDisplayName);
    }

    public CloudPcProvisioningPolicy withImageDisplayName(String imageDisplayName) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("imageDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.imageDisplayName = imageDisplayName;
        return _x;
    }

    @Property(name="imageId")
    @JsonIgnore
    public Optional<String> getImageId() {
        return Optional.ofNullable(imageId);
    }

    public CloudPcProvisioningPolicy withImageId(String imageId) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("imageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.imageId = imageId;
        return _x;
    }

    @Property(name="imageType")
    @JsonIgnore
    public Optional<CloudPcProvisioningPolicyImageType> getImageType() {
        return Optional.ofNullable(imageType);
    }

    public CloudPcProvisioningPolicy withImageType(CloudPcProvisioningPolicyImageType imageType) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("imageType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.imageType = imageType;
        return _x;
    }

    @Property(name="microsoftManagedDesktop")
    @JsonIgnore
    public Optional<MicrosoftManagedDesktop> getMicrosoftManagedDesktop() {
        return Optional.ofNullable(microsoftManagedDesktop);
    }

    public CloudPcProvisioningPolicy withMicrosoftManagedDesktop(MicrosoftManagedDesktop microsoftManagedDesktop) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("microsoftManagedDesktop");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.microsoftManagedDesktop = microsoftManagedDesktop;
        return _x;
    }

    @Property(name="onPremisesConnectionId")
    @JsonIgnore
    public Optional<String> getOnPremisesConnectionId() {
        return Optional.ofNullable(onPremisesConnectionId);
    }

    public CloudPcProvisioningPolicy withOnPremisesConnectionId(String onPremisesConnectionId) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("onPremisesConnectionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.onPremisesConnectionId = onPremisesConnectionId;
        return _x;
    }

    public CloudPcProvisioningPolicy withUnmappedField(String name, Object value) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="assignments")
    @JsonIgnore
    public CloudPcProvisioningPolicyAssignmentCollectionRequest getAssignments() {
        return new CloudPcProvisioningPolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    public CloudPcProvisioningPolicy withAssignments(List<CloudPcProvisioningPolicyAssignment> assignments) {
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcProvisioningPolicy");
        _x.assignments = assignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcProvisioningPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcProvisioningPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcProvisioningPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcProvisioningPolicy _copy() {
        CloudPcProvisioningPolicy _x = new CloudPcProvisioningPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.domainJoinConfiguration = domainJoinConfiguration;
        _x.imageDisplayName = imageDisplayName;
        _x.imageId = imageId;
        _x.imageType = imageType;
        _x.microsoftManagedDesktop = microsoftManagedDesktop;
        _x.onPremisesConnectionId = onPremisesConnectionId;
        _x.assignments = assignments;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<CloudPcProvisioningPolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.cloudPcProvisioningPolicyAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcProvisioningPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("domainJoinConfiguration=");
        b.append(this.domainJoinConfiguration);
        b.append(", ");
        b.append("imageDisplayName=");
        b.append(this.imageDisplayName);
        b.append(", ");
        b.append("imageId=");
        b.append(this.imageId);
        b.append(", ");
        b.append("imageType=");
        b.append(this.imageType);
        b.append(", ");
        b.append("microsoftManagedDesktop=");
        b.append(this.microsoftManagedDesktop);
        b.append(", ");
        b.append("onPremisesConnectionId=");
        b.append(this.onPremisesConnectionId);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
