package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcOperatingSystem;
import odata.msgraph.client.beta.enums.CloudPcUserAccountType;

@JsonPropertyOrder({
    "@odata.type", 
    "osVersion", 
    "userAccountType"})
@JsonInclude(Include.NON_NULL)
public class CloudPcOrganizationSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcOrganizationSettings";
    }

    @JsonProperty("osVersion")
    protected CloudPcOperatingSystem osVersion;

    @JsonProperty("userAccountType")
    protected CloudPcUserAccountType userAccountType;

    protected CloudPcOrganizationSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcOrganizationSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CloudPcOperatingSystem osVersion;
        private CloudPcUserAccountType userAccountType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder osVersion(CloudPcOperatingSystem osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public Builder userAccountType(CloudPcUserAccountType userAccountType) {
            this.userAccountType = userAccountType;
            this.changedFields = changedFields.add("userAccountType");
            return this;
        }

        public CloudPcOrganizationSettings build() {
            CloudPcOrganizationSettings _x = new CloudPcOrganizationSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcOrganizationSettings";
            _x.id = id;
            _x.osVersion = osVersion;
            _x.userAccountType = userAccountType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="osVersion")
    @JsonIgnore
    public Optional<CloudPcOperatingSystem> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    public CloudPcOrganizationSettings withOsVersion(CloudPcOperatingSystem osVersion) {
        CloudPcOrganizationSettings _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOrganizationSettings");
        _x.osVersion = osVersion;
        return _x;
    }

    @Property(name="userAccountType")
    @JsonIgnore
    public Optional<CloudPcUserAccountType> getUserAccountType() {
        return Optional.ofNullable(userAccountType);
    }

    public CloudPcOrganizationSettings withUserAccountType(CloudPcUserAccountType userAccountType) {
        CloudPcOrganizationSettings _x = _copy();
        _x.changedFields = changedFields.add("userAccountType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOrganizationSettings");
        _x.userAccountType = userAccountType;
        return _x;
    }

    public CloudPcOrganizationSettings withUnmappedField(String name, Object value) {
        CloudPcOrganizationSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcOrganizationSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcOrganizationSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcOrganizationSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcOrganizationSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcOrganizationSettings _copy() {
        CloudPcOrganizationSettings _x = new CloudPcOrganizationSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.osVersion = osVersion;
        _x.userAccountType = userAccountType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcOrganizationSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("userAccountType=");
        b.append(this.userAccountType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
