package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcOnPremisesConnectionStatusDetails;
import odata.msgraph.client.beta.enums.CloudPcOnPremisesConnectionStatus;
import odata.msgraph.client.beta.enums.CloudPcOnPremisesConnectionType;

@JsonPropertyOrder({
    "@odata.type", 
    "adDomainName", 
    "adDomainPassword", 
    "adDomainUsername", 
    "displayName", 
    "healthCheckStatus", 
    "healthCheckStatusDetails", 
    "inUse", 
    "organizationalUnit", 
    "resourceGroupId", 
    "subnetId", 
    "subscriptionId", 
    "subscriptionName", 
    "type", 
    "virtualNetworkId"})
@JsonInclude(Include.NON_NULL)
public class CloudPcOnPremisesConnection extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcOnPremisesConnection";
    }

    @JsonProperty("adDomainName")
    protected String adDomainName;

    @JsonProperty("adDomainPassword")
    protected String adDomainPassword;

    @JsonProperty("adDomainUsername")
    protected String adDomainUsername;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("healthCheckStatus")
    protected CloudPcOnPremisesConnectionStatus healthCheckStatus;

    @JsonProperty("healthCheckStatusDetails")
    protected CloudPcOnPremisesConnectionStatusDetails healthCheckStatusDetails;

    @JsonProperty("inUse")
    protected Boolean inUse;

    @JsonProperty("organizationalUnit")
    protected String organizationalUnit;

    @JsonProperty("resourceGroupId")
    protected String resourceGroupId;

    @JsonProperty("subnetId")
    protected String subnetId;

    @JsonProperty("subscriptionId")
    protected String subscriptionId;

    @JsonProperty("subscriptionName")
    protected String subscriptionName;

    @JsonProperty("type")
    protected CloudPcOnPremisesConnectionType type;

    @JsonProperty("virtualNetworkId")
    protected String virtualNetworkId;

    protected CloudPcOnPremisesConnection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcOnPremisesConnection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String adDomainName;
        private String adDomainPassword;
        private String adDomainUsername;
        private String displayName;
        private CloudPcOnPremisesConnectionStatus healthCheckStatus;
        private CloudPcOnPremisesConnectionStatusDetails healthCheckStatusDetails;
        private Boolean inUse;
        private String organizationalUnit;
        private String resourceGroupId;
        private String subnetId;
        private String subscriptionId;
        private String subscriptionName;
        private CloudPcOnPremisesConnectionType type;
        private String virtualNetworkId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder adDomainName(String adDomainName) {
            this.adDomainName = adDomainName;
            this.changedFields = changedFields.add("adDomainName");
            return this;
        }

        public Builder adDomainPassword(String adDomainPassword) {
            this.adDomainPassword = adDomainPassword;
            this.changedFields = changedFields.add("adDomainPassword");
            return this;
        }

        public Builder adDomainUsername(String adDomainUsername) {
            this.adDomainUsername = adDomainUsername;
            this.changedFields = changedFields.add("adDomainUsername");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder healthCheckStatus(CloudPcOnPremisesConnectionStatus healthCheckStatus) {
            this.healthCheckStatus = healthCheckStatus;
            this.changedFields = changedFields.add("healthCheckStatus");
            return this;
        }

        public Builder healthCheckStatusDetails(CloudPcOnPremisesConnectionStatusDetails healthCheckStatusDetails) {
            this.healthCheckStatusDetails = healthCheckStatusDetails;
            this.changedFields = changedFields.add("healthCheckStatusDetails");
            return this;
        }

        public Builder inUse(Boolean inUse) {
            this.inUse = inUse;
            this.changedFields = changedFields.add("inUse");
            return this;
        }

        public Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            this.changedFields = changedFields.add("organizationalUnit");
            return this;
        }

        public Builder resourceGroupId(String resourceGroupId) {
            this.resourceGroupId = resourceGroupId;
            this.changedFields = changedFields.add("resourceGroupId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.changedFields = changedFields.add("subnetId");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.changedFields = changedFields.add("subscriptionId");
            return this;
        }

        public Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            this.changedFields = changedFields.add("subscriptionName");
            return this;
        }

        public Builder type(CloudPcOnPremisesConnectionType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder virtualNetworkId(String virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            this.changedFields = changedFields.add("virtualNetworkId");
            return this;
        }

        public CloudPcOnPremisesConnection build() {
            CloudPcOnPremisesConnection _x = new CloudPcOnPremisesConnection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcOnPremisesConnection";
            _x.id = id;
            _x.adDomainName = adDomainName;
            _x.adDomainPassword = adDomainPassword;
            _x.adDomainUsername = adDomainUsername;
            _x.displayName = displayName;
            _x.healthCheckStatus = healthCheckStatus;
            _x.healthCheckStatusDetails = healthCheckStatusDetails;
            _x.inUse = inUse;
            _x.organizationalUnit = organizationalUnit;
            _x.resourceGroupId = resourceGroupId;
            _x.subnetId = subnetId;
            _x.subscriptionId = subscriptionId;
            _x.subscriptionName = subscriptionName;
            _x.type = type;
            _x.virtualNetworkId = virtualNetworkId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="adDomainName")
    @JsonIgnore
    public Optional<String> getAdDomainName() {
        return Optional.ofNullable(adDomainName);
    }

    public CloudPcOnPremisesConnection withAdDomainName(String adDomainName) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("adDomainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.adDomainName = adDomainName;
        return _x;
    }

    @Property(name="adDomainPassword")
    @JsonIgnore
    public Optional<String> getAdDomainPassword() {
        return Optional.ofNullable(adDomainPassword);
    }

    public CloudPcOnPremisesConnection withAdDomainPassword(String adDomainPassword) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("adDomainPassword");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.adDomainPassword = adDomainPassword;
        return _x;
    }

    @Property(name="adDomainUsername")
    @JsonIgnore
    public Optional<String> getAdDomainUsername() {
        return Optional.ofNullable(adDomainUsername);
    }

    public CloudPcOnPremisesConnection withAdDomainUsername(String adDomainUsername) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("adDomainUsername");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.adDomainUsername = adDomainUsername;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcOnPremisesConnection withDisplayName(String displayName) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="healthCheckStatus")
    @JsonIgnore
    public Optional<CloudPcOnPremisesConnectionStatus> getHealthCheckStatus() {
        return Optional.ofNullable(healthCheckStatus);
    }

    public CloudPcOnPremisesConnection withHealthCheckStatus(CloudPcOnPremisesConnectionStatus healthCheckStatus) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("healthCheckStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.healthCheckStatus = healthCheckStatus;
        return _x;
    }

    @Property(name="healthCheckStatusDetails")
    @JsonIgnore
    public Optional<CloudPcOnPremisesConnectionStatusDetails> getHealthCheckStatusDetails() {
        return Optional.ofNullable(healthCheckStatusDetails);
    }

    public CloudPcOnPremisesConnection withHealthCheckStatusDetails(CloudPcOnPremisesConnectionStatusDetails healthCheckStatusDetails) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("healthCheckStatusDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.healthCheckStatusDetails = healthCheckStatusDetails;
        return _x;
    }

    @Property(name="inUse")
    @JsonIgnore
    public Optional<Boolean> getInUse() {
        return Optional.ofNullable(inUse);
    }

    public CloudPcOnPremisesConnection withInUse(Boolean inUse) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("inUse");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.inUse = inUse;
        return _x;
    }

    @Property(name="organizationalUnit")
    @JsonIgnore
    public Optional<String> getOrganizationalUnit() {
        return Optional.ofNullable(organizationalUnit);
    }

    public CloudPcOnPremisesConnection withOrganizationalUnit(String organizationalUnit) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("organizationalUnit");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.organizationalUnit = organizationalUnit;
        return _x;
    }

    @Property(name="resourceGroupId")
    @JsonIgnore
    public Optional<String> getResourceGroupId() {
        return Optional.ofNullable(resourceGroupId);
    }

    public CloudPcOnPremisesConnection withResourceGroupId(String resourceGroupId) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("resourceGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.resourceGroupId = resourceGroupId;
        return _x;
    }

    @Property(name="subnetId")
    @JsonIgnore
    public Optional<String> getSubnetId() {
        return Optional.ofNullable(subnetId);
    }

    public CloudPcOnPremisesConnection withSubnetId(String subnetId) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("subnetId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.subnetId = subnetId;
        return _x;
    }

    @Property(name="subscriptionId")
    @JsonIgnore
    public Optional<String> getSubscriptionId() {
        return Optional.ofNullable(subscriptionId);
    }

    public CloudPcOnPremisesConnection withSubscriptionId(String subscriptionId) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("subscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.subscriptionId = subscriptionId;
        return _x;
    }

    @Property(name="subscriptionName")
    @JsonIgnore
    public Optional<String> getSubscriptionName() {
        return Optional.ofNullable(subscriptionName);
    }

    public CloudPcOnPremisesConnection withSubscriptionName(String subscriptionName) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("subscriptionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.subscriptionName = subscriptionName;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<CloudPcOnPremisesConnectionType> getType() {
        return Optional.ofNullable(type);
    }

    public CloudPcOnPremisesConnection withType(CloudPcOnPremisesConnectionType type) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.type = type;
        return _x;
    }

    @Property(name="virtualNetworkId")
    @JsonIgnore
    public Optional<String> getVirtualNetworkId() {
        return Optional.ofNullable(virtualNetworkId);
    }

    public CloudPcOnPremisesConnection withVirtualNetworkId(String virtualNetworkId) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = changedFields.add("virtualNetworkId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcOnPremisesConnection");
        _x.virtualNetworkId = virtualNetworkId;
        return _x;
    }

    public CloudPcOnPremisesConnection withUnmappedField(String name, Object value) {
        CloudPcOnPremisesConnection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcOnPremisesConnection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcOnPremisesConnection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcOnPremisesConnection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcOnPremisesConnection _copy() {
        CloudPcOnPremisesConnection _x = new CloudPcOnPremisesConnection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.adDomainName = adDomainName;
        _x.adDomainPassword = adDomainPassword;
        _x.adDomainUsername = adDomainUsername;
        _x.displayName = displayName;
        _x.healthCheckStatus = healthCheckStatus;
        _x.healthCheckStatusDetails = healthCheckStatusDetails;
        _x.inUse = inUse;
        _x.organizationalUnit = organizationalUnit;
        _x.resourceGroupId = resourceGroupId;
        _x.subnetId = subnetId;
        _x.subscriptionId = subscriptionId;
        _x.subscriptionName = subscriptionName;
        _x.type = type;
        _x.virtualNetworkId = virtualNetworkId;
        return _x;
    }

    @Action(name = "runHealthChecks")
    @JsonIgnore
    public ActionRequestNoReturn runHealthChecks() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.runHealthChecks"), _parameters);
    }

    @Action(name = "updateAdDomainPassword")
    @JsonIgnore
    public ActionRequestNoReturn updateAdDomainPassword(String adDomainPassword) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("adDomainPassword", "Edm.String", Checks.checkIsAscii(adDomainPassword))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateAdDomainPassword"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcOnPremisesConnection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("adDomainName=");
        b.append(this.adDomainName);
        b.append(", ");
        b.append("adDomainPassword=");
        b.append(this.adDomainPassword);
        b.append(", ");
        b.append("adDomainUsername=");
        b.append(this.adDomainUsername);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("healthCheckStatus=");
        b.append(this.healthCheckStatus);
        b.append(", ");
        b.append("healthCheckStatusDetails=");
        b.append(this.healthCheckStatusDetails);
        b.append(", ");
        b.append("inUse=");
        b.append(this.inUse);
        b.append(", ");
        b.append("organizationalUnit=");
        b.append(this.organizationalUnit);
        b.append(", ");
        b.append("resourceGroupId=");
        b.append(this.resourceGroupId);
        b.append(", ");
        b.append("subnetId=");
        b.append(this.subnetId);
        b.append(", ");
        b.append("subscriptionId=");
        b.append(this.subscriptionId);
        b.append(", ");
        b.append("subscriptionName=");
        b.append(this.subscriptionName);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("virtualNetworkId=");
        b.append(this.virtualNetworkId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
