package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcGalleryImageStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "endDate", 
    "expirationDate", 
    "offer", 
    "offerDisplayName", 
    "publisher", 
    "recommendedSku", 
    "sizeInGB", 
    "sku", 
    "skuDisplayName", 
    "startDate", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class CloudPcGalleryImage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcGalleryImage";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("endDate")
    protected LocalDate endDate;

    @JsonProperty("expirationDate")
    protected LocalDate expirationDate;

    @JsonProperty("offer")
    protected String offer;

    @JsonProperty("offerDisplayName")
    protected String offerDisplayName;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("recommendedSku")
    protected String recommendedSku;

    @JsonProperty("sizeInGB")
    protected Integer sizeInGB;

    @JsonProperty("sku")
    protected String sku;

    @JsonProperty("skuDisplayName")
    protected String skuDisplayName;

    @JsonProperty("startDate")
    protected LocalDate startDate;

    @JsonProperty("status")
    protected CloudPcGalleryImageStatus status;

    protected CloudPcGalleryImage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcGalleryImage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private LocalDate endDate;
        private LocalDate expirationDate;
        private String offer;
        private String offerDisplayName;
        private String publisher;
        private String recommendedSku;
        private Integer sizeInGB;
        private String sku;
        private String skuDisplayName;
        private LocalDate startDate;
        private CloudPcGalleryImageStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("endDate");
            return this;
        }

        public Builder expirationDate(LocalDate expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("expirationDate");
            return this;
        }

        public Builder offer(String offer) {
            this.offer = offer;
            this.changedFields = changedFields.add("offer");
            return this;
        }

        public Builder offerDisplayName(String offerDisplayName) {
            this.offerDisplayName = offerDisplayName;
            this.changedFields = changedFields.add("offerDisplayName");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder recommendedSku(String recommendedSku) {
            this.recommendedSku = recommendedSku;
            this.changedFields = changedFields.add("recommendedSku");
            return this;
        }

        public Builder sizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
            this.changedFields = changedFields.add("sizeInGB");
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            this.changedFields = changedFields.add("sku");
            return this;
        }

        public Builder skuDisplayName(String skuDisplayName) {
            this.skuDisplayName = skuDisplayName;
            this.changedFields = changedFields.add("skuDisplayName");
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("startDate");
            return this;
        }

        public Builder status(CloudPcGalleryImageStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public CloudPcGalleryImage build() {
            CloudPcGalleryImage _x = new CloudPcGalleryImage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcGalleryImage";
            _x.id = id;
            _x.displayName = displayName;
            _x.endDate = endDate;
            _x.expirationDate = expirationDate;
            _x.offer = offer;
            _x.offerDisplayName = offerDisplayName;
            _x.publisher = publisher;
            _x.recommendedSku = recommendedSku;
            _x.sizeInGB = sizeInGB;
            _x.sku = sku;
            _x.skuDisplayName = skuDisplayName;
            _x.startDate = startDate;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcGalleryImage withDisplayName(String displayName) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="endDate")
    @JsonIgnore
    public Optional<LocalDate> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public CloudPcGalleryImage withEndDate(LocalDate endDate) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("endDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="expirationDate")
    @JsonIgnore
    public Optional<LocalDate> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public CloudPcGalleryImage withExpirationDate(LocalDate expirationDate) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("expirationDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Property(name="offer")
    @JsonIgnore
    public Optional<String> getOffer() {
        return Optional.ofNullable(offer);
    }

    public CloudPcGalleryImage withOffer(String offer) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("offer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.offer = offer;
        return _x;
    }

    @Property(name="offerDisplayName")
    @JsonIgnore
    public Optional<String> getOfferDisplayName() {
        return Optional.ofNullable(offerDisplayName);
    }

    public CloudPcGalleryImage withOfferDisplayName(String offerDisplayName) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("offerDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.offerDisplayName = offerDisplayName;
        return _x;
    }

    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    public CloudPcGalleryImage withPublisher(String publisher) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.publisher = publisher;
        return _x;
    }

    @Property(name="recommendedSku")
    @JsonIgnore
    public Optional<String> getRecommendedSku() {
        return Optional.ofNullable(recommendedSku);
    }

    public CloudPcGalleryImage withRecommendedSku(String recommendedSku) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("recommendedSku");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.recommendedSku = recommendedSku;
        return _x;
    }

    @Property(name="sizeInGB")
    @JsonIgnore
    public Optional<Integer> getSizeInGB() {
        return Optional.ofNullable(sizeInGB);
    }

    public CloudPcGalleryImage withSizeInGB(Integer sizeInGB) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("sizeInGB");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.sizeInGB = sizeInGB;
        return _x;
    }

    @Property(name="sku")
    @JsonIgnore
    public Optional<String> getSku() {
        return Optional.ofNullable(sku);
    }

    public CloudPcGalleryImage withSku(String sku) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("sku");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.sku = sku;
        return _x;
    }

    @Property(name="skuDisplayName")
    @JsonIgnore
    public Optional<String> getSkuDisplayName() {
        return Optional.ofNullable(skuDisplayName);
    }

    public CloudPcGalleryImage withSkuDisplayName(String skuDisplayName) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("skuDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.skuDisplayName = skuDisplayName;
        return _x;
    }

    @Property(name="startDate")
    @JsonIgnore
    public Optional<LocalDate> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public CloudPcGalleryImage withStartDate(LocalDate startDate) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("startDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CloudPcGalleryImageStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CloudPcGalleryImage withStatus(CloudPcGalleryImageStatus status) {
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcGalleryImage");
        _x.status = status;
        return _x;
    }

    public CloudPcGalleryImage withUnmappedField(String name, Object value) {
        CloudPcGalleryImage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcGalleryImage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcGalleryImage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcGalleryImage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcGalleryImage _copy() {
        CloudPcGalleryImage _x = new CloudPcGalleryImage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.endDate = endDate;
        _x.expirationDate = expirationDate;
        _x.offer = offer;
        _x.offerDisplayName = offerDisplayName;
        _x.publisher = publisher;
        _x.recommendedSku = recommendedSku;
        _x.sizeInGB = sizeInGB;
        _x.sku = sku;
        _x.skuDisplayName = skuDisplayName;
        _x.startDate = startDate;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcGalleryImage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("expirationDate=");
        b.append(this.expirationDate);
        b.append(", ");
        b.append("offer=");
        b.append(this.offer);
        b.append(", ");
        b.append("offerDisplayName=");
        b.append(this.offerDisplayName);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("recommendedSku=");
        b.append(this.recommendedSku);
        b.append(", ");
        b.append("sizeInGB=");
        b.append(this.sizeInGB);
        b.append(", ");
        b.append("sku=");
        b.append(this.sku);
        b.append(", ");
        b.append("skuDisplayName=");
        b.append(this.skuDisplayName);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
