package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcDeviceImageOsStatus;
import odata.msgraph.client.beta.enums.CloudPcDeviceImageStatus;
import odata.msgraph.client.beta.enums.CloudPcDeviceImageStatusDetails;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "expirationDate", 
    "lastModifiedDateTime", 
    "operatingSystem", 
    "osBuildNumber", 
    "osStatus", 
    "sourceImageResourceId", 
    "status", 
    "statusDetails", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class CloudPcDeviceImage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcDeviceImage";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("expirationDate")
    protected LocalDate expirationDate;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("operatingSystem")
    protected String operatingSystem;

    @JsonProperty("osBuildNumber")
    protected String osBuildNumber;

    @JsonProperty("osStatus")
    protected CloudPcDeviceImageOsStatus osStatus;

    @JsonProperty("sourceImageResourceId")
    protected String sourceImageResourceId;

    @JsonProperty("status")
    protected CloudPcDeviceImageStatus status;

    @JsonProperty("statusDetails")
    protected CloudPcDeviceImageStatusDetails statusDetails;

    @JsonProperty("version")
    protected String version;

    protected CloudPcDeviceImage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcDeviceImage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private LocalDate expirationDate;
        private OffsetDateTime lastModifiedDateTime;
        private String operatingSystem;
        private String osBuildNumber;
        private CloudPcDeviceImageOsStatus osStatus;
        private String sourceImageResourceId;
        private CloudPcDeviceImageStatus status;
        private CloudPcDeviceImageStatusDetails statusDetails;
        private String version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder expirationDate(LocalDate expirationDate) {
            this.expirationDate = expirationDate;
            this.changedFields = changedFields.add("expirationDate");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        public Builder osBuildNumber(String osBuildNumber) {
            this.osBuildNumber = osBuildNumber;
            this.changedFields = changedFields.add("osBuildNumber");
            return this;
        }

        public Builder osStatus(CloudPcDeviceImageOsStatus osStatus) {
            this.osStatus = osStatus;
            this.changedFields = changedFields.add("osStatus");
            return this;
        }

        public Builder sourceImageResourceId(String sourceImageResourceId) {
            this.sourceImageResourceId = sourceImageResourceId;
            this.changedFields = changedFields.add("sourceImageResourceId");
            return this;
        }

        public Builder status(CloudPcDeviceImageStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder statusDetails(CloudPcDeviceImageStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            this.changedFields = changedFields.add("statusDetails");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public CloudPcDeviceImage build() {
            CloudPcDeviceImage _x = new CloudPcDeviceImage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcDeviceImage";
            _x.id = id;
            _x.displayName = displayName;
            _x.expirationDate = expirationDate;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.operatingSystem = operatingSystem;
            _x.osBuildNumber = osBuildNumber;
            _x.osStatus = osStatus;
            _x.sourceImageResourceId = sourceImageResourceId;
            _x.status = status;
            _x.statusDetails = statusDetails;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcDeviceImage withDisplayName(String displayName) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="expirationDate")
    @JsonIgnore
    public Optional<LocalDate> getExpirationDate() {
        return Optional.ofNullable(expirationDate);
    }

    public CloudPcDeviceImage withExpirationDate(LocalDate expirationDate) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("expirationDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.expirationDate = expirationDate;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CloudPcDeviceImage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="operatingSystem")
    @JsonIgnore
    public Optional<String> getOperatingSystem() {
        return Optional.ofNullable(operatingSystem);
    }

    public CloudPcDeviceImage withOperatingSystem(String operatingSystem) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("operatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.operatingSystem = operatingSystem;
        return _x;
    }

    @Property(name="osBuildNumber")
    @JsonIgnore
    public Optional<String> getOsBuildNumber() {
        return Optional.ofNullable(osBuildNumber);
    }

    public CloudPcDeviceImage withOsBuildNumber(String osBuildNumber) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("osBuildNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.osBuildNumber = osBuildNumber;
        return _x;
    }

    @Property(name="osStatus")
    @JsonIgnore
    public Optional<CloudPcDeviceImageOsStatus> getOsStatus() {
        return Optional.ofNullable(osStatus);
    }

    public CloudPcDeviceImage withOsStatus(CloudPcDeviceImageOsStatus osStatus) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("osStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.osStatus = osStatus;
        return _x;
    }

    @Property(name="sourceImageResourceId")
    @JsonIgnore
    public Optional<String> getSourceImageResourceId() {
        return Optional.ofNullable(sourceImageResourceId);
    }

    public CloudPcDeviceImage withSourceImageResourceId(String sourceImageResourceId) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("sourceImageResourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.sourceImageResourceId = sourceImageResourceId;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CloudPcDeviceImageStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CloudPcDeviceImage withStatus(CloudPcDeviceImageStatus status) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.status = status;
        return _x;
    }

    @Property(name="statusDetails")
    @JsonIgnore
    public Optional<CloudPcDeviceImageStatusDetails> getStatusDetails() {
        return Optional.ofNullable(statusDetails);
    }

    public CloudPcDeviceImage withStatusDetails(CloudPcDeviceImageStatusDetails statusDetails) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("statusDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.statusDetails = statusDetails;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public CloudPcDeviceImage withVersion(String version) {
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcDeviceImage");
        _x.version = version;
        return _x;
    }

    public CloudPcDeviceImage withUnmappedField(String name, Object value) {
        CloudPcDeviceImage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcDeviceImage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcDeviceImage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcDeviceImage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcDeviceImage _copy() {
        CloudPcDeviceImage _x = new CloudPcDeviceImage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.expirationDate = expirationDate;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.operatingSystem = operatingSystem;
        _x.osBuildNumber = osBuildNumber;
        _x.osStatus = osStatus;
        _x.sourceImageResourceId = sourceImageResourceId;
        _x.status = status;
        _x.statusDetails = statusDetails;
        _x.version = version;
        return _x;
    }

    @Action(name = "reupload")
    @JsonIgnore
    public ActionRequestNoReturn reupload() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reupload"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcDeviceImage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("expirationDate=");
        b.append(this.expirationDate);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("osBuildNumber=");
        b.append(this.osBuildNumber);
        b.append(", ");
        b.append("osStatus=");
        b.append(this.osStatus);
        b.append(", ");
        b.append("sourceImageResourceId=");
        b.append(this.sourceImageResourceId);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("statusDetails=");
        b.append(this.statusDetails);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
