package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The user experience analyte connectivity issue entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceId", 
    "errorCode", 
    "errorDateTime", 
    "errorDescription", 
    "recommendedAction", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class CloudPCConnectivityIssue extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPCConnectivityIssue";
    }

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("errorDateTime")
    protected OffsetDateTime errorDateTime;

    @JsonProperty("errorDescription")
    protected String errorDescription;

    @JsonProperty("recommendedAction")
    protected String recommendedAction;

    @JsonProperty("userId")
    protected String userId;

    protected CloudPCConnectivityIssue() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPCConnectivityIssue() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceId;
        private String errorCode;
        private OffsetDateTime errorDateTime;
        private String errorDescription;
        private String recommendedAction;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Intune DeviceId of the device the connection is associated with.”</i>
         * 
         * @param deviceId
         *            value of {@code deviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        /**
         * <i>“The error code of the connectivity issue.”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        /**
         * <i>“The time that the connection initiated. The time is shown in ISO 8601 format and
         * Coordinated Universal Time (UTC) time.”</i>
         * 
         * @param errorDateTime
         *            value of {@code errorDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDateTime(OffsetDateTime errorDateTime) {
            this.errorDateTime = errorDateTime;
            this.changedFields = changedFields.add("errorDateTime");
            return this;
        }

        /**
         * <i>“The detailed description of what went wrong.”</i>
         * 
         * @param errorDescription
         *            value of {@code errorDescription} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            this.changedFields = changedFields.add("errorDescription");
            return this;
        }

        /**
         * <i>“The recommended action to fix the corresponding error.”</i>
         * 
         * @param recommendedAction
         *            value of {@code recommendedAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
            this.changedFields = changedFields.add("recommendedAction");
            return this;
        }

        /**
         * <i>“The unique id of user who initialize the connection.”</i>
         * 
         * @param userId
         *            value of {@code userId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public CloudPCConnectivityIssue build() {
            CloudPCConnectivityIssue _x = new CloudPCConnectivityIssue();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPCConnectivityIssue";
            _x.id = id;
            _x.deviceId = deviceId;
            _x.errorCode = errorCode;
            _x.errorDateTime = errorDateTime;
            _x.errorDescription = errorDescription;
            _x.recommendedAction = recommendedAction;
            _x.userId = userId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The Intune DeviceId of the device the connection is associated with.”</i>
     * 
     * @return property deviceId
     */
    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The Intune DeviceId of the device the connection is associated with.”</i>
     * 
     * @param deviceId
     *            new value of {@code deviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceId} field changed
     */
    public CloudPCConnectivityIssue withDeviceId(String deviceId) {
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPCConnectivityIssue");
        _x.deviceId = deviceId;
        return _x;
    }

    /**
     * <i>“The error code of the connectivity issue.”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The error code of the connectivity issue.”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public CloudPCConnectivityIssue withErrorCode(String errorCode) {
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = changedFields.add("errorCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPCConnectivityIssue");
        _x.errorCode = errorCode;
        return _x;
    }

    /**
     * <i>“The time that the connection initiated. The time is shown in ISO 8601 format and
     * Coordinated Universal Time (UTC) time.”</i>
     * 
     * @return property errorDateTime
     */
    @Property(name="errorDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getErrorDateTime() {
        return Optional.ofNullable(errorDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The time that the connection initiated. The time is shown in ISO 8601 format and
     * Coordinated Universal Time (UTC) time.”</i>
     * 
     * @param errorDateTime
     *            new value of {@code errorDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDateTime} field changed
     */
    public CloudPCConnectivityIssue withErrorDateTime(OffsetDateTime errorDateTime) {
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = changedFields.add("errorDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPCConnectivityIssue");
        _x.errorDateTime = errorDateTime;
        return _x;
    }

    /**
     * <i>“The detailed description of what went wrong.”</i>
     * 
     * @return property errorDescription
     */
    @Property(name="errorDescription")
    @JsonIgnore
    public Optional<String> getErrorDescription() {
        return Optional.ofNullable(errorDescription);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorDescription}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The detailed description of what went wrong.”</i>
     * 
     * @param errorDescription
     *            new value of {@code errorDescription} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorDescription} field changed
     */
    public CloudPCConnectivityIssue withErrorDescription(String errorDescription) {
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = changedFields.add("errorDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPCConnectivityIssue");
        _x.errorDescription = errorDescription;
        return _x;
    }

    /**
     * <i>“The recommended action to fix the corresponding error.”</i>
     * 
     * @return property recommendedAction
     */
    @Property(name="recommendedAction")
    @JsonIgnore
    public Optional<String> getRecommendedAction() {
        return Optional.ofNullable(recommendedAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recommendedAction
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The recommended action to fix the corresponding error.”</i>
     * 
     * @param recommendedAction
     *            new value of {@code recommendedAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recommendedAction} field changed
     */
    public CloudPCConnectivityIssue withRecommendedAction(String recommendedAction) {
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = changedFields.add("recommendedAction");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPCConnectivityIssue");
        _x.recommendedAction = recommendedAction;
        return _x;
    }

    /**
     * <i>“The unique id of user who initialize the connection.”</i>
     * 
     * @return property userId
     */
    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The unique id of user who initialize the connection.”</i>
     * 
     * @param userId
     *            new value of {@code userId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userId} field changed
     */
    public CloudPCConnectivityIssue withUserId(String userId) {
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPCConnectivityIssue");
        _x.userId = userId;
        return _x;
    }

    public CloudPCConnectivityIssue withUnmappedField(String name, Object value) {
        CloudPCConnectivityIssue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPCConnectivityIssue patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPCConnectivityIssue put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPCConnectivityIssue _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPCConnectivityIssue _copy() {
        CloudPCConnectivityIssue _x = new CloudPCConnectivityIssue();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceId = deviceId;
        _x.errorCode = errorCode;
        _x.errorDateTime = errorDateTime;
        _x.errorDescription = errorDescription;
        _x.recommendedAction = recommendedAction;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPCConnectivityIssue[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("errorDateTime=");
        b.append(this.errorDateTime);
        b.append(", ");
        b.append("errorDescription=");
        b.append(this.errorDescription);
        b.append(", ");
        b.append("recommendedAction=");
        b.append(this.recommendedAction);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
