package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.callRecords.entity.CallRecord;
import odata.msgraph.client.beta.callRecords.entity.collection.request.CallRecordCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CallCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PresenceCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "calls", 
    "callRecords", 
    "onlineMeetings", 
    "presences"})
@JsonInclude(Include.NON_NULL)
public class CloudCommunications extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudCommunications";
    }

    @JsonProperty("calls")
    protected List<Call> calls;

    @JsonProperty("callRecords")
    protected List<CallRecord> callRecords;

    @JsonProperty("onlineMeetings")
    protected List<OnlineMeeting> onlineMeetings;

    @JsonProperty("presences")
    protected List<Presence> presences;

    protected CloudCommunications() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudCommunications() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<Call> calls;
        private List<CallRecord> callRecords;
        private List<OnlineMeeting> onlineMeetings;
        private List<Presence> presences;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder calls(List<Call> calls) {
            this.calls = calls;
            this.changedFields = changedFields.add("calls");
            return this;
        }

        public Builder calls(Call... calls) {
            return calls(Arrays.asList(calls));
        }

        public Builder callRecords(List<CallRecord> callRecords) {
            this.callRecords = callRecords;
            this.changedFields = changedFields.add("callRecords");
            return this;
        }

        public Builder callRecords(CallRecord... callRecords) {
            return callRecords(Arrays.asList(callRecords));
        }

        public Builder onlineMeetings(List<OnlineMeeting> onlineMeetings) {
            this.onlineMeetings = onlineMeetings;
            this.changedFields = changedFields.add("onlineMeetings");
            return this;
        }

        public Builder onlineMeetings(OnlineMeeting... onlineMeetings) {
            return onlineMeetings(Arrays.asList(onlineMeetings));
        }

        public Builder presences(List<Presence> presences) {
            this.presences = presences;
            this.changedFields = changedFields.add("presences");
            return this;
        }

        public Builder presences(Presence... presences) {
            return presences(Arrays.asList(presences));
        }

        public CloudCommunications build() {
            CloudCommunications _x = new CloudCommunications();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudCommunications";
            _x.id = id;
            _x.calls = calls;
            _x.callRecords = callRecords;
            _x.onlineMeetings = onlineMeetings;
            _x.presences = presences;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public CloudCommunications withUnmappedField(String name, Object value) {
        CloudCommunications _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="calls")
    @JsonIgnore
    public CallCollectionRequest getCalls() {
        return new CallCollectionRequest(
                        contextPath.addSegment("calls"), Optional.ofNullable(calls));
    }

    @NavigationProperty(name="callRecords")
    @JsonIgnore
    public CallRecordCollectionRequest getCallRecords() {
        return new CallRecordCollectionRequest(
                        contextPath.addSegment("callRecords"), Optional.ofNullable(callRecords));
    }

    @NavigationProperty(name="onlineMeetings")
    @JsonIgnore
    public OnlineMeetingCollectionRequest getOnlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"), Optional.ofNullable(onlineMeetings));
    }

    @NavigationProperty(name="presences")
    @JsonIgnore
    public PresenceCollectionRequest getPresences() {
        return new PresenceCollectionRequest(
                        contextPath.addSegment("presences"), Optional.ofNullable(presences));
    }

    public CloudCommunications withCalls(List<Call> calls) {
        CloudCommunications _x = _copy();
        _x.changedFields = changedFields.add("calls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudCommunications");
        _x.calls = calls;
        return _x;
    }

    public CloudCommunications withCallRecords(List<CallRecord> callRecords) {
        CloudCommunications _x = _copy();
        _x.changedFields = changedFields.add("callRecords");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudCommunications");
        _x.callRecords = callRecords;
        return _x;
    }

    public CloudCommunications withOnlineMeetings(List<OnlineMeeting> onlineMeetings) {
        CloudCommunications _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudCommunications");
        _x.onlineMeetings = onlineMeetings;
        return _x;
    }

    public CloudCommunications withPresences(List<Presence> presences) {
        CloudCommunications _x = _copy();
        _x.changedFields = changedFields.add("presences");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudCommunications");
        _x.presences = presences;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudCommunications patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudCommunications _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudCommunications put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudCommunications _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudCommunications _copy() {
        CloudCommunications _x = new CloudCommunications();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.calls = calls;
        _x.callRecords = callRecords;
        _x.onlineMeetings = onlineMeetings;
        _x.presences = presences;
        return _x;
    }

    @Action(name = "getPresencesByUserId")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Presence> getPresencesByUserId(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPresencesByUserId"), Presence.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudCommunications[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("calls=");
        b.append(this.calls);
        b.append(", ");
        b.append("callRecords=");
        b.append(this.callRecords);
        b.append(", ");
        b.append("onlineMeetings=");
        b.append(this.onlineMeetings);
        b.append(", ");
        b.append("presences=");
        b.append(this.presences);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
