package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ChatMessageFromIdentitySet;
import odata.msgraph.client.beta.complex.EventMessageDetail;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.enums.ChatMessageType;

@JsonPropertyOrder({
    "@odata.type", 
    "body", 
    "createdDateTime", 
    "eventDetail", 
    "from", 
    "isDeleted", 
    "messageType"})
@JsonInclude(Include.NON_NULL)
public class ChatMessageInfo extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessageInfo";
    }

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("eventDetail")
    protected EventMessageDetail eventDetail;

    @JsonProperty("from")
    protected ChatMessageFromIdentitySet from;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("messageType")
    protected ChatMessageType messageType;

    protected ChatMessageInfo() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChatMessageInfo() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ItemBody body;
        private OffsetDateTime createdDateTime;
        private EventMessageDetail eventDetail;
        private ChatMessageFromIdentitySet from;
        private Boolean isDeleted;
        private ChatMessageType messageType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder eventDetail(EventMessageDetail eventDetail) {
            this.eventDetail = eventDetail;
            this.changedFields = changedFields.add("eventDetail");
            return this;
        }

        public Builder from(ChatMessageFromIdentitySet from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder messageType(ChatMessageType messageType) {
            this.messageType = messageType;
            this.changedFields = changedFields.add("messageType");
            return this;
        }

        public ChatMessageInfo build() {
            ChatMessageInfo _x = new ChatMessageInfo();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessageInfo";
            _x.id = id;
            _x.body = body;
            _x.createdDateTime = createdDateTime;
            _x.eventDetail = eventDetail;
            _x.from = from;
            _x.isDeleted = isDeleted;
            _x.messageType = messageType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public ChatMessageInfo withBody(ItemBody body) {
        ChatMessageInfo _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageInfo");
        _x.body = body;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ChatMessageInfo withCreatedDateTime(OffsetDateTime createdDateTime) {
        ChatMessageInfo _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageInfo");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="eventDetail")
    @JsonIgnore
    public Optional<EventMessageDetail> getEventDetail() {
        return Optional.ofNullable(eventDetail);
    }

    public ChatMessageInfo withEventDetail(EventMessageDetail eventDetail) {
        ChatMessageInfo _x = _copy();
        _x.changedFields = changedFields.add("eventDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageInfo");
        _x.eventDetail = eventDetail;
        return _x;
    }

    @Property(name="from")
    @JsonIgnore
    public Optional<ChatMessageFromIdentitySet> getFrom() {
        return Optional.ofNullable(from);
    }

    public ChatMessageInfo withFrom(ChatMessageFromIdentitySet from) {
        ChatMessageInfo _x = _copy();
        _x.changedFields = changedFields.add("from");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageInfo");
        _x.from = from;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public ChatMessageInfo withIsDeleted(Boolean isDeleted) {
        ChatMessageInfo _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageInfo");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="messageType")
    @JsonIgnore
    public Optional<ChatMessageType> getMessageType() {
        return Optional.ofNullable(messageType);
    }

    public ChatMessageInfo withMessageType(ChatMessageType messageType) {
        ChatMessageInfo _x = _copy();
        _x.changedFields = changedFields.add("messageType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessageInfo");
        _x.messageType = messageType;
        return _x;
    }

    public ChatMessageInfo withUnmappedField(String name, Object value) {
        ChatMessageInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ChatMessageInfo patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ChatMessageInfo _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ChatMessageInfo put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ChatMessageInfo _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ChatMessageInfo _copy() {
        ChatMessageInfo _x = new ChatMessageInfo();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.body = body;
        _x.createdDateTime = createdDateTime;
        _x.eventDetail = eventDetail;
        _x.from = from;
        _x.isDeleted = isDeleted;
        _x.messageType = messageType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessageInfo[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("eventDetail=");
        b.append(this.eventDetail);
        b.append(", ");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("messageType=");
        b.append(this.messageType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
