package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ChannelIdentity;
import odata.msgraph.client.beta.complex.ChatMessageAttachment;
import odata.msgraph.client.beta.complex.ChatMessageFromIdentitySet;
import odata.msgraph.client.beta.complex.ChatMessageMention;
import odata.msgraph.client.beta.complex.ChatMessagePolicyViolation;
import odata.msgraph.client.beta.complex.ChatMessageReaction;
import odata.msgraph.client.beta.complex.EventMessageDetail;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageHostedContentCollectionRequest;
import odata.msgraph.client.beta.enums.ChatMessageImportance;
import odata.msgraph.client.beta.enums.ChatMessageType;

@JsonPropertyOrder({
    "@odata.type", 
    "attachments", 
    "body", 
    "channelIdentity", 
    "chatId", 
    "createdDateTime", 
    "deletedDateTime", 
    "etag", 
    "eventDetail", 
    "from", 
    "importance", 
    "lastEditedDateTime", 
    "lastModifiedDateTime", 
    "locale", 
    "mentions", 
    "messageType", 
    "onBehalfOf", 
    "policyViolation", 
    "reactions", 
    "replyToId", 
    "subject", 
    "summary", 
    "webUrl", 
    "hostedContents", 
    "replies"})
@JsonInclude(Include.NON_NULL)
public class ChatMessage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessage";
    }

    @JsonProperty("attachments")
    protected List<ChatMessageAttachment> attachments;

    @JsonProperty("attachments@nextLink")
    protected String attachmentsNextLink;

    @JsonProperty("body")
    protected ItemBody body;

    @JsonProperty("channelIdentity")
    protected ChannelIdentity channelIdentity;

    @JsonProperty("chatId")
    protected String chatId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deletedDateTime")
    protected OffsetDateTime deletedDateTime;

    @JsonProperty("etag")
    protected String etag;

    @JsonProperty("eventDetail")
    protected EventMessageDetail eventDetail;

    @JsonProperty("from")
    protected ChatMessageFromIdentitySet from;

    @JsonProperty("importance")
    protected ChatMessageImportance importance;

    @JsonProperty("lastEditedDateTime")
    protected OffsetDateTime lastEditedDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("locale")
    protected String locale;

    @JsonProperty("mentions")
    protected List<ChatMessageMention> mentions;

    @JsonProperty("mentions@nextLink")
    protected String mentionsNextLink;

    @JsonProperty("messageType")
    protected ChatMessageType messageType;

    @JsonProperty("onBehalfOf")
    protected ChatMessageFromIdentitySet onBehalfOf;

    @JsonProperty("policyViolation")
    protected ChatMessagePolicyViolation policyViolation;

    @JsonProperty("reactions")
    protected List<ChatMessageReaction> reactions;

    @JsonProperty("reactions@nextLink")
    protected String reactionsNextLink;

    @JsonProperty("replyToId")
    protected String replyToId;

    @JsonProperty("subject")
    protected String subject;

    @JsonProperty("summary")
    protected String summary;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("hostedContents")
    protected List<ChatMessageHostedContent> hostedContents;

    @JsonProperty("replies")
    protected List<ChatMessage> replies;

    protected ChatMessage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChatMessage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<ChatMessageAttachment> attachments;
        private String attachmentsNextLink;
        private ItemBody body;
        private ChannelIdentity channelIdentity;
        private String chatId;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime deletedDateTime;
        private String etag;
        private EventMessageDetail eventDetail;
        private ChatMessageFromIdentitySet from;
        private ChatMessageImportance importance;
        private OffsetDateTime lastEditedDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String locale;
        private List<ChatMessageMention> mentions;
        private String mentionsNextLink;
        private ChatMessageType messageType;
        private ChatMessageFromIdentitySet onBehalfOf;
        private ChatMessagePolicyViolation policyViolation;
        private List<ChatMessageReaction> reactions;
        private String reactionsNextLink;
        private String replyToId;
        private String subject;
        private String summary;
        private String webUrl;
        private List<ChatMessageHostedContent> hostedContents;
        private List<ChatMessage> replies;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder attachments(List<ChatMessageAttachment> attachments) {
            this.attachments = attachments;
            this.changedFields = changedFields.add("attachments");
            return this;
        }

        public Builder attachments(ChatMessageAttachment... attachments) {
            return attachments(Arrays.asList(attachments));
        }

        public Builder attachmentsNextLink(String attachmentsNextLink) {
            this.attachmentsNextLink = attachmentsNextLink;
            this.changedFields = changedFields.add("attachments");
            return this;
        }

        public Builder body(ItemBody body) {
            this.body = body;
            this.changedFields = changedFields.add("body");
            return this;
        }

        public Builder channelIdentity(ChannelIdentity channelIdentity) {
            this.channelIdentity = channelIdentity;
            this.changedFields = changedFields.add("channelIdentity");
            return this;
        }

        public Builder chatId(String chatId) {
            this.chatId = chatId;
            this.changedFields = changedFields.add("chatId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            this.changedFields = changedFields.add("etag");
            return this;
        }

        public Builder eventDetail(EventMessageDetail eventDetail) {
            this.eventDetail = eventDetail;
            this.changedFields = changedFields.add("eventDetail");
            return this;
        }

        public Builder from(ChatMessageFromIdentitySet from) {
            this.from = from;
            this.changedFields = changedFields.add("from");
            return this;
        }

        public Builder importance(ChatMessageImportance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder lastEditedDateTime(OffsetDateTime lastEditedDateTime) {
            this.lastEditedDateTime = lastEditedDateTime;
            this.changedFields = changedFields.add("lastEditedDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            this.changedFields = changedFields.add("locale");
            return this;
        }

        public Builder mentions(List<ChatMessageMention> mentions) {
            this.mentions = mentions;
            this.changedFields = changedFields.add("mentions");
            return this;
        }

        public Builder mentions(ChatMessageMention... mentions) {
            return mentions(Arrays.asList(mentions));
        }

        public Builder mentionsNextLink(String mentionsNextLink) {
            this.mentionsNextLink = mentionsNextLink;
            this.changedFields = changedFields.add("mentions");
            return this;
        }

        public Builder messageType(ChatMessageType messageType) {
            this.messageType = messageType;
            this.changedFields = changedFields.add("messageType");
            return this;
        }

        public Builder onBehalfOf(ChatMessageFromIdentitySet onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            this.changedFields = changedFields.add("onBehalfOf");
            return this;
        }

        public Builder policyViolation(ChatMessagePolicyViolation policyViolation) {
            this.policyViolation = policyViolation;
            this.changedFields = changedFields.add("policyViolation");
            return this;
        }

        public Builder reactions(List<ChatMessageReaction> reactions) {
            this.reactions = reactions;
            this.changedFields = changedFields.add("reactions");
            return this;
        }

        public Builder reactions(ChatMessageReaction... reactions) {
            return reactions(Arrays.asList(reactions));
        }

        public Builder reactionsNextLink(String reactionsNextLink) {
            this.reactionsNextLink = reactionsNextLink;
            this.changedFields = changedFields.add("reactions");
            return this;
        }

        public Builder replyToId(String replyToId) {
            this.replyToId = replyToId;
            this.changedFields = changedFields.add("replyToId");
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            this.changedFields = changedFields.add("subject");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.changedFields = changedFields.add("summary");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder hostedContents(List<ChatMessageHostedContent> hostedContents) {
            this.hostedContents = hostedContents;
            this.changedFields = changedFields.add("hostedContents");
            return this;
        }

        public Builder hostedContents(ChatMessageHostedContent... hostedContents) {
            return hostedContents(Arrays.asList(hostedContents));
        }

        public Builder replies(List<ChatMessage> replies) {
            this.replies = replies;
            this.changedFields = changedFields.add("replies");
            return this;
        }

        public Builder replies(ChatMessage... replies) {
            return replies(Arrays.asList(replies));
        }

        public ChatMessage build() {
            ChatMessage _x = new ChatMessage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chatMessage";
            _x.id = id;
            _x.attachments = attachments;
            _x.attachmentsNextLink = attachmentsNextLink;
            _x.body = body;
            _x.channelIdentity = channelIdentity;
            _x.chatId = chatId;
            _x.createdDateTime = createdDateTime;
            _x.deletedDateTime = deletedDateTime;
            _x.etag = etag;
            _x.eventDetail = eventDetail;
            _x.from = from;
            _x.importance = importance;
            _x.lastEditedDateTime = lastEditedDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.locale = locale;
            _x.mentions = mentions;
            _x.mentionsNextLink = mentionsNextLink;
            _x.messageType = messageType;
            _x.onBehalfOf = onBehalfOf;
            _x.policyViolation = policyViolation;
            _x.reactions = reactions;
            _x.reactionsNextLink = reactionsNextLink;
            _x.replyToId = replyToId;
            _x.subject = subject;
            _x.summary = summary;
            _x.webUrl = webUrl;
            _x.hostedContents = hostedContents;
            _x.replies = replies;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="attachments")
    @JsonIgnore
    public CollectionPage<ChatMessageAttachment> getAttachments() {
        return new CollectionPage<ChatMessageAttachment>(contextPath, ChatMessageAttachment.class, this.attachments, Optional.ofNullable(attachmentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ChatMessage withAttachments(List<ChatMessageAttachment> attachments) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("attachments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.attachments = attachments;
        return _x;
    }

    @Property(name="attachments")
    @JsonIgnore
    public CollectionPage<ChatMessageAttachment> getAttachments(HttpRequestOptions options) {
        return new CollectionPage<ChatMessageAttachment>(contextPath, ChatMessageAttachment.class, this.attachments, Optional.ofNullable(attachmentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="body")
    @JsonIgnore
    public Optional<ItemBody> getBody() {
        return Optional.ofNullable(body);
    }

    public ChatMessage withBody(ItemBody body) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("body");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.body = body;
        return _x;
    }

    @Property(name="channelIdentity")
    @JsonIgnore
    public Optional<ChannelIdentity> getChannelIdentity() {
        return Optional.ofNullable(channelIdentity);
    }

    public ChatMessage withChannelIdentity(ChannelIdentity channelIdentity) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("channelIdentity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.channelIdentity = channelIdentity;
        return _x;
    }

    @Property(name="chatId")
    @JsonIgnore
    public Optional<String> getChatId() {
        return Optional.ofNullable(chatId);
    }

    public ChatMessage withChatId(String chatId) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("chatId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.chatId = chatId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ChatMessage withCreatedDateTime(OffsetDateTime createdDateTime) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="deletedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDeletedDateTime() {
        return Optional.ofNullable(deletedDateTime);
    }

    public ChatMessage withDeletedDateTime(OffsetDateTime deletedDateTime) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("deletedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.deletedDateTime = deletedDateTime;
        return _x;
    }

    @Property(name="etag")
    @JsonIgnore
    public Optional<String> getEtag() {
        return Optional.ofNullable(etag);
    }

    public ChatMessage withEtag(String etag) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("etag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.etag = etag;
        return _x;
    }

    @Property(name="eventDetail")
    @JsonIgnore
    public Optional<EventMessageDetail> getEventDetail() {
        return Optional.ofNullable(eventDetail);
    }

    public ChatMessage withEventDetail(EventMessageDetail eventDetail) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("eventDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.eventDetail = eventDetail;
        return _x;
    }

    @Property(name="from")
    @JsonIgnore
    public Optional<ChatMessageFromIdentitySet> getFrom() {
        return Optional.ofNullable(from);
    }

    public ChatMessage withFrom(ChatMessageFromIdentitySet from) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("from");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.from = from;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<ChatMessageImportance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public ChatMessage withImportance(ChatMessageImportance importance) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.importance = importance;
        return _x;
    }

    @Property(name="lastEditedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastEditedDateTime() {
        return Optional.ofNullable(lastEditedDateTime);
    }

    public ChatMessage withLastEditedDateTime(OffsetDateTime lastEditedDateTime) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("lastEditedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.lastEditedDateTime = lastEditedDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ChatMessage withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="locale")
    @JsonIgnore
    public Optional<String> getLocale() {
        return Optional.ofNullable(locale);
    }

    public ChatMessage withLocale(String locale) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("locale");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.locale = locale;
        return _x;
    }

    @Property(name="mentions")
    @JsonIgnore
    public CollectionPage<ChatMessageMention> getMentions() {
        return new CollectionPage<ChatMessageMention>(contextPath, ChatMessageMention.class, this.mentions, Optional.ofNullable(mentionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ChatMessage withMentions(List<ChatMessageMention> mentions) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("mentions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.mentions = mentions;
        return _x;
    }

    @Property(name="mentions")
    @JsonIgnore
    public CollectionPage<ChatMessageMention> getMentions(HttpRequestOptions options) {
        return new CollectionPage<ChatMessageMention>(contextPath, ChatMessageMention.class, this.mentions, Optional.ofNullable(mentionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="messageType")
    @JsonIgnore
    public Optional<ChatMessageType> getMessageType() {
        return Optional.ofNullable(messageType);
    }

    public ChatMessage withMessageType(ChatMessageType messageType) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("messageType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.messageType = messageType;
        return _x;
    }

    @Property(name="onBehalfOf")
    @JsonIgnore
    public Optional<ChatMessageFromIdentitySet> getOnBehalfOf() {
        return Optional.ofNullable(onBehalfOf);
    }

    public ChatMessage withOnBehalfOf(ChatMessageFromIdentitySet onBehalfOf) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("onBehalfOf");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.onBehalfOf = onBehalfOf;
        return _x;
    }

    @Property(name="policyViolation")
    @JsonIgnore
    public Optional<ChatMessagePolicyViolation> getPolicyViolation() {
        return Optional.ofNullable(policyViolation);
    }

    public ChatMessage withPolicyViolation(ChatMessagePolicyViolation policyViolation) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("policyViolation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.policyViolation = policyViolation;
        return _x;
    }

    @Property(name="reactions")
    @JsonIgnore
    public CollectionPage<ChatMessageReaction> getReactions() {
        return new CollectionPage<ChatMessageReaction>(contextPath, ChatMessageReaction.class, this.reactions, Optional.ofNullable(reactionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ChatMessage withReactions(List<ChatMessageReaction> reactions) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("reactions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.reactions = reactions;
        return _x;
    }

    @Property(name="reactions")
    @JsonIgnore
    public CollectionPage<ChatMessageReaction> getReactions(HttpRequestOptions options) {
        return new CollectionPage<ChatMessageReaction>(contextPath, ChatMessageReaction.class, this.reactions, Optional.ofNullable(reactionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="replyToId")
    @JsonIgnore
    public Optional<String> getReplyToId() {
        return Optional.ofNullable(replyToId);
    }

    public ChatMessage withReplyToId(String replyToId) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("replyToId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.replyToId = replyToId;
        return _x;
    }

    @Property(name="subject")
    @JsonIgnore
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    public ChatMessage withSubject(String subject) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("subject");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.subject = subject;
        return _x;
    }

    @Property(name="summary")
    @JsonIgnore
    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    public ChatMessage withSummary(String summary) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("summary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.summary = summary;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public ChatMessage withWebUrl(String webUrl) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.webUrl = webUrl;
        return _x;
    }

    public ChatMessage withUnmappedField(String name, Object value) {
        ChatMessage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="hostedContents")
    @JsonIgnore
    public ChatMessageHostedContentCollectionRequest getHostedContents() {
        return new ChatMessageHostedContentCollectionRequest(
                        contextPath.addSegment("hostedContents"), Optional.ofNullable(hostedContents));
    }

    @NavigationProperty(name="replies")
    @JsonIgnore
    public ChatMessageCollectionRequest getReplies() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("replies"), Optional.ofNullable(replies));
    }

    public ChatMessage withHostedContents(List<ChatMessageHostedContent> hostedContents) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("hostedContents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.hostedContents = hostedContents;
        return _x;
    }

    public ChatMessage withReplies(List<ChatMessage> replies) {
        ChatMessage _x = _copy();
        _x.changedFields = changedFields.add("replies");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessage");
        _x.replies = replies;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ChatMessage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ChatMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ChatMessage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ChatMessage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ChatMessage _copy() {
        ChatMessage _x = new ChatMessage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.attachments = attachments;
        _x.body = body;
        _x.channelIdentity = channelIdentity;
        _x.chatId = chatId;
        _x.createdDateTime = createdDateTime;
        _x.deletedDateTime = deletedDateTime;
        _x.etag = etag;
        _x.eventDetail = eventDetail;
        _x.from = from;
        _x.importance = importance;
        _x.lastEditedDateTime = lastEditedDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.locale = locale;
        _x.mentions = mentions;
        _x.messageType = messageType;
        _x.onBehalfOf = onBehalfOf;
        _x.policyViolation = policyViolation;
        _x.reactions = reactions;
        _x.replyToId = replyToId;
        _x.subject = subject;
        _x.summary = summary;
        _x.webUrl = webUrl;
        _x.hostedContents = hostedContents;
        _x.replies = replies;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("attachments=");
        b.append(this.attachments);
        b.append(", ");
        b.append("body=");
        b.append(this.body);
        b.append(", ");
        b.append("channelIdentity=");
        b.append(this.channelIdentity);
        b.append(", ");
        b.append("chatId=");
        b.append(this.chatId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("etag=");
        b.append(this.etag);
        b.append(", ");
        b.append("eventDetail=");
        b.append(this.eventDetail);
        b.append(", ");
        b.append("from=");
        b.append(this.from);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("lastEditedDateTime=");
        b.append(this.lastEditedDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("locale=");
        b.append(this.locale);
        b.append(", ");
        b.append("mentions=");
        b.append(this.mentions);
        b.append(", ");
        b.append("messageType=");
        b.append(this.messageType);
        b.append(", ");
        b.append("onBehalfOf=");
        b.append(this.onBehalfOf);
        b.append(", ");
        b.append("policyViolation=");
        b.append(this.policyViolation);
        b.append(", ");
        b.append("reactions=");
        b.append(this.reactions);
        b.append(", ");
        b.append("replyToId=");
        b.append(this.replyToId);
        b.append(", ");
        b.append("subject=");
        b.append(this.subject);
        b.append(", ");
        b.append("summary=");
        b.append(this.summary);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("hostedContents=");
        b.append(this.hostedContents);
        b.append(", ");
        b.append("replies=");
        b.append(this.replies);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
