package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ChatViewpoint;
import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.complex.TeamworkNotificationRecipient;
import odata.msgraph.client.beta.complex.TeamworkOnlineMeetingInfo;
import odata.msgraph.client.beta.complex.TeamworkUserIdentity;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceSpecificPermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAsyncOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsTabCollectionRequest;
import odata.msgraph.client.beta.entity.request.ChatMessageInfoRequest;
import odata.msgraph.client.beta.enums.ChatType;

@JsonPropertyOrder({
    "@odata.type", 
    "chatType", 
    "createdDateTime", 
    "lastUpdatedDateTime", 
    "onlineMeetingInfo", 
    "tenantId", 
    "topic", 
    "viewpoint", 
    "webUrl", 
    "installedApps", 
    "lastMessagePreview", 
    "members", 
    "messages", 
    "operations", 
    "permissionGrants", 
    "tabs"})
@JsonInclude(Include.NON_NULL)
public class Chat extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chat";
    }

    @JsonProperty("chatType")
    protected ChatType chatType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("onlineMeetingInfo")
    protected TeamworkOnlineMeetingInfo onlineMeetingInfo;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("topic")
    protected String topic;

    @JsonProperty("viewpoint")
    protected ChatViewpoint viewpoint;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("installedApps")
    protected List<TeamsAppInstallation> installedApps;

    @JsonProperty("lastMessagePreview")
    protected ChatMessageInfo lastMessagePreview;

    @JsonProperty("members")
    protected List<ConversationMember> members;

    @JsonProperty("messages")
    protected List<ChatMessage> messages;

    @JsonProperty("operations")
    protected List<TeamsAsyncOperation> operations;

    @JsonProperty("permissionGrants")
    protected List<ResourceSpecificPermissionGrant> permissionGrants;

    @JsonProperty("tabs")
    protected List<TeamsTab> tabs;

    protected Chat() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChat() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChatType chatType;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private TeamworkOnlineMeetingInfo onlineMeetingInfo;
        private String tenantId;
        private String topic;
        private ChatViewpoint viewpoint;
        private String webUrl;
        private List<TeamsAppInstallation> installedApps;
        private ChatMessageInfo lastMessagePreview;
        private List<ConversationMember> members;
        private List<ChatMessage> messages;
        private List<TeamsAsyncOperation> operations;
        private List<ResourceSpecificPermissionGrant> permissionGrants;
        private List<TeamsTab> tabs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder chatType(ChatType chatType) {
            this.chatType = chatType;
            this.changedFields = changedFields.add("chatType");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder onlineMeetingInfo(TeamworkOnlineMeetingInfo onlineMeetingInfo) {
            this.onlineMeetingInfo = onlineMeetingInfo;
            this.changedFields = changedFields.add("onlineMeetingInfo");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            this.changedFields = changedFields.add("topic");
            return this;
        }

        public Builder viewpoint(ChatViewpoint viewpoint) {
            this.viewpoint = viewpoint;
            this.changedFields = changedFields.add("viewpoint");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder installedApps(List<TeamsAppInstallation> installedApps) {
            this.installedApps = installedApps;
            this.changedFields = changedFields.add("installedApps");
            return this;
        }

        public Builder installedApps(TeamsAppInstallation... installedApps) {
            return installedApps(Arrays.asList(installedApps));
        }

        public Builder lastMessagePreview(ChatMessageInfo lastMessagePreview) {
            this.lastMessagePreview = lastMessagePreview;
            this.changedFields = changedFields.add("lastMessagePreview");
            return this;
        }

        public Builder members(List<ConversationMember> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder members(ConversationMember... members) {
            return members(Arrays.asList(members));
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("messages");
            return this;
        }

        public Builder messages(ChatMessage... messages) {
            return messages(Arrays.asList(messages));
        }

        public Builder operations(List<TeamsAsyncOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(TeamsAsyncOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder permissionGrants(List<ResourceSpecificPermissionGrant> permissionGrants) {
            this.permissionGrants = permissionGrants;
            this.changedFields = changedFields.add("permissionGrants");
            return this;
        }

        public Builder permissionGrants(ResourceSpecificPermissionGrant... permissionGrants) {
            return permissionGrants(Arrays.asList(permissionGrants));
        }

        public Builder tabs(List<TeamsTab> tabs) {
            this.tabs = tabs;
            this.changedFields = changedFields.add("tabs");
            return this;
        }

        public Builder tabs(TeamsTab... tabs) {
            return tabs(Arrays.asList(tabs));
        }

        public Chat build() {
            Chat _x = new Chat();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chat";
            _x.id = id;
            _x.chatType = chatType;
            _x.createdDateTime = createdDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.onlineMeetingInfo = onlineMeetingInfo;
            _x.tenantId = tenantId;
            _x.topic = topic;
            _x.viewpoint = viewpoint;
            _x.webUrl = webUrl;
            _x.installedApps = installedApps;
            _x.lastMessagePreview = lastMessagePreview;
            _x.members = members;
            _x.messages = messages;
            _x.operations = operations;
            _x.permissionGrants = permissionGrants;
            _x.tabs = tabs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="chatType")
    @JsonIgnore
    public Optional<ChatType> getChatType() {
        return Optional.ofNullable(chatType);
    }

    public Chat withChatType(ChatType chatType) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("chatType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.chatType = chatType;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Chat withCreatedDateTime(OffsetDateTime createdDateTime) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public Chat withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="onlineMeetingInfo")
    @JsonIgnore
    public Optional<TeamworkOnlineMeetingInfo> getOnlineMeetingInfo() {
        return Optional.ofNullable(onlineMeetingInfo);
    }

    public Chat withOnlineMeetingInfo(TeamworkOnlineMeetingInfo onlineMeetingInfo) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetingInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.onlineMeetingInfo = onlineMeetingInfo;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public Chat withTenantId(String tenantId) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="topic")
    @JsonIgnore
    public Optional<String> getTopic() {
        return Optional.ofNullable(topic);
    }

    public Chat withTopic(String topic) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("topic");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.topic = topic;
        return _x;
    }

    @Property(name="viewpoint")
    @JsonIgnore
    public Optional<ChatViewpoint> getViewpoint() {
        return Optional.ofNullable(viewpoint);
    }

    public Chat withViewpoint(ChatViewpoint viewpoint) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("viewpoint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.viewpoint = viewpoint;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public Chat withWebUrl(String webUrl) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.webUrl = webUrl;
        return _x;
    }

    public Chat withUnmappedField(String name, Object value) {
        Chat _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="installedApps")
    @JsonIgnore
    public TeamsAppInstallationCollectionRequest getInstalledApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"), Optional.ofNullable(installedApps));
    }

    @NavigationProperty(name="lastMessagePreview")
    @JsonIgnore
    public ChatMessageInfoRequest getLastMessagePreview() {
        return new ChatMessageInfoRequest(contextPath.addSegment("lastMessagePreview"), Optional.ofNullable(lastMessagePreview));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public ConversationMemberCollectionRequest getMembers() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.ofNullable(members));
    }

    @NavigationProperty(name="messages")
    @JsonIgnore
    public ChatMessageCollectionRequest getMessages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.ofNullable(messages));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public TeamsAsyncOperationCollectionRequest getOperations() {
        return new TeamsAsyncOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="permissionGrants")
    @JsonIgnore
    public ResourceSpecificPermissionGrantCollectionRequest getPermissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(
                        contextPath.addSegment("permissionGrants"), Optional.ofNullable(permissionGrants));
    }

    @NavigationProperty(name="tabs")
    @JsonIgnore
    public TeamsTabCollectionRequest getTabs() {
        return new TeamsTabCollectionRequest(
                        contextPath.addSegment("tabs"), Optional.ofNullable(tabs));
    }

    public Chat withInstalledApps(List<TeamsAppInstallation> installedApps) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("installedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.installedApps = installedApps;
        return _x;
    }

    public Chat withLastMessagePreview(ChatMessageInfo lastMessagePreview) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("lastMessagePreview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.lastMessagePreview = lastMessagePreview;
        return _x;
    }

    public Chat withMembers(List<ConversationMember> members) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("members");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.members = members;
        return _x;
    }

    public Chat withMessages(List<ChatMessage> messages) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("messages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.messages = messages;
        return _x;
    }

    public Chat withOperations(List<TeamsAsyncOperation> operations) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.operations = operations;
        return _x;
    }

    public Chat withPermissionGrants(List<ResourceSpecificPermissionGrant> permissionGrants) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("permissionGrants");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.permissionGrants = permissionGrants;
        return _x;
    }

    public Chat withTabs(List<TeamsTab> tabs) {
        Chat _x = _copy();
        _x.changedFields = changedFields.add("tabs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chat");
        _x.tabs = tabs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Chat patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Chat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Chat put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Chat _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Chat _copy() {
        Chat _x = new Chat();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.chatType = chatType;
        _x.createdDateTime = createdDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.onlineMeetingInfo = onlineMeetingInfo;
        _x.tenantId = tenantId;
        _x.topic = topic;
        _x.viewpoint = viewpoint;
        _x.webUrl = webUrl;
        _x.installedApps = installedApps;
        _x.lastMessagePreview = lastMessagePreview;
        _x.members = members;
        _x.messages = messages;
        _x.operations = operations;
        _x.permissionGrants = permissionGrants;
        _x.tabs = tabs;
        return _x;
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters, TeamworkNotificationRecipient recipient) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .put("recipient", "microsoft.graph.teamworkNotificationRecipient", recipient)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

    @Action(name = "hideForUser")
    @JsonIgnore
    public ActionRequestNoReturn hideForUser(TeamworkUserIdentity user, String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hideForUser"), _parameters);
    }

    @Action(name = "markChatReadForUser")
    @JsonIgnore
    public ActionRequestNoReturn markChatReadForUser(TeamworkUserIdentity user, String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.markChatReadForUser"), _parameters);
    }

    @Action(name = "markChatUnreadForUser")
    @JsonIgnore
    public ActionRequestNoReturn markChatUnreadForUser(TeamworkUserIdentity user, String tenantId, OffsetDateTime lastMessageReadDateTime) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("lastMessageReadDateTime", "Edm.DateTimeOffset", lastMessageReadDateTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.markChatUnreadForUser"), _parameters);
    }

    @Action(name = "unhideForUser")
    @JsonIgnore
    public ActionRequestNoReturn unhideForUser(TeamworkUserIdentity user, String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unhideForUser"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Chat[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("chatType=");
        b.append(this.chatType);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("onlineMeetingInfo=");
        b.append(this.onlineMeetingInfo);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("topic=");
        b.append(this.topic);
        b.append(", ");
        b.append("viewpoint=");
        b.append(this.viewpoint);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("installedApps=");
        b.append(this.installedApps);
        b.append(", ");
        b.append("lastMessagePreview=");
        b.append(this.lastMessagePreview);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append(", ");
        b.append("messages=");
        b.append(this.messages);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("permissionGrants=");
        b.append(this.permissionGrants);
        b.append(", ");
        b.append("tabs=");
        b.append(this.tabs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
