package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "changeKey", 
    "classId", 
    "name", 
    "calendars"})
@JsonInclude(Include.NON_NULL)
public class CalendarGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.calendarGroup";
    }

    @JsonProperty("changeKey")
    protected String changeKey;

    @JsonProperty("classId")
    protected UUID classId;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("calendars")
    protected List<Calendar> calendars;

    protected CalendarGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCalendarGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String changeKey;
        private UUID classId;
        private String name;
        private List<Calendar> calendars;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder classId(UUID classId) {
            this.classId = classId;
            this.changedFields = changedFields.add("classId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendars
         *            value of {@code calendars} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendars(List<Calendar> calendars) {
            this.calendars = calendars;
            this.changedFields = changedFields.add("calendars");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param calendars
         *            value of {@code calendars} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendars(Calendar... calendars) {
            return calendars(Arrays.asList(calendars));
        }

        public CalendarGroup build() {
            CalendarGroup _x = new CalendarGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.calendarGroup";
            _x.id = id;
            _x.changeKey = changeKey;
            _x.classId = classId;
            _x.name = name;
            _x.calendars = calendars;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="changeKey")
    @JsonIgnore
    public Optional<String> getChangeKey() {
        return Optional.ofNullable(changeKey);
    }

    public CalendarGroup withChangeKey(String changeKey) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("changeKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.changeKey = changeKey;
        return _x;
    }

    @Property(name="classId")
    @JsonIgnore
    public Optional<UUID> getClassId() {
        return Optional.ofNullable(classId);
    }

    public CalendarGroup withClassId(UUID classId) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("classId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.classId = classId;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public CalendarGroup withName(String name) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.name = name;
        return _x;
    }

    public CalendarGroup withUnmappedField(String name, Object value) {
        CalendarGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property calendars
     */
    @NavigationProperty(name="calendars")
    @JsonIgnore
    public CalendarCollectionRequest getCalendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"), Optional.ofNullable(calendars));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendars} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param calendars
     *            new value of {@code calendars} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendars} field changed
     */
    public CalendarGroup withCalendars(List<Calendar> calendars) {
        CalendarGroup _x = _copy();
        _x.changedFields = changedFields.add("calendars");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarGroup");
        _x.calendars = calendars;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CalendarGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CalendarGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CalendarGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CalendarGroup _copy() {
        CalendarGroup _x = new CalendarGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.changeKey = changeKey;
        _x.classId = classId;
        _x.name = name;
        _x.calendars = calendars;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CalendarGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("classId=");
        b.append(this.classId);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("calendars=");
        b.append(this.calendars);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
