package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BusinessFlowSettings;
import odata.msgraph.client.beta.complex.GovernancePolicy;

@JsonPropertyOrder({
    "@odata.type", 
    "customData", 
    "deDuplicationId", 
    "description", 
    "displayName", 
    "policy", 
    "policyTemplateId", 
    "recordVersion", 
    "schemaId", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class BusinessFlow extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.businessFlow";
    }

    @JsonProperty("customData")
    protected String customData;

    @JsonProperty("deDuplicationId")
    protected String deDuplicationId;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("policy")
    protected GovernancePolicy policy;

    @JsonProperty("policyTemplateId")
    protected String policyTemplateId;

    @JsonProperty("recordVersion")
    protected String recordVersion;

    @JsonProperty("schemaId")
    protected String schemaId;

    @JsonProperty("settings")
    protected BusinessFlowSettings settings;

    protected BusinessFlow() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBusinessFlow() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String customData;
        private String deDuplicationId;
        private String description;
        private String displayName;
        private GovernancePolicy policy;
        private String policyTemplateId;
        private String recordVersion;
        private String schemaId;
        private BusinessFlowSettings settings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder customData(String customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        public Builder deDuplicationId(String deDuplicationId) {
            this.deDuplicationId = deDuplicationId;
            this.changedFields = changedFields.add("deDuplicationId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder policy(GovernancePolicy policy) {
            this.policy = policy;
            this.changedFields = changedFields.add("policy");
            return this;
        }

        public Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            this.changedFields = changedFields.add("policyTemplateId");
            return this;
        }

        public Builder recordVersion(String recordVersion) {
            this.recordVersion = recordVersion;
            this.changedFields = changedFields.add("recordVersion");
            return this;
        }

        public Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            this.changedFields = changedFields.add("schemaId");
            return this;
        }

        public Builder settings(BusinessFlowSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public BusinessFlow build() {
            BusinessFlow _x = new BusinessFlow();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.businessFlow";
            _x.id = id;
            _x.customData = customData;
            _x.deDuplicationId = deDuplicationId;
            _x.description = description;
            _x.displayName = displayName;
            _x.policy = policy;
            _x.policyTemplateId = policyTemplateId;
            _x.recordVersion = recordVersion;
            _x.schemaId = schemaId;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="customData")
    @JsonIgnore
    public Optional<String> getCustomData() {
        return Optional.ofNullable(customData);
    }

    public BusinessFlow withCustomData(String customData) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("customData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.customData = customData;
        return _x;
    }

    @Property(name="deDuplicationId")
    @JsonIgnore
    public Optional<String> getDeDuplicationId() {
        return Optional.ofNullable(deDuplicationId);
    }

    public BusinessFlow withDeDuplicationId(String deDuplicationId) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("deDuplicationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.deDuplicationId = deDuplicationId;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public BusinessFlow withDescription(String description) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public BusinessFlow withDisplayName(String displayName) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="policy")
    @JsonIgnore
    public Optional<GovernancePolicy> getPolicy() {
        return Optional.ofNullable(policy);
    }

    public BusinessFlow withPolicy(GovernancePolicy policy) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("policy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.policy = policy;
        return _x;
    }

    @Property(name="policyTemplateId")
    @JsonIgnore
    public Optional<String> getPolicyTemplateId() {
        return Optional.ofNullable(policyTemplateId);
    }

    public BusinessFlow withPolicyTemplateId(String policyTemplateId) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("policyTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.policyTemplateId = policyTemplateId;
        return _x;
    }

    @Property(name="recordVersion")
    @JsonIgnore
    public Optional<String> getRecordVersion() {
        return Optional.ofNullable(recordVersion);
    }

    public BusinessFlow withRecordVersion(String recordVersion) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("recordVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.recordVersion = recordVersion;
        return _x;
    }

    @Property(name="schemaId")
    @JsonIgnore
    public Optional<String> getSchemaId() {
        return Optional.ofNullable(schemaId);
    }

    public BusinessFlow withSchemaId(String schemaId) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("schemaId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.schemaId = schemaId;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<BusinessFlowSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public BusinessFlow withSettings(BusinessFlowSettings settings) {
        BusinessFlow _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.businessFlow");
        _x.settings = settings;
        return _x;
    }

    public BusinessFlow withUnmappedField(String name, Object value) {
        BusinessFlow _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BusinessFlow patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BusinessFlow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BusinessFlow put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BusinessFlow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BusinessFlow _copy() {
        BusinessFlow _x = new BusinessFlow();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.customData = customData;
        _x.deDuplicationId = deDuplicationId;
        _x.description = description;
        _x.displayName = displayName;
        _x.policy = policy;
        _x.policyTemplateId = policyTemplateId;
        _x.recordVersion = recordVersion;
        _x.schemaId = schemaId;
        _x.settings = settings;
        return _x;
    }

    @Action(name = "recordDecisions")
    @JsonIgnore
    public ActionRequestNoReturn recordDecisions(String reviewResult, String justification) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reviewResult", "Edm.String", Checks.checkIsAscii(reviewResult))
            .put("justification", "Edm.String", Checks.checkIsAscii(justification))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recordDecisions"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BusinessFlow[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("deDuplicationId=");
        b.append(this.deDuplicationId);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("policy=");
        b.append(this.policy);
        b.append(", ");
        b.append("policyTemplateId=");
        b.append(this.policyTemplateId);
        b.append(", ");
        b.append("recordVersion=");
        b.append(this.recordVersion);
        b.append(", ");
        b.append("schemaId=");
        b.append(this.schemaId);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
