package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;


/**
 * <i>“Represents a booking customer or staff member.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "emailAddress"})
@JsonInclude(Include.NON_NULL)
public class BookingPerson extends BookingNamedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingPerson";
    }

    @JsonProperty("emailAddress")
    protected String emailAddress;

    protected BookingPerson() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingPerson() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String emailAddress;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The e-mail address of this person.”</i>
         * 
         * @param emailAddress
         *            value of {@code emailAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public BookingPerson build() {
            BookingPerson _x = new BookingPerson();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingPerson";
            _x.id = id;
            _x.displayName = displayName;
            _x.emailAddress = emailAddress;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The e-mail address of this person.”</i>
     * 
     * @return property emailAddress
     */
    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code emailAddress}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The e-mail address of this person.”</i>
     * 
     * @param emailAddress
     *            new value of {@code emailAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailAddress} field changed
     */
    public BookingPerson withEmailAddress(String emailAddress) {
        BookingPerson _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingPerson");
        _x.emailAddress = emailAddress;
        return _x;
    }

    public BookingPerson withUnmappedField(String name, Object value) {
        BookingPerson _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingPerson patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BookingPerson _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingPerson put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BookingPerson _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BookingPerson _copy() {
        BookingPerson _x = new BookingPerson();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingPerson[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
