package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.VolumeType;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "deviceId", 
    "key", 
    "volumeType"})
@JsonInclude(Include.NON_NULL)
public class BitlockerRecoveryKey extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitlockerRecoveryKey";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("key")
    protected String key;

    @JsonProperty("volumeType")
    protected VolumeType volumeType;

    protected BitlockerRecoveryKey() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBitlockerRecoveryKey() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String deviceId;
        private String key;
        private VolumeType volumeType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("key");
            return this;
        }

        public Builder volumeType(VolumeType volumeType) {
            this.volumeType = volumeType;
            this.changedFields = changedFields.add("volumeType");
            return this;
        }

        public BitlockerRecoveryKey build() {
            BitlockerRecoveryKey _x = new BitlockerRecoveryKey();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bitlockerRecoveryKey";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.deviceId = deviceId;
            _x.key = key;
            _x.volumeType = volumeType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public BitlockerRecoveryKey withCreatedDateTime(OffsetDateTime createdDateTime) {
        BitlockerRecoveryKey _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitlockerRecoveryKey");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public BitlockerRecoveryKey withDeviceId(String deviceId) {
        BitlockerRecoveryKey _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitlockerRecoveryKey");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public BitlockerRecoveryKey withKey(String key) {
        BitlockerRecoveryKey _x = _copy();
        _x.changedFields = changedFields.add("key");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitlockerRecoveryKey");
        _x.key = key;
        return _x;
    }

    @Property(name="volumeType")
    @JsonIgnore
    public Optional<VolumeType> getVolumeType() {
        return Optional.ofNullable(volumeType);
    }

    public BitlockerRecoveryKey withVolumeType(VolumeType volumeType) {
        BitlockerRecoveryKey _x = _copy();
        _x.changedFields = changedFields.add("volumeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitlockerRecoveryKey");
        _x.volumeType = volumeType;
        return _x;
    }

    public BitlockerRecoveryKey withUnmappedField(String name, Object value) {
        BitlockerRecoveryKey _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BitlockerRecoveryKey patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BitlockerRecoveryKey _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BitlockerRecoveryKey put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BitlockerRecoveryKey _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BitlockerRecoveryKey _copy() {
        BitlockerRecoveryKey _x = new BitlockerRecoveryKey();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.deviceId = deviceId;
        _x.key = key;
        _x.volumeType = volumeType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BitlockerRecoveryKey[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("key=");
        b.append(this.key);
        b.append(", ");
        b.append("volumeType=");
        b.append(this.volumeType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
