package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.PatternedRecurrence;
import odata.msgraph.client.beta.complex.TaskViewpoint;
import odata.msgraph.client.beta.entity.collection.request.ChecklistItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LinkedResource_v2CollectionRequest;
import odata.msgraph.client.beta.entity.request.BaseTaskListRequest;
import odata.msgraph.client.beta.enums.Importance;
import odata.msgraph.client.beta.enums.TaskStatus_v2;

@JsonPropertyOrder({
    "@odata.type", 
    "bodyLastModifiedDateTime", 
    "completedDateTime", 
    "createdDateTime", 
    "displayName", 
    "dueDateTime", 
    "importance", 
    "lastModifiedDateTime", 
    "recurrence", 
    "startDateTime", 
    "status", 
    "textBody", 
    "viewpoint", 
    "checklistItems", 
    "extensions", 
    "linkedResources"})
@JsonInclude(Include.NON_NULL)
public class BaseTask extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.baseTask";
    }

    @JsonProperty("bodyLastModifiedDateTime")
    protected OffsetDateTime bodyLastModifiedDateTime;

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("dueDateTime")
    protected DateTimeTimeZone dueDateTime;

    @JsonProperty("importance")
    protected Importance importance;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("recurrence")
    protected PatternedRecurrence recurrence;

    @JsonProperty("startDateTime")
    protected DateTimeTimeZone startDateTime;

    @JsonProperty("status")
    protected TaskStatus_v2 status;

    @JsonProperty("textBody")
    protected String textBody;

    @JsonProperty("viewpoint")
    protected TaskViewpoint viewpoint;

    @JsonProperty("checklistItems")
    protected List<ChecklistItem> checklistItems;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("linkedResources")
    protected List<LinkedResource_v2> linkedResources;

    protected BaseTask() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="bodyLastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getBodyLastModifiedDateTime() {
        return Optional.ofNullable(bodyLastModifiedDateTime);
    }

    public BaseTask withBodyLastModifiedDateTime(OffsetDateTime bodyLastModifiedDateTime) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("bodyLastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public BaseTask withCompletedDateTime(OffsetDateTime completedDateTime) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public BaseTask withCreatedDateTime(OffsetDateTime createdDateTime) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public BaseTask withDisplayName(String displayName) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    public BaseTask withDueDateTime(DateTimeTimeZone dueDateTime) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<Importance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public BaseTask withImportance(Importance importance) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("importance");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.importance = importance;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public BaseTask withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="recurrence")
    @JsonIgnore
    public Optional<PatternedRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public BaseTask withRecurrence(PatternedRecurrence recurrence) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("recurrence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public BaseTask withStartDateTime(DateTimeTimeZone startDateTime) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<TaskStatus_v2> getStatus() {
        return Optional.ofNullable(status);
    }

    public BaseTask withStatus(TaskStatus_v2 status) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.status = status;
        return _x;
    }

    @Property(name="textBody")
    @JsonIgnore
    public Optional<String> getTextBody() {
        return Optional.ofNullable(textBody);
    }

    public BaseTask withTextBody(String textBody) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("textBody");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.textBody = textBody;
        return _x;
    }

    @Property(name="viewpoint")
    @JsonIgnore
    public Optional<TaskViewpoint> getViewpoint() {
        return Optional.ofNullable(viewpoint);
    }

    public BaseTask withViewpoint(TaskViewpoint viewpoint) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("viewpoint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.viewpoint = viewpoint;
        return _x;
    }

    public BaseTask withUnmappedField(String name, Object value) {
        BaseTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="checklistItems")
    @JsonIgnore
    public ChecklistItemCollectionRequest getChecklistItems() {
        return new ChecklistItemCollectionRequest(
                        contextPath.addSegment("checklistItems"), Optional.ofNullable(checklistItems));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    @NavigationProperty(name="linkedResources")
    @JsonIgnore
    public LinkedResource_v2CollectionRequest getLinkedResources() {
        return new LinkedResource_v2CollectionRequest(
                        contextPath.addSegment("linkedResources"), Optional.ofNullable(linkedResources));
    }

    @NavigationProperty(name="parentList")
    @JsonIgnore
    public BaseTaskListRequest getParentList() {
        return new BaseTaskListRequest(contextPath.addSegment("parentList"), RequestHelper.getValue(unmappedFields, "parentList"));
    }

    public BaseTask withChecklistItems(List<ChecklistItem> checklistItems) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("checklistItems");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.checklistItems = checklistItems;
        return _x;
    }

    public BaseTask withExtensions(List<Extension> extensions) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.extensions = extensions;
        return _x;
    }

    public BaseTask withLinkedResources(List<LinkedResource_v2> linkedResources) {
        BaseTask _x = _copy();
        _x.changedFields = changedFields.add("linkedResources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.baseTask");
        _x.linkedResources = linkedResources;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BaseTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BaseTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BaseTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BaseTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BaseTask _copy() {
        BaseTask _x = new BaseTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
        _x.completedDateTime = completedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.dueDateTime = dueDateTime;
        _x.importance = importance;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.recurrence = recurrence;
        _x.startDateTime = startDateTime;
        _x.status = status;
        _x.textBody = textBody;
        _x.viewpoint = viewpoint;
        _x.checklistItems = checklistItems;
        _x.extensions = extensions;
        _x.linkedResources = linkedResources;
        return _x;
    }

    @Action(name = "move")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BaseTask> move(String destinationTaskListId) {
        Preconditions.checkNotNull(destinationTaskListId, "destinationTaskListId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("destinationTaskListId", "Edm.String", Checks.checkIsAscii(destinationTaskListId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BaseTask>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.move"), BaseTask.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BaseTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("bodyLastModifiedDateTime=");
        b.append(this.bodyLastModifiedDateTime);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("textBody=");
        b.append(this.textBody);
        b.append(", ");
        b.append("viewpoint=");
        b.append(this.viewpoint);
        b.append(", ");
        b.append("checklistItems=");
        b.append(this.checklistItems);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("linkedResources=");
        b.append(this.linkedResources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
