package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "isEmailPasswordAuthenticationEnabled", 
    "isPhoneOneTimePasswordAuthenticationEnabled", 
    "isUserNameAuthenticationEnabled"})
@JsonInclude(Include.NON_NULL)
public class B2cAuthenticationMethodsPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.b2cAuthenticationMethodsPolicy";
    }

    @JsonProperty("isEmailPasswordAuthenticationEnabled")
    protected Boolean isEmailPasswordAuthenticationEnabled;

    @JsonProperty("isPhoneOneTimePasswordAuthenticationEnabled")
    protected Boolean isPhoneOneTimePasswordAuthenticationEnabled;

    @JsonProperty("isUserNameAuthenticationEnabled")
    protected Boolean isUserNameAuthenticationEnabled;

    protected B2cAuthenticationMethodsPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderB2cAuthenticationMethodsPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isEmailPasswordAuthenticationEnabled;
        private Boolean isPhoneOneTimePasswordAuthenticationEnabled;
        private Boolean isUserNameAuthenticationEnabled;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isEmailPasswordAuthenticationEnabled(Boolean isEmailPasswordAuthenticationEnabled) {
            this.isEmailPasswordAuthenticationEnabled = isEmailPasswordAuthenticationEnabled;
            this.changedFields = changedFields.add("isEmailPasswordAuthenticationEnabled");
            return this;
        }

        public Builder isPhoneOneTimePasswordAuthenticationEnabled(Boolean isPhoneOneTimePasswordAuthenticationEnabled) {
            this.isPhoneOneTimePasswordAuthenticationEnabled = isPhoneOneTimePasswordAuthenticationEnabled;
            this.changedFields = changedFields.add("isPhoneOneTimePasswordAuthenticationEnabled");
            return this;
        }

        public Builder isUserNameAuthenticationEnabled(Boolean isUserNameAuthenticationEnabled) {
            this.isUserNameAuthenticationEnabled = isUserNameAuthenticationEnabled;
            this.changedFields = changedFields.add("isUserNameAuthenticationEnabled");
            return this;
        }

        public B2cAuthenticationMethodsPolicy build() {
            B2cAuthenticationMethodsPolicy _x = new B2cAuthenticationMethodsPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.b2cAuthenticationMethodsPolicy";
            _x.id = id;
            _x.isEmailPasswordAuthenticationEnabled = isEmailPasswordAuthenticationEnabled;
            _x.isPhoneOneTimePasswordAuthenticationEnabled = isPhoneOneTimePasswordAuthenticationEnabled;
            _x.isUserNameAuthenticationEnabled = isUserNameAuthenticationEnabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isEmailPasswordAuthenticationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEmailPasswordAuthenticationEnabled() {
        return Optional.ofNullable(isEmailPasswordAuthenticationEnabled);
    }

    public B2cAuthenticationMethodsPolicy withIsEmailPasswordAuthenticationEnabled(Boolean isEmailPasswordAuthenticationEnabled) {
        B2cAuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("isEmailPasswordAuthenticationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cAuthenticationMethodsPolicy");
        _x.isEmailPasswordAuthenticationEnabled = isEmailPasswordAuthenticationEnabled;
        return _x;
    }

    @Property(name="isPhoneOneTimePasswordAuthenticationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsPhoneOneTimePasswordAuthenticationEnabled() {
        return Optional.ofNullable(isPhoneOneTimePasswordAuthenticationEnabled);
    }

    public B2cAuthenticationMethodsPolicy withIsPhoneOneTimePasswordAuthenticationEnabled(Boolean isPhoneOneTimePasswordAuthenticationEnabled) {
        B2cAuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("isPhoneOneTimePasswordAuthenticationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cAuthenticationMethodsPolicy");
        _x.isPhoneOneTimePasswordAuthenticationEnabled = isPhoneOneTimePasswordAuthenticationEnabled;
        return _x;
    }

    @Property(name="isUserNameAuthenticationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsUserNameAuthenticationEnabled() {
        return Optional.ofNullable(isUserNameAuthenticationEnabled);
    }

    public B2cAuthenticationMethodsPolicy withIsUserNameAuthenticationEnabled(Boolean isUserNameAuthenticationEnabled) {
        B2cAuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("isUserNameAuthenticationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cAuthenticationMethodsPolicy");
        _x.isUserNameAuthenticationEnabled = isUserNameAuthenticationEnabled;
        return _x;
    }

    public B2cAuthenticationMethodsPolicy withUnmappedField(String name, Object value) {
        B2cAuthenticationMethodsPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public B2cAuthenticationMethodsPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        B2cAuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public B2cAuthenticationMethodsPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        B2cAuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private B2cAuthenticationMethodsPolicy _copy() {
        B2cAuthenticationMethodsPolicy _x = new B2cAuthenticationMethodsPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isEmailPasswordAuthenticationEnabled = isEmailPasswordAuthenticationEnabled;
        _x.isPhoneOneTimePasswordAuthenticationEnabled = isPhoneOneTimePasswordAuthenticationEnabled;
        _x.isUserNameAuthenticationEnabled = isUserNameAuthenticationEnabled;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("B2cAuthenticationMethodsPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isEmailPasswordAuthenticationEnabled=");
        b.append(this.isEmailPasswordAuthenticationEnabled);
        b.append(", ");
        b.append("isPhoneOneTimePasswordAuthenticationEnabled=");
        b.append(this.isPhoneOneTimePasswordAuthenticationEnabled);
        b.append(", ");
        b.append("isUserNameAuthenticationEnabled=");
        b.append(this.isUserNameAuthenticationEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
