package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.FeatureUsageDetail;
import odata.msgraph.client.beta.enums.AzureADLicenseType;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "featureUsageDetails", 
    "lastUpdatedDateTime", 
    "licenseAssigned", 
    "licenseRecommended", 
    "userDisplayName", 
    "userId", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class AzureADUserFeatureUsage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.azureADUserFeatureUsage";
    }

    @JsonProperty("featureUsageDetails")
    protected List<FeatureUsageDetail> featureUsageDetails;

    @JsonProperty("featureUsageDetails@nextLink")
    protected String featureUsageDetailsNextLink;

    @JsonProperty("lastUpdatedDateTime")
    protected OffsetDateTime lastUpdatedDateTime;

    @JsonProperty("licenseAssigned")
    protected AzureADLicenseType licenseAssigned;

    @JsonProperty("licenseRecommended")
    protected AzureADLicenseType licenseRecommended;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected AzureADUserFeatureUsage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureADUserFeatureUsage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<FeatureUsageDetail> featureUsageDetails;
        private String featureUsageDetailsNextLink;
        private OffsetDateTime lastUpdatedDateTime;
        private AzureADLicenseType licenseAssigned;
        private AzureADLicenseType licenseRecommended;
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder featureUsageDetails(List<FeatureUsageDetail> featureUsageDetails) {
            this.featureUsageDetails = featureUsageDetails;
            this.changedFields = changedFields.add("featureUsageDetails");
            return this;
        }

        public Builder featureUsageDetails(FeatureUsageDetail... featureUsageDetails) {
            return featureUsageDetails(Arrays.asList(featureUsageDetails));
        }

        public Builder featureUsageDetailsNextLink(String featureUsageDetailsNextLink) {
            this.featureUsageDetailsNextLink = featureUsageDetailsNextLink;
            this.changedFields = changedFields.add("featureUsageDetails");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public Builder licenseAssigned(AzureADLicenseType licenseAssigned) {
            this.licenseAssigned = licenseAssigned;
            this.changedFields = changedFields.add("licenseAssigned");
            return this;
        }

        public Builder licenseRecommended(AzureADLicenseType licenseRecommended) {
            this.licenseRecommended = licenseRecommended;
            this.changedFields = changedFields.add("licenseRecommended");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public AzureADUserFeatureUsage build() {
            AzureADUserFeatureUsage _x = new AzureADUserFeatureUsage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.azureADUserFeatureUsage";
            _x.id = id;
            _x.featureUsageDetails = featureUsageDetails;
            _x.featureUsageDetailsNextLink = featureUsageDetailsNextLink;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.licenseAssigned = licenseAssigned;
            _x.licenseRecommended = licenseRecommended;
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="featureUsageDetails")
    @JsonIgnore
    public CollectionPage<FeatureUsageDetail> getFeatureUsageDetails() {
        return new CollectionPage<FeatureUsageDetail>(contextPath, FeatureUsageDetail.class, this.featureUsageDetails, Optional.ofNullable(featureUsageDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AzureADUserFeatureUsage withFeatureUsageDetails(List<FeatureUsageDetail> featureUsageDetails) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("featureUsageDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.featureUsageDetails = featureUsageDetails;
        return _x;
    }

    @Property(name="featureUsageDetails")
    @JsonIgnore
    public CollectionPage<FeatureUsageDetail> getFeatureUsageDetails(HttpRequestOptions options) {
        return new CollectionPage<FeatureUsageDetail>(contextPath, FeatureUsageDetail.class, this.featureUsageDetails, Optional.ofNullable(featureUsageDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    public AzureADUserFeatureUsage withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Property(name="licenseAssigned")
    @JsonIgnore
    public Optional<AzureADLicenseType> getLicenseAssigned() {
        return Optional.ofNullable(licenseAssigned);
    }

    public AzureADUserFeatureUsage withLicenseAssigned(AzureADLicenseType licenseAssigned) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("licenseAssigned");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.licenseAssigned = licenseAssigned;
        return _x;
    }

    @Property(name="licenseRecommended")
    @JsonIgnore
    public Optional<AzureADLicenseType> getLicenseRecommended() {
        return Optional.ofNullable(licenseRecommended);
    }

    public AzureADUserFeatureUsage withLicenseRecommended(AzureADLicenseType licenseRecommended) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("licenseRecommended");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.licenseRecommended = licenseRecommended;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public AzureADUserFeatureUsage withUserDisplayName(String userDisplayName) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public AzureADUserFeatureUsage withUserId(String userId) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.userId = userId;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public AzureADUserFeatureUsage withUserPrincipalName(String userPrincipalName) {
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADUserFeatureUsage");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public AzureADUserFeatureUsage withUnmappedField(String name, Object value) {
        AzureADUserFeatureUsage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADUserFeatureUsage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADUserFeatureUsage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AzureADUserFeatureUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AzureADUserFeatureUsage _copy() {
        AzureADUserFeatureUsage _x = new AzureADUserFeatureUsage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.featureUsageDetails = featureUsageDetails;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.licenseAssigned = licenseAssigned;
        _x.licenseRecommended = licenseRecommended;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureADUserFeatureUsage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("featureUsageDetails=");
        b.append(this.featureUsageDetails);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("licenseAssigned=");
        b.append(this.licenseAssigned);
        b.append(", ");
        b.append("licenseRecommended=");
        b.append(this.licenseRecommended);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
