package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.complex.DefaultUserRolePermissions;
import odata.msgraph.client.beta.entity.collection.request.DefaultUserRoleOverrideCollectionRequest;
import odata.msgraph.client.beta.enums.AllowInvitesFrom;

@JsonPropertyOrder({
    "@odata.type", 
    "allowedToSignUpEmailBasedSubscriptions", 
    "allowedToUseSSPR", 
    "allowEmailVerifiedUsersToJoinOrganization", 
    "allowInvitesFrom", 
    "blockMsolPowerShell", 
    "defaultUserRolePermissions", 
    "enabledPreviewFeatures", 
    "guestUserRoleId", 
    "permissionGrantPolicyIdsAssignedToDefaultUserRole", 
    "defaultUserRoleOverrides"})
@JsonInclude(Include.NON_NULL)
public class AuthorizationPolicy extends PolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authorizationPolicy";
    }

    @JsonProperty("allowedToSignUpEmailBasedSubscriptions")
    protected Boolean allowedToSignUpEmailBasedSubscriptions;

    @JsonProperty("allowedToUseSSPR")
    protected Boolean allowedToUseSSPR;

    @JsonProperty("allowEmailVerifiedUsersToJoinOrganization")
    protected Boolean allowEmailVerifiedUsersToJoinOrganization;

    @JsonProperty("allowInvitesFrom")
    protected AllowInvitesFrom allowInvitesFrom;

    @JsonProperty("blockMsolPowerShell")
    protected Boolean blockMsolPowerShell;

    @JsonProperty("defaultUserRolePermissions")
    protected DefaultUserRolePermissions defaultUserRolePermissions;

    @JsonProperty("enabledPreviewFeatures")
    protected List<String> enabledPreviewFeatures;

    @JsonProperty("enabledPreviewFeatures@nextLink")
    protected String enabledPreviewFeaturesNextLink;

    @JsonProperty("guestUserRoleId")
    protected UUID guestUserRoleId;

    @JsonProperty("permissionGrantPolicyIdsAssignedToDefaultUserRole")
    protected List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole;

    @JsonProperty("permissionGrantPolicyIdsAssignedToDefaultUserRole@nextLink")
    protected String permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;

    @JsonProperty("defaultUserRoleOverrides")
    protected List<DefaultUserRoleOverride> defaultUserRoleOverrides;

    protected AuthorizationPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthorizationPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private Boolean allowedToSignUpEmailBasedSubscriptions;
        private Boolean allowedToUseSSPR;
        private Boolean allowEmailVerifiedUsersToJoinOrganization;
        private AllowInvitesFrom allowInvitesFrom;
        private Boolean blockMsolPowerShell;
        private DefaultUserRolePermissions defaultUserRolePermissions;
        private List<String> enabledPreviewFeatures;
        private String enabledPreviewFeaturesNextLink;
        private UUID guestUserRoleId;
        private List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole;
        private String permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;
        private List<DefaultUserRoleOverride> defaultUserRoleOverrides;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder allowedToSignUpEmailBasedSubscriptions(Boolean allowedToSignUpEmailBasedSubscriptions) {
            this.allowedToSignUpEmailBasedSubscriptions = allowedToSignUpEmailBasedSubscriptions;
            this.changedFields = changedFields.add("allowedToSignUpEmailBasedSubscriptions");
            return this;
        }

        public Builder allowedToUseSSPR(Boolean allowedToUseSSPR) {
            this.allowedToUseSSPR = allowedToUseSSPR;
            this.changedFields = changedFields.add("allowedToUseSSPR");
            return this;
        }

        public Builder allowEmailVerifiedUsersToJoinOrganization(Boolean allowEmailVerifiedUsersToJoinOrganization) {
            this.allowEmailVerifiedUsersToJoinOrganization = allowEmailVerifiedUsersToJoinOrganization;
            this.changedFields = changedFields.add("allowEmailVerifiedUsersToJoinOrganization");
            return this;
        }

        public Builder allowInvitesFrom(AllowInvitesFrom allowInvitesFrom) {
            this.allowInvitesFrom = allowInvitesFrom;
            this.changedFields = changedFields.add("allowInvitesFrom");
            return this;
        }

        public Builder blockMsolPowerShell(Boolean blockMsolPowerShell) {
            this.blockMsolPowerShell = blockMsolPowerShell;
            this.changedFields = changedFields.add("blockMsolPowerShell");
            return this;
        }

        public Builder defaultUserRolePermissions(DefaultUserRolePermissions defaultUserRolePermissions) {
            this.defaultUserRolePermissions = defaultUserRolePermissions;
            this.changedFields = changedFields.add("defaultUserRolePermissions");
            return this;
        }

        public Builder enabledPreviewFeatures(List<String> enabledPreviewFeatures) {
            this.enabledPreviewFeatures = enabledPreviewFeatures;
            this.changedFields = changedFields.add("enabledPreviewFeatures");
            return this;
        }

        public Builder enabledPreviewFeatures(String... enabledPreviewFeatures) {
            return enabledPreviewFeatures(Arrays.asList(enabledPreviewFeatures));
        }

        public Builder enabledPreviewFeaturesNextLink(String enabledPreviewFeaturesNextLink) {
            this.enabledPreviewFeaturesNextLink = enabledPreviewFeaturesNextLink;
            this.changedFields = changedFields.add("enabledPreviewFeatures");
            return this;
        }

        public Builder guestUserRoleId(UUID guestUserRoleId) {
            this.guestUserRoleId = guestUserRoleId;
            this.changedFields = changedFields.add("guestUserRoleId");
            return this;
        }

        public Builder permissionGrantPolicyIdsAssignedToDefaultUserRole(List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole) {
            this.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
            this.changedFields = changedFields.add("permissionGrantPolicyIdsAssignedToDefaultUserRole");
            return this;
        }

        public Builder permissionGrantPolicyIdsAssignedToDefaultUserRole(String... permissionGrantPolicyIdsAssignedToDefaultUserRole) {
            return permissionGrantPolicyIdsAssignedToDefaultUserRole(Arrays.asList(permissionGrantPolicyIdsAssignedToDefaultUserRole));
        }

        public Builder permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink(String permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink) {
            this.permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink = permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;
            this.changedFields = changedFields.add("permissionGrantPolicyIdsAssignedToDefaultUserRole");
            return this;
        }

        public Builder defaultUserRoleOverrides(List<DefaultUserRoleOverride> defaultUserRoleOverrides) {
            this.defaultUserRoleOverrides = defaultUserRoleOverrides;
            this.changedFields = changedFields.add("defaultUserRoleOverrides");
            return this;
        }

        public Builder defaultUserRoleOverrides(DefaultUserRoleOverride... defaultUserRoleOverrides) {
            return defaultUserRoleOverrides(Arrays.asList(defaultUserRoleOverrides));
        }

        public AuthorizationPolicy build() {
            AuthorizationPolicy _x = new AuthorizationPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authorizationPolicy";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.allowedToSignUpEmailBasedSubscriptions = allowedToSignUpEmailBasedSubscriptions;
            _x.allowedToUseSSPR = allowedToUseSSPR;
            _x.allowEmailVerifiedUsersToJoinOrganization = allowEmailVerifiedUsersToJoinOrganization;
            _x.allowInvitesFrom = allowInvitesFrom;
            _x.blockMsolPowerShell = blockMsolPowerShell;
            _x.defaultUserRolePermissions = defaultUserRolePermissions;
            _x.enabledPreviewFeatures = enabledPreviewFeatures;
            _x.enabledPreviewFeaturesNextLink = enabledPreviewFeaturesNextLink;
            _x.guestUserRoleId = guestUserRoleId;
            _x.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
            _x.permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink = permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;
            _x.defaultUserRoleOverrides = defaultUserRoleOverrides;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="allowedToSignUpEmailBasedSubscriptions")
    @JsonIgnore
    public Optional<Boolean> getAllowedToSignUpEmailBasedSubscriptions() {
        return Optional.ofNullable(allowedToSignUpEmailBasedSubscriptions);
    }

    public AuthorizationPolicy withAllowedToSignUpEmailBasedSubscriptions(Boolean allowedToSignUpEmailBasedSubscriptions) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("allowedToSignUpEmailBasedSubscriptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.allowedToSignUpEmailBasedSubscriptions = allowedToSignUpEmailBasedSubscriptions;
        return _x;
    }

    @Property(name="allowedToUseSSPR")
    @JsonIgnore
    public Optional<Boolean> getAllowedToUseSSPR() {
        return Optional.ofNullable(allowedToUseSSPR);
    }

    public AuthorizationPolicy withAllowedToUseSSPR(Boolean allowedToUseSSPR) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("allowedToUseSSPR");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.allowedToUseSSPR = allowedToUseSSPR;
        return _x;
    }

    @Property(name="allowEmailVerifiedUsersToJoinOrganization")
    @JsonIgnore
    public Optional<Boolean> getAllowEmailVerifiedUsersToJoinOrganization() {
        return Optional.ofNullable(allowEmailVerifiedUsersToJoinOrganization);
    }

    public AuthorizationPolicy withAllowEmailVerifiedUsersToJoinOrganization(Boolean allowEmailVerifiedUsersToJoinOrganization) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("allowEmailVerifiedUsersToJoinOrganization");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.allowEmailVerifiedUsersToJoinOrganization = allowEmailVerifiedUsersToJoinOrganization;
        return _x;
    }

    @Property(name="allowInvitesFrom")
    @JsonIgnore
    public Optional<AllowInvitesFrom> getAllowInvitesFrom() {
        return Optional.ofNullable(allowInvitesFrom);
    }

    public AuthorizationPolicy withAllowInvitesFrom(AllowInvitesFrom allowInvitesFrom) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("allowInvitesFrom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.allowInvitesFrom = allowInvitesFrom;
        return _x;
    }

    @Property(name="blockMsolPowerShell")
    @JsonIgnore
    public Optional<Boolean> getBlockMsolPowerShell() {
        return Optional.ofNullable(blockMsolPowerShell);
    }

    public AuthorizationPolicy withBlockMsolPowerShell(Boolean blockMsolPowerShell) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("blockMsolPowerShell");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.blockMsolPowerShell = blockMsolPowerShell;
        return _x;
    }

    @Property(name="defaultUserRolePermissions")
    @JsonIgnore
    public Optional<DefaultUserRolePermissions> getDefaultUserRolePermissions() {
        return Optional.ofNullable(defaultUserRolePermissions);
    }

    public AuthorizationPolicy withDefaultUserRolePermissions(DefaultUserRolePermissions defaultUserRolePermissions) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("defaultUserRolePermissions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.defaultUserRolePermissions = defaultUserRolePermissions;
        return _x;
    }

    @Property(name="enabledPreviewFeatures")
    @JsonIgnore
    public CollectionPage<String> getEnabledPreviewFeatures() {
        return new CollectionPage<String>(contextPath, String.class, this.enabledPreviewFeatures, Optional.ofNullable(enabledPreviewFeaturesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AuthorizationPolicy withEnabledPreviewFeatures(List<String> enabledPreviewFeatures) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("enabledPreviewFeatures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.enabledPreviewFeatures = enabledPreviewFeatures;
        return _x;
    }

    @Property(name="enabledPreviewFeatures")
    @JsonIgnore
    public CollectionPage<String> getEnabledPreviewFeatures(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.enabledPreviewFeatures, Optional.ofNullable(enabledPreviewFeaturesNextLink), Collections.emptyList(), options);
    }

    @Property(name="guestUserRoleId")
    @JsonIgnore
    public Optional<UUID> getGuestUserRoleId() {
        return Optional.ofNullable(guestUserRoleId);
    }

    public AuthorizationPolicy withGuestUserRoleId(UUID guestUserRoleId) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("guestUserRoleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.guestUserRoleId = guestUserRoleId;
        return _x;
    }

    @Property(name="permissionGrantPolicyIdsAssignedToDefaultUserRole")
    @JsonIgnore
    public CollectionPage<String> getPermissionGrantPolicyIdsAssignedToDefaultUserRole() {
        return new CollectionPage<String>(contextPath, String.class, this.permissionGrantPolicyIdsAssignedToDefaultUserRole, Optional.ofNullable(permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AuthorizationPolicy withPermissionGrantPolicyIdsAssignedToDefaultUserRole(List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("permissionGrantPolicyIdsAssignedToDefaultUserRole");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
        return _x;
    }

    @Property(name="permissionGrantPolicyIdsAssignedToDefaultUserRole")
    @JsonIgnore
    public CollectionPage<String> getPermissionGrantPolicyIdsAssignedToDefaultUserRole(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.permissionGrantPolicyIdsAssignedToDefaultUserRole, Optional.ofNullable(permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink), Collections.emptyList(), options);
    }

    public AuthorizationPolicy withUnmappedField(String name, Object value) {
        AuthorizationPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="defaultUserRoleOverrides")
    @JsonIgnore
    public DefaultUserRoleOverrideCollectionRequest getDefaultUserRoleOverrides() {
        return new DefaultUserRoleOverrideCollectionRequest(
                        contextPath.addSegment("defaultUserRoleOverrides"), Optional.ofNullable(defaultUserRoleOverrides));
    }

    public AuthorizationPolicy withDefaultUserRoleOverrides(List<DefaultUserRoleOverride> defaultUserRoleOverrides) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("defaultUserRoleOverrides");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.defaultUserRoleOverrides = defaultUserRoleOverrides;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthorizationPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuthorizationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthorizationPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuthorizationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuthorizationPolicy _copy() {
        AuthorizationPolicy _x = new AuthorizationPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.allowedToSignUpEmailBasedSubscriptions = allowedToSignUpEmailBasedSubscriptions;
        _x.allowedToUseSSPR = allowedToUseSSPR;
        _x.allowEmailVerifiedUsersToJoinOrganization = allowEmailVerifiedUsersToJoinOrganization;
        _x.allowInvitesFrom = allowInvitesFrom;
        _x.blockMsolPowerShell = blockMsolPowerShell;
        _x.defaultUserRolePermissions = defaultUserRolePermissions;
        _x.enabledPreviewFeatures = enabledPreviewFeatures;
        _x.guestUserRoleId = guestUserRoleId;
        _x.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
        _x.defaultUserRoleOverrides = defaultUserRoleOverrides;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthorizationPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("allowedToSignUpEmailBasedSubscriptions=");
        b.append(this.allowedToSignUpEmailBasedSubscriptions);
        b.append(", ");
        b.append("allowedToUseSSPR=");
        b.append(this.allowedToUseSSPR);
        b.append(", ");
        b.append("allowEmailVerifiedUsersToJoinOrganization=");
        b.append(this.allowEmailVerifiedUsersToJoinOrganization);
        b.append(", ");
        b.append("allowInvitesFrom=");
        b.append(this.allowInvitesFrom);
        b.append(", ");
        b.append("blockMsolPowerShell=");
        b.append(this.blockMsolPowerShell);
        b.append(", ");
        b.append("defaultUserRolePermissions=");
        b.append(this.defaultUserRolePermissions);
        b.append(", ");
        b.append("enabledPreviewFeatures=");
        b.append(this.enabledPreviewFeatures);
        b.append(", ");
        b.append("guestUserRoleId=");
        b.append(this.guestUserRoleId);
        b.append(", ");
        b.append("permissionGrantPolicyIdsAssignedToDefaultUserRole=");
        b.append(this.permissionGrantPolicyIdsAssignedToDefaultUserRole);
        b.append(", ");
        b.append("defaultUserRoleOverrides=");
        b.append(this.defaultUserRoleOverrides);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
