package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RegistrationEnforcement;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodConfigurationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "policyVersion", 
    "reconfirmationInDays", 
    "registrationEnforcement", 
    "authenticationMethodConfigurations"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationMethodsPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationMethodsPolicy";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("policyVersion")
    protected String policyVersion;

    @JsonProperty("reconfirmationInDays")
    protected Integer reconfirmationInDays;

    @JsonProperty("registrationEnforcement")
    protected RegistrationEnforcement registrationEnforcement;

    @JsonProperty("authenticationMethodConfigurations")
    protected List<AuthenticationMethodConfiguration> authenticationMethodConfigurations;

    protected AuthenticationMethodsPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthenticationMethodsPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private String policyVersion;
        private Integer reconfirmationInDays;
        private RegistrationEnforcement registrationEnforcement;
        private List<AuthenticationMethodConfiguration> authenticationMethodConfigurations;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            this.changedFields = changedFields.add("policyVersion");
            return this;
        }

        public Builder reconfirmationInDays(Integer reconfirmationInDays) {
            this.reconfirmationInDays = reconfirmationInDays;
            this.changedFields = changedFields.add("reconfirmationInDays");
            return this;
        }

        public Builder registrationEnforcement(RegistrationEnforcement registrationEnforcement) {
            this.registrationEnforcement = registrationEnforcement;
            this.changedFields = changedFields.add("registrationEnforcement");
            return this;
        }

        public Builder authenticationMethodConfigurations(List<AuthenticationMethodConfiguration> authenticationMethodConfigurations) {
            this.authenticationMethodConfigurations = authenticationMethodConfigurations;
            this.changedFields = changedFields.add("authenticationMethodConfigurations");
            return this;
        }

        public Builder authenticationMethodConfigurations(AuthenticationMethodConfiguration... authenticationMethodConfigurations) {
            return authenticationMethodConfigurations(Arrays.asList(authenticationMethodConfigurations));
        }

        public AuthenticationMethodsPolicy build() {
            AuthenticationMethodsPolicy _x = new AuthenticationMethodsPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authenticationMethodsPolicy";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.policyVersion = policyVersion;
            _x.reconfirmationInDays = reconfirmationInDays;
            _x.registrationEnforcement = registrationEnforcement;
            _x.authenticationMethodConfigurations = authenticationMethodConfigurations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AuthenticationMethodsPolicy withDescription(String description) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AuthenticationMethodsPolicy withDisplayName(String displayName) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public AuthenticationMethodsPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="policyVersion")
    @JsonIgnore
    public Optional<String> getPolicyVersion() {
        return Optional.ofNullable(policyVersion);
    }

    public AuthenticationMethodsPolicy withPolicyVersion(String policyVersion) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("policyVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.policyVersion = policyVersion;
        return _x;
    }

    @Property(name="reconfirmationInDays")
    @JsonIgnore
    public Optional<Integer> getReconfirmationInDays() {
        return Optional.ofNullable(reconfirmationInDays);
    }

    public AuthenticationMethodsPolicy withReconfirmationInDays(Integer reconfirmationInDays) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("reconfirmationInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.reconfirmationInDays = reconfirmationInDays;
        return _x;
    }

    @Property(name="registrationEnforcement")
    @JsonIgnore
    public Optional<RegistrationEnforcement> getRegistrationEnforcement() {
        return Optional.ofNullable(registrationEnforcement);
    }

    public AuthenticationMethodsPolicy withRegistrationEnforcement(RegistrationEnforcement registrationEnforcement) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("registrationEnforcement");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.registrationEnforcement = registrationEnforcement;
        return _x;
    }

    public AuthenticationMethodsPolicy withUnmappedField(String name, Object value) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="authenticationMethodConfigurations")
    @JsonIgnore
    public AuthenticationMethodConfigurationCollectionRequest getAuthenticationMethodConfigurations() {
        return new AuthenticationMethodConfigurationCollectionRequest(
                        contextPath.addSegment("authenticationMethodConfigurations"), Optional.ofNullable(authenticationMethodConfigurations));
    }

    public AuthenticationMethodsPolicy withAuthenticationMethodConfigurations(List<AuthenticationMethodConfiguration> authenticationMethodConfigurations) {
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethodConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodsPolicy");
        _x.authenticationMethodConfigurations = authenticationMethodConfigurations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthenticationMethodsPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthenticationMethodsPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuthenticationMethodsPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuthenticationMethodsPolicy _copy() {
        AuthenticationMethodsPolicy _x = new AuthenticationMethodsPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.policyVersion = policyVersion;
        _x.reconfirmationInDays = reconfirmationInDays;
        _x.registrationEnforcement = registrationEnforcement;
        _x.authenticationMethodConfigurations = authenticationMethodConfigurations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationMethodsPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("policyVersion=");
        b.append(this.policyVersion);
        b.append(", ");
        b.append("reconfirmationInDays=");
        b.append(this.reconfirmationInDays);
        b.append(", ");
        b.append("registrationEnforcement=");
        b.append(this.registrationEnforcement);
        b.append(", ");
        b.append("authenticationMethodConfigurations=");
        b.append(this.authenticationMethodConfigurations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
