package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AuthenticationMethodTargetType;

@JsonPropertyOrder({
    "@odata.type", 
    "isRegistrationRequired", 
    "targetType"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationMethodTarget extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationMethodTarget";
    }

    @JsonProperty("isRegistrationRequired")
    protected Boolean isRegistrationRequired;

    @JsonProperty("targetType")
    protected AuthenticationMethodTargetType targetType;

    protected AuthenticationMethodTarget() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthenticationMethodTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isRegistrationRequired;
        private AuthenticationMethodTargetType targetType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isRegistrationRequired(Boolean isRegistrationRequired) {
            this.isRegistrationRequired = isRegistrationRequired;
            this.changedFields = changedFields.add("isRegistrationRequired");
            return this;
        }

        public Builder targetType(AuthenticationMethodTargetType targetType) {
            this.targetType = targetType;
            this.changedFields = changedFields.add("targetType");
            return this;
        }

        public AuthenticationMethodTarget build() {
            AuthenticationMethodTarget _x = new AuthenticationMethodTarget();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authenticationMethodTarget";
            _x.id = id;
            _x.isRegistrationRequired = isRegistrationRequired;
            _x.targetType = targetType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isRegistrationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsRegistrationRequired() {
        return Optional.ofNullable(isRegistrationRequired);
    }

    public AuthenticationMethodTarget withIsRegistrationRequired(Boolean isRegistrationRequired) {
        AuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("isRegistrationRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodTarget");
        _x.isRegistrationRequired = isRegistrationRequired;
        return _x;
    }

    @Property(name="targetType")
    @JsonIgnore
    public Optional<AuthenticationMethodTargetType> getTargetType() {
        return Optional.ofNullable(targetType);
    }

    public AuthenticationMethodTarget withTargetType(AuthenticationMethodTargetType targetType) {
        AuthenticationMethodTarget _x = _copy();
        _x.changedFields = changedFields.add("targetType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationMethodTarget");
        _x.targetType = targetType;
        return _x;
    }

    public AuthenticationMethodTarget withUnmappedField(String name, Object value) {
        AuthenticationMethodTarget _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthenticationMethodTarget patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuthenticationMethodTarget _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthenticationMethodTarget put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuthenticationMethodTarget _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuthenticationMethodTarget _copy() {
        AuthenticationMethodTarget _x = new AuthenticationMethodTarget();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.isRegistrationRequired = isRegistrationRequired;
        _x.targetType = targetType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationMethodTarget[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isRegistrationRequired=");
        b.append(this.isRegistrationRequired);
        b.append(", ");
        b.append("targetType=");
        b.append(this.targetType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
