package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmailAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.Fido2AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PhoneAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SoftwareOathAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TemporaryAccessPassAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsHelloForBusinessAuthenticationMethodCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "emailMethods", 
    "fido2Methods", 
    "methods", 
    "microsoftAuthenticatorMethods", 
    "operations", 
    "passwordlessMicrosoftAuthenticatorMethods", 
    "passwordMethods", 
    "phoneMethods", 
    "softwareOathMethods", 
    "temporaryAccessPassMethods", 
    "windowsHelloForBusinessMethods"})
@JsonInclude(Include.NON_NULL)
public class Authentication extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authentication";
    }

    @JsonProperty("emailMethods")
    protected List<EmailAuthenticationMethod> emailMethods;

    @JsonProperty("fido2Methods")
    protected List<Fido2AuthenticationMethod> fido2Methods;

    @JsonProperty("methods")
    protected List<AuthenticationMethod> methods;

    @JsonProperty("microsoftAuthenticatorMethods")
    protected List<MicrosoftAuthenticatorAuthenticationMethod> microsoftAuthenticatorMethods;

    @JsonProperty("operations")
    protected List<LongRunningOperation> operations;

    @JsonProperty("passwordlessMicrosoftAuthenticatorMethods")
    protected List<PasswordlessMicrosoftAuthenticatorAuthenticationMethod> passwordlessMicrosoftAuthenticatorMethods;

    @JsonProperty("passwordMethods")
    protected List<PasswordAuthenticationMethod> passwordMethods;

    @JsonProperty("phoneMethods")
    protected List<PhoneAuthenticationMethod> phoneMethods;

    @JsonProperty("softwareOathMethods")
    protected List<SoftwareOathAuthenticationMethod> softwareOathMethods;

    @JsonProperty("temporaryAccessPassMethods")
    protected List<TemporaryAccessPassAuthenticationMethod> temporaryAccessPassMethods;

    @JsonProperty("windowsHelloForBusinessMethods")
    protected List<WindowsHelloForBusinessAuthenticationMethod> windowsHelloForBusinessMethods;

    protected Authentication() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthentication() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<EmailAuthenticationMethod> emailMethods;
        private List<Fido2AuthenticationMethod> fido2Methods;
        private List<AuthenticationMethod> methods;
        private List<MicrosoftAuthenticatorAuthenticationMethod> microsoftAuthenticatorMethods;
        private List<LongRunningOperation> operations;
        private List<PasswordlessMicrosoftAuthenticatorAuthenticationMethod> passwordlessMicrosoftAuthenticatorMethods;
        private List<PasswordAuthenticationMethod> passwordMethods;
        private List<PhoneAuthenticationMethod> phoneMethods;
        private List<SoftwareOathAuthenticationMethod> softwareOathMethods;
        private List<TemporaryAccessPassAuthenticationMethod> temporaryAccessPassMethods;
        private List<WindowsHelloForBusinessAuthenticationMethod> windowsHelloForBusinessMethods;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder emailMethods(List<EmailAuthenticationMethod> emailMethods) {
            this.emailMethods = emailMethods;
            this.changedFields = changedFields.add("emailMethods");
            return this;
        }

        public Builder emailMethods(EmailAuthenticationMethod... emailMethods) {
            return emailMethods(Arrays.asList(emailMethods));
        }

        public Builder fido2Methods(List<Fido2AuthenticationMethod> fido2Methods) {
            this.fido2Methods = fido2Methods;
            this.changedFields = changedFields.add("fido2Methods");
            return this;
        }

        public Builder fido2Methods(Fido2AuthenticationMethod... fido2Methods) {
            return fido2Methods(Arrays.asList(fido2Methods));
        }

        public Builder methods(List<AuthenticationMethod> methods) {
            this.methods = methods;
            this.changedFields = changedFields.add("methods");
            return this;
        }

        public Builder methods(AuthenticationMethod... methods) {
            return methods(Arrays.asList(methods));
        }

        public Builder microsoftAuthenticatorMethods(List<MicrosoftAuthenticatorAuthenticationMethod> microsoftAuthenticatorMethods) {
            this.microsoftAuthenticatorMethods = microsoftAuthenticatorMethods;
            this.changedFields = changedFields.add("microsoftAuthenticatorMethods");
            return this;
        }

        public Builder microsoftAuthenticatorMethods(MicrosoftAuthenticatorAuthenticationMethod... microsoftAuthenticatorMethods) {
            return microsoftAuthenticatorMethods(Arrays.asList(microsoftAuthenticatorMethods));
        }

        public Builder operations(List<LongRunningOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(LongRunningOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder passwordlessMicrosoftAuthenticatorMethods(List<PasswordlessMicrosoftAuthenticatorAuthenticationMethod> passwordlessMicrosoftAuthenticatorMethods) {
            this.passwordlessMicrosoftAuthenticatorMethods = passwordlessMicrosoftAuthenticatorMethods;
            this.changedFields = changedFields.add("passwordlessMicrosoftAuthenticatorMethods");
            return this;
        }

        public Builder passwordlessMicrosoftAuthenticatorMethods(PasswordlessMicrosoftAuthenticatorAuthenticationMethod... passwordlessMicrosoftAuthenticatorMethods) {
            return passwordlessMicrosoftAuthenticatorMethods(Arrays.asList(passwordlessMicrosoftAuthenticatorMethods));
        }

        public Builder passwordMethods(List<PasswordAuthenticationMethod> passwordMethods) {
            this.passwordMethods = passwordMethods;
            this.changedFields = changedFields.add("passwordMethods");
            return this;
        }

        public Builder passwordMethods(PasswordAuthenticationMethod... passwordMethods) {
            return passwordMethods(Arrays.asList(passwordMethods));
        }

        public Builder phoneMethods(List<PhoneAuthenticationMethod> phoneMethods) {
            this.phoneMethods = phoneMethods;
            this.changedFields = changedFields.add("phoneMethods");
            return this;
        }

        public Builder phoneMethods(PhoneAuthenticationMethod... phoneMethods) {
            return phoneMethods(Arrays.asList(phoneMethods));
        }

        public Builder softwareOathMethods(List<SoftwareOathAuthenticationMethod> softwareOathMethods) {
            this.softwareOathMethods = softwareOathMethods;
            this.changedFields = changedFields.add("softwareOathMethods");
            return this;
        }

        public Builder softwareOathMethods(SoftwareOathAuthenticationMethod... softwareOathMethods) {
            return softwareOathMethods(Arrays.asList(softwareOathMethods));
        }

        public Builder temporaryAccessPassMethods(List<TemporaryAccessPassAuthenticationMethod> temporaryAccessPassMethods) {
            this.temporaryAccessPassMethods = temporaryAccessPassMethods;
            this.changedFields = changedFields.add("temporaryAccessPassMethods");
            return this;
        }

        public Builder temporaryAccessPassMethods(TemporaryAccessPassAuthenticationMethod... temporaryAccessPassMethods) {
            return temporaryAccessPassMethods(Arrays.asList(temporaryAccessPassMethods));
        }

        public Builder windowsHelloForBusinessMethods(List<WindowsHelloForBusinessAuthenticationMethod> windowsHelloForBusinessMethods) {
            this.windowsHelloForBusinessMethods = windowsHelloForBusinessMethods;
            this.changedFields = changedFields.add("windowsHelloForBusinessMethods");
            return this;
        }

        public Builder windowsHelloForBusinessMethods(WindowsHelloForBusinessAuthenticationMethod... windowsHelloForBusinessMethods) {
            return windowsHelloForBusinessMethods(Arrays.asList(windowsHelloForBusinessMethods));
        }

        public Authentication build() {
            Authentication _x = new Authentication();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authentication";
            _x.id = id;
            _x.emailMethods = emailMethods;
            _x.fido2Methods = fido2Methods;
            _x.methods = methods;
            _x.microsoftAuthenticatorMethods = microsoftAuthenticatorMethods;
            _x.operations = operations;
            _x.passwordlessMicrosoftAuthenticatorMethods = passwordlessMicrosoftAuthenticatorMethods;
            _x.passwordMethods = passwordMethods;
            _x.phoneMethods = phoneMethods;
            _x.softwareOathMethods = softwareOathMethods;
            _x.temporaryAccessPassMethods = temporaryAccessPassMethods;
            _x.windowsHelloForBusinessMethods = windowsHelloForBusinessMethods;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Authentication withUnmappedField(String name, Object value) {
        Authentication _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="emailMethods")
    @JsonIgnore
    public EmailAuthenticationMethodCollectionRequest getEmailMethods() {
        return new EmailAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("emailMethods"), Optional.ofNullable(emailMethods));
    }

    @NavigationProperty(name="fido2Methods")
    @JsonIgnore
    public Fido2AuthenticationMethodCollectionRequest getFido2Methods() {
        return new Fido2AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("fido2Methods"), Optional.ofNullable(fido2Methods));
    }

    @NavigationProperty(name="methods")
    @JsonIgnore
    public AuthenticationMethodCollectionRequest getMethods() {
        return new AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("methods"), Optional.ofNullable(methods));
    }

    @NavigationProperty(name="microsoftAuthenticatorMethods")
    @JsonIgnore
    public MicrosoftAuthenticatorAuthenticationMethodCollectionRequest getMicrosoftAuthenticatorMethods() {
        return new MicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("microsoftAuthenticatorMethods"), Optional.ofNullable(microsoftAuthenticatorMethods));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public LongRunningOperationCollectionRequest getOperations() {
        return new LongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="passwordlessMicrosoftAuthenticatorMethods")
    @JsonIgnore
    public PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest getPasswordlessMicrosoftAuthenticatorMethods() {
        return new PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordlessMicrosoftAuthenticatorMethods"), Optional.ofNullable(passwordlessMicrosoftAuthenticatorMethods));
    }

    @NavigationProperty(name="passwordMethods")
    @JsonIgnore
    public PasswordAuthenticationMethodCollectionRequest getPasswordMethods() {
        return new PasswordAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordMethods"), Optional.ofNullable(passwordMethods));
    }

    @NavigationProperty(name="phoneMethods")
    @JsonIgnore
    public PhoneAuthenticationMethodCollectionRequest getPhoneMethods() {
        return new PhoneAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("phoneMethods"), Optional.ofNullable(phoneMethods));
    }

    @NavigationProperty(name="softwareOathMethods")
    @JsonIgnore
    public SoftwareOathAuthenticationMethodCollectionRequest getSoftwareOathMethods() {
        return new SoftwareOathAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("softwareOathMethods"), Optional.ofNullable(softwareOathMethods));
    }

    @NavigationProperty(name="temporaryAccessPassMethods")
    @JsonIgnore
    public TemporaryAccessPassAuthenticationMethodCollectionRequest getTemporaryAccessPassMethods() {
        return new TemporaryAccessPassAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("temporaryAccessPassMethods"), Optional.ofNullable(temporaryAccessPassMethods));
    }

    @NavigationProperty(name="windowsHelloForBusinessMethods")
    @JsonIgnore
    public WindowsHelloForBusinessAuthenticationMethodCollectionRequest getWindowsHelloForBusinessMethods() {
        return new WindowsHelloForBusinessAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("windowsHelloForBusinessMethods"), Optional.ofNullable(windowsHelloForBusinessMethods));
    }

    public Authentication withEmailMethods(List<EmailAuthenticationMethod> emailMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("emailMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.emailMethods = emailMethods;
        return _x;
    }

    public Authentication withFido2Methods(List<Fido2AuthenticationMethod> fido2Methods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("fido2Methods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.fido2Methods = fido2Methods;
        return _x;
    }

    public Authentication withMethods(List<AuthenticationMethod> methods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("methods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.methods = methods;
        return _x;
    }

    public Authentication withMicrosoftAuthenticatorMethods(List<MicrosoftAuthenticatorAuthenticationMethod> microsoftAuthenticatorMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("microsoftAuthenticatorMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.microsoftAuthenticatorMethods = microsoftAuthenticatorMethods;
        return _x;
    }

    public Authentication withOperations(List<LongRunningOperation> operations) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.operations = operations;
        return _x;
    }

    public Authentication withPasswordlessMicrosoftAuthenticatorMethods(List<PasswordlessMicrosoftAuthenticatorAuthenticationMethod> passwordlessMicrosoftAuthenticatorMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("passwordlessMicrosoftAuthenticatorMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.passwordlessMicrosoftAuthenticatorMethods = passwordlessMicrosoftAuthenticatorMethods;
        return _x;
    }

    public Authentication withPasswordMethods(List<PasswordAuthenticationMethod> passwordMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("passwordMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.passwordMethods = passwordMethods;
        return _x;
    }

    public Authentication withPhoneMethods(List<PhoneAuthenticationMethod> phoneMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("phoneMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.phoneMethods = phoneMethods;
        return _x;
    }

    public Authentication withSoftwareOathMethods(List<SoftwareOathAuthenticationMethod> softwareOathMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("softwareOathMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.softwareOathMethods = softwareOathMethods;
        return _x;
    }

    public Authentication withTemporaryAccessPassMethods(List<TemporaryAccessPassAuthenticationMethod> temporaryAccessPassMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("temporaryAccessPassMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.temporaryAccessPassMethods = temporaryAccessPassMethods;
        return _x;
    }

    public Authentication withWindowsHelloForBusinessMethods(List<WindowsHelloForBusinessAuthenticationMethod> windowsHelloForBusinessMethods) {
        Authentication _x = _copy();
        _x.changedFields = changedFields.add("windowsHelloForBusinessMethods");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authentication");
        _x.windowsHelloForBusinessMethods = windowsHelloForBusinessMethods;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Authentication patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Authentication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Authentication put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Authentication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Authentication _copy() {
        Authentication _x = new Authentication();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.emailMethods = emailMethods;
        _x.fido2Methods = fido2Methods;
        _x.methods = methods;
        _x.microsoftAuthenticatorMethods = microsoftAuthenticatorMethods;
        _x.operations = operations;
        _x.passwordlessMicrosoftAuthenticatorMethods = passwordlessMicrosoftAuthenticatorMethods;
        _x.passwordMethods = passwordMethods;
        _x.phoneMethods = phoneMethods;
        _x.softwareOathMethods = softwareOathMethods;
        _x.temporaryAccessPassMethods = temporaryAccessPassMethods;
        _x.windowsHelloForBusinessMethods = windowsHelloForBusinessMethods;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Authentication[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("emailMethods=");
        b.append(this.emailMethods);
        b.append(", ");
        b.append("fido2Methods=");
        b.append(this.fido2Methods);
        b.append(", ");
        b.append("methods=");
        b.append(this.methods);
        b.append(", ");
        b.append("microsoftAuthenticatorMethods=");
        b.append(this.microsoftAuthenticatorMethods);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("passwordlessMicrosoftAuthenticatorMethods=");
        b.append(this.passwordlessMicrosoftAuthenticatorMethods);
        b.append(", ");
        b.append("passwordMethods=");
        b.append(this.passwordMethods);
        b.append(", ");
        b.append("phoneMethods=");
        b.append(this.phoneMethods);
        b.append(", ");
        b.append("softwareOathMethods=");
        b.append(this.softwareOathMethods);
        b.append(", ");
        b.append("temporaryAccessPassMethods=");
        b.append(this.temporaryAccessPassMethods);
        b.append(", ");
        b.append("windowsHelloForBusinessMethods=");
        b.append(this.windowsHelloForBusinessMethods);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
