package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DirectoryAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProvisioningObjectSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedSignInCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SignInCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "directoryAudits", 
    "directoryProvisioning", 
    "provisioning", 
    "restrictedSignIns", 
    "signIns"})
@JsonInclude(Include.NON_NULL)
public class AuditLogRoot implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditLogRoot";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("directoryAudits")
    protected List<DirectoryAudit> directoryAudits;

    @JsonProperty("directoryProvisioning")
    protected List<ProvisioningObjectSummary> directoryProvisioning;

    @JsonProperty("provisioning")
    protected List<ProvisioningObjectSummary> provisioning;

    @JsonProperty("restrictedSignIns")
    protected List<RestrictedSignIn> restrictedSignIns;

    @JsonProperty("signIns")
    protected List<SignIn> signIns;

    protected AuditLogRoot() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<DirectoryAudit> directoryAudits;
        private List<ProvisioningObjectSummary> directoryProvisioning;
        private List<ProvisioningObjectSummary> provisioning;
        private List<RestrictedSignIn> restrictedSignIns;
        private List<SignIn> signIns;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder directoryAudits(List<DirectoryAudit> directoryAudits) {
            this.directoryAudits = directoryAudits;
            this.changedFields = changedFields.add("directoryAudits");
            return this;
        }

        public Builder directoryAudits(DirectoryAudit... directoryAudits) {
            return directoryAudits(Arrays.asList(directoryAudits));
        }

        public Builder directoryProvisioning(List<ProvisioningObjectSummary> directoryProvisioning) {
            this.directoryProvisioning = directoryProvisioning;
            this.changedFields = changedFields.add("directoryProvisioning");
            return this;
        }

        public Builder directoryProvisioning(ProvisioningObjectSummary... directoryProvisioning) {
            return directoryProvisioning(Arrays.asList(directoryProvisioning));
        }

        public Builder provisioning(List<ProvisioningObjectSummary> provisioning) {
            this.provisioning = provisioning;
            this.changedFields = changedFields.add("provisioning");
            return this;
        }

        public Builder provisioning(ProvisioningObjectSummary... provisioning) {
            return provisioning(Arrays.asList(provisioning));
        }

        public Builder restrictedSignIns(List<RestrictedSignIn> restrictedSignIns) {
            this.restrictedSignIns = restrictedSignIns;
            this.changedFields = changedFields.add("restrictedSignIns");
            return this;
        }

        public Builder restrictedSignIns(RestrictedSignIn... restrictedSignIns) {
            return restrictedSignIns(Arrays.asList(restrictedSignIns));
        }

        public Builder signIns(List<SignIn> signIns) {
            this.signIns = signIns;
            this.changedFields = changedFields.add("signIns");
            return this;
        }

        public Builder signIns(SignIn... signIns) {
            return signIns(Arrays.asList(signIns));
        }

        public AuditLogRoot build() {
            AuditLogRoot _x = new AuditLogRoot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.auditLogRoot";
            _x.directoryAudits = directoryAudits;
            _x.directoryProvisioning = directoryProvisioning;
            _x.provisioning = provisioning;
            _x.restrictedSignIns = restrictedSignIns;
            _x.signIns = signIns;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath) {
            contextPath = contextPath.clearQueries();
        }
    }

    public AuditLogRoot withUnmappedField(String name, Object value) {
        AuditLogRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="directoryAudits")
    @JsonIgnore
    public DirectoryAuditCollectionRequest getDirectoryAudits() {
        return new DirectoryAuditCollectionRequest(
                        contextPath.addSegment("directoryAudits"), Optional.ofNullable(directoryAudits));
    }

    @NavigationProperty(name="directoryProvisioning")
    @JsonIgnore
    public ProvisioningObjectSummaryCollectionRequest getDirectoryProvisioning() {
        return new ProvisioningObjectSummaryCollectionRequest(
                        contextPath.addSegment("directoryProvisioning"), Optional.ofNullable(directoryProvisioning));
    }

    @NavigationProperty(name="provisioning")
    @JsonIgnore
    public ProvisioningObjectSummaryCollectionRequest getProvisioning() {
        return new ProvisioningObjectSummaryCollectionRequest(
                        contextPath.addSegment("provisioning"), Optional.ofNullable(provisioning));
    }

    @NavigationProperty(name="restrictedSignIns")
    @JsonIgnore
    public RestrictedSignInCollectionRequest getRestrictedSignIns() {
        return new RestrictedSignInCollectionRequest(
                        contextPath.addSegment("restrictedSignIns"), Optional.ofNullable(restrictedSignIns));
    }

    @NavigationProperty(name="signIns")
    @JsonIgnore
    public SignInCollectionRequest getSignIns() {
        return new SignInCollectionRequest(
                        contextPath.addSegment("signIns"), Optional.ofNullable(signIns));
    }

    public AuditLogRoot withDirectoryAudits(List<DirectoryAudit> directoryAudits) {
        AuditLogRoot _x = _copy();
        _x.changedFields = changedFields.add("directoryAudits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditLogRoot");
        _x.directoryAudits = directoryAudits;
        return _x;
    }

    public AuditLogRoot withDirectoryProvisioning(List<ProvisioningObjectSummary> directoryProvisioning) {
        AuditLogRoot _x = _copy();
        _x.changedFields = changedFields.add("directoryProvisioning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditLogRoot");
        _x.directoryProvisioning = directoryProvisioning;
        return _x;
    }

    public AuditLogRoot withProvisioning(List<ProvisioningObjectSummary> provisioning) {
        AuditLogRoot _x = _copy();
        _x.changedFields = changedFields.add("provisioning");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditLogRoot");
        _x.provisioning = provisioning;
        return _x;
    }

    public AuditLogRoot withRestrictedSignIns(List<RestrictedSignIn> restrictedSignIns) {
        AuditLogRoot _x = _copy();
        _x.changedFields = changedFields.add("restrictedSignIns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditLogRoot");
        _x.restrictedSignIns = restrictedSignIns;
        return _x;
    }

    public AuditLogRoot withSignIns(List<SignIn> signIns) {
        AuditLogRoot _x = _copy();
        _x.changedFields = changedFields.add("signIns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditLogRoot");
        _x.signIns = signIns;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuditLogRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuditLogRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuditLogRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuditLogRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuditLogRoot _copy() {
        AuditLogRoot _x = new AuditLogRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.directoryAudits = directoryAudits;
        _x.directoryProvisioning = directoryProvisioning;
        _x.provisioning = provisioning;
        _x.restrictedSignIns = restrictedSignIns;
        _x.signIns = signIns;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditLogRoot[");
        b.append("directoryAudits=");
        b.append(this.directoryAudits);
        b.append(", ");
        b.append("directoryProvisioning=");
        b.append(this.directoryProvisioning);
        b.append(", ");
        b.append("provisioning=");
        b.append(this.provisioning);
        b.append(", ");
        b.append("restrictedSignIns=");
        b.append(this.restrictedSignIns);
        b.append(", ");
        b.append("signIns=");
        b.append(this.signIns);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
