package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "maxAttributesPerSet"})
@JsonInclude(Include.NON_NULL)
public class AttributeSet extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attributeSet";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("maxAttributesPerSet")
    protected Integer maxAttributesPerSet;

    protected AttributeSet() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttributeSet() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private Integer maxAttributesPerSet;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder maxAttributesPerSet(Integer maxAttributesPerSet) {
            this.maxAttributesPerSet = maxAttributesPerSet;
            this.changedFields = changedFields.add("maxAttributesPerSet");
            return this;
        }

        public AttributeSet build() {
            AttributeSet _x = new AttributeSet();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attributeSet";
            _x.id = id;
            _x.description = description;
            _x.maxAttributesPerSet = maxAttributesPerSet;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AttributeSet withDescription(String description) {
        AttributeSet _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeSet");
        _x.description = description;
        return _x;
    }

    @Property(name="maxAttributesPerSet")
    @JsonIgnore
    public Optional<Integer> getMaxAttributesPerSet() {
        return Optional.ofNullable(maxAttributesPerSet);
    }

    public AttributeSet withMaxAttributesPerSet(Integer maxAttributesPerSet) {
        AttributeSet _x = _copy();
        _x.changedFields = changedFields.add("maxAttributesPerSet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeSet");
        _x.maxAttributesPerSet = maxAttributesPerSet;
        return _x;
    }

    public AttributeSet withUnmappedField(String name, Object value) {
        AttributeSet _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttributeSet patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AttributeSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttributeSet put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AttributeSet _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AttributeSet _copy() {
        AttributeSet _x = new AttributeSet();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.maxAttributesPerSet = maxAttributesPerSet;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeSet[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("maxAttributesPerSet=");
        b.append(this.maxAttributesPerSet);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
