package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AttributeMappingParameterSchema;

@JsonPropertyOrder({
    "@odata.type", 
    "parameters"})
@JsonInclude(Include.NON_NULL)
public class AttributeMappingFunctionSchema extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attributeMappingFunctionSchema";
    }

    @JsonProperty("parameters")
    protected List<AttributeMappingParameterSchema> parameters;

    @JsonProperty("parameters@nextLink")
    protected String parametersNextLink;

    protected AttributeMappingFunctionSchema() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttributeMappingFunctionSchema() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AttributeMappingParameterSchema> parameters;
        private String parametersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder parameters(List<AttributeMappingParameterSchema> parameters) {
            this.parameters = parameters;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder parameters(AttributeMappingParameterSchema... parameters) {
            return parameters(Arrays.asList(parameters));
        }

        public Builder parametersNextLink(String parametersNextLink) {
            this.parametersNextLink = parametersNextLink;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public AttributeMappingFunctionSchema build() {
            AttributeMappingFunctionSchema _x = new AttributeMappingFunctionSchema();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attributeMappingFunctionSchema";
            _x.id = id;
            _x.parameters = parameters;
            _x.parametersNextLink = parametersNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<AttributeMappingParameterSchema> getParameters() {
        return new CollectionPage<AttributeMappingParameterSchema>(contextPath, AttributeMappingParameterSchema.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AttributeMappingFunctionSchema withParameters(List<AttributeMappingParameterSchema> parameters) {
        AttributeMappingFunctionSchema _x = _copy();
        _x.changedFields = changedFields.add("parameters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMappingFunctionSchema");
        _x.parameters = parameters;
        return _x;
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<AttributeMappingParameterSchema> getParameters(HttpRequestOptions options) {
        return new CollectionPage<AttributeMappingParameterSchema>(contextPath, AttributeMappingParameterSchema.class, this.parameters, Optional.ofNullable(parametersNextLink), Collections.emptyList(), options);
    }

    public AttributeMappingFunctionSchema withUnmappedField(String name, Object value) {
        AttributeMappingFunctionSchema _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttributeMappingFunctionSchema patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AttributeMappingFunctionSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttributeMappingFunctionSchema put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AttributeMappingFunctionSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AttributeMappingFunctionSchema _copy() {
        AttributeMappingFunctionSchema _x = new AttributeMappingFunctionSchema();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.parameters = parameters;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeMappingFunctionSchema[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("parameters=");
        b.append(this.parameters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
