package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AttendanceInterval;
import odata.msgraph.client.beta.complex.Identity;

@JsonPropertyOrder({
    "@odata.type", 
    "attendanceIntervals", 
    "emailAddress", 
    "identity", 
    "role", 
    "totalAttendanceInSeconds"})
@JsonInclude(Include.NON_NULL)
public class AttendanceRecord extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attendanceRecord";
    }

    @JsonProperty("attendanceIntervals")
    protected List<AttendanceInterval> attendanceIntervals;

    @JsonProperty("attendanceIntervals@nextLink")
    protected String attendanceIntervalsNextLink;

    @JsonProperty("emailAddress")
    protected String emailAddress;

    @JsonProperty("identity")
    protected Identity identity;

    @JsonProperty("role")
    protected String role;

    @JsonProperty("totalAttendanceInSeconds")
    protected Integer totalAttendanceInSeconds;

    protected AttendanceRecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAttendanceRecord() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AttendanceInterval> attendanceIntervals;
        private String attendanceIntervalsNextLink;
        private String emailAddress;
        private Identity identity;
        private String role;
        private Integer totalAttendanceInSeconds;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder attendanceIntervals(List<AttendanceInterval> attendanceIntervals) {
            this.attendanceIntervals = attendanceIntervals;
            this.changedFields = changedFields.add("attendanceIntervals");
            return this;
        }

        public Builder attendanceIntervals(AttendanceInterval... attendanceIntervals) {
            return attendanceIntervals(Arrays.asList(attendanceIntervals));
        }

        public Builder attendanceIntervalsNextLink(String attendanceIntervalsNextLink) {
            this.attendanceIntervalsNextLink = attendanceIntervalsNextLink;
            this.changedFields = changedFields.add("attendanceIntervals");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder identity(Identity identity) {
            this.identity = identity;
            this.changedFields = changedFields.add("identity");
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder totalAttendanceInSeconds(Integer totalAttendanceInSeconds) {
            this.totalAttendanceInSeconds = totalAttendanceInSeconds;
            this.changedFields = changedFields.add("totalAttendanceInSeconds");
            return this;
        }

        public AttendanceRecord build() {
            AttendanceRecord _x = new AttendanceRecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.attendanceRecord";
            _x.id = id;
            _x.attendanceIntervals = attendanceIntervals;
            _x.attendanceIntervalsNextLink = attendanceIntervalsNextLink;
            _x.emailAddress = emailAddress;
            _x.identity = identity;
            _x.role = role;
            _x.totalAttendanceInSeconds = totalAttendanceInSeconds;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="attendanceIntervals")
    @JsonIgnore
    public CollectionPage<AttendanceInterval> getAttendanceIntervals() {
        return new CollectionPage<AttendanceInterval>(contextPath, AttendanceInterval.class, this.attendanceIntervals, Optional.ofNullable(attendanceIntervalsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AttendanceRecord withAttendanceIntervals(List<AttendanceInterval> attendanceIntervals) {
        AttendanceRecord _x = _copy();
        _x.changedFields = changedFields.add("attendanceIntervals");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceRecord");
        _x.attendanceIntervals = attendanceIntervals;
        return _x;
    }

    @Property(name="attendanceIntervals")
    @JsonIgnore
    public CollectionPage<AttendanceInterval> getAttendanceIntervals(HttpRequestOptions options) {
        return new CollectionPage<AttendanceInterval>(contextPath, AttendanceInterval.class, this.attendanceIntervals, Optional.ofNullable(attendanceIntervalsNextLink), Collections.emptyList(), options);
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public AttendanceRecord withEmailAddress(String emailAddress) {
        AttendanceRecord _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceRecord");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Property(name="identity")
    @JsonIgnore
    public Optional<Identity> getIdentity() {
        return Optional.ofNullable(identity);
    }

    public AttendanceRecord withIdentity(Identity identity) {
        AttendanceRecord _x = _copy();
        _x.changedFields = changedFields.add("identity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceRecord");
        _x.identity = identity;
        return _x;
    }

    @Property(name="role")
    @JsonIgnore
    public Optional<String> getRole() {
        return Optional.ofNullable(role);
    }

    public AttendanceRecord withRole(String role) {
        AttendanceRecord _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceRecord");
        _x.role = role;
        return _x;
    }

    @Property(name="totalAttendanceInSeconds")
    @JsonIgnore
    public Optional<Integer> getTotalAttendanceInSeconds() {
        return Optional.ofNullable(totalAttendanceInSeconds);
    }

    public AttendanceRecord withTotalAttendanceInSeconds(Integer totalAttendanceInSeconds) {
        AttendanceRecord _x = _copy();
        _x.changedFields = changedFields.add("totalAttendanceInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendanceRecord");
        _x.totalAttendanceInSeconds = totalAttendanceInSeconds;
        return _x;
    }

    public AttendanceRecord withUnmappedField(String name, Object value) {
        AttendanceRecord _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttendanceRecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AttendanceRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttendanceRecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AttendanceRecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AttendanceRecord _copy() {
        AttendanceRecord _x = new AttendanceRecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.attendanceIntervals = attendanceIntervals;
        _x.emailAddress = emailAddress;
        _x.identity = identity;
        _x.role = role;
        _x.totalAttendanceInSeconds = totalAttendanceInSeconds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttendanceRecord[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("attendanceIntervals=");
        b.append(this.attendanceIntervals);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("identity=");
        b.append(this.identity);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("totalAttendanceInSeconds=");
        b.append(this.totalAttendanceInSeconds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
