package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.SimulationAutomationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SimulationCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "simulationAutomations", 
    "simulations"})
@JsonInclude(Include.NON_NULL)
public class AttackSimulationRoot extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attackSimulationRoot";
    }

    @JsonProperty("simulationAutomations")
    protected List<SimulationAutomation> simulationAutomations;

    @JsonProperty("simulations")
    protected List<Simulation> simulations;

    protected AttackSimulationRoot() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public AttackSimulationRoot withUnmappedField(String name, Object value) {
        AttackSimulationRoot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="simulationAutomations")
    @JsonIgnore
    public SimulationAutomationCollectionRequest getSimulationAutomations() {
        return new SimulationAutomationCollectionRequest(
                        contextPath.addSegment("simulationAutomations"), Optional.ofNullable(simulationAutomations));
    }

    @NavigationProperty(name="simulations")
    @JsonIgnore
    public SimulationCollectionRequest getSimulations() {
        return new SimulationCollectionRequest(
                        contextPath.addSegment("simulations"), Optional.ofNullable(simulations));
    }

    public AttackSimulationRoot withSimulationAutomations(List<SimulationAutomation> simulationAutomations) {
        AttackSimulationRoot _x = _copy();
        _x.changedFields = changedFields.add("simulationAutomations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationRoot");
        _x.simulationAutomations = simulationAutomations;
        return _x;
    }

    public AttackSimulationRoot withSimulations(List<Simulation> simulations) {
        AttackSimulationRoot _x = _copy();
        _x.changedFields = changedFields.add("simulations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attackSimulationRoot");
        _x.simulations = simulations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttackSimulationRoot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AttackSimulationRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AttackSimulationRoot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AttackSimulationRoot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AttackSimulationRoot _copy() {
        AttackSimulationRoot _x = new AttackSimulationRoot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.simulationAutomations = simulationAutomations;
        _x.simulations = simulations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttackSimulationRoot[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("simulationAutomations=");
        b.append(this.simulationAutomations);
        b.append(", ");
        b.append("simulations=");
        b.append(this.simulations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
