package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ApplicationServicePrincipal;

@JsonPropertyOrder({
    "@odata.type", 
    "categories", 
    "description", 
    "displayName", 
    "homePageUrl", 
    "logoUrl", 
    "publisher", 
    "supportedProvisioningTypes", 
    "supportedSingleSignOnModes"})
@JsonInclude(Include.NON_NULL)
public class ApplicationTemplate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.applicationTemplate";
    }

    @JsonProperty("categories")
    protected List<String> categories;

    @JsonProperty("categories@nextLink")
    protected String categoriesNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("homePageUrl")
    protected String homePageUrl;

    @JsonProperty("logoUrl")
    protected String logoUrl;

    @JsonProperty("publisher")
    protected String publisher;

    @JsonProperty("supportedProvisioningTypes")
    protected List<String> supportedProvisioningTypes;

    @JsonProperty("supportedProvisioningTypes@nextLink")
    protected String supportedProvisioningTypesNextLink;

    @JsonProperty("supportedSingleSignOnModes")
    protected List<String> supportedSingleSignOnModes;

    @JsonProperty("supportedSingleSignOnModes@nextLink")
    protected String supportedSingleSignOnModesNextLink;

    protected ApplicationTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplicationTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> categories;
        private String categoriesNextLink;
        private String description;
        private String displayName;
        private String homePageUrl;
        private String logoUrl;
        private String publisher;
        private List<String> supportedProvisioningTypes;
        private String supportedProvisioningTypesNextLink;
        private List<String> supportedSingleSignOnModes;
        private String supportedSingleSignOnModesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder homePageUrl(String homePageUrl) {
            this.homePageUrl = homePageUrl;
            this.changedFields = changedFields.add("homePageUrl");
            return this;
        }

        public Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            this.changedFields = changedFields.add("logoUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder supportedProvisioningTypes(List<String> supportedProvisioningTypes) {
            this.supportedProvisioningTypes = supportedProvisioningTypes;
            this.changedFields = changedFields.add("supportedProvisioningTypes");
            return this;
        }

        public Builder supportedProvisioningTypes(String... supportedProvisioningTypes) {
            return supportedProvisioningTypes(Arrays.asList(supportedProvisioningTypes));
        }

        public Builder supportedProvisioningTypesNextLink(String supportedProvisioningTypesNextLink) {
            this.supportedProvisioningTypesNextLink = supportedProvisioningTypesNextLink;
            this.changedFields = changedFields.add("supportedProvisioningTypes");
            return this;
        }

        public Builder supportedSingleSignOnModes(List<String> supportedSingleSignOnModes) {
            this.supportedSingleSignOnModes = supportedSingleSignOnModes;
            this.changedFields = changedFields.add("supportedSingleSignOnModes");
            return this;
        }

        public Builder supportedSingleSignOnModes(String... supportedSingleSignOnModes) {
            return supportedSingleSignOnModes(Arrays.asList(supportedSingleSignOnModes));
        }

        public Builder supportedSingleSignOnModesNextLink(String supportedSingleSignOnModesNextLink) {
            this.supportedSingleSignOnModesNextLink = supportedSingleSignOnModesNextLink;
            this.changedFields = changedFields.add("supportedSingleSignOnModes");
            return this;
        }

        public ApplicationTemplate build() {
            ApplicationTemplate _x = new ApplicationTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.applicationTemplate";
            _x.id = id;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.homePageUrl = homePageUrl;
            _x.logoUrl = logoUrl;
            _x.publisher = publisher;
            _x.supportedProvisioningTypes = supportedProvisioningTypes;
            _x.supportedProvisioningTypesNextLink = supportedProvisioningTypesNextLink;
            _x.supportedSingleSignOnModes = supportedSingleSignOnModes;
            _x.supportedSingleSignOnModesNextLink = supportedSingleSignOnModesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories() {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ApplicationTemplate withCategories(List<String> categories) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("categories");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.categories = categories;
        return _x;
    }

    @Property(name="categories")
    @JsonIgnore
    public CollectionPage<String> getCategories(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.categories, Optional.ofNullable(categoriesNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ApplicationTemplate withDescription(String description) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ApplicationTemplate withDisplayName(String displayName) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="homePageUrl")
    @JsonIgnore
    public Optional<String> getHomePageUrl() {
        return Optional.ofNullable(homePageUrl);
    }

    public ApplicationTemplate withHomePageUrl(String homePageUrl) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("homePageUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.homePageUrl = homePageUrl;
        return _x;
    }

    @Property(name="logoUrl")
    @JsonIgnore
    public Optional<String> getLogoUrl() {
        return Optional.ofNullable(logoUrl);
    }

    public ApplicationTemplate withLogoUrl(String logoUrl) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("logoUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.logoUrl = logoUrl;
        return _x;
    }

    @Property(name="publisher")
    @JsonIgnore
    public Optional<String> getPublisher() {
        return Optional.ofNullable(publisher);
    }

    public ApplicationTemplate withPublisher(String publisher) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("publisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.publisher = publisher;
        return _x;
    }

    @Property(name="supportedProvisioningTypes")
    @JsonIgnore
    public CollectionPage<String> getSupportedProvisioningTypes() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedProvisioningTypes, Optional.ofNullable(supportedProvisioningTypesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ApplicationTemplate withSupportedProvisioningTypes(List<String> supportedProvisioningTypes) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("supportedProvisioningTypes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.supportedProvisioningTypes = supportedProvisioningTypes;
        return _x;
    }

    @Property(name="supportedProvisioningTypes")
    @JsonIgnore
    public CollectionPage<String> getSupportedProvisioningTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedProvisioningTypes, Optional.ofNullable(supportedProvisioningTypesNextLink), Collections.emptyList(), options);
    }

    @Property(name="supportedSingleSignOnModes")
    @JsonIgnore
    public CollectionPage<String> getSupportedSingleSignOnModes() {
        return new CollectionPage<String>(contextPath, String.class, this.supportedSingleSignOnModes, Optional.ofNullable(supportedSingleSignOnModesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ApplicationTemplate withSupportedSingleSignOnModes(List<String> supportedSingleSignOnModes) {
        ApplicationTemplate _x = _copy();
        _x.changedFields = changedFields.add("supportedSingleSignOnModes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationTemplate");
        _x.supportedSingleSignOnModes = supportedSingleSignOnModes;
        return _x;
    }

    @Property(name="supportedSingleSignOnModes")
    @JsonIgnore
    public CollectionPage<String> getSupportedSingleSignOnModes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.supportedSingleSignOnModes, Optional.ofNullable(supportedSingleSignOnModesNextLink), Collections.emptyList(), options);
    }

    public ApplicationTemplate withUnmappedField(String name, Object value) {
        ApplicationTemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplicationTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ApplicationTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplicationTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ApplicationTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ApplicationTemplate _copy() {
        ApplicationTemplate _x = new ApplicationTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categories = categories;
        _x.description = description;
        _x.displayName = displayName;
        _x.homePageUrl = homePageUrl;
        _x.logoUrl = logoUrl;
        _x.publisher = publisher;
        _x.supportedProvisioningTypes = supportedProvisioningTypes;
        _x.supportedSingleSignOnModes = supportedSingleSignOnModes;
        return _x;
    }

    @Action(name = "instantiate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ApplicationServicePrincipal> instantiate(String displayName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ApplicationServicePrincipal>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.instantiate"), ApplicationServicePrincipal.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApplicationTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("homePageUrl=");
        b.append(this.homePageUrl);
        b.append(", ");
        b.append("logoUrl=");
        b.append(this.logoUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("supportedProvisioningTypes=");
        b.append(this.supportedProvisioningTypes);
        b.append(", ");
        b.append("supportedSingleSignOnModes=");
        b.append(this.supportedSingleSignOnModes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
