package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.SignInStatus;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "aggregatedEventDateTime", 
    "appDisplayName", 
    "appId", 
    "signInCount", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class ApplicationSignInDetailedSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.applicationSignInDetailedSummary";
    }

    @JsonProperty("aggregatedEventDateTime")
    protected OffsetDateTime aggregatedEventDateTime;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("signInCount")
    protected Long signInCount;

    @JsonProperty("status")
    protected SignInStatus status;

    protected ApplicationSignInDetailedSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplicationSignInDetailedSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime aggregatedEventDateTime;
        private String appDisplayName;
        private String appId;
        private Long signInCount;
        private SignInStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder aggregatedEventDateTime(OffsetDateTime aggregatedEventDateTime) {
            this.aggregatedEventDateTime = aggregatedEventDateTime;
            this.changedFields = changedFields.add("aggregatedEventDateTime");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder signInCount(Long signInCount) {
            this.signInCount = signInCount;
            this.changedFields = changedFields.add("signInCount");
            return this;
        }

        public Builder status(SignInStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public ApplicationSignInDetailedSummary build() {
            ApplicationSignInDetailedSummary _x = new ApplicationSignInDetailedSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.applicationSignInDetailedSummary";
            _x.id = id;
            _x.aggregatedEventDateTime = aggregatedEventDateTime;
            _x.appDisplayName = appDisplayName;
            _x.appId = appId;
            _x.signInCount = signInCount;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="aggregatedEventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAggregatedEventDateTime() {
        return Optional.ofNullable(aggregatedEventDateTime);
    }

    public ApplicationSignInDetailedSummary withAggregatedEventDateTime(OffsetDateTime aggregatedEventDateTime) {
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("aggregatedEventDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInDetailedSummary");
        _x.aggregatedEventDateTime = aggregatedEventDateTime;
        return _x;
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public ApplicationSignInDetailedSummary withAppDisplayName(String appDisplayName) {
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInDetailedSummary");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public ApplicationSignInDetailedSummary withAppId(String appId) {
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInDetailedSummary");
        _x.appId = appId;
        return _x;
    }

    @Property(name="signInCount")
    @JsonIgnore
    public Optional<Long> getSignInCount() {
        return Optional.ofNullable(signInCount);
    }

    public ApplicationSignInDetailedSummary withSignInCount(Long signInCount) {
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("signInCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInDetailedSummary");
        _x.signInCount = signInCount;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<SignInStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public ApplicationSignInDetailedSummary withStatus(SignInStatus status) {
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInDetailedSummary");
        _x.status = status;
        return _x;
    }

    public ApplicationSignInDetailedSummary withUnmappedField(String name, Object value) {
        ApplicationSignInDetailedSummary _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplicationSignInDetailedSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplicationSignInDetailedSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ApplicationSignInDetailedSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ApplicationSignInDetailedSummary _copy() {
        ApplicationSignInDetailedSummary _x = new ApplicationSignInDetailedSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.aggregatedEventDateTime = aggregatedEventDateTime;
        _x.appDisplayName = appDisplayName;
        _x.appId = appId;
        _x.signInCount = signInCount;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApplicationSignInDetailedSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("aggregatedEventDateTime=");
        b.append(this.aggregatedEventDateTime);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("signInCount=");
        b.append(this.signInCount);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
