package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppleOwnerTypeEnrollmentType;
import odata.msgraph.client.beta.entity.collection.request.AppleEnrollmentProfileAssignmentCollectionRequest;
import odata.msgraph.client.beta.enums.AppleUserInitiatedEnrollmentType;
import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“The enrollmentProfile resource represents a collection of configurations which
 * must be provided pre-enrollment to enable enrolling certain devices whose
 * identities have been pre-staged. Pre-staged device identities are assigned to
 * this type of profile to apply the profile's configurations at enrollment of the
 * corresponding device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "availableEnrollmentTypeOptions", 
    "createdDateTime", 
    "defaultEnrollmentType", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "platform", 
    "priority", 
    "assignments"})
@JsonInclude(Include.NON_NULL)
public class AppleUserInitiatedEnrollmentProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleUserInitiatedEnrollmentProfile";
    }

    @JsonProperty("availableEnrollmentTypeOptions")
    protected List<AppleOwnerTypeEnrollmentType> availableEnrollmentTypeOptions;

    @JsonProperty("availableEnrollmentTypeOptions@nextLink")
    protected String availableEnrollmentTypeOptionsNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("defaultEnrollmentType")
    protected AppleUserInitiatedEnrollmentType defaultEnrollmentType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("platform")
    protected DevicePlatformType platform;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("assignments")
    protected List<AppleEnrollmentProfileAssignment> assignments;

    protected AppleUserInitiatedEnrollmentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppleUserInitiatedEnrollmentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<AppleOwnerTypeEnrollmentType> availableEnrollmentTypeOptions;
        private String availableEnrollmentTypeOptionsNextLink;
        private OffsetDateTime createdDateTime;
        private AppleUserInitiatedEnrollmentType defaultEnrollmentType;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private DevicePlatformType platform;
        private Integer priority;
        private List<AppleEnrollmentProfileAssignment> assignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“List of available enrollment type options”</i>
         * 
         * @param availableEnrollmentTypeOptions
         *            value of {@code availableEnrollmentTypeOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder availableEnrollmentTypeOptions(List<AppleOwnerTypeEnrollmentType> availableEnrollmentTypeOptions) {
            this.availableEnrollmentTypeOptions = availableEnrollmentTypeOptions;
            this.changedFields = changedFields.add("availableEnrollmentTypeOptions");
            return this;
        }

        /**
         * <i>“List of available enrollment type options”</i>
         * 
         * @param availableEnrollmentTypeOptions
         *            value of {@code availableEnrollmentTypeOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder availableEnrollmentTypeOptions(AppleOwnerTypeEnrollmentType... availableEnrollmentTypeOptions) {
            return availableEnrollmentTypeOptions(Arrays.asList(availableEnrollmentTypeOptions));
        }

        /**
         * <i>“List of available enrollment type options”</i>
         * 
         * @param availableEnrollmentTypeOptionsNextLink
         *            value of {@code availableEnrollmentTypeOptions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder availableEnrollmentTypeOptionsNextLink(String availableEnrollmentTypeOptionsNextLink) {
            this.availableEnrollmentTypeOptionsNextLink = availableEnrollmentTypeOptionsNextLink;
            this.changedFields = changedFields.add("availableEnrollmentTypeOptions");
            return this;
        }

        /**
         * <i>“Profile creation time”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The default profile enrollment type.”</i>
         * 
         * @param defaultEnrollmentType
         *            value of {@code defaultEnrollmentType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder defaultEnrollmentType(AppleUserInitiatedEnrollmentType defaultEnrollmentType) {
            this.defaultEnrollmentType = defaultEnrollmentType;
            this.changedFields = changedFields.add("defaultEnrollmentType");
            return this;
        }

        /**
         * <i>“Description of the profile”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Name of the profile”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Profile last modified time”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The platform of the Device.”</i>
         * 
         * @param platform
         *            value of {@code platform} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder platform(DevicePlatformType platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        /**
         * <i>“Priority, 0 is highest”</i>
         * 
         * @param priority
         *            value of {@code priority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        /**
         * <i>“The list of assignments for this profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(List<AppleEnrollmentProfileAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        /**
         * <i>“The list of assignments for this profile.”</i>
         * 
         * @param assignments
         *            value of {@code assignments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignments(AppleEnrollmentProfileAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public AppleUserInitiatedEnrollmentProfile build() {
            AppleUserInitiatedEnrollmentProfile _x = new AppleUserInitiatedEnrollmentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appleUserInitiatedEnrollmentProfile";
            _x.id = id;
            _x.availableEnrollmentTypeOptions = availableEnrollmentTypeOptions;
            _x.availableEnrollmentTypeOptionsNextLink = availableEnrollmentTypeOptionsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.defaultEnrollmentType = defaultEnrollmentType;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.platform = platform;
            _x.priority = priority;
            _x.assignments = assignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“List of available enrollment type options”</i>
     * 
     * @return property availableEnrollmentTypeOptions
     */
    @Property(name="availableEnrollmentTypeOptions")
    @JsonIgnore
    public CollectionPage<AppleOwnerTypeEnrollmentType> getAvailableEnrollmentTypeOptions() {
        return new CollectionPage<AppleOwnerTypeEnrollmentType>(contextPath, AppleOwnerTypeEnrollmentType.class, this.availableEnrollmentTypeOptions, Optional.ofNullable(availableEnrollmentTypeOptionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * availableEnrollmentTypeOptions} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“List of available enrollment type options”</i>
     * 
     * @param availableEnrollmentTypeOptions
     *            new value of {@code availableEnrollmentTypeOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code availableEnrollmentTypeOptions} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withAvailableEnrollmentTypeOptions(List<AppleOwnerTypeEnrollmentType> availableEnrollmentTypeOptions) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("availableEnrollmentTypeOptions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.availableEnrollmentTypeOptions = availableEnrollmentTypeOptions;
        return _x;
    }

    /**
     * <i>“List of available enrollment type options”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property availableEnrollmentTypeOptions
     */
    @Property(name="availableEnrollmentTypeOptions")
    @JsonIgnore
    public CollectionPage<AppleOwnerTypeEnrollmentType> getAvailableEnrollmentTypeOptions(HttpRequestOptions options) {
        return new CollectionPage<AppleOwnerTypeEnrollmentType>(contextPath, AppleOwnerTypeEnrollmentType.class, this.availableEnrollmentTypeOptions, Optional.ofNullable(availableEnrollmentTypeOptionsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Profile creation time”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Profile creation time”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The default profile enrollment type.”</i>
     * 
     * @return property defaultEnrollmentType
     */
    @Property(name="defaultEnrollmentType")
    @JsonIgnore
    public Optional<AppleUserInitiatedEnrollmentType> getDefaultEnrollmentType() {
        return Optional.ofNullable(defaultEnrollmentType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * defaultEnrollmentType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The default profile enrollment type.”</i>
     * 
     * @param defaultEnrollmentType
     *            new value of {@code defaultEnrollmentType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code defaultEnrollmentType} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withDefaultEnrollmentType(AppleUserInitiatedEnrollmentType defaultEnrollmentType) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("defaultEnrollmentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.defaultEnrollmentType = defaultEnrollmentType;
        return _x;
    }

    /**
     * <i>“Description of the profile”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the profile”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withDescription(String description) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Name of the profile”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the profile”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withDisplayName(String displayName) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Profile last modified time”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Profile last modified time”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The platform of the Device.”</i>
     * 
     * @return property platform
     */
    @Property(name="platform")
    @JsonIgnore
    public Optional<DevicePlatformType> getPlatform() {
        return Optional.ofNullable(platform);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code platform} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The platform of the Device.”</i>
     * 
     * @param platform
     *            new value of {@code platform} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code platform} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withPlatform(DevicePlatformType platform) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.platform = platform;
        return _x;
    }

    /**
     * <i>“Priority, 0 is highest”</i>
     * 
     * @return property priority
     */
    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code priority} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Priority, 0 is highest”</i>
     * 
     * @param priority
     *            new value of {@code priority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code priority} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withPriority(Integer priority) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.priority = priority;
        return _x;
    }

    public AppleUserInitiatedEnrollmentProfile withUnmappedField(String name, Object value) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The list of assignments for this profile.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public AppleEnrollmentProfileAssignmentCollectionRequest getAssignments() {
        return new AppleEnrollmentProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The list of assignments for this profile.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public AppleUserInitiatedEnrollmentProfile withAssignments(List<AppleEnrollmentProfileAssignment> assignments) {
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleUserInitiatedEnrollmentProfile");
        _x.assignments = assignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleUserInitiatedEnrollmentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleUserInitiatedEnrollmentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppleUserInitiatedEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppleUserInitiatedEnrollmentProfile _copy() {
        AppleUserInitiatedEnrollmentProfile _x = new AppleUserInitiatedEnrollmentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.availableEnrollmentTypeOptions = availableEnrollmentTypeOptions;
        _x.createdDateTime = createdDateTime;
        _x.defaultEnrollmentType = defaultEnrollmentType;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.platform = platform;
        _x.priority = priority;
        _x.assignments = assignments;
        return _x;
    }

    @Action(name = "setPriority")
    @JsonIgnore
    public ActionRequestNoReturn setPriority(Integer priority) {
        Preconditions.checkNotNull(priority, "priority cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("priority", "Edm.Int32", priority)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setPriority"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleUserInitiatedEnrollmentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("availableEnrollmentTypeOptions=");
        b.append(this.availableEnrollmentTypeOptions);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("defaultEnrollmentType=");
        b.append(this.defaultEnrollmentType);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
