package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerRequiredPasswordType;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the AndroidDeviceOwnerAOSPDeviceConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appsBlockInstallFromUnknownSources", 
    "bluetoothBlockConfiguration", 
    "bluetoothBlocked", 
    "cameraBlocked", 
    "factoryResetBlocked", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordRequiredType", 
    "passwordSignInFailureCountBeforeFactoryReset", 
    "screenCaptureBlocked", 
    "securityAllowDebuggingFeatures", 
    "storageBlockExternalMedia", 
    "storageBlockUsbFileTransfer", 
    "wifiBlockEditConfigurations"})
@JsonInclude(Include.NON_NULL)
public class AospDeviceOwnerDeviceConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.aospDeviceOwnerDeviceConfiguration";
    }

    @JsonProperty("appsBlockInstallFromUnknownSources")
    protected Boolean appsBlockInstallFromUnknownSources;

    @JsonProperty("bluetoothBlockConfiguration")
    protected Boolean bluetoothBlockConfiguration;

    @JsonProperty("bluetoothBlocked")
    protected Boolean bluetoothBlocked;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("factoryResetBlocked")
    protected Boolean factoryResetBlocked;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordRequiredType")
    protected AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordSignInFailureCountBeforeFactoryReset")
    protected Integer passwordSignInFailureCountBeforeFactoryReset;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("securityAllowDebuggingFeatures")
    protected Boolean securityAllowDebuggingFeatures;

    @JsonProperty("storageBlockExternalMedia")
    protected Boolean storageBlockExternalMedia;

    @JsonProperty("storageBlockUsbFileTransfer")
    protected Boolean storageBlockUsbFileTransfer;

    @JsonProperty("wifiBlockEditConfigurations")
    protected Boolean wifiBlockEditConfigurations;

    protected AospDeviceOwnerDeviceConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAospDeviceOwnerDeviceConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean appsBlockInstallFromUnknownSources;
        private Boolean bluetoothBlockConfiguration;
        private Boolean bluetoothBlocked;
        private Boolean cameraBlocked;
        private Boolean factoryResetBlocked;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;
        private Integer passwordSignInFailureCountBeforeFactoryReset;
        private Boolean screenCaptureBlocked;
        private Boolean securityAllowDebuggingFeatures;
        private Boolean storageBlockExternalMedia;
        private Boolean storageBlockUsbFileTransfer;
        private Boolean wifiBlockEditConfigurations;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Indicates whether or not the user is allowed to enable unknown sources setting.
         * When set to true, user is not allowed to enable unknown sources settings.”</i>
         * 
         * @param appsBlockInstallFromUnknownSources
         *            value of {@code appsBlockInstallFromUnknownSources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsBlockInstallFromUnknownSources(Boolean appsBlockInstallFromUnknownSources) {
            this.appsBlockInstallFromUnknownSources = appsBlockInstallFromUnknownSources;
            this.changedFields = changedFields.add("appsBlockInstallFromUnknownSources");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block a user from configuring bluetooth.”</i>
         * 
         * @param bluetoothBlockConfiguration
         *            value of {@code bluetoothBlockConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockConfiguration(Boolean bluetoothBlockConfiguration) {
            this.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
            this.changedFields = changedFields.add("bluetoothBlockConfiguration");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the use of bluetooth. When set to true,
         * bluetooth cannot be enabled on the device.”</i>
         * 
         * @param bluetoothBlocked
         *            value of {@code bluetoothBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlocked(Boolean bluetoothBlocked) {
            this.bluetoothBlocked = bluetoothBlocked;
            this.changedFields = changedFields.add("bluetoothBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the use of the camera.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not the factory reset option in settings is disabled.”</i>
         * 
         * @param factoryResetBlocked
         *            value of {@code factoryResetBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder factoryResetBlocked(Boolean factoryResetBlocked) {
            this.factoryResetBlocked = factoryResetBlocked;
            this.changedFields = changedFields.add("factoryResetBlocked");
            return this;
        }

        /**
         * <i>“Indicates the minimum length of the password required on the device. Valid
         * values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before the screen times out.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Indicates the minimum password quality required on the device.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Indicates the number of times a user can enter an incorrect password before the
         * device is wiped. Valid values 4 to 11”</i>
         * 
         * @param passwordSignInFailureCountBeforeFactoryReset
         *            value of {@code passwordSignInFailureCountBeforeFactoryReset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
            this.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            this.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the capability to take screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from enabling debugging features on
         * the device.”</i>
         * 
         * @param securityAllowDebuggingFeatures
         *            value of {@code securityAllowDebuggingFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityAllowDebuggingFeatures(Boolean securityAllowDebuggingFeatures) {
            this.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
            this.changedFields = changedFields.add("securityAllowDebuggingFeatures");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block external media.”</i>
         * 
         * @param storageBlockExternalMedia
         *            value of {@code storageBlockExternalMedia} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockExternalMedia(Boolean storageBlockExternalMedia) {
            this.storageBlockExternalMedia = storageBlockExternalMedia;
            this.changedFields = changedFields.add("storageBlockExternalMedia");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block USB file transfer.”</i>
         * 
         * @param storageBlockUsbFileTransfer
         *            value of {@code storageBlockUsbFileTransfer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockUsbFileTransfer(Boolean storageBlockUsbFileTransfer) {
            this.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
            this.changedFields = changedFields.add("storageBlockUsbFileTransfer");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from editing the wifi connection
         * settings.”</i>
         * 
         * @param wifiBlockEditConfigurations
         *            value of {@code wifiBlockEditConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiBlockEditConfigurations(Boolean wifiBlockEditConfigurations) {
            this.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
            this.changedFields = changedFields.add("wifiBlockEditConfigurations");
            return this;
        }

        public AospDeviceOwnerDeviceConfiguration build() {
            AospDeviceOwnerDeviceConfiguration _x = new AospDeviceOwnerDeviceConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.aospDeviceOwnerDeviceConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.appsBlockInstallFromUnknownSources = appsBlockInstallFromUnknownSources;
            _x.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
            _x.bluetoothBlocked = bluetoothBlocked;
            _x.cameraBlocked = cameraBlocked;
            _x.factoryResetBlocked = factoryResetBlocked;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
            _x.storageBlockExternalMedia = storageBlockExternalMedia;
            _x.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
            _x.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Indicates whether or not the user is allowed to enable unknown sources setting.
     * When set to true, user is not allowed to enable unknown sources settings.”</i>
     * 
     * @return property appsBlockInstallFromUnknownSources
     */
    @Property(name="appsBlockInstallFromUnknownSources")
    @JsonIgnore
    public Optional<Boolean> getAppsBlockInstallFromUnknownSources() {
        return Optional.ofNullable(appsBlockInstallFromUnknownSources);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsBlockInstallFromUnknownSources} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the user is allowed to enable unknown sources setting.
     * When set to true, user is not allowed to enable unknown sources settings.”</i>
     * 
     * @param appsBlockInstallFromUnknownSources
     *            new value of {@code appsBlockInstallFromUnknownSources} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsBlockInstallFromUnknownSources} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withAppsBlockInstallFromUnknownSources(Boolean appsBlockInstallFromUnknownSources) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsBlockInstallFromUnknownSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.appsBlockInstallFromUnknownSources = appsBlockInstallFromUnknownSources;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block a user from configuring bluetooth.”</i>
     * 
     * @return property bluetoothBlockConfiguration
     */
    @Property(name="bluetoothBlockConfiguration")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockConfiguration() {
        return Optional.ofNullable(bluetoothBlockConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockConfiguration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block a user from configuring bluetooth.”</i>
     * 
     * @param bluetoothBlockConfiguration
     *            new value of {@code bluetoothBlockConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockConfiguration} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withBluetoothBlockConfiguration(Boolean bluetoothBlockConfiguration) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the use of bluetooth. When set to true,
     * bluetooth cannot be enabled on the device.”</i>
     * 
     * @return property bluetoothBlocked
     */
    @Property(name="bluetoothBlocked")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlocked() {
        return Optional.ofNullable(bluetoothBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bluetoothBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the use of bluetooth. When set to true,
     * bluetooth cannot be enabled on the device.”</i>
     * 
     * @param bluetoothBlocked
     *            new value of {@code bluetoothBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlocked} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withBluetoothBlocked(Boolean bluetoothBlocked) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.bluetoothBlocked = bluetoothBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the use of the camera.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the use of the camera.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withCameraBlocked(Boolean cameraBlocked) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the factory reset option in settings is disabled.”</i>
     * 
     * @return property factoryResetBlocked
     */
    @Property(name="factoryResetBlocked")
    @JsonIgnore
    public Optional<Boolean> getFactoryResetBlocked() {
        return Optional.ofNullable(factoryResetBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * factoryResetBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the factory reset option in settings is disabled.”</i>
     * 
     * @param factoryResetBlocked
     *            new value of {@code factoryResetBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code factoryResetBlocked} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withFactoryResetBlocked(Boolean factoryResetBlocked) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("factoryResetBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.factoryResetBlocked = factoryResetBlocked;
        return _x;
    }

    /**
     * <i>“Indicates the minimum length of the password required on the device. Valid
     * values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum length of the password required on the device. Valid
     * values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Indicates the minimum password quality required on the device.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerRequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum password quality required on the device.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withPasswordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Indicates the number of times a user can enter an incorrect password before the
     * device is wiped. Valid values 4 to 11”</i>
     * 
     * @return property passwordSignInFailureCountBeforeFactoryReset
     */
    @Property(name="passwordSignInFailureCountBeforeFactoryReset")
    @JsonIgnore
    public Optional<Integer> getPasswordSignInFailureCountBeforeFactoryReset() {
        return Optional.ofNullable(passwordSignInFailureCountBeforeFactoryReset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordSignInFailureCountBeforeFactoryReset} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the number of times a user can enter an incorrect password before the
     * device is wiped. Valid values 4 to 11”</i>
     * 
     * @param passwordSignInFailureCountBeforeFactoryReset
     *            new value of {@code passwordSignInFailureCountBeforeFactoryReset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordSignInFailureCountBeforeFactoryReset} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withPasswordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the capability to take screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the capability to take screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from enabling debugging features on
     * the device.”</i>
     * 
     * @return property securityAllowDebuggingFeatures
     */
    @Property(name="securityAllowDebuggingFeatures")
    @JsonIgnore
    public Optional<Boolean> getSecurityAllowDebuggingFeatures() {
        return Optional.ofNullable(securityAllowDebuggingFeatures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityAllowDebuggingFeatures} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from enabling debugging features on
     * the device.”</i>
     * 
     * @param securityAllowDebuggingFeatures
     *            new value of {@code securityAllowDebuggingFeatures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityAllowDebuggingFeatures} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withSecurityAllowDebuggingFeatures(Boolean securityAllowDebuggingFeatures) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityAllowDebuggingFeatures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block external media.”</i>
     * 
     * @return property storageBlockExternalMedia
     */
    @Property(name="storageBlockExternalMedia")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockExternalMedia() {
        return Optional.ofNullable(storageBlockExternalMedia);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockExternalMedia} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block external media.”</i>
     * 
     * @param storageBlockExternalMedia
     *            new value of {@code storageBlockExternalMedia} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockExternalMedia} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withStorageBlockExternalMedia(Boolean storageBlockExternalMedia) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockExternalMedia");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.storageBlockExternalMedia = storageBlockExternalMedia;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block USB file transfer.”</i>
     * 
     * @return property storageBlockUsbFileTransfer
     */
    @Property(name="storageBlockUsbFileTransfer")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockUsbFileTransfer() {
        return Optional.ofNullable(storageBlockUsbFileTransfer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockUsbFileTransfer} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block USB file transfer.”</i>
     * 
     * @param storageBlockUsbFileTransfer
     *            new value of {@code storageBlockUsbFileTransfer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockUsbFileTransfer} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withStorageBlockUsbFileTransfer(Boolean storageBlockUsbFileTransfer) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockUsbFileTransfer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from editing the wifi connection
     * settings.”</i>
     * 
     * @return property wifiBlockEditConfigurations
     */
    @Property(name="wifiBlockEditConfigurations")
    @JsonIgnore
    public Optional<Boolean> getWifiBlockEditConfigurations() {
        return Optional.ofNullable(wifiBlockEditConfigurations);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wifiBlockEditConfigurations} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from editing the wifi connection
     * settings.”</i>
     * 
     * @param wifiBlockEditConfigurations
     *            new value of {@code wifiBlockEditConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiBlockEditConfigurations} field changed
     */
    public AospDeviceOwnerDeviceConfiguration withWifiBlockEditConfigurations(Boolean wifiBlockEditConfigurations) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiBlockEditConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerDeviceConfiguration");
        _x.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
        return _x;
    }

    public AospDeviceOwnerDeviceConfiguration withUnmappedField(String name, Object value) {
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AospDeviceOwnerDeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AospDeviceOwnerDeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AospDeviceOwnerDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AospDeviceOwnerDeviceConfiguration _copy() {
        AospDeviceOwnerDeviceConfiguration _x = new AospDeviceOwnerDeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.appsBlockInstallFromUnknownSources = appsBlockInstallFromUnknownSources;
        _x.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
        _x.bluetoothBlocked = bluetoothBlocked;
        _x.cameraBlocked = cameraBlocked;
        _x.factoryResetBlocked = factoryResetBlocked;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
        _x.storageBlockExternalMedia = storageBlockExternalMedia;
        _x.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
        _x.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AospDeviceOwnerDeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("appsBlockInstallFromUnknownSources=");
        b.append(this.appsBlockInstallFromUnknownSources);
        b.append(", ");
        b.append("bluetoothBlockConfiguration=");
        b.append(this.bluetoothBlockConfiguration);
        b.append(", ");
        b.append("bluetoothBlocked=");
        b.append(this.bluetoothBlocked);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("factoryResetBlocked=");
        b.append(this.factoryResetBlocked);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordSignInFailureCountBeforeFactoryReset=");
        b.append(this.passwordSignInFailureCountBeforeFactoryReset);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("securityAllowDebuggingFeatures=");
        b.append(this.securityAllowDebuggingFeatures);
        b.append(", ");
        b.append("storageBlockExternalMedia=");
        b.append(this.storageBlockExternalMedia);
        b.append(", ");
        b.append("storageBlockUsbFileTransfer=");
        b.append(this.storageBlockUsbFileTransfer);
        b.append(", ");
        b.append("wifiBlockEditConfigurations=");
        b.append(this.wifiBlockEditConfigurations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
