package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AndroidManagedStoreAppTrack;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for Android Managed Store Apps.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appIdentifier", 
    "appStoreUrl", 
    "appTracks", 
    "isPrivate", 
    "isSystemApp", 
    "packageId", 
    "supportsOemConfig", 
    "totalLicenseCount", 
    "usedLicenseCount"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreApp extends MobileApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreApp";
    }

    @JsonProperty("appIdentifier")
    protected String appIdentifier;

    @JsonProperty("appStoreUrl")
    protected String appStoreUrl;

    @JsonProperty("appTracks")
    protected List<AndroidManagedStoreAppTrack> appTracks;

    @JsonProperty("appTracks@nextLink")
    protected String appTracksNextLink;

    @JsonProperty("isPrivate")
    protected Boolean isPrivate;

    @JsonProperty("isSystemApp")
    protected Boolean isSystemApp;

    @JsonProperty("packageId")
    protected String packageId;

    @JsonProperty("supportsOemConfig")
    protected Boolean supportsOemConfig;

    @JsonProperty("totalLicenseCount")
    protected Integer totalLicenseCount;

    @JsonProperty("usedLicenseCount")
    protected Integer usedLicenseCount;

    protected AndroidManagedStoreApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedStoreApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private Integer dependentAppCount;
        private String description;
        private String developer;
        private String displayName;
        private String informationUrl;
        private Boolean isAssigned;
        private Boolean isFeatured;
        private MimeContent largeIcon;
        private OffsetDateTime lastModifiedDateTime;
        private String notes;
        private String owner;
        private String privacyInformationUrl;
        private String publisher;
        private MobileAppPublishingState publishingState;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer supersededAppCount;
        private Integer supersedingAppCount;
        private Integer uploadState;
        private List<MobileAppAssignment> assignments;
        private List<MobileAppInstallStatus> deviceStatuses;
        private MobileAppInstallSummary installSummary;
        private List<MobileAppRelationship> relationships;
        private List<UserAppInstallStatus> userStatuses;
        private String appIdentifier;
        private String appStoreUrl;
        private List<AndroidManagedStoreAppTrack> appTracks;
        private String appTracksNextLink;
        private Boolean isPrivate;
        private Boolean isSystemApp;
        private String packageId;
        private Boolean supportsOemConfig;
        private Integer totalLicenseCount;
        private Integer usedLicenseCount;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supersededAppCount(Integer supersededAppCount) {
            this.supersededAppCount = supersededAppCount;
            this.changedFields = changedFields.add("supersededAppCount");
            return this;
        }

        public Builder supersedingAppCount(Integer supersedingAppCount) {
            this.supersedingAppCount = supersedingAppCount;
            this.changedFields = changedFields.add("supersedingAppCount");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder assignments(List<MobileAppAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(MobileAppAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<MobileAppInstallStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(MobileAppInstallStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder installSummary(MobileAppInstallSummary installSummary) {
            this.installSummary = installSummary;
            this.changedFields = changedFields.add("installSummary");
            return this;
        }

        public Builder relationships(List<MobileAppRelationship> relationships) {
            this.relationships = relationships;
            this.changedFields = changedFields.add("relationships");
            return this;
        }

        public Builder relationships(MobileAppRelationship... relationships) {
            return relationships(Arrays.asList(relationships));
        }

        public Builder userStatuses(List<UserAppInstallStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(UserAppInstallStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        /**
         * <i>“The Identity Name.”</i>
         * 
         * @param appIdentifier
         *            value of {@code appIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appIdentifier(String appIdentifier) {
            this.appIdentifier = appIdentifier;
            this.changedFields = changedFields.add("appIdentifier");
            return this;
        }

        /**
         * <i>“The Play for Work Store app URL.”</i>
         * 
         * @param appStoreUrl
         *            value of {@code appStoreUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            this.changedFields = changedFields.add("appStoreUrl");
            return this;
        }

        /**
         * <i>“The tracks that are visible to this enterprise.”</i>
         * 
         * @param appTracks
         *            value of {@code appTracks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appTracks(List<AndroidManagedStoreAppTrack> appTracks) {
            this.appTracks = appTracks;
            this.changedFields = changedFields.add("appTracks");
            return this;
        }

        /**
         * <i>“The tracks that are visible to this enterprise.”</i>
         * 
         * @param appTracks
         *            value of {@code appTracks} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appTracks(AndroidManagedStoreAppTrack... appTracks) {
            return appTracks(Arrays.asList(appTracks));
        }

        /**
         * <i>“The tracks that are visible to this enterprise.”</i>
         * 
         * @param appTracksNextLink
         *            value of {@code appTracks@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appTracksNextLink(String appTracksNextLink) {
            this.appTracksNextLink = appTracksNextLink;
            this.changedFields = changedFields.add("appTracks");
            return this;
        }

        /**
         * <i>“Indicates whether the app is only available to a given enterprise's users.”</i>
         * 
         * @param isPrivate
         *            value of {@code isPrivate} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = changedFields.add("isPrivate");
            return this;
        }

        /**
         * <i>“Indicates whether the app is a preinstalled system app.”</i>
         * 
         * @param isSystemApp
         *            value of {@code isSystemApp} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSystemApp(Boolean isSystemApp) {
            this.isSystemApp = isSystemApp;
            this.changedFields = changedFields.add("isSystemApp");
            return this;
        }

        /**
         * <i>“The package identifier.”</i>
         * 
         * @param packageId
         *            value of {@code packageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageId(String packageId) {
            this.packageId = packageId;
            this.changedFields = changedFields.add("packageId");
            return this;
        }

        /**
         * <i>“Whether this app supports OEMConfig policy.”</i>
         * 
         * @param supportsOemConfig
         *            value of {@code supportsOemConfig} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder supportsOemConfig(Boolean supportsOemConfig) {
            this.supportsOemConfig = supportsOemConfig;
            this.changedFields = changedFields.add("supportsOemConfig");
            return this;
        }

        /**
         * <i>“The total number of VPP licenses.”</i>
         * 
         * @param totalLicenseCount
         *            value of {@code totalLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        /**
         * <i>“The number of VPP licenses in use.”</i>
         * 
         * @param usedLicenseCount
         *            value of {@code usedLicenseCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        public AndroidManagedStoreApp build() {
            AndroidManagedStoreApp _x = new AndroidManagedStoreApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidManagedStoreApp";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.dependentAppCount = dependentAppCount;
            _x.description = description;
            _x.developer = developer;
            _x.displayName = displayName;
            _x.informationUrl = informationUrl;
            _x.isAssigned = isAssigned;
            _x.isFeatured = isFeatured;
            _x.largeIcon = largeIcon;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.notes = notes;
            _x.owner = owner;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.publisher = publisher;
            _x.publishingState = publishingState;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supersededAppCount = supersededAppCount;
            _x.supersedingAppCount = supersedingAppCount;
            _x.uploadState = uploadState;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.installSummary = installSummary;
            _x.relationships = relationships;
            _x.userStatuses = userStatuses;
            _x.appIdentifier = appIdentifier;
            _x.appStoreUrl = appStoreUrl;
            _x.appTracks = appTracks;
            _x.appTracksNextLink = appTracksNextLink;
            _x.isPrivate = isPrivate;
            _x.isSystemApp = isSystemApp;
            _x.packageId = packageId;
            _x.supportsOemConfig = supportsOemConfig;
            _x.totalLicenseCount = totalLicenseCount;
            _x.usedLicenseCount = usedLicenseCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The Identity Name.”</i>
     * 
     * @return property appIdentifier
     */
    @Property(name="appIdentifier")
    @JsonIgnore
    public Optional<String> getAppIdentifier() {
        return Optional.ofNullable(appIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Identity Name.”</i>
     * 
     * @param appIdentifier
     *            new value of {@code appIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appIdentifier} field changed
     */
    public AndroidManagedStoreApp withAppIdentifier(String appIdentifier) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("appIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.appIdentifier = appIdentifier;
        return _x;
    }

    /**
     * <i>“The Play for Work Store app URL.”</i>
     * 
     * @return property appStoreUrl
     */
    @Property(name="appStoreUrl")
    @JsonIgnore
    public Optional<String> getAppStoreUrl() {
        return Optional.ofNullable(appStoreUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appStoreUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Play for Work Store app URL.”</i>
     * 
     * @param appStoreUrl
     *            new value of {@code appStoreUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appStoreUrl} field changed
     */
    public AndroidManagedStoreApp withAppStoreUrl(String appStoreUrl) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("appStoreUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.appStoreUrl = appStoreUrl;
        return _x;
    }

    /**
     * <i>“The tracks that are visible to this enterprise.”</i>
     * 
     * @return property appTracks
     */
    @Property(name="appTracks")
    @JsonIgnore
    public CollectionPage<AndroidManagedStoreAppTrack> getAppTracks() {
        return new CollectionPage<AndroidManagedStoreAppTrack>(contextPath, AndroidManagedStoreAppTrack.class, this.appTracks, Optional.ofNullable(appTracksNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appTracks} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The tracks that are visible to this enterprise.”</i>
     * 
     * @param appTracks
     *            new value of {@code appTracks} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appTracks} field changed
     */
    public AndroidManagedStoreApp withAppTracks(List<AndroidManagedStoreAppTrack> appTracks) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("appTracks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.appTracks = appTracks;
        return _x;
    }

    /**
     * <i>“The tracks that are visible to this enterprise.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appTracks
     */
    @Property(name="appTracks")
    @JsonIgnore
    public CollectionPage<AndroidManagedStoreAppTrack> getAppTracks(HttpRequestOptions options) {
        return new CollectionPage<AndroidManagedStoreAppTrack>(contextPath, AndroidManagedStoreAppTrack.class, this.appTracks, Optional.ofNullable(appTracksNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether the app is only available to a given enterprise's users.”</i>
     * 
     * @return property isPrivate
     */
    @Property(name="isPrivate")
    @JsonIgnore
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(isPrivate);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isPrivate} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether the app is only available to a given enterprise's users.”</i>
     * 
     * @param isPrivate
     *            new value of {@code isPrivate} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isPrivate} field changed
     */
    public AndroidManagedStoreApp withIsPrivate(Boolean isPrivate) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("isPrivate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.isPrivate = isPrivate;
        return _x;
    }

    /**
     * <i>“Indicates whether the app is a preinstalled system app.”</i>
     * 
     * @return property isSystemApp
     */
    @Property(name="isSystemApp")
    @JsonIgnore
    public Optional<Boolean> getIsSystemApp() {
        return Optional.ofNullable(isSystemApp);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSystemApp}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether the app is a preinstalled system app.”</i>
     * 
     * @param isSystemApp
     *            new value of {@code isSystemApp} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSystemApp} field changed
     */
    public AndroidManagedStoreApp withIsSystemApp(Boolean isSystemApp) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("isSystemApp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.isSystemApp = isSystemApp;
        return _x;
    }

    /**
     * <i>“The package identifier.”</i>
     * 
     * @return property packageId
     */
    @Property(name="packageId")
    @JsonIgnore
    public Optional<String> getPackageId() {
        return Optional.ofNullable(packageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code packageId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The package identifier.”</i>
     * 
     * @param packageId
     *            new value of {@code packageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageId} field changed
     */
    public AndroidManagedStoreApp withPackageId(String packageId) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("packageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.packageId = packageId;
        return _x;
    }

    /**
     * <i>“Whether this app supports OEMConfig policy.”</i>
     * 
     * @return property supportsOemConfig
     */
    @Property(name="supportsOemConfig")
    @JsonIgnore
    public Optional<Boolean> getSupportsOemConfig() {
        return Optional.ofNullable(supportsOemConfig);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code supportsOemConfig
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether this app supports OEMConfig policy.”</i>
     * 
     * @param supportsOemConfig
     *            new value of {@code supportsOemConfig} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code supportsOemConfig} field changed
     */
    public AndroidManagedStoreApp withSupportsOemConfig(Boolean supportsOemConfig) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("supportsOemConfig");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.supportsOemConfig = supportsOemConfig;
        return _x;
    }

    /**
     * <i>“The total number of VPP licenses.”</i>
     * 
     * @return property totalLicenseCount
     */
    @Property(name="totalLicenseCount")
    @JsonIgnore
    public Optional<Integer> getTotalLicenseCount() {
        return Optional.ofNullable(totalLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalLicenseCount
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The total number of VPP licenses.”</i>
     * 
     * @param totalLicenseCount
     *            new value of {@code totalLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalLicenseCount} field changed
     */
    public AndroidManagedStoreApp withTotalLicenseCount(Integer totalLicenseCount) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("totalLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.totalLicenseCount = totalLicenseCount;
        return _x;
    }

    /**
     * <i>“The number of VPP licenses in use.”</i>
     * 
     * @return property usedLicenseCount
     */
    @Property(name="usedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getUsedLicenseCount() {
        return Optional.ofNullable(usedLicenseCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usedLicenseCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of VPP licenses in use.”</i>
     * 
     * @param usedLicenseCount
     *            new value of {@code usedLicenseCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usedLicenseCount} field changed
     */
    public AndroidManagedStoreApp withUsedLicenseCount(Integer usedLicenseCount) {
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = changedFields.add("usedLicenseCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreApp");
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    public AndroidManagedStoreApp withUnmappedField(String name, Object value) {
        AndroidManagedStoreApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidManagedStoreApp _copy() {
        AndroidManagedStoreApp _x = new AndroidManagedStoreApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.dependentAppCount = dependentAppCount;
        _x.description = description;
        _x.developer = developer;
        _x.displayName = displayName;
        _x.informationUrl = informationUrl;
        _x.isAssigned = isAssigned;
        _x.isFeatured = isFeatured;
        _x.largeIcon = largeIcon;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.notes = notes;
        _x.owner = owner;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.publisher = publisher;
        _x.publishingState = publishingState;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supersededAppCount = supersededAppCount;
        _x.supersedingAppCount = supersedingAppCount;
        _x.uploadState = uploadState;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.installSummary = installSummary;
        _x.relationships = relationships;
        _x.userStatuses = userStatuses;
        _x.appIdentifier = appIdentifier;
        _x.appStoreUrl = appStoreUrl;
        _x.appTracks = appTracks;
        _x.isPrivate = isPrivate;
        _x.isSystemApp = isSystemApp;
        _x.packageId = packageId;
        _x.supportsOemConfig = supportsOemConfig;
        _x.totalLicenseCount = totalLicenseCount;
        _x.usedLicenseCount = usedLicenseCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supersededAppCount=");
        b.append(this.supersededAppCount);
        b.append(", ");
        b.append("supersedingAppCount=");
        b.append(this.supersedingAppCount);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("installSummary=");
        b.append(this.installSummary);
        b.append(", ");
        b.append("relationships=");
        b.append(this.relationships);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("appIdentifier=");
        b.append(this.appIdentifier);
        b.append(", ");
        b.append("appStoreUrl=");
        b.append(this.appStoreUrl);
        b.append(", ");
        b.append("appTracks=");
        b.append(this.appTracks);
        b.append(", ");
        b.append("isPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("isSystemApp=");
        b.append(this.isSystemApp);
        b.append(", ");
        b.append("packageId=");
        b.append(this.packageId);
        b.append(", ");
        b.append("supportsOemConfig=");
        b.append(this.supportsOemConfig);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
