package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyDeploymentSummaryRequest;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetAppsVerificationType;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetDeviceAttestationType;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetEvaluationType;
import odata.msgraph.client.beta.enums.AppManagementLevel;
import odata.msgraph.client.beta.enums.ManagedAppClipboardSharingLevel;
import odata.msgraph.client.beta.enums.ManagedAppDataIngestionLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataStorageLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataTransferLevel;
import odata.msgraph.client.beta.enums.ManagedAppDeviceThreatLevel;
import odata.msgraph.client.beta.enums.ManagedAppNotificationRestriction;
import odata.msgraph.client.beta.enums.ManagedAppPhoneNumberRedirectLevel;
import odata.msgraph.client.beta.enums.ManagedAppPinCharacterSet;
import odata.msgraph.client.beta.enums.ManagedAppRemediationAction;
import odata.msgraph.client.beta.enums.ManagedBrowserType;
import odata.msgraph.client.beta.enums.TargetedManagedAppGroupType;


/**
 * <i>“Policy used to configure detailed management settings targeted to specific
 * security groups and for a specified set of apps on an Android device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedAndroidDeviceManufacturers", 
    "allowedAndroidDeviceModels", 
    "appActionIfAndroidDeviceManufacturerNotAllowed", 
    "appActionIfAndroidDeviceModelNotAllowed", 
    "appActionIfAndroidSafetyNetAppsVerificationFailed", 
    "appActionIfAndroidSafetyNetDeviceAttestationFailed", 
    "appActionIfDeviceLockNotSet", 
    "approvedKeyboards", 
    "biometricAuthenticationBlocked", 
    "blockAfterCompanyPortalUpdateDeferralInDays", 
    "connectToVpnOnLaunch", 
    "customBrowserDisplayName", 
    "customBrowserPackageId", 
    "customDialerAppDisplayName", 
    "customDialerAppPackageId", 
    "deployedAppCount", 
    "deviceLockRequired", 
    "disableAppEncryptionIfDeviceEncryptionIsEnabled", 
    "encryptAppData", 
    "exemptedAppPackages", 
    "keyboardsRestricted", 
    "minimumRequiredCompanyPortalVersion", 
    "minimumRequiredPatchVersion", 
    "minimumWarningCompanyPortalVersion", 
    "minimumWarningPatchVersion", 
    "minimumWipeCompanyPortalVersion", 
    "minimumWipePatchVersion", 
    "requiredAndroidSafetyNetAppsVerificationType", 
    "requiredAndroidSafetyNetDeviceAttestationType", 
    "requiredAndroidSafetyNetEvaluationType", 
    "screenCaptureBlocked", 
    "warnAfterCompanyPortalUpdateDeferralInDays", 
    "wipeAfterCompanyPortalUpdateDeferralInDays", 
    "apps", 
    "deploymentSummary"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedAppProtection extends TargetedManagedAppProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedAppProtection";
    }

    @JsonProperty("allowedAndroidDeviceManufacturers")
    protected String allowedAndroidDeviceManufacturers;

    @JsonProperty("allowedAndroidDeviceModels")
    protected List<String> allowedAndroidDeviceModels;

    @JsonProperty("allowedAndroidDeviceModels@nextLink")
    protected String allowedAndroidDeviceModelsNextLink;

    @JsonProperty("appActionIfAndroidDeviceManufacturerNotAllowed")
    protected ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed;

    @JsonProperty("appActionIfAndroidDeviceModelNotAllowed")
    protected ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed;

    @JsonProperty("appActionIfAndroidSafetyNetAppsVerificationFailed")
    protected ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed;

    @JsonProperty("appActionIfAndroidSafetyNetDeviceAttestationFailed")
    protected ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed;

    @JsonProperty("appActionIfDeviceLockNotSet")
    protected ManagedAppRemediationAction appActionIfDeviceLockNotSet;

    @JsonProperty("approvedKeyboards")
    protected List<KeyValuePair> approvedKeyboards;

    @JsonProperty("approvedKeyboards@nextLink")
    protected String approvedKeyboardsNextLink;

    @JsonProperty("biometricAuthenticationBlocked")
    protected Boolean biometricAuthenticationBlocked;

    @JsonProperty("blockAfterCompanyPortalUpdateDeferralInDays")
    protected Integer blockAfterCompanyPortalUpdateDeferralInDays;

    @JsonProperty("connectToVpnOnLaunch")
    protected Boolean connectToVpnOnLaunch;

    @JsonProperty("customBrowserDisplayName")
    protected String customBrowserDisplayName;

    @JsonProperty("customBrowserPackageId")
    protected String customBrowserPackageId;

    @JsonProperty("customDialerAppDisplayName")
    protected String customDialerAppDisplayName;

    @JsonProperty("customDialerAppPackageId")
    protected String customDialerAppPackageId;

    @JsonProperty("deployedAppCount")
    protected Integer deployedAppCount;

    @JsonProperty("deviceLockRequired")
    protected Boolean deviceLockRequired;

    @JsonProperty("disableAppEncryptionIfDeviceEncryptionIsEnabled")
    protected Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;

    @JsonProperty("encryptAppData")
    protected Boolean encryptAppData;

    @JsonProperty("exemptedAppPackages")
    protected List<KeyValuePair> exemptedAppPackages;

    @JsonProperty("exemptedAppPackages@nextLink")
    protected String exemptedAppPackagesNextLink;

    @JsonProperty("keyboardsRestricted")
    protected Boolean keyboardsRestricted;

    @JsonProperty("minimumRequiredCompanyPortalVersion")
    protected String minimumRequiredCompanyPortalVersion;

    @JsonProperty("minimumRequiredPatchVersion")
    protected String minimumRequiredPatchVersion;

    @JsonProperty("minimumWarningCompanyPortalVersion")
    protected String minimumWarningCompanyPortalVersion;

    @JsonProperty("minimumWarningPatchVersion")
    protected String minimumWarningPatchVersion;

    @JsonProperty("minimumWipeCompanyPortalVersion")
    protected String minimumWipeCompanyPortalVersion;

    @JsonProperty("minimumWipePatchVersion")
    protected String minimumWipePatchVersion;

    @JsonProperty("requiredAndroidSafetyNetAppsVerificationType")
    protected AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType;

    @JsonProperty("requiredAndroidSafetyNetDeviceAttestationType")
    protected AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType;

    @JsonProperty("requiredAndroidSafetyNetEvaluationType")
    protected AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("warnAfterCompanyPortalUpdateDeferralInDays")
    protected Integer warnAfterCompanyPortalUpdateDeferralInDays;

    @JsonProperty("wipeAfterCompanyPortalUpdateDeferralInDays")
    protected Integer wipeAfterCompanyPortalUpdateDeferralInDays;

    @JsonProperty("apps")
    protected List<ManagedMobileApp> apps;

    @JsonProperty("deploymentSummary")
    protected ManagedAppPolicyDeploymentSummary deploymentSummary;

    protected AndroidManagedAppProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedAppProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations;
        private String allowedDataIngestionLocationsNextLink;
        private List<ManagedAppDataStorageLocation> allowedDataStorageLocations;
        private String allowedDataStorageLocationsNextLink;
        private ManagedAppDataTransferLevel allowedInboundDataTransferSources;
        private Integer allowedOutboundClipboardSharingExceptionLength;
        private ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel;
        private ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations;
        private ManagedAppRemediationAction appActionIfDeviceComplianceRequired;
        private ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded;
        private ManagedAppRemediationAction appActionIfUnableToAuthenticateUser;
        private Boolean blockDataIngestionIntoOrganizationDocuments;
        private Boolean contactSyncBlocked;
        private Boolean dataBackupBlocked;
        private Boolean deviceComplianceRequired;
        private ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel;
        private Boolean disableAppPinIfDevicePinIsSet;
        private Boolean fingerprintBlocked;
        private Duration gracePeriodToBlockAppsDuringOffClockHours;
        private ManagedBrowserType managedBrowser;
        private Boolean managedBrowserToOpenLinksRequired;
        private ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel;
        private Integer maximumPinRetries;
        private String maximumRequiredOsVersion;
        private String maximumWarningOsVersion;
        private String maximumWipeOsVersion;
        private Integer minimumPinLength;
        private String minimumRequiredAppVersion;
        private String minimumRequiredOsVersion;
        private String minimumWarningAppVersion;
        private String minimumWarningOsVersion;
        private String minimumWipeAppVersion;
        private String minimumWipeOsVersion;
        private ManagedAppRemediationAction mobileThreatDefenseRemediationAction;
        private ManagedAppNotificationRestriction notificationRestriction;
        private Boolean organizationalCredentialsRequired;
        private Duration periodBeforePinReset;
        private Duration periodOfflineBeforeAccessCheck;
        private Duration periodOfflineBeforeWipeIsEnforced;
        private Duration periodOnlineBeforeAccessCheck;
        private ManagedAppPinCharacterSet pinCharacterSet;
        private Boolean pinRequired;
        private Duration pinRequiredInsteadOfBiometricTimeout;
        private Integer previousPinBlockCount;
        private Boolean printBlocked;
        private Boolean saveAsBlocked;
        private Boolean simplePinBlocked;
        private TargetedManagedAppGroupType appGroupType;
        private Boolean isAssigned;
        private AppManagementLevel targetedAppManagementLevels;
        private List<TargetedManagedAppPolicyAssignment> assignments;
        private String allowedAndroidDeviceManufacturers;
        private List<String> allowedAndroidDeviceModels;
        private String allowedAndroidDeviceModelsNextLink;
        private ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed;
        private ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed;
        private ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed;
        private ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed;
        private ManagedAppRemediationAction appActionIfDeviceLockNotSet;
        private List<KeyValuePair> approvedKeyboards;
        private String approvedKeyboardsNextLink;
        private Boolean biometricAuthenticationBlocked;
        private Integer blockAfterCompanyPortalUpdateDeferralInDays;
        private Boolean connectToVpnOnLaunch;
        private String customBrowserDisplayName;
        private String customBrowserPackageId;
        private String customDialerAppDisplayName;
        private String customDialerAppPackageId;
        private Integer deployedAppCount;
        private Boolean deviceLockRequired;
        private Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;
        private Boolean encryptAppData;
        private List<KeyValuePair> exemptedAppPackages;
        private String exemptedAppPackagesNextLink;
        private Boolean keyboardsRestricted;
        private String minimumRequiredCompanyPortalVersion;
        private String minimumRequiredPatchVersion;
        private String minimumWarningCompanyPortalVersion;
        private String minimumWarningPatchVersion;
        private String minimumWipeCompanyPortalVersion;
        private String minimumWipePatchVersion;
        private AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType;
        private AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType;
        private AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType;
        private Boolean screenCaptureBlocked;
        private Integer warnAfterCompanyPortalUpdateDeferralInDays;
        private Integer wipeAfterCompanyPortalUpdateDeferralInDays;
        private List<ManagedMobileApp> apps;
        private ManagedAppPolicyDeploymentSummary deploymentSummary;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder allowedDataIngestionLocations(List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations) {
            this.allowedDataIngestionLocations = allowedDataIngestionLocations;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder allowedDataIngestionLocations(ManagedAppDataIngestionLocation... allowedDataIngestionLocations) {
            return allowedDataIngestionLocations(Arrays.asList(allowedDataIngestionLocations));
        }

        public Builder allowedDataIngestionLocationsNextLink(String allowedDataIngestionLocationsNextLink) {
            this.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder allowedDataStorageLocations(List<ManagedAppDataStorageLocation> allowedDataStorageLocations) {
            this.allowedDataStorageLocations = allowedDataStorageLocations;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder allowedDataStorageLocations(ManagedAppDataStorageLocation... allowedDataStorageLocations) {
            return allowedDataStorageLocations(Arrays.asList(allowedDataStorageLocations));
        }

        public Builder allowedDataStorageLocationsNextLink(String allowedDataStorageLocationsNextLink) {
            this.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder allowedInboundDataTransferSources(ManagedAppDataTransferLevel allowedInboundDataTransferSources) {
            this.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            this.changedFields = changedFields.add("allowedInboundDataTransferSources");
            return this;
        }

        public Builder allowedOutboundClipboardSharingExceptionLength(Integer allowedOutboundClipboardSharingExceptionLength) {
            this.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingExceptionLength");
            return this;
        }

        public Builder allowedOutboundClipboardSharingLevel(ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel) {
            this.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingLevel");
            return this;
        }

        public Builder allowedOutboundDataTransferDestinations(ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations) {
            this.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            this.changedFields = changedFields.add("allowedOutboundDataTransferDestinations");
            return this;
        }

        public Builder appActionIfDeviceComplianceRequired(ManagedAppRemediationAction appActionIfDeviceComplianceRequired) {
            this.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            this.changedFields = changedFields.add("appActionIfDeviceComplianceRequired");
            return this;
        }

        public Builder appActionIfMaximumPinRetriesExceeded(ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded) {
            this.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            this.changedFields = changedFields.add("appActionIfMaximumPinRetriesExceeded");
            return this;
        }

        public Builder appActionIfUnableToAuthenticateUser(ManagedAppRemediationAction appActionIfUnableToAuthenticateUser) {
            this.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            this.changedFields = changedFields.add("appActionIfUnableToAuthenticateUser");
            return this;
        }

        public Builder blockDataIngestionIntoOrganizationDocuments(Boolean blockDataIngestionIntoOrganizationDocuments) {
            this.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            this.changedFields = changedFields.add("blockDataIngestionIntoOrganizationDocuments");
            return this;
        }

        public Builder contactSyncBlocked(Boolean contactSyncBlocked) {
            this.contactSyncBlocked = contactSyncBlocked;
            this.changedFields = changedFields.add("contactSyncBlocked");
            return this;
        }

        public Builder dataBackupBlocked(Boolean dataBackupBlocked) {
            this.dataBackupBlocked = dataBackupBlocked;
            this.changedFields = changedFields.add("dataBackupBlocked");
            return this;
        }

        public Builder deviceComplianceRequired(Boolean deviceComplianceRequired) {
            this.deviceComplianceRequired = deviceComplianceRequired;
            this.changedFields = changedFields.add("deviceComplianceRequired");
            return this;
        }

        public Builder dialerRestrictionLevel(ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel) {
            this.dialerRestrictionLevel = dialerRestrictionLevel;
            this.changedFields = changedFields.add("dialerRestrictionLevel");
            return this;
        }

        public Builder disableAppPinIfDevicePinIsSet(Boolean disableAppPinIfDevicePinIsSet) {
            this.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            this.changedFields = changedFields.add("disableAppPinIfDevicePinIsSet");
            return this;
        }

        public Builder fingerprintBlocked(Boolean fingerprintBlocked) {
            this.fingerprintBlocked = fingerprintBlocked;
            this.changedFields = changedFields.add("fingerprintBlocked");
            return this;
        }

        public Builder gracePeriodToBlockAppsDuringOffClockHours(Duration gracePeriodToBlockAppsDuringOffClockHours) {
            this.gracePeriodToBlockAppsDuringOffClockHours = gracePeriodToBlockAppsDuringOffClockHours;
            this.changedFields = changedFields.add("gracePeriodToBlockAppsDuringOffClockHours");
            return this;
        }

        public Builder managedBrowser(ManagedBrowserType managedBrowser) {
            this.managedBrowser = managedBrowser;
            this.changedFields = changedFields.add("managedBrowser");
            return this;
        }

        public Builder managedBrowserToOpenLinksRequired(Boolean managedBrowserToOpenLinksRequired) {
            this.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            this.changedFields = changedFields.add("managedBrowserToOpenLinksRequired");
            return this;
        }

        public Builder maximumAllowedDeviceThreatLevel(ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel) {
            this.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            this.changedFields = changedFields.add("maximumAllowedDeviceThreatLevel");
            return this;
        }

        public Builder maximumPinRetries(Integer maximumPinRetries) {
            this.maximumPinRetries = maximumPinRetries;
            this.changedFields = changedFields.add("maximumPinRetries");
            return this;
        }

        public Builder maximumRequiredOsVersion(String maximumRequiredOsVersion) {
            this.maximumRequiredOsVersion = maximumRequiredOsVersion;
            this.changedFields = changedFields.add("maximumRequiredOsVersion");
            return this;
        }

        public Builder maximumWarningOsVersion(String maximumWarningOsVersion) {
            this.maximumWarningOsVersion = maximumWarningOsVersion;
            this.changedFields = changedFields.add("maximumWarningOsVersion");
            return this;
        }

        public Builder maximumWipeOsVersion(String maximumWipeOsVersion) {
            this.maximumWipeOsVersion = maximumWipeOsVersion;
            this.changedFields = changedFields.add("maximumWipeOsVersion");
            return this;
        }

        public Builder minimumPinLength(Integer minimumPinLength) {
            this.minimumPinLength = minimumPinLength;
            this.changedFields = changedFields.add("minimumPinLength");
            return this;
        }

        public Builder minimumRequiredAppVersion(String minimumRequiredAppVersion) {
            this.minimumRequiredAppVersion = minimumRequiredAppVersion;
            this.changedFields = changedFields.add("minimumRequiredAppVersion");
            return this;
        }

        public Builder minimumRequiredOsVersion(String minimumRequiredOsVersion) {
            this.minimumRequiredOsVersion = minimumRequiredOsVersion;
            this.changedFields = changedFields.add("minimumRequiredOsVersion");
            return this;
        }

        public Builder minimumWarningAppVersion(String minimumWarningAppVersion) {
            this.minimumWarningAppVersion = minimumWarningAppVersion;
            this.changedFields = changedFields.add("minimumWarningAppVersion");
            return this;
        }

        public Builder minimumWarningOsVersion(String minimumWarningOsVersion) {
            this.minimumWarningOsVersion = minimumWarningOsVersion;
            this.changedFields = changedFields.add("minimumWarningOsVersion");
            return this;
        }

        public Builder minimumWipeAppVersion(String minimumWipeAppVersion) {
            this.minimumWipeAppVersion = minimumWipeAppVersion;
            this.changedFields = changedFields.add("minimumWipeAppVersion");
            return this;
        }

        public Builder minimumWipeOsVersion(String minimumWipeOsVersion) {
            this.minimumWipeOsVersion = minimumWipeOsVersion;
            this.changedFields = changedFields.add("minimumWipeOsVersion");
            return this;
        }

        public Builder mobileThreatDefenseRemediationAction(ManagedAppRemediationAction mobileThreatDefenseRemediationAction) {
            this.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            this.changedFields = changedFields.add("mobileThreatDefenseRemediationAction");
            return this;
        }

        public Builder notificationRestriction(ManagedAppNotificationRestriction notificationRestriction) {
            this.notificationRestriction = notificationRestriction;
            this.changedFields = changedFields.add("notificationRestriction");
            return this;
        }

        public Builder organizationalCredentialsRequired(Boolean organizationalCredentialsRequired) {
            this.organizationalCredentialsRequired = organizationalCredentialsRequired;
            this.changedFields = changedFields.add("organizationalCredentialsRequired");
            return this;
        }

        public Builder periodBeforePinReset(Duration periodBeforePinReset) {
            this.periodBeforePinReset = periodBeforePinReset;
            this.changedFields = changedFields.add("periodBeforePinReset");
            return this;
        }

        public Builder periodOfflineBeforeAccessCheck(Duration periodOfflineBeforeAccessCheck) {
            this.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOfflineBeforeAccessCheck");
            return this;
        }

        public Builder periodOfflineBeforeWipeIsEnforced(Duration periodOfflineBeforeWipeIsEnforced) {
            this.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            this.changedFields = changedFields.add("periodOfflineBeforeWipeIsEnforced");
            return this;
        }

        public Builder periodOnlineBeforeAccessCheck(Duration periodOnlineBeforeAccessCheck) {
            this.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOnlineBeforeAccessCheck");
            return this;
        }

        public Builder pinCharacterSet(ManagedAppPinCharacterSet pinCharacterSet) {
            this.pinCharacterSet = pinCharacterSet;
            this.changedFields = changedFields.add("pinCharacterSet");
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = pinRequired;
            this.changedFields = changedFields.add("pinRequired");
            return this;
        }

        public Builder pinRequiredInsteadOfBiometricTimeout(Duration pinRequiredInsteadOfBiometricTimeout) {
            this.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            this.changedFields = changedFields.add("pinRequiredInsteadOfBiometricTimeout");
            return this;
        }

        public Builder previousPinBlockCount(Integer previousPinBlockCount) {
            this.previousPinBlockCount = previousPinBlockCount;
            this.changedFields = changedFields.add("previousPinBlockCount");
            return this;
        }

        public Builder printBlocked(Boolean printBlocked) {
            this.printBlocked = printBlocked;
            this.changedFields = changedFields.add("printBlocked");
            return this;
        }

        public Builder saveAsBlocked(Boolean saveAsBlocked) {
            this.saveAsBlocked = saveAsBlocked;
            this.changedFields = changedFields.add("saveAsBlocked");
            return this;
        }

        public Builder simplePinBlocked(Boolean simplePinBlocked) {
            this.simplePinBlocked = simplePinBlocked;
            this.changedFields = changedFields.add("simplePinBlocked");
            return this;
        }

        public Builder appGroupType(TargetedManagedAppGroupType appGroupType) {
            this.appGroupType = appGroupType;
            this.changedFields = changedFields.add("appGroupType");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder targetedAppManagementLevels(AppManagementLevel targetedAppManagementLevels) {
            this.targetedAppManagementLevels = targetedAppManagementLevels;
            this.changedFields = changedFields.add("targetedAppManagementLevels");
            return this;
        }

        public Builder assignments(List<TargetedManagedAppPolicyAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(TargetedManagedAppPolicyAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
         * managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceManufacturers
         *            value of {@code allowedAndroidDeviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceManufacturers(String allowedAndroidDeviceManufacturers) {
            this.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
            this.changedFields = changedFields.add("allowedAndroidDeviceManufacturers");
            return this;
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceModels
         *            value of {@code allowedAndroidDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModels(List<String> allowedAndroidDeviceModels) {
            this.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
            this.changedFields = changedFields.add("allowedAndroidDeviceModels");
            return this;
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceModels
         *            value of {@code allowedAndroidDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModels(String... allowedAndroidDeviceModels) {
            return allowedAndroidDeviceModels(Arrays.asList(allowedAndroidDeviceModels));
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceModelsNextLink
         *            value of {@code allowedAndroidDeviceModels@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModelsNextLink(String allowedAndroidDeviceModelsNextLink) {
            this.allowedAndroidDeviceModelsNextLink = allowedAndroidDeviceModelsNextLink;
            this.changedFields = changedFields.add("allowedAndroidDeviceModels");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * manufacturer is not allowed.”</i>
         * 
         * @param appActionIfAndroidDeviceManufacturerNotAllowed
         *            value of {@code appActionIfAndroidDeviceManufacturerNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidDeviceManufacturerNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed) {
            this.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
            this.changedFields = changedFields.add("appActionIfAndroidDeviceManufacturerNotAllowed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * model is not allowed.”</i>
         * 
         * @param appActionIfAndroidDeviceModelNotAllowed
         *            value of {@code appActionIfAndroidDeviceModelNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed) {
            this.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
            this.changedFields = changedFields.add("appActionIfAndroidDeviceModelNotAllowed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn or block, if the specified Android
         * App Verification requirement fails.”</i>
         * 
         * @param appActionIfAndroidSafetyNetAppsVerificationFailed
         *            value of {@code appActionIfAndroidSafetyNetAppsVerificationFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidSafetyNetAppsVerificationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed) {
            this.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
            this.changedFields = changedFields.add("appActionIfAndroidSafetyNetAppsVerificationFailed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn or block, if the specified Android
         * SafetyNet Attestation requirement fails.”</i>
         * 
         * @param appActionIfAndroidSafetyNetDeviceAttestationFailed
         *            value of {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidSafetyNetDeviceAttestationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed) {
            this.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
            this.changedFields = changedFields.add("appActionIfAndroidSafetyNetDeviceAttestationFailed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn, block or wipe, if the screen lock
         * is required on android device but is not set.”</i>
         * 
         * @param appActionIfDeviceLockNotSet
         *            value of {@code appActionIfDeviceLockNotSet} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfDeviceLockNotSet(ManagedAppRemediationAction appActionIfDeviceLockNotSet) {
            this.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
            this.changedFields = changedFields.add("appActionIfDeviceLockNotSet");
            return this;
        }

        /**
         * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
         * allowed. A key should be Android package id for a keyboard and value should be a
         * friendly name”</i>
         * 
         * @param approvedKeyboards
         *            value of {@code approvedKeyboards} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvedKeyboards(List<KeyValuePair> approvedKeyboards) {
            this.approvedKeyboards = approvedKeyboards;
            this.changedFields = changedFields.add("approvedKeyboards");
            return this;
        }

        /**
         * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
         * allowed. A key should be Android package id for a keyboard and value should be a
         * friendly name”</i>
         * 
         * @param approvedKeyboards
         *            value of {@code approvedKeyboards} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvedKeyboards(KeyValuePair... approvedKeyboards) {
            return approvedKeyboards(Arrays.asList(approvedKeyboards));
        }

        /**
         * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
         * allowed. A key should be Android package id for a keyboard and value should be a
         * friendly name”</i>
         * 
         * @param approvedKeyboardsNextLink
         *            value of {@code approvedKeyboards@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvedKeyboardsNextLink(String approvedKeyboardsNextLink) {
            this.approvedKeyboardsNextLink = approvedKeyboardsNextLink;
            this.changedFields = changedFields.add("approvedKeyboards");
            return this;
        }

        /**
         * <i>“Indicates whether use of the biometric authentication is allowed in place of a
         * pin if PinRequired is set to True.”</i>
         * 
         * @param biometricAuthenticationBlocked
         *            value of {@code biometricAuthenticationBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder biometricAuthenticationBlocked(Boolean biometricAuthenticationBlocked) {
            this.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
            this.changedFields = changedFields.add("biometricAuthenticationBlocked");
            return this;
        }

        /**
         * <i>“Maximum number of days Company Portal update can be deferred on the device or
         * app access will be blocked.”</i>
         * 
         * @param blockAfterCompanyPortalUpdateDeferralInDays
         *            value of {@code blockAfterCompanyPortalUpdateDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockAfterCompanyPortalUpdateDeferralInDays(Integer blockAfterCompanyPortalUpdateDeferralInDays) {
            this.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
            this.changedFields = changedFields.add("blockAfterCompanyPortalUpdateDeferralInDays");
            return this;
        }

        /**
         * <i>“Whether the app should connect to the configured VPN on launch.”</i>
         * 
         * @param connectToVpnOnLaunch
         *            value of {@code connectToVpnOnLaunch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectToVpnOnLaunch(Boolean connectToVpnOnLaunch) {
            this.connectToVpnOnLaunch = connectToVpnOnLaunch;
            this.changedFields = changedFields.add("connectToVpnOnLaunch");
            return this;
        }

        /**
         * <i>“Friendly name of the preferred custom browser to open weblink on Android. When
         * this property is configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
         * 
         * @param customBrowserDisplayName
         *            value of {@code customBrowserDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserDisplayName(String customBrowserDisplayName) {
            this.customBrowserDisplayName = customBrowserDisplayName;
            this.changedFields = changedFields.add("customBrowserDisplayName");
            return this;
        }

        /**
         * <i>“Unique identifier of the preferred custom browser to open weblink on Android.
         * When this property is configured, ManagedBrowserToOpenLinksRequired should be
         * true.”</i>
         * 
         * @param customBrowserPackageId
         *            value of {@code customBrowserPackageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserPackageId(String customBrowserPackageId) {
            this.customBrowserPackageId = customBrowserPackageId;
            this.changedFields = changedFields.add("customBrowserPackageId");
            return this;
        }

        /**
         * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
         * 
         * @param customDialerAppDisplayName
         *            value of {@code customDialerAppDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppDisplayName(String customDialerAppDisplayName) {
            this.customDialerAppDisplayName = customDialerAppDisplayName;
            this.changedFields = changedFields.add("customDialerAppDisplayName");
            return this;
        }

        /**
         * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
         * 
         * @param customDialerAppPackageId
         *            value of {@code customDialerAppPackageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppPackageId(String customDialerAppPackageId) {
            this.customDialerAppPackageId = customDialerAppPackageId;
            this.changedFields = changedFields.add("customDialerAppPackageId");
            return this;
        }

        /**
         * <i>“Count of apps to which the current policy is deployed.”</i>
         * 
         * @param deployedAppCount
         *            value of {@code deployedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployedAppCount(Integer deployedAppCount) {
            this.deployedAppCount = deployedAppCount;
            this.changedFields = changedFields.add("deployedAppCount");
            return this;
        }

        /**
         * <i>“Defines if any kind of lock must be required on android device”</i>
         * 
         * @param deviceLockRequired
         *            value of {@code deviceLockRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceLockRequired(Boolean deviceLockRequired) {
            this.deviceLockRequired = deviceLockRequired;
            this.changedFields = changedFields.add("deviceLockRequired");
            return this;
        }

        /**
         * <i>“When this setting is enabled, app level encryption is disabled if device level
         * encryption is enabled”</i>
         * 
         * @param disableAppEncryptionIfDeviceEncryptionIsEnabled
         *            value of {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableAppEncryptionIfDeviceEncryptionIsEnabled(Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled) {
            this.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
            this.changedFields = changedFields.add("disableAppEncryptionIfDeviceEncryptionIsEnabled");
            return this;
        }

        /**
         * <i>“Indicates whether application data for managed apps should be encrypted”</i>
         * 
         * @param encryptAppData
         *            value of {@code encryptAppData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptAppData(Boolean encryptAppData) {
            this.encryptAppData = encryptAppData;
            this.changedFields = changedFields.add("encryptAppData");
            return this;
        }

        /**
         * <i>“App packages in this list will be exempt from the policy and will be able to
         * receive data from managed apps.”</i>
         * 
         * @param exemptedAppPackages
         *            value of {@code exemptedAppPackages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackages(List<KeyValuePair> exemptedAppPackages) {
            this.exemptedAppPackages = exemptedAppPackages;
            this.changedFields = changedFields.add("exemptedAppPackages");
            return this;
        }

        /**
         * <i>“App packages in this list will be exempt from the policy and will be able to
         * receive data from managed apps.”</i>
         * 
         * @param exemptedAppPackages
         *            value of {@code exemptedAppPackages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackages(KeyValuePair... exemptedAppPackages) {
            return exemptedAppPackages(Arrays.asList(exemptedAppPackages));
        }

        /**
         * <i>“App packages in this list will be exempt from the policy and will be able to
         * receive data from managed apps.”</i>
         * 
         * @param exemptedAppPackagesNextLink
         *            value of {@code exemptedAppPackages@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackagesNextLink(String exemptedAppPackagesNextLink) {
            this.exemptedAppPackagesNextLink = exemptedAppPackagesNextLink;
            this.changedFields = changedFields.add("exemptedAppPackages");
            return this;
        }

        /**
         * <i>“Indicates if keyboard restriction is enabled. If enabled list of approved
         * keyboards must be provided as well.”</i>
         * 
         * @param keyboardsRestricted
         *            value of {@code keyboardsRestricted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardsRestricted(Boolean keyboardsRestricted) {
            this.keyboardsRestricted = keyboardsRestricted;
            this.changedFields = changedFields.add("keyboardsRestricted");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * app access will be blocked”</i>
         * 
         * @param minimumRequiredCompanyPortalVersion
         *            value of {@code minimumRequiredCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredCompanyPortalVersion(String minimumRequiredCompanyPortalVersion) {
            this.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumRequiredCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Define the oldest required Android security patch level a user can have to gain
         * secure access to the app.”</i>
         * 
         * @param minimumRequiredPatchVersion
         *            value of {@code minimumRequiredPatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredPatchVersion(String minimumRequiredPatchVersion) {
            this.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
            this.changedFields = changedFields.add("minimumRequiredPatchVersion");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * the user will receive a warning”</i>
         * 
         * @param minimumWarningCompanyPortalVersion
         *            value of {@code minimumWarningCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWarningCompanyPortalVersion(String minimumWarningCompanyPortalVersion) {
            this.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumWarningCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Define the oldest recommended Android security patch level a user can have for
         * secure access to the app.”</i>
         * 
         * @param minimumWarningPatchVersion
         *            value of {@code minimumWarningPatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWarningPatchVersion(String minimumWarningPatchVersion) {
            this.minimumWarningPatchVersion = minimumWarningPatchVersion;
            this.changedFields = changedFields.add("minimumWarningPatchVersion");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * the company data on the app will be wiped”</i>
         * 
         * @param minimumWipeCompanyPortalVersion
         *            value of {@code minimumWipeCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipeCompanyPortalVersion(String minimumWipeCompanyPortalVersion) {
            this.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumWipeCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Android security patch level  less than or equal to the specified value will
         * wipe the managed app and the associated company data.”</i>
         * 
         * @param minimumWipePatchVersion
         *            value of {@code minimumWipePatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipePatchVersion(String minimumWipePatchVersion) {
            this.minimumWipePatchVersion = minimumWipePatchVersion;
            this.changedFields = changedFields.add("minimumWipePatchVersion");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
         * work.”</i>
         * 
         * @param requiredAndroidSafetyNetAppsVerificationType
         *            value of {@code requiredAndroidSafetyNetAppsVerificationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetAppsVerificationType(AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType) {
            this.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetAppsVerificationType");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
         * to work.”</i>
         * 
         * @param requiredAndroidSafetyNetDeviceAttestationType
         *            value of {@code requiredAndroidSafetyNetDeviceAttestationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetDeviceAttestationType(AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType) {
            this.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetDeviceAttestationType");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet evaluation type requirement for a managed app to
         * work.”</i>
         * 
         * @param requiredAndroidSafetyNetEvaluationType
         *            value of {@code requiredAndroidSafetyNetEvaluationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetEvaluationType(AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType) {
            this.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetEvaluationType");
            return this;
        }

        /**
         * <i>“Indicates whether a managed user can take screen captures of managed apps”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Maximum number of days Company Portal update can be deferred on the device or
         * the user will receive the warning”</i>
         * 
         * @param warnAfterCompanyPortalUpdateDeferralInDays
         *            value of {@code warnAfterCompanyPortalUpdateDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder warnAfterCompanyPortalUpdateDeferralInDays(Integer warnAfterCompanyPortalUpdateDeferralInDays) {
            this.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
            this.changedFields = changedFields.add("warnAfterCompanyPortalUpdateDeferralInDays");
            return this;
        }

        /**
         * <i>“Maximum number of days Company Portal update can be deferred on the device or
         * the company data on the app will be wiped”</i>
         * 
         * @param wipeAfterCompanyPortalUpdateDeferralInDays
         *            value of {@code wipeAfterCompanyPortalUpdateDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wipeAfterCompanyPortalUpdateDeferralInDays(Integer wipeAfterCompanyPortalUpdateDeferralInDays) {
            this.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
            this.changedFields = changedFields.add("wipeAfterCompanyPortalUpdateDeferralInDays");
            return this;
        }

        /**
         * <i>“List of apps to which the policy is deployed.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(List<ManagedMobileApp> apps) {
            this.apps = apps;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“List of apps to which the policy is deployed.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(ManagedMobileApp... apps) {
            return apps(Arrays.asList(apps));
        }

        /**
         * <i>“Navigation property to deployment summary of the configuration.”</i>
         * 
         * @param deploymentSummary
         *            value of {@code deploymentSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentSummary(ManagedAppPolicyDeploymentSummary deploymentSummary) {
            this.deploymentSummary = deploymentSummary;
            this.changedFields = changedFields.add("deploymentSummary");
            return this;
        }

        public AndroidManagedAppProtection build() {
            AndroidManagedAppProtection _x = new AndroidManagedAppProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidManagedAppProtection";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
            _x.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            _x.allowedDataStorageLocations = allowedDataStorageLocations;
            _x.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            _x.contactSyncBlocked = contactSyncBlocked;
            _x.dataBackupBlocked = dataBackupBlocked;
            _x.deviceComplianceRequired = deviceComplianceRequired;
            _x.dialerRestrictionLevel = dialerRestrictionLevel;
            _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            _x.fingerprintBlocked = fingerprintBlocked;
            _x.gracePeriodToBlockAppsDuringOffClockHours = gracePeriodToBlockAppsDuringOffClockHours;
            _x.managedBrowser = managedBrowser;
            _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            _x.maximumPinRetries = maximumPinRetries;
            _x.maximumRequiredOsVersion = maximumRequiredOsVersion;
            _x.maximumWarningOsVersion = maximumWarningOsVersion;
            _x.maximumWipeOsVersion = maximumWipeOsVersion;
            _x.minimumPinLength = minimumPinLength;
            _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
            _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
            _x.minimumWarningAppVersion = minimumWarningAppVersion;
            _x.minimumWarningOsVersion = minimumWarningOsVersion;
            _x.minimumWipeAppVersion = minimumWipeAppVersion;
            _x.minimumWipeOsVersion = minimumWipeOsVersion;
            _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            _x.notificationRestriction = notificationRestriction;
            _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
            _x.periodBeforePinReset = periodBeforePinReset;
            _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            _x.pinCharacterSet = pinCharacterSet;
            _x.pinRequired = pinRequired;
            _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            _x.previousPinBlockCount = previousPinBlockCount;
            _x.printBlocked = printBlocked;
            _x.saveAsBlocked = saveAsBlocked;
            _x.simplePinBlocked = simplePinBlocked;
            _x.appGroupType = appGroupType;
            _x.isAssigned = isAssigned;
            _x.targetedAppManagementLevels = targetedAppManagementLevels;
            _x.assignments = assignments;
            _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
            _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
            _x.allowedAndroidDeviceModelsNextLink = allowedAndroidDeviceModelsNextLink;
            _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
            _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
            _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
            _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
            _x.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
            _x.approvedKeyboards = approvedKeyboards;
            _x.approvedKeyboardsNextLink = approvedKeyboardsNextLink;
            _x.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
            _x.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
            _x.connectToVpnOnLaunch = connectToVpnOnLaunch;
            _x.customBrowserDisplayName = customBrowserDisplayName;
            _x.customBrowserPackageId = customBrowserPackageId;
            _x.customDialerAppDisplayName = customDialerAppDisplayName;
            _x.customDialerAppPackageId = customDialerAppPackageId;
            _x.deployedAppCount = deployedAppCount;
            _x.deviceLockRequired = deviceLockRequired;
            _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
            _x.encryptAppData = encryptAppData;
            _x.exemptedAppPackages = exemptedAppPackages;
            _x.exemptedAppPackagesNextLink = exemptedAppPackagesNextLink;
            _x.keyboardsRestricted = keyboardsRestricted;
            _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
            _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
            _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
            _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
            _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
            _x.minimumWipePatchVersion = minimumWipePatchVersion;
            _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
            _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
            _x.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
            _x.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
            _x.apps = apps;
            _x.deploymentSummary = deploymentSummary;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
     * managed app to work.”</i>
     * 
     * @return property allowedAndroidDeviceManufacturers
     */
    @Property(name="allowedAndroidDeviceManufacturers")
    @JsonIgnore
    public Optional<String> getAllowedAndroidDeviceManufacturers() {
        return Optional.ofNullable(allowedAndroidDeviceManufacturers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedAndroidDeviceManufacturers} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
     * managed app to work.”</i>
     * 
     * @param allowedAndroidDeviceManufacturers
     *            new value of {@code allowedAndroidDeviceManufacturers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedAndroidDeviceManufacturers} field changed
     */
    public AndroidManagedAppProtection withAllowedAndroidDeviceManufacturers(String allowedAndroidDeviceManufacturers) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedAndroidDeviceManufacturers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
        return _x;
    }

    /**
     * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
     * 
     * @return property allowedAndroidDeviceModels
     */
    @Property(name="allowedAndroidDeviceModels")
    @JsonIgnore
    public CollectionPage<String> getAllowedAndroidDeviceModels() {
        return new CollectionPage<String>(contextPath, String.class, this.allowedAndroidDeviceModels, Optional.ofNullable(allowedAndroidDeviceModelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedAndroidDeviceModels} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
     * 
     * @param allowedAndroidDeviceModels
     *            new value of {@code allowedAndroidDeviceModels} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedAndroidDeviceModels} field changed
     */
    public AndroidManagedAppProtection withAllowedAndroidDeviceModels(List<String> allowedAndroidDeviceModels) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedAndroidDeviceModels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
        return _x;
    }

    /**
     * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property allowedAndroidDeviceModels
     */
    @Property(name="allowedAndroidDeviceModels")
    @JsonIgnore
    public CollectionPage<String> getAllowedAndroidDeviceModels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.allowedAndroidDeviceModels, Optional.ofNullable(allowedAndroidDeviceModelsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * manufacturer is not allowed.”</i>
     * 
     * @return property appActionIfAndroidDeviceManufacturerNotAllowed
     */
    @Property(name="appActionIfAndroidDeviceManufacturerNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidDeviceManufacturerNotAllowed() {
        return Optional.ofNullable(appActionIfAndroidDeviceManufacturerNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidDeviceManufacturerNotAllowed} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * manufacturer is not allowed.”</i>
     * 
     * @param appActionIfAndroidDeviceManufacturerNotAllowed
     *            new value of {@code appActionIfAndroidDeviceManufacturerNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidDeviceManufacturerNotAllowed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidDeviceManufacturerNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidDeviceManufacturerNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed.”</i>
     * 
     * @return property appActionIfAndroidDeviceModelNotAllowed
     */
    @Property(name="appActionIfAndroidDeviceModelNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidDeviceModelNotAllowed() {
        return Optional.ofNullable(appActionIfAndroidDeviceModelNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidDeviceModelNotAllowed} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed.”</i>
     * 
     * @param appActionIfAndroidDeviceModelNotAllowed
     *            new value of {@code appActionIfAndroidDeviceModelNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidDeviceModelNotAllowed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidDeviceModelNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * App Verification requirement fails.”</i>
     * 
     * @return property appActionIfAndroidSafetyNetAppsVerificationFailed
     */
    @Property(name="appActionIfAndroidSafetyNetAppsVerificationFailed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidSafetyNetAppsVerificationFailed() {
        return Optional.ofNullable(appActionIfAndroidSafetyNetAppsVerificationFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidSafetyNetAppsVerificationFailed} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * App Verification requirement fails.”</i>
     * 
     * @param appActionIfAndroidSafetyNetAppsVerificationFailed
     *            new value of {@code appActionIfAndroidSafetyNetAppsVerificationFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidSafetyNetAppsVerificationFailed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidSafetyNetAppsVerificationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidSafetyNetAppsVerificationFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * SafetyNet Attestation requirement fails.”</i>
     * 
     * @return property appActionIfAndroidSafetyNetDeviceAttestationFailed
     */
    @Property(name="appActionIfAndroidSafetyNetDeviceAttestationFailed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidSafetyNetDeviceAttestationFailed() {
        return Optional.ofNullable(appActionIfAndroidSafetyNetDeviceAttestationFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidSafetyNetDeviceAttestationFailed} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * SafetyNet Attestation requirement fails.”</i>
     * 
     * @param appActionIfAndroidSafetyNetDeviceAttestationFailed
     *            new value of {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidSafetyNetDeviceAttestationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidSafetyNetDeviceAttestationFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn, block or wipe, if the screen lock
     * is required on android device but is not set.”</i>
     * 
     * @return property appActionIfDeviceLockNotSet
     */
    @Property(name="appActionIfDeviceLockNotSet")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfDeviceLockNotSet() {
        return Optional.ofNullable(appActionIfDeviceLockNotSet);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfDeviceLockNotSet} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn, block or wipe, if the screen lock
     * is required on android device but is not set.”</i>
     * 
     * @param appActionIfDeviceLockNotSet
     *            new value of {@code appActionIfDeviceLockNotSet} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfDeviceLockNotSet} field changed
     */
    public AndroidManagedAppProtection withAppActionIfDeviceLockNotSet(ManagedAppRemediationAction appActionIfDeviceLockNotSet) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfDeviceLockNotSet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
        return _x;
    }

    /**
     * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
     * allowed. A key should be Android package id for a keyboard and value should be a
     * friendly name”</i>
     * 
     * @return property approvedKeyboards
     */
    @Property(name="approvedKeyboards")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getApprovedKeyboards() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.approvedKeyboards, Optional.ofNullable(approvedKeyboardsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code approvedKeyboards
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
     * allowed. A key should be Android package id for a keyboard and value should be a
     * friendly name”</i>
     * 
     * @param approvedKeyboards
     *            new value of {@code approvedKeyboards} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code approvedKeyboards} field changed
     */
    public AndroidManagedAppProtection withApprovedKeyboards(List<KeyValuePair> approvedKeyboards) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("approvedKeyboards");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.approvedKeyboards = approvedKeyboards;
        return _x;
    }

    /**
     * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
     * allowed. A key should be Android package id for a keyboard and value should be a
     * friendly name”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property approvedKeyboards
     */
    @Property(name="approvedKeyboards")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getApprovedKeyboards(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.approvedKeyboards, Optional.ofNullable(approvedKeyboardsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether use of the biometric authentication is allowed in place of a
     * pin if PinRequired is set to True.”</i>
     * 
     * @return property biometricAuthenticationBlocked
     */
    @Property(name="biometricAuthenticationBlocked")
    @JsonIgnore
    public Optional<Boolean> getBiometricAuthenticationBlocked() {
        return Optional.ofNullable(biometricAuthenticationBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * biometricAuthenticationBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether use of the biometric authentication is allowed in place of a
     * pin if PinRequired is set to True.”</i>
     * 
     * @param biometricAuthenticationBlocked
     *            new value of {@code biometricAuthenticationBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code biometricAuthenticationBlocked} field changed
     */
    public AndroidManagedAppProtection withBiometricAuthenticationBlocked(Boolean biometricAuthenticationBlocked) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("biometricAuthenticationBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
        return _x;
    }

    /**
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * app access will be blocked.”</i>
     * 
     * @return property blockAfterCompanyPortalUpdateDeferralInDays
     */
    @Property(name="blockAfterCompanyPortalUpdateDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getBlockAfterCompanyPortalUpdateDeferralInDays() {
        return Optional.ofNullable(blockAfterCompanyPortalUpdateDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockAfterCompanyPortalUpdateDeferralInDays} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * app access will be blocked.”</i>
     * 
     * @param blockAfterCompanyPortalUpdateDeferralInDays
     *            new value of {@code blockAfterCompanyPortalUpdateDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockAfterCompanyPortalUpdateDeferralInDays} field changed
     */
    public AndroidManagedAppProtection withBlockAfterCompanyPortalUpdateDeferralInDays(Integer blockAfterCompanyPortalUpdateDeferralInDays) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("blockAfterCompanyPortalUpdateDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
        return _x;
    }

    /**
     * <i>“Whether the app should connect to the configured VPN on launch.”</i>
     * 
     * @return property connectToVpnOnLaunch
     */
    @Property(name="connectToVpnOnLaunch")
    @JsonIgnore
    public Optional<Boolean> getConnectToVpnOnLaunch() {
        return Optional.ofNullable(connectToVpnOnLaunch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectToVpnOnLaunch} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether the app should connect to the configured VPN on launch.”</i>
     * 
     * @param connectToVpnOnLaunch
     *            new value of {@code connectToVpnOnLaunch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectToVpnOnLaunch} field changed
     */
    public AndroidManagedAppProtection withConnectToVpnOnLaunch(Boolean connectToVpnOnLaunch) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("connectToVpnOnLaunch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.connectToVpnOnLaunch = connectToVpnOnLaunch;
        return _x;
    }

    /**
     * <i>“Friendly name of the preferred custom browser to open weblink on Android. When
     * this property is configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
     * 
     * @return property customBrowserDisplayName
     */
    @Property(name="customBrowserDisplayName")
    @JsonIgnore
    public Optional<String> getCustomBrowserDisplayName() {
        return Optional.ofNullable(customBrowserDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserDisplayName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly name of the preferred custom browser to open weblink on Android. When
     * this property is configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
     * 
     * @param customBrowserDisplayName
     *            new value of {@code customBrowserDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserDisplayName} field changed
     */
    public AndroidManagedAppProtection withCustomBrowserDisplayName(String customBrowserDisplayName) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customBrowserDisplayName = customBrowserDisplayName;
        return _x;
    }

    /**
     * <i>“Unique identifier of the preferred custom browser to open weblink on Android.
     * When this property is configured, ManagedBrowserToOpenLinksRequired should be
     * true.”</i>
     * 
     * @return property customBrowserPackageId
     */
    @Property(name="customBrowserPackageId")
    @JsonIgnore
    public Optional<String> getCustomBrowserPackageId() {
        return Optional.ofNullable(customBrowserPackageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserPackageId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Unique identifier of the preferred custom browser to open weblink on Android.
     * When this property is configured, ManagedBrowserToOpenLinksRequired should be
     * true.”</i>
     * 
     * @param customBrowserPackageId
     *            new value of {@code customBrowserPackageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserPackageId} field changed
     */
    public AndroidManagedAppProtection withCustomBrowserPackageId(String customBrowserPackageId) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customBrowserPackageId = customBrowserPackageId;
        return _x;
    }

    /**
     * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @return property customDialerAppDisplayName
     */
    @Property(name="customDialerAppDisplayName")
    @JsonIgnore
    public Optional<String> getCustomDialerAppDisplayName() {
        return Optional.ofNullable(customDialerAppDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @param customDialerAppDisplayName
     *            new value of {@code customDialerAppDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppDisplayName} field changed
     */
    public AndroidManagedAppProtection withCustomDialerAppDisplayName(String customDialerAppDisplayName) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customDialerAppDisplayName = customDialerAppDisplayName;
        return _x;
    }

    /**
     * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @return property customDialerAppPackageId
     */
    @Property(name="customDialerAppPackageId")
    @JsonIgnore
    public Optional<String> getCustomDialerAppPackageId() {
        return Optional.ofNullable(customDialerAppPackageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppPackageId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @param customDialerAppPackageId
     *            new value of {@code customDialerAppPackageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppPackageId} field changed
     */
    public AndroidManagedAppProtection withCustomDialerAppPackageId(String customDialerAppPackageId) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customDialerAppPackageId = customDialerAppPackageId;
        return _x;
    }

    /**
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @return property deployedAppCount
     */
    @Property(name="deployedAppCount")
    @JsonIgnore
    public Optional<Integer> getDeployedAppCount() {
        return Optional.ofNullable(deployedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deployedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @param deployedAppCount
     *            new value of {@code deployedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployedAppCount} field changed
     */
    public AndroidManagedAppProtection withDeployedAppCount(Integer deployedAppCount) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deployedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.deployedAppCount = deployedAppCount;
        return _x;
    }

    /**
     * <i>“Defines if any kind of lock must be required on android device”</i>
     * 
     * @return property deviceLockRequired
     */
    @Property(name="deviceLockRequired")
    @JsonIgnore
    public Optional<Boolean> getDeviceLockRequired() {
        return Optional.ofNullable(deviceLockRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceLockRequired} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Defines if any kind of lock must be required on android device”</i>
     * 
     * @param deviceLockRequired
     *            new value of {@code deviceLockRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceLockRequired} field changed
     */
    public AndroidManagedAppProtection withDeviceLockRequired(Boolean deviceLockRequired) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deviceLockRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.deviceLockRequired = deviceLockRequired;
        return _x;
    }

    /**
     * <i>“When this setting is enabled, app level encryption is disabled if device level
     * encryption is enabled”</i>
     * 
     * @return property disableAppEncryptionIfDeviceEncryptionIsEnabled
     */
    @Property(name="disableAppEncryptionIfDeviceEncryptionIsEnabled")
    @JsonIgnore
    public Optional<Boolean> getDisableAppEncryptionIfDeviceEncryptionIsEnabled() {
        return Optional.ofNullable(disableAppEncryptionIfDeviceEncryptionIsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableAppEncryptionIfDeviceEncryptionIsEnabled} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“When this setting is enabled, app level encryption is disabled if device level
     * encryption is enabled”</i>
     * 
     * @param disableAppEncryptionIfDeviceEncryptionIsEnabled
     *            new value of {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} field changed
     */
    public AndroidManagedAppProtection withDisableAppEncryptionIfDeviceEncryptionIsEnabled(Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("disableAppEncryptionIfDeviceEncryptionIsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
        return _x;
    }

    /**
     * <i>“Indicates whether application data for managed apps should be encrypted”</i>
     * 
     * @return property encryptAppData
     */
    @Property(name="encryptAppData")
    @JsonIgnore
    public Optional<Boolean> getEncryptAppData() {
        return Optional.ofNullable(encryptAppData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptAppData}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether application data for managed apps should be encrypted”</i>
     * 
     * @param encryptAppData
     *            new value of {@code encryptAppData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptAppData} field changed
     */
    public AndroidManagedAppProtection withEncryptAppData(Boolean encryptAppData) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("encryptAppData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.encryptAppData = encryptAppData;
        return _x;
    }

    /**
     * <i>“App packages in this list will be exempt from the policy and will be able to
     * receive data from managed apps.”</i>
     * 
     * @return property exemptedAppPackages
     */
    @Property(name="exemptedAppPackages")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppPackages() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.exemptedAppPackages, Optional.ofNullable(exemptedAppPackagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exemptedAppPackages} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“App packages in this list will be exempt from the policy and will be able to
     * receive data from managed apps.”</i>
     * 
     * @param exemptedAppPackages
     *            new value of {@code exemptedAppPackages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exemptedAppPackages} field changed
     */
    public AndroidManagedAppProtection withExemptedAppPackages(List<KeyValuePair> exemptedAppPackages) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("exemptedAppPackages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.exemptedAppPackages = exemptedAppPackages;
        return _x;
    }

    /**
     * <i>“App packages in this list will be exempt from the policy and will be able to
     * receive data from managed apps.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property exemptedAppPackages
     */
    @Property(name="exemptedAppPackages")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppPackages(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.exemptedAppPackages, Optional.ofNullable(exemptedAppPackagesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates if keyboard restriction is enabled. If enabled list of approved
     * keyboards must be provided as well.”</i>
     * 
     * @return property keyboardsRestricted
     */
    @Property(name="keyboardsRestricted")
    @JsonIgnore
    public Optional<Boolean> getKeyboardsRestricted() {
        return Optional.ofNullable(keyboardsRestricted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardsRestricted} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if keyboard restriction is enabled. If enabled list of approved
     * keyboards must be provided as well.”</i>
     * 
     * @param keyboardsRestricted
     *            new value of {@code keyboardsRestricted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardsRestricted} field changed
     */
    public AndroidManagedAppProtection withKeyboardsRestricted(Boolean keyboardsRestricted) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("keyboardsRestricted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.keyboardsRestricted = keyboardsRestricted;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * app access will be blocked”</i>
     * 
     * @return property minimumRequiredCompanyPortalVersion
     */
    @Property(name="minimumRequiredCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredCompanyPortalVersion() {
        return Optional.ofNullable(minimumRequiredCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * app access will be blocked”</i>
     * 
     * @param minimumRequiredCompanyPortalVersion
     *            new value of {@code minimumRequiredCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredCompanyPortalVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumRequiredCompanyPortalVersion(String minimumRequiredCompanyPortalVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Define the oldest required Android security patch level a user can have to gain
     * secure access to the app.”</i>
     * 
     * @return property minimumRequiredPatchVersion
     */
    @Property(name="minimumRequiredPatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredPatchVersion() {
        return Optional.ofNullable(minimumRequiredPatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredPatchVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the oldest required Android security patch level a user can have to gain
     * secure access to the app.”</i>
     * 
     * @param minimumRequiredPatchVersion
     *            new value of {@code minimumRequiredPatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredPatchVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumRequiredPatchVersion(String minimumRequiredPatchVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredPatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the user will receive a warning”</i>
     * 
     * @return property minimumWarningCompanyPortalVersion
     */
    @Property(name="minimumWarningCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumWarningCompanyPortalVersion() {
        return Optional.ofNullable(minimumWarningCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWarningCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the user will receive a warning”</i>
     * 
     * @param minimumWarningCompanyPortalVersion
     *            new value of {@code minimumWarningCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWarningCompanyPortalVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWarningCompanyPortalVersion(String minimumWarningCompanyPortalVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWarningCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Define the oldest recommended Android security patch level a user can have for
     * secure access to the app.”</i>
     * 
     * @return property minimumWarningPatchVersion
     */
    @Property(name="minimumWarningPatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumWarningPatchVersion() {
        return Optional.ofNullable(minimumWarningPatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWarningPatchVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the oldest recommended Android security patch level a user can have for
     * secure access to the app.”</i>
     * 
     * @param minimumWarningPatchVersion
     *            new value of {@code minimumWarningPatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWarningPatchVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWarningPatchVersion(String minimumWarningPatchVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWarningPatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @return property minimumWipeCompanyPortalVersion
     */
    @Property(name="minimumWipeCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipeCompanyPortalVersion() {
        return Optional.ofNullable(minimumWipeCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipeCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @param minimumWipeCompanyPortalVersion
     *            new value of {@code minimumWipeCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipeCompanyPortalVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWipeCompanyPortalVersion(String minimumWipeCompanyPortalVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipeCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Android security patch level  less than or equal to the specified value will
     * wipe the managed app and the associated company data.”</i>
     * 
     * @return property minimumWipePatchVersion
     */
    @Property(name="minimumWipePatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipePatchVersion() {
        return Optional.ofNullable(minimumWipePatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipePatchVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android security patch level  less than or equal to the specified value will
     * wipe the managed app and the associated company data.”</i>
     * 
     * @param minimumWipePatchVersion
     *            new value of {@code minimumWipePatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipePatchVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWipePatchVersion(String minimumWipePatchVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipePatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWipePatchVersion = minimumWipePatchVersion;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
     * work.”</i>
     * 
     * @return property requiredAndroidSafetyNetAppsVerificationType
     */
    @Property(name="requiredAndroidSafetyNetAppsVerificationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetAppsVerificationType> getRequiredAndroidSafetyNetAppsVerificationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetAppsVerificationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetAppsVerificationType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
     * work.”</i>
     * 
     * @param requiredAndroidSafetyNetAppsVerificationType
     *            new value of {@code requiredAndroidSafetyNetAppsVerificationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetAppsVerificationType} field changed
     */
    public AndroidManagedAppProtection withRequiredAndroidSafetyNetAppsVerificationType(AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetAppsVerificationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
     * to work.”</i>
     * 
     * @return property requiredAndroidSafetyNetDeviceAttestationType
     */
    @Property(name="requiredAndroidSafetyNetDeviceAttestationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetDeviceAttestationType> getRequiredAndroidSafetyNetDeviceAttestationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetDeviceAttestationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetDeviceAttestationType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
     * to work.”</i>
     * 
     * @param requiredAndroidSafetyNetDeviceAttestationType
     *            new value of {@code requiredAndroidSafetyNetDeviceAttestationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetDeviceAttestationType} field changed
     */
    public AndroidManagedAppProtection withRequiredAndroidSafetyNetDeviceAttestationType(AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetDeviceAttestationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet evaluation type requirement for a managed app to
     * work.”</i>
     * 
     * @return property requiredAndroidSafetyNetEvaluationType
     */
    @Property(name="requiredAndroidSafetyNetEvaluationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetEvaluationType> getRequiredAndroidSafetyNetEvaluationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetEvaluationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetEvaluationType} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet evaluation type requirement for a managed app to
     * work.”</i>
     * 
     * @param requiredAndroidSafetyNetEvaluationType
     *            new value of {@code requiredAndroidSafetyNetEvaluationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetEvaluationType} field changed
     */
    public AndroidManagedAppProtection withRequiredAndroidSafetyNetEvaluationType(AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetEvaluationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
        return _x;
    }

    /**
     * <i>“Indicates whether a managed user can take screen captures of managed apps”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether a managed user can take screen captures of managed apps”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public AndroidManagedAppProtection withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the user will receive the warning”</i>
     * 
     * @return property warnAfterCompanyPortalUpdateDeferralInDays
     */
    @Property(name="warnAfterCompanyPortalUpdateDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getWarnAfterCompanyPortalUpdateDeferralInDays() {
        return Optional.ofNullable(warnAfterCompanyPortalUpdateDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * warnAfterCompanyPortalUpdateDeferralInDays} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the user will receive the warning”</i>
     * 
     * @param warnAfterCompanyPortalUpdateDeferralInDays
     *            new value of {@code warnAfterCompanyPortalUpdateDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code warnAfterCompanyPortalUpdateDeferralInDays} field changed
     */
    public AndroidManagedAppProtection withWarnAfterCompanyPortalUpdateDeferralInDays(Integer warnAfterCompanyPortalUpdateDeferralInDays) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("warnAfterCompanyPortalUpdateDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
        return _x;
    }

    /**
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @return property wipeAfterCompanyPortalUpdateDeferralInDays
     */
    @Property(name="wipeAfterCompanyPortalUpdateDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getWipeAfterCompanyPortalUpdateDeferralInDays() {
        return Optional.ofNullable(wipeAfterCompanyPortalUpdateDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wipeAfterCompanyPortalUpdateDeferralInDays} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @param wipeAfterCompanyPortalUpdateDeferralInDays
     *            new value of {@code wipeAfterCompanyPortalUpdateDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wipeAfterCompanyPortalUpdateDeferralInDays} field changed
     */
    public AndroidManagedAppProtection withWipeAfterCompanyPortalUpdateDeferralInDays(Integer wipeAfterCompanyPortalUpdateDeferralInDays) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("wipeAfterCompanyPortalUpdateDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
        return _x;
    }

    public AndroidManagedAppProtection withUnmappedField(String name, Object value) {
        AndroidManagedAppProtection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @return navigational property apps
     */
    @NavigationProperty(name="apps")
    @JsonIgnore
    public ManagedMobileAppCollectionRequest getApps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"), Optional.ofNullable(apps));
    }

    /**
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @return navigational property deploymentSummary
     */
    @NavigationProperty(name="deploymentSummary")
    @JsonIgnore
    public ManagedAppPolicyDeploymentSummaryRequest getDeploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"), Optional.ofNullable(deploymentSummary));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code apps} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @param apps
     *            new value of {@code apps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code apps} field changed
     */
    public AndroidManagedAppProtection withApps(List<ManagedMobileApp> apps) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("apps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.apps = apps;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deploymentSummary
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @param deploymentSummary
     *            new value of {@code deploymentSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentSummary} field changed
     */
    public AndroidManagedAppProtection withDeploymentSummary(ManagedAppPolicyDeploymentSummary deploymentSummary) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deploymentSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.deploymentSummary = deploymentSummary;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedAppProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedAppProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidManagedAppProtection _copy() {
        AndroidManagedAppProtection _x = new AndroidManagedAppProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
        _x.allowedDataStorageLocations = allowedDataStorageLocations;
        _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
        _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
        _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
        _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
        _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
        _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
        _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
        _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
        _x.contactSyncBlocked = contactSyncBlocked;
        _x.dataBackupBlocked = dataBackupBlocked;
        _x.deviceComplianceRequired = deviceComplianceRequired;
        _x.dialerRestrictionLevel = dialerRestrictionLevel;
        _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
        _x.fingerprintBlocked = fingerprintBlocked;
        _x.gracePeriodToBlockAppsDuringOffClockHours = gracePeriodToBlockAppsDuringOffClockHours;
        _x.managedBrowser = managedBrowser;
        _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
        _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
        _x.maximumPinRetries = maximumPinRetries;
        _x.maximumRequiredOsVersion = maximumRequiredOsVersion;
        _x.maximumWarningOsVersion = maximumWarningOsVersion;
        _x.maximumWipeOsVersion = maximumWipeOsVersion;
        _x.minimumPinLength = minimumPinLength;
        _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
        _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
        _x.minimumWarningAppVersion = minimumWarningAppVersion;
        _x.minimumWarningOsVersion = minimumWarningOsVersion;
        _x.minimumWipeAppVersion = minimumWipeAppVersion;
        _x.minimumWipeOsVersion = minimumWipeOsVersion;
        _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
        _x.notificationRestriction = notificationRestriction;
        _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
        _x.periodBeforePinReset = periodBeforePinReset;
        _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
        _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
        _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
        _x.pinCharacterSet = pinCharacterSet;
        _x.pinRequired = pinRequired;
        _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
        _x.previousPinBlockCount = previousPinBlockCount;
        _x.printBlocked = printBlocked;
        _x.saveAsBlocked = saveAsBlocked;
        _x.simplePinBlocked = simplePinBlocked;
        _x.appGroupType = appGroupType;
        _x.isAssigned = isAssigned;
        _x.targetedAppManagementLevels = targetedAppManagementLevels;
        _x.assignments = assignments;
        _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
        _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
        _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
        _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
        _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
        _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
        _x.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
        _x.approvedKeyboards = approvedKeyboards;
        _x.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
        _x.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
        _x.connectToVpnOnLaunch = connectToVpnOnLaunch;
        _x.customBrowserDisplayName = customBrowserDisplayName;
        _x.customBrowserPackageId = customBrowserPackageId;
        _x.customDialerAppDisplayName = customDialerAppDisplayName;
        _x.customDialerAppPackageId = customDialerAppPackageId;
        _x.deployedAppCount = deployedAppCount;
        _x.deviceLockRequired = deviceLockRequired;
        _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
        _x.encryptAppData = encryptAppData;
        _x.exemptedAppPackages = exemptedAppPackages;
        _x.keyboardsRestricted = keyboardsRestricted;
        _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
        _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
        _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
        _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
        _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
        _x.minimumWipePatchVersion = minimumWipePatchVersion;
        _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
        _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
        _x.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
        _x.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
        _x.apps = apps;
        _x.deploymentSummary = deploymentSummary;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedAppProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("allowedDataIngestionLocations=");
        b.append(this.allowedDataIngestionLocations);
        b.append(", ");
        b.append("allowedDataStorageLocations=");
        b.append(this.allowedDataStorageLocations);
        b.append(", ");
        b.append("allowedInboundDataTransferSources=");
        b.append(this.allowedInboundDataTransferSources);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingExceptionLength=");
        b.append(this.allowedOutboundClipboardSharingExceptionLength);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingLevel=");
        b.append(this.allowedOutboundClipboardSharingLevel);
        b.append(", ");
        b.append("allowedOutboundDataTransferDestinations=");
        b.append(this.allowedOutboundDataTransferDestinations);
        b.append(", ");
        b.append("appActionIfDeviceComplianceRequired=");
        b.append(this.appActionIfDeviceComplianceRequired);
        b.append(", ");
        b.append("appActionIfMaximumPinRetriesExceeded=");
        b.append(this.appActionIfMaximumPinRetriesExceeded);
        b.append(", ");
        b.append("appActionIfUnableToAuthenticateUser=");
        b.append(this.appActionIfUnableToAuthenticateUser);
        b.append(", ");
        b.append("blockDataIngestionIntoOrganizationDocuments=");
        b.append(this.blockDataIngestionIntoOrganizationDocuments);
        b.append(", ");
        b.append("contactSyncBlocked=");
        b.append(this.contactSyncBlocked);
        b.append(", ");
        b.append("dataBackupBlocked=");
        b.append(this.dataBackupBlocked);
        b.append(", ");
        b.append("deviceComplianceRequired=");
        b.append(this.deviceComplianceRequired);
        b.append(", ");
        b.append("dialerRestrictionLevel=");
        b.append(this.dialerRestrictionLevel);
        b.append(", ");
        b.append("disableAppPinIfDevicePinIsSet=");
        b.append(this.disableAppPinIfDevicePinIsSet);
        b.append(", ");
        b.append("fingerprintBlocked=");
        b.append(this.fingerprintBlocked);
        b.append(", ");
        b.append("gracePeriodToBlockAppsDuringOffClockHours=");
        b.append(this.gracePeriodToBlockAppsDuringOffClockHours);
        b.append(", ");
        b.append("managedBrowser=");
        b.append(this.managedBrowser);
        b.append(", ");
        b.append("managedBrowserToOpenLinksRequired=");
        b.append(this.managedBrowserToOpenLinksRequired);
        b.append(", ");
        b.append("maximumAllowedDeviceThreatLevel=");
        b.append(this.maximumAllowedDeviceThreatLevel);
        b.append(", ");
        b.append("maximumPinRetries=");
        b.append(this.maximumPinRetries);
        b.append(", ");
        b.append("maximumRequiredOsVersion=");
        b.append(this.maximumRequiredOsVersion);
        b.append(", ");
        b.append("maximumWarningOsVersion=");
        b.append(this.maximumWarningOsVersion);
        b.append(", ");
        b.append("maximumWipeOsVersion=");
        b.append(this.maximumWipeOsVersion);
        b.append(", ");
        b.append("minimumPinLength=");
        b.append(this.minimumPinLength);
        b.append(", ");
        b.append("minimumRequiredAppVersion=");
        b.append(this.minimumRequiredAppVersion);
        b.append(", ");
        b.append("minimumRequiredOsVersion=");
        b.append(this.minimumRequiredOsVersion);
        b.append(", ");
        b.append("minimumWarningAppVersion=");
        b.append(this.minimumWarningAppVersion);
        b.append(", ");
        b.append("minimumWarningOsVersion=");
        b.append(this.minimumWarningOsVersion);
        b.append(", ");
        b.append("minimumWipeAppVersion=");
        b.append(this.minimumWipeAppVersion);
        b.append(", ");
        b.append("minimumWipeOsVersion=");
        b.append(this.minimumWipeOsVersion);
        b.append(", ");
        b.append("mobileThreatDefenseRemediationAction=");
        b.append(this.mobileThreatDefenseRemediationAction);
        b.append(", ");
        b.append("notificationRestriction=");
        b.append(this.notificationRestriction);
        b.append(", ");
        b.append("organizationalCredentialsRequired=");
        b.append(this.organizationalCredentialsRequired);
        b.append(", ");
        b.append("periodBeforePinReset=");
        b.append(this.periodBeforePinReset);
        b.append(", ");
        b.append("periodOfflineBeforeAccessCheck=");
        b.append(this.periodOfflineBeforeAccessCheck);
        b.append(", ");
        b.append("periodOfflineBeforeWipeIsEnforced=");
        b.append(this.periodOfflineBeforeWipeIsEnforced);
        b.append(", ");
        b.append("periodOnlineBeforeAccessCheck=");
        b.append(this.periodOnlineBeforeAccessCheck);
        b.append(", ");
        b.append("pinCharacterSet=");
        b.append(this.pinCharacterSet);
        b.append(", ");
        b.append("pinRequired=");
        b.append(this.pinRequired);
        b.append(", ");
        b.append("pinRequiredInsteadOfBiometricTimeout=");
        b.append(this.pinRequiredInsteadOfBiometricTimeout);
        b.append(", ");
        b.append("previousPinBlockCount=");
        b.append(this.previousPinBlockCount);
        b.append(", ");
        b.append("printBlocked=");
        b.append(this.printBlocked);
        b.append(", ");
        b.append("saveAsBlocked=");
        b.append(this.saveAsBlocked);
        b.append(", ");
        b.append("simplePinBlocked=");
        b.append(this.simplePinBlocked);
        b.append(", ");
        b.append("appGroupType=");
        b.append(this.appGroupType);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("targetedAppManagementLevels=");
        b.append(this.targetedAppManagementLevels);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("allowedAndroidDeviceManufacturers=");
        b.append(this.allowedAndroidDeviceManufacturers);
        b.append(", ");
        b.append("allowedAndroidDeviceModels=");
        b.append(this.allowedAndroidDeviceModels);
        b.append(", ");
        b.append("appActionIfAndroidDeviceManufacturerNotAllowed=");
        b.append(this.appActionIfAndroidDeviceManufacturerNotAllowed);
        b.append(", ");
        b.append("appActionIfAndroidDeviceModelNotAllowed=");
        b.append(this.appActionIfAndroidDeviceModelNotAllowed);
        b.append(", ");
        b.append("appActionIfAndroidSafetyNetAppsVerificationFailed=");
        b.append(this.appActionIfAndroidSafetyNetAppsVerificationFailed);
        b.append(", ");
        b.append("appActionIfAndroidSafetyNetDeviceAttestationFailed=");
        b.append(this.appActionIfAndroidSafetyNetDeviceAttestationFailed);
        b.append(", ");
        b.append("appActionIfDeviceLockNotSet=");
        b.append(this.appActionIfDeviceLockNotSet);
        b.append(", ");
        b.append("approvedKeyboards=");
        b.append(this.approvedKeyboards);
        b.append(", ");
        b.append("biometricAuthenticationBlocked=");
        b.append(this.biometricAuthenticationBlocked);
        b.append(", ");
        b.append("blockAfterCompanyPortalUpdateDeferralInDays=");
        b.append(this.blockAfterCompanyPortalUpdateDeferralInDays);
        b.append(", ");
        b.append("connectToVpnOnLaunch=");
        b.append(this.connectToVpnOnLaunch);
        b.append(", ");
        b.append("customBrowserDisplayName=");
        b.append(this.customBrowserDisplayName);
        b.append(", ");
        b.append("customBrowserPackageId=");
        b.append(this.customBrowserPackageId);
        b.append(", ");
        b.append("customDialerAppDisplayName=");
        b.append(this.customDialerAppDisplayName);
        b.append(", ");
        b.append("customDialerAppPackageId=");
        b.append(this.customDialerAppPackageId);
        b.append(", ");
        b.append("deployedAppCount=");
        b.append(this.deployedAppCount);
        b.append(", ");
        b.append("deviceLockRequired=");
        b.append(this.deviceLockRequired);
        b.append(", ");
        b.append("disableAppEncryptionIfDeviceEncryptionIsEnabled=");
        b.append(this.disableAppEncryptionIfDeviceEncryptionIsEnabled);
        b.append(", ");
        b.append("encryptAppData=");
        b.append(this.encryptAppData);
        b.append(", ");
        b.append("exemptedAppPackages=");
        b.append(this.exemptedAppPackages);
        b.append(", ");
        b.append("keyboardsRestricted=");
        b.append(this.keyboardsRestricted);
        b.append(", ");
        b.append("minimumRequiredCompanyPortalVersion=");
        b.append(this.minimumRequiredCompanyPortalVersion);
        b.append(", ");
        b.append("minimumRequiredPatchVersion=");
        b.append(this.minimumRequiredPatchVersion);
        b.append(", ");
        b.append("minimumWarningCompanyPortalVersion=");
        b.append(this.minimumWarningCompanyPortalVersion);
        b.append(", ");
        b.append("minimumWarningPatchVersion=");
        b.append(this.minimumWarningPatchVersion);
        b.append(", ");
        b.append("minimumWipeCompanyPortalVersion=");
        b.append(this.minimumWipeCompanyPortalVersion);
        b.append(", ");
        b.append("minimumWipePatchVersion=");
        b.append(this.minimumWipePatchVersion);
        b.append(", ");
        b.append("requiredAndroidSafetyNetAppsVerificationType=");
        b.append(this.requiredAndroidSafetyNetAppsVerificationType);
        b.append(", ");
        b.append("requiredAndroidSafetyNetDeviceAttestationType=");
        b.append(this.requiredAndroidSafetyNetDeviceAttestationType);
        b.append(", ");
        b.append("requiredAndroidSafetyNetEvaluationType=");
        b.append(this.requiredAndroidSafetyNetEvaluationType);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("warnAfterCompanyPortalUpdateDeferralInDays=");
        b.append(this.warnAfterCompanyPortalUpdateDeferralInDays);
        b.append(", ");
        b.append("wipeAfterCompanyPortalUpdateDeferralInDays=");
        b.append(this.wipeAfterCompanyPortalUpdateDeferralInDays);
        b.append(", ");
        b.append("apps=");
        b.append(this.apps);
        b.append(", ");
        b.append("deploymentSummary=");
        b.append(this.deploymentSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
