package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.AndroidRequiredPasswordComplexity;
import odata.msgraph.client.beta.enums.AndroidRequiredPasswordType;
import odata.msgraph.client.beta.enums.AppListType;
import odata.msgraph.client.beta.enums.WebBrowserCookieSettings;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the androidGeneralDeviceConfiguration resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appsBlockClipboardSharing", 
    "appsBlockCopyPaste", 
    "appsBlockYouTube", 
    "appsHideList", 
    "appsInstallAllowList", 
    "appsLaunchBlockList", 
    "bluetoothBlocked", 
    "cameraBlocked", 
    "cellularBlockDataRoaming", 
    "cellularBlockMessaging", 
    "cellularBlockVoiceRoaming", 
    "cellularBlockWiFiTethering", 
    "compliantAppListType", 
    "compliantAppsList", 
    "dateAndTimeBlockChanges", 
    "deviceSharingAllowed", 
    "diagnosticDataBlockSubmission", 
    "factoryResetBlocked", 
    "googleAccountBlockAutoSync", 
    "googlePlayStoreBlocked", 
    "kioskModeApps", 
    "kioskModeBlockSleepButton", 
    "kioskModeBlockVolumeButtons", 
    "locationServicesBlocked", 
    "nfcBlocked", 
    "passwordBlockFingerprintUnlock", 
    "passwordBlockTrustAgents", 
    "passwordExpirationDays", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordPreviousPasswordBlockCount", 
    "passwordRequired", 
    "passwordRequiredType", 
    "passwordSignInFailureCountBeforeFactoryReset", 
    "powerOffBlocked", 
    "requiredPasswordComplexity", 
    "screenCaptureBlocked", 
    "securityRequireVerifyApps", 
    "storageBlockGoogleBackup", 
    "storageBlockRemovableStorage", 
    "storageRequireDeviceEncryption", 
    "storageRequireRemovableStorageEncryption", 
    "voiceAssistantBlocked", 
    "voiceDialingBlocked", 
    "webBrowserBlockAutofill", 
    "webBrowserBlocked", 
    "webBrowserBlockJavaScript", 
    "webBrowserBlockPopups", 
    "webBrowserCookieSettings", 
    "wiFiBlocked"})
@JsonInclude(Include.NON_NULL)
public class AndroidGeneralDeviceConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidGeneralDeviceConfiguration";
    }

    @JsonProperty("appsBlockClipboardSharing")
    protected Boolean appsBlockClipboardSharing;

    @JsonProperty("appsBlockCopyPaste")
    protected Boolean appsBlockCopyPaste;

    @JsonProperty("appsBlockYouTube")
    protected Boolean appsBlockYouTube;

    @JsonProperty("appsHideList")
    protected List<AppListItem> appsHideList;

    @JsonProperty("appsHideList@nextLink")
    protected String appsHideListNextLink;

    @JsonProperty("appsInstallAllowList")
    protected List<AppListItem> appsInstallAllowList;

    @JsonProperty("appsInstallAllowList@nextLink")
    protected String appsInstallAllowListNextLink;

    @JsonProperty("appsLaunchBlockList")
    protected List<AppListItem> appsLaunchBlockList;

    @JsonProperty("appsLaunchBlockList@nextLink")
    protected String appsLaunchBlockListNextLink;

    @JsonProperty("bluetoothBlocked")
    protected Boolean bluetoothBlocked;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("cellularBlockDataRoaming")
    protected Boolean cellularBlockDataRoaming;

    @JsonProperty("cellularBlockMessaging")
    protected Boolean cellularBlockMessaging;

    @JsonProperty("cellularBlockVoiceRoaming")
    protected Boolean cellularBlockVoiceRoaming;

    @JsonProperty("cellularBlockWiFiTethering")
    protected Boolean cellularBlockWiFiTethering;

    @JsonProperty("compliantAppListType")
    protected AppListType compliantAppListType;

    @JsonProperty("compliantAppsList")
    protected List<AppListItem> compliantAppsList;

    @JsonProperty("compliantAppsList@nextLink")
    protected String compliantAppsListNextLink;

    @JsonProperty("dateAndTimeBlockChanges")
    protected Boolean dateAndTimeBlockChanges;

    @JsonProperty("deviceSharingAllowed")
    protected Boolean deviceSharingAllowed;

    @JsonProperty("diagnosticDataBlockSubmission")
    protected Boolean diagnosticDataBlockSubmission;

    @JsonProperty("factoryResetBlocked")
    protected Boolean factoryResetBlocked;

    @JsonProperty("googleAccountBlockAutoSync")
    protected Boolean googleAccountBlockAutoSync;

    @JsonProperty("googlePlayStoreBlocked")
    protected Boolean googlePlayStoreBlocked;

    @JsonProperty("kioskModeApps")
    protected List<AppListItem> kioskModeApps;

    @JsonProperty("kioskModeApps@nextLink")
    protected String kioskModeAppsNextLink;

    @JsonProperty("kioskModeBlockSleepButton")
    protected Boolean kioskModeBlockSleepButton;

    @JsonProperty("kioskModeBlockVolumeButtons")
    protected Boolean kioskModeBlockVolumeButtons;

    @JsonProperty("locationServicesBlocked")
    protected Boolean locationServicesBlocked;

    @JsonProperty("nfcBlocked")
    protected Boolean nfcBlocked;

    @JsonProperty("passwordBlockFingerprintUnlock")
    protected Boolean passwordBlockFingerprintUnlock;

    @JsonProperty("passwordBlockTrustAgents")
    protected Boolean passwordBlockTrustAgents;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordPreviousPasswordBlockCount")
    protected Integer passwordPreviousPasswordBlockCount;

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordRequiredType")
    protected AndroidRequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordSignInFailureCountBeforeFactoryReset")
    protected Integer passwordSignInFailureCountBeforeFactoryReset;

    @JsonProperty("powerOffBlocked")
    protected Boolean powerOffBlocked;

    @JsonProperty("requiredPasswordComplexity")
    protected AndroidRequiredPasswordComplexity requiredPasswordComplexity;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("securityRequireVerifyApps")
    protected Boolean securityRequireVerifyApps;

    @JsonProperty("storageBlockGoogleBackup")
    protected Boolean storageBlockGoogleBackup;

    @JsonProperty("storageBlockRemovableStorage")
    protected Boolean storageBlockRemovableStorage;

    @JsonProperty("storageRequireDeviceEncryption")
    protected Boolean storageRequireDeviceEncryption;

    @JsonProperty("storageRequireRemovableStorageEncryption")
    protected Boolean storageRequireRemovableStorageEncryption;

    @JsonProperty("voiceAssistantBlocked")
    protected Boolean voiceAssistantBlocked;

    @JsonProperty("voiceDialingBlocked")
    protected Boolean voiceDialingBlocked;

    @JsonProperty("webBrowserBlockAutofill")
    protected Boolean webBrowserBlockAutofill;

    @JsonProperty("webBrowserBlocked")
    protected Boolean webBrowserBlocked;

    @JsonProperty("webBrowserBlockJavaScript")
    protected Boolean webBrowserBlockJavaScript;

    @JsonProperty("webBrowserBlockPopups")
    protected Boolean webBrowserBlockPopups;

    @JsonProperty("webBrowserCookieSettings")
    protected WebBrowserCookieSettings webBrowserCookieSettings;

    @JsonProperty("wiFiBlocked")
    protected Boolean wiFiBlocked;

    protected AndroidGeneralDeviceConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidGeneralDeviceConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean appsBlockClipboardSharing;
        private Boolean appsBlockCopyPaste;
        private Boolean appsBlockYouTube;
        private List<AppListItem> appsHideList;
        private String appsHideListNextLink;
        private List<AppListItem> appsInstallAllowList;
        private String appsInstallAllowListNextLink;
        private List<AppListItem> appsLaunchBlockList;
        private String appsLaunchBlockListNextLink;
        private Boolean bluetoothBlocked;
        private Boolean cameraBlocked;
        private Boolean cellularBlockDataRoaming;
        private Boolean cellularBlockMessaging;
        private Boolean cellularBlockVoiceRoaming;
        private Boolean cellularBlockWiFiTethering;
        private AppListType compliantAppListType;
        private List<AppListItem> compliantAppsList;
        private String compliantAppsListNextLink;
        private Boolean dateAndTimeBlockChanges;
        private Boolean deviceSharingAllowed;
        private Boolean diagnosticDataBlockSubmission;
        private Boolean factoryResetBlocked;
        private Boolean googleAccountBlockAutoSync;
        private Boolean googlePlayStoreBlocked;
        private List<AppListItem> kioskModeApps;
        private String kioskModeAppsNextLink;
        private Boolean kioskModeBlockSleepButton;
        private Boolean kioskModeBlockVolumeButtons;
        private Boolean locationServicesBlocked;
        private Boolean nfcBlocked;
        private Boolean passwordBlockFingerprintUnlock;
        private Boolean passwordBlockTrustAgents;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private Integer passwordPreviousPasswordBlockCount;
        private Boolean passwordRequired;
        private AndroidRequiredPasswordType passwordRequiredType;
        private Integer passwordSignInFailureCountBeforeFactoryReset;
        private Boolean powerOffBlocked;
        private AndroidRequiredPasswordComplexity requiredPasswordComplexity;
        private Boolean screenCaptureBlocked;
        private Boolean securityRequireVerifyApps;
        private Boolean storageBlockGoogleBackup;
        private Boolean storageBlockRemovableStorage;
        private Boolean storageRequireDeviceEncryption;
        private Boolean storageRequireRemovableStorageEncryption;
        private Boolean voiceAssistantBlocked;
        private Boolean voiceDialingBlocked;
        private Boolean webBrowserBlockAutofill;
        private Boolean webBrowserBlocked;
        private Boolean webBrowserBlockJavaScript;
        private Boolean webBrowserBlockPopups;
        private WebBrowserCookieSettings webBrowserCookieSettings;
        private Boolean wiFiBlocked;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block clipboard sharing to copy and paste between
         * applications.”</i>
         * 
         * @param appsBlockClipboardSharing
         *            value of {@code appsBlockClipboardSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsBlockClipboardSharing(Boolean appsBlockClipboardSharing) {
            this.appsBlockClipboardSharing = appsBlockClipboardSharing;
            this.changedFields = changedFields.add("appsBlockClipboardSharing");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block copy and paste within applications.”</i>
         * 
         * @param appsBlockCopyPaste
         *            value of {@code appsBlockCopyPaste} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsBlockCopyPaste(Boolean appsBlockCopyPaste) {
            this.appsBlockCopyPaste = appsBlockCopyPaste;
            this.changedFields = changedFields.add("appsBlockCopyPaste");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the YouTube app.”</i>
         * 
         * @param appsBlockYouTube
         *            value of {@code appsBlockYouTube} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsBlockYouTube(Boolean appsBlockYouTube) {
            this.appsBlockYouTube = appsBlockYouTube;
            this.changedFields = changedFields.add("appsBlockYouTube");
            return this;
        }

        /**
         * <i>“List of apps to be hidden on the KNOX device. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param appsHideList
         *            value of {@code appsHideList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsHideList(List<AppListItem> appsHideList) {
            this.appsHideList = appsHideList;
            this.changedFields = changedFields.add("appsHideList");
            return this;
        }

        /**
         * <i>“List of apps to be hidden on the KNOX device. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param appsHideList
         *            value of {@code appsHideList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsHideList(AppListItem... appsHideList) {
            return appsHideList(Arrays.asList(appsHideList));
        }

        /**
         * <i>“List of apps to be hidden on the KNOX device. This collection can contain a
         * maximum of 500 elements.”</i>
         * 
         * @param appsHideListNextLink
         *            value of {@code appsHideList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsHideListNextLink(String appsHideListNextLink) {
            this.appsHideListNextLink = appsHideListNextLink;
            this.changedFields = changedFields.add("appsHideList");
            return this;
        }

        /**
         * <i>“List of apps which can be installed on the KNOX device. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param appsInstallAllowList
         *            value of {@code appsInstallAllowList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsInstallAllowList(List<AppListItem> appsInstallAllowList) {
            this.appsInstallAllowList = appsInstallAllowList;
            this.changedFields = changedFields.add("appsInstallAllowList");
            return this;
        }

        /**
         * <i>“List of apps which can be installed on the KNOX device. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param appsInstallAllowList
         *            value of {@code appsInstallAllowList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsInstallAllowList(AppListItem... appsInstallAllowList) {
            return appsInstallAllowList(Arrays.asList(appsInstallAllowList));
        }

        /**
         * <i>“List of apps which can be installed on the KNOX device. This collection can
         * contain a maximum of 500 elements.”</i>
         * 
         * @param appsInstallAllowListNextLink
         *            value of {@code appsInstallAllowList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsInstallAllowListNextLink(String appsInstallAllowListNextLink) {
            this.appsInstallAllowListNextLink = appsInstallAllowListNextLink;
            this.changedFields = changedFields.add("appsInstallAllowList");
            return this;
        }

        /**
         * <i>“List of apps which are blocked from being launched on the KNOX device. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param appsLaunchBlockList
         *            value of {@code appsLaunchBlockList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsLaunchBlockList(List<AppListItem> appsLaunchBlockList) {
            this.appsLaunchBlockList = appsLaunchBlockList;
            this.changedFields = changedFields.add("appsLaunchBlockList");
            return this;
        }

        /**
         * <i>“List of apps which are blocked from being launched on the KNOX device. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param appsLaunchBlockList
         *            value of {@code appsLaunchBlockList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsLaunchBlockList(AppListItem... appsLaunchBlockList) {
            return appsLaunchBlockList(Arrays.asList(appsLaunchBlockList));
        }

        /**
         * <i>“List of apps which are blocked from being launched on the KNOX device. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param appsLaunchBlockListNextLink
         *            value of {@code appsLaunchBlockList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsLaunchBlockListNextLink(String appsLaunchBlockListNextLink) {
            this.appsLaunchBlockListNextLink = appsLaunchBlockListNextLink;
            this.changedFields = changedFields.add("appsLaunchBlockList");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Bluetooth.”</i>
         * 
         * @param bluetoothBlocked
         *            value of {@code bluetoothBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlocked(Boolean bluetoothBlocked) {
            this.bluetoothBlocked = bluetoothBlocked;
            this.changedFields = changedFields.add("bluetoothBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the use of the camera.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block data roaming.”</i>
         * 
         * @param cellularBlockDataRoaming
         *            value of {@code cellularBlockDataRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockDataRoaming(Boolean cellularBlockDataRoaming) {
            this.cellularBlockDataRoaming = cellularBlockDataRoaming;
            this.changedFields = changedFields.add("cellularBlockDataRoaming");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block SMS/MMS messaging.”</i>
         * 
         * @param cellularBlockMessaging
         *            value of {@code cellularBlockMessaging} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockMessaging(Boolean cellularBlockMessaging) {
            this.cellularBlockMessaging = cellularBlockMessaging;
            this.changedFields = changedFields.add("cellularBlockMessaging");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block voice roaming.”</i>
         * 
         * @param cellularBlockVoiceRoaming
         *            value of {@code cellularBlockVoiceRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockVoiceRoaming(Boolean cellularBlockVoiceRoaming) {
            this.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
            this.changedFields = changedFields.add("cellularBlockVoiceRoaming");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block syncing Wi-Fi tethering.”</i>
         * 
         * @param cellularBlockWiFiTethering
         *            value of {@code cellularBlockWiFiTethering} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockWiFiTethering(Boolean cellularBlockWiFiTethering) {
            this.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
            this.changedFields = changedFields.add("cellularBlockWiFiTethering");
            return this;
        }

        /**
         * <i>“Type of list that is in the CompliantAppsList.”</i>
         * 
         * @param compliantAppListType
         *            value of {@code compliantAppListType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppListType(AppListType compliantAppListType) {
            this.compliantAppListType = compliantAppListType;
            this.changedFields = changedFields.add("compliantAppListType");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(List<AppListItem> compliantAppsList) {
            this.compliantAppsList = compliantAppsList;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsList
         *            value of {@code compliantAppsList} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsList(AppListItem... compliantAppsList) {
            return compliantAppsList(Arrays.asList(compliantAppsList));
        }

        /**
         * <i>“List of apps in the compliance (either allow list or block list, controlled by
         * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
         * 
         * @param compliantAppsListNextLink
         *            value of {@code compliantAppsList@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliantAppsListNextLink(String compliantAppsListNextLink) {
            this.compliantAppsListNextLink = compliantAppsListNextLink;
            this.changedFields = changedFields.add("compliantAppsList");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block changing date and time while in KNOX Mode.”</i>
         * 
         * @param dateAndTimeBlockChanges
         *            value of {@code dateAndTimeBlockChanges} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dateAndTimeBlockChanges(Boolean dateAndTimeBlockChanges) {
            this.dateAndTimeBlockChanges = dateAndTimeBlockChanges;
            this.changedFields = changedFields.add("dateAndTimeBlockChanges");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow device sharing mode.”</i>
         * 
         * @param deviceSharingAllowed
         *            value of {@code deviceSharingAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceSharingAllowed(Boolean deviceSharingAllowed) {
            this.deviceSharingAllowed = deviceSharingAllowed;
            this.changedFields = changedFields.add("deviceSharingAllowed");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block diagnostic data submission.”</i>
         * 
         * @param diagnosticDataBlockSubmission
         *            value of {@code diagnosticDataBlockSubmission} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder diagnosticDataBlockSubmission(Boolean diagnosticDataBlockSubmission) {
            this.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
            this.changedFields = changedFields.add("diagnosticDataBlockSubmission");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block user performing a factory reset.”</i>
         * 
         * @param factoryResetBlocked
         *            value of {@code factoryResetBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder factoryResetBlocked(Boolean factoryResetBlocked) {
            this.factoryResetBlocked = factoryResetBlocked;
            this.changedFields = changedFields.add("factoryResetBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Google account auto sync.”</i>
         * 
         * @param googleAccountBlockAutoSync
         *            value of {@code googleAccountBlockAutoSync} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder googleAccountBlockAutoSync(Boolean googleAccountBlockAutoSync) {
            this.googleAccountBlockAutoSync = googleAccountBlockAutoSync;
            this.changedFields = changedFields.add("googleAccountBlockAutoSync");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the Google Play store.”</i>
         * 
         * @param googlePlayStoreBlocked
         *            value of {@code googlePlayStoreBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder googlePlayStoreBlocked(Boolean googlePlayStoreBlocked) {
            this.googlePlayStoreBlocked = googlePlayStoreBlocked;
            this.changedFields = changedFields.add("googlePlayStoreBlocked");
            return this;
        }

        /**
         * <i>“A list of apps that will be allowed to run when the device is in Kiosk Mode.
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeApps
         *            value of {@code kioskModeApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeApps(List<AppListItem> kioskModeApps) {
            this.kioskModeApps = kioskModeApps;
            this.changedFields = changedFields.add("kioskModeApps");
            return this;
        }

        /**
         * <i>“A list of apps that will be allowed to run when the device is in Kiosk Mode.
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeApps
         *            value of {@code kioskModeApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeApps(AppListItem... kioskModeApps) {
            return kioskModeApps(Arrays.asList(kioskModeApps));
        }

        /**
         * <i>“A list of apps that will be allowed to run when the device is in Kiosk Mode.
         * This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeAppsNextLink
         *            value of {@code kioskModeApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAppsNextLink(String kioskModeAppsNextLink) {
            this.kioskModeAppsNextLink = kioskModeAppsNextLink;
            this.changedFields = changedFields.add("kioskModeApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the screen sleep button while in Kiosk Mode.”</i>
         * 
         * @param kioskModeBlockSleepButton
         *            value of {@code kioskModeBlockSleepButton} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockSleepButton(Boolean kioskModeBlockSleepButton) {
            this.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
            this.changedFields = changedFields.add("kioskModeBlockSleepButton");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the volume buttons while in Kiosk Mode.”</i>
         * 
         * @param kioskModeBlockVolumeButtons
         *            value of {@code kioskModeBlockVolumeButtons} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBlockVolumeButtons(Boolean kioskModeBlockVolumeButtons) {
            this.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
            this.changedFields = changedFields.add("kioskModeBlockVolumeButtons");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block location services.”</i>
         * 
         * @param locationServicesBlocked
         *            value of {@code locationServicesBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder locationServicesBlocked(Boolean locationServicesBlocked) {
            this.locationServicesBlocked = locationServicesBlocked;
            this.changedFields = changedFields.add("locationServicesBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Near-Field Communication.”</i>
         * 
         * @param nfcBlocked
         *            value of {@code nfcBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nfcBlocked(Boolean nfcBlocked) {
            this.nfcBlocked = nfcBlocked;
            this.changedFields = changedFields.add("nfcBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block fingerprint unlock.”</i>
         * 
         * @param passwordBlockFingerprintUnlock
         *            value of {@code passwordBlockFingerprintUnlock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockFingerprintUnlock(Boolean passwordBlockFingerprintUnlock) {
            this.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
            this.changedFields = changedFields.add("passwordBlockFingerprintUnlock");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Smart Lock and other trust agents.”</i>
         * 
         * @param passwordBlockTrustAgents
         *            value of {@code passwordBlockTrustAgents} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockTrustAgents(Boolean passwordBlockTrustAgents) {
            this.passwordBlockTrustAgents = passwordBlockTrustAgents;
            this.changedFields = changedFields.add("passwordBlockTrustAgents");
            return this;
        }

        /**
         * <i>“Number of days before the password expires. Valid values 1 to 365”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Minimum length of passwords. Valid values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before the screen times out.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Number of previous passwords to block. Valid values 0 to 24”</i>
         * 
         * @param passwordPreviousPasswordBlockCount
         *            value of {@code passwordPreviousPasswordBlockCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
            this.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            this.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require a password.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Type of password that is required.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(AndroidRequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Number of sign in failures allowed before factory reset. Valid values 1 to 16”</i>
         * 
         * @param passwordSignInFailureCountBeforeFactoryReset
         *            value of {@code passwordSignInFailureCountBeforeFactoryReset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
            this.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            this.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block powering off the device.”</i>
         * 
         * @param powerOffBlocked
         *            value of {@code powerOffBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder powerOffBlocked(Boolean powerOffBlocked) {
            this.powerOffBlocked = powerOffBlocked;
            this.changedFields = changedFields.add("powerOffBlocked");
            return this;
        }

        /**
         * <i>“Indicates the required password complexity on Android. One of: NONE, LOW, MEDIUM
         * , HIGH. This is an API targeted to Android 11+.”</i>
         * 
         * @param requiredPasswordComplexity
         *            value of {@code requiredPasswordComplexity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredPasswordComplexity(AndroidRequiredPasswordComplexity requiredPasswordComplexity) {
            this.requiredPasswordComplexity = requiredPasswordComplexity;
            this.changedFields = changedFields.add("requiredPasswordComplexity");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Require the Android Verify apps feature is turned on.”</i>
         * 
         * @param securityRequireVerifyApps
         *            value of {@code securityRequireVerifyApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityRequireVerifyApps(Boolean securityRequireVerifyApps) {
            this.securityRequireVerifyApps = securityRequireVerifyApps;
            this.changedFields = changedFields.add("securityRequireVerifyApps");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Google Backup.”</i>
         * 
         * @param storageBlockGoogleBackup
         *            value of {@code storageBlockGoogleBackup} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockGoogleBackup(Boolean storageBlockGoogleBackup) {
            this.storageBlockGoogleBackup = storageBlockGoogleBackup;
            this.changedFields = changedFields.add("storageBlockGoogleBackup");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block removable storage usage.”</i>
         * 
         * @param storageBlockRemovableStorage
         *            value of {@code storageBlockRemovableStorage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockRemovableStorage(Boolean storageBlockRemovableStorage) {
            this.storageBlockRemovableStorage = storageBlockRemovableStorage;
            this.changedFields = changedFields.add("storageBlockRemovableStorage");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require device encryption.”</i>
         * 
         * @param storageRequireDeviceEncryption
         *            value of {@code storageRequireDeviceEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireDeviceEncryption(Boolean storageRequireDeviceEncryption) {
            this.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
            this.changedFields = changedFields.add("storageRequireDeviceEncryption");
            return this;
        }

        /**
         * <i>“Indicates whether or not to require removable storage encryption.”</i>
         * 
         * @param storageRequireRemovableStorageEncryption
         *            value of {@code storageRequireRemovableStorageEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireRemovableStorageEncryption(Boolean storageRequireRemovableStorageEncryption) {
            this.storageRequireRemovableStorageEncryption = storageRequireRemovableStorageEncryption;
            this.changedFields = changedFields.add("storageRequireRemovableStorageEncryption");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the use of the Voice Assistant.”</i>
         * 
         * @param voiceAssistantBlocked
         *            value of {@code voiceAssistantBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder voiceAssistantBlocked(Boolean voiceAssistantBlocked) {
            this.voiceAssistantBlocked = voiceAssistantBlocked;
            this.changedFields = changedFields.add("voiceAssistantBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block voice dialing.”</i>
         * 
         * @param voiceDialingBlocked
         *            value of {@code voiceDialingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder voiceDialingBlocked(Boolean voiceDialingBlocked) {
            this.voiceDialingBlocked = voiceDialingBlocked;
            this.changedFields = changedFields.add("voiceDialingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the web browser's auto fill feature.”</i>
         * 
         * @param webBrowserBlockAutofill
         *            value of {@code webBrowserBlockAutofill} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webBrowserBlockAutofill(Boolean webBrowserBlockAutofill) {
            this.webBrowserBlockAutofill = webBrowserBlockAutofill;
            this.changedFields = changedFields.add("webBrowserBlockAutofill");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the web browser.”</i>
         * 
         * @param webBrowserBlocked
         *            value of {@code webBrowserBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webBrowserBlocked(Boolean webBrowserBlocked) {
            this.webBrowserBlocked = webBrowserBlocked;
            this.changedFields = changedFields.add("webBrowserBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block JavaScript within the web browser.”</i>
         * 
         * @param webBrowserBlockJavaScript
         *            value of {@code webBrowserBlockJavaScript} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webBrowserBlockJavaScript(Boolean webBrowserBlockJavaScript) {
            this.webBrowserBlockJavaScript = webBrowserBlockJavaScript;
            this.changedFields = changedFields.add("webBrowserBlockJavaScript");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block popups within the web browser.”</i>
         * 
         * @param webBrowserBlockPopups
         *            value of {@code webBrowserBlockPopups} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webBrowserBlockPopups(Boolean webBrowserBlockPopups) {
            this.webBrowserBlockPopups = webBrowserBlockPopups;
            this.changedFields = changedFields.add("webBrowserBlockPopups");
            return this;
        }

        /**
         * <i>“Cookie settings within the web browser.”</i>
         * 
         * @param webBrowserCookieSettings
         *            value of {@code webBrowserCookieSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webBrowserCookieSettings(WebBrowserCookieSettings webBrowserCookieSettings) {
            this.webBrowserCookieSettings = webBrowserCookieSettings;
            this.changedFields = changedFields.add("webBrowserCookieSettings");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block syncing Wi-Fi.”</i>
         * 
         * @param wiFiBlocked
         *            value of {@code wiFiBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiBlocked(Boolean wiFiBlocked) {
            this.wiFiBlocked = wiFiBlocked;
            this.changedFields = changedFields.add("wiFiBlocked");
            return this;
        }

        public AndroidGeneralDeviceConfiguration build() {
            AndroidGeneralDeviceConfiguration _x = new AndroidGeneralDeviceConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidGeneralDeviceConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.appsBlockClipboardSharing = appsBlockClipboardSharing;
            _x.appsBlockCopyPaste = appsBlockCopyPaste;
            _x.appsBlockYouTube = appsBlockYouTube;
            _x.appsHideList = appsHideList;
            _x.appsHideListNextLink = appsHideListNextLink;
            _x.appsInstallAllowList = appsInstallAllowList;
            _x.appsInstallAllowListNextLink = appsInstallAllowListNextLink;
            _x.appsLaunchBlockList = appsLaunchBlockList;
            _x.appsLaunchBlockListNextLink = appsLaunchBlockListNextLink;
            _x.bluetoothBlocked = bluetoothBlocked;
            _x.cameraBlocked = cameraBlocked;
            _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
            _x.cellularBlockMessaging = cellularBlockMessaging;
            _x.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
            _x.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
            _x.compliantAppListType = compliantAppListType;
            _x.compliantAppsList = compliantAppsList;
            _x.compliantAppsListNextLink = compliantAppsListNextLink;
            _x.dateAndTimeBlockChanges = dateAndTimeBlockChanges;
            _x.deviceSharingAllowed = deviceSharingAllowed;
            _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
            _x.factoryResetBlocked = factoryResetBlocked;
            _x.googleAccountBlockAutoSync = googleAccountBlockAutoSync;
            _x.googlePlayStoreBlocked = googlePlayStoreBlocked;
            _x.kioskModeApps = kioskModeApps;
            _x.kioskModeAppsNextLink = kioskModeAppsNextLink;
            _x.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
            _x.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
            _x.locationServicesBlocked = locationServicesBlocked;
            _x.nfcBlocked = nfcBlocked;
            _x.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
            _x.passwordBlockTrustAgents = passwordBlockTrustAgents;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
            _x.passwordRequired = passwordRequired;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            _x.powerOffBlocked = powerOffBlocked;
            _x.requiredPasswordComplexity = requiredPasswordComplexity;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.securityRequireVerifyApps = securityRequireVerifyApps;
            _x.storageBlockGoogleBackup = storageBlockGoogleBackup;
            _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
            _x.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
            _x.storageRequireRemovableStorageEncryption = storageRequireRemovableStorageEncryption;
            _x.voiceAssistantBlocked = voiceAssistantBlocked;
            _x.voiceDialingBlocked = voiceDialingBlocked;
            _x.webBrowserBlockAutofill = webBrowserBlockAutofill;
            _x.webBrowserBlocked = webBrowserBlocked;
            _x.webBrowserBlockJavaScript = webBrowserBlockJavaScript;
            _x.webBrowserBlockPopups = webBrowserBlockPopups;
            _x.webBrowserCookieSettings = webBrowserCookieSettings;
            _x.wiFiBlocked = wiFiBlocked;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Indicates whether or not to block clipboard sharing to copy and paste between
     * applications.”</i>
     * 
     * @return property appsBlockClipboardSharing
     */
    @Property(name="appsBlockClipboardSharing")
    @JsonIgnore
    public Optional<Boolean> getAppsBlockClipboardSharing() {
        return Optional.ofNullable(appsBlockClipboardSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsBlockClipboardSharing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block clipboard sharing to copy and paste between
     * applications.”</i>
     * 
     * @param appsBlockClipboardSharing
     *            new value of {@code appsBlockClipboardSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsBlockClipboardSharing} field changed
     */
    public AndroidGeneralDeviceConfiguration withAppsBlockClipboardSharing(Boolean appsBlockClipboardSharing) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsBlockClipboardSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.appsBlockClipboardSharing = appsBlockClipboardSharing;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block copy and paste within applications.”</i>
     * 
     * @return property appsBlockCopyPaste
     */
    @Property(name="appsBlockCopyPaste")
    @JsonIgnore
    public Optional<Boolean> getAppsBlockCopyPaste() {
        return Optional.ofNullable(appsBlockCopyPaste);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsBlockCopyPaste} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block copy and paste within applications.”</i>
     * 
     * @param appsBlockCopyPaste
     *            new value of {@code appsBlockCopyPaste} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsBlockCopyPaste} field changed
     */
    public AndroidGeneralDeviceConfiguration withAppsBlockCopyPaste(Boolean appsBlockCopyPaste) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsBlockCopyPaste");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.appsBlockCopyPaste = appsBlockCopyPaste;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the YouTube app.”</i>
     * 
     * @return property appsBlockYouTube
     */
    @Property(name="appsBlockYouTube")
    @JsonIgnore
    public Optional<Boolean> getAppsBlockYouTube() {
        return Optional.ofNullable(appsBlockYouTube);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appsBlockYouTube}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the YouTube app.”</i>
     * 
     * @param appsBlockYouTube
     *            new value of {@code appsBlockYouTube} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsBlockYouTube} field changed
     */
    public AndroidGeneralDeviceConfiguration withAppsBlockYouTube(Boolean appsBlockYouTube) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsBlockYouTube");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.appsBlockYouTube = appsBlockYouTube;
        return _x;
    }

    /**
     * <i>“List of apps to be hidden on the KNOX device. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @return property appsHideList
     */
    @Property(name="appsHideList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsHideList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.appsHideList, Optional.ofNullable(appsHideListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appsHideList}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of apps to be hidden on the KNOX device. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @param appsHideList
     *            new value of {@code appsHideList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsHideList} field changed
     */
    public AndroidGeneralDeviceConfiguration withAppsHideList(List<AppListItem> appsHideList) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsHideList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.appsHideList = appsHideList;
        return _x;
    }

    /**
     * <i>“List of apps to be hidden on the KNOX device. This collection can contain a
     * maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appsHideList
     */
    @Property(name="appsHideList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsHideList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.appsHideList, Optional.ofNullable(appsHideListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of apps which can be installed on the KNOX device. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property appsInstallAllowList
     */
    @Property(name="appsInstallAllowList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsInstallAllowList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.appsInstallAllowList, Optional.ofNullable(appsInstallAllowListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsInstallAllowList} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of apps which can be installed on the KNOX device. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param appsInstallAllowList
     *            new value of {@code appsInstallAllowList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsInstallAllowList} field changed
     */
    public AndroidGeneralDeviceConfiguration withAppsInstallAllowList(List<AppListItem> appsInstallAllowList) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsInstallAllowList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.appsInstallAllowList = appsInstallAllowList;
        return _x;
    }

    /**
     * <i>“List of apps which can be installed on the KNOX device. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appsInstallAllowList
     */
    @Property(name="appsInstallAllowList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsInstallAllowList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.appsInstallAllowList, Optional.ofNullable(appsInstallAllowListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“List of apps which are blocked from being launched on the KNOX device. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property appsLaunchBlockList
     */
    @Property(name="appsLaunchBlockList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsLaunchBlockList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.appsLaunchBlockList, Optional.ofNullable(appsLaunchBlockListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsLaunchBlockList} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“List of apps which are blocked from being launched on the KNOX device. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @param appsLaunchBlockList
     *            new value of {@code appsLaunchBlockList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsLaunchBlockList} field changed
     */
    public AndroidGeneralDeviceConfiguration withAppsLaunchBlockList(List<AppListItem> appsLaunchBlockList) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsLaunchBlockList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.appsLaunchBlockList = appsLaunchBlockList;
        return _x;
    }

    /**
     * <i>“List of apps which are blocked from being launched on the KNOX device. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property appsLaunchBlockList
     */
    @Property(name="appsLaunchBlockList")
    @JsonIgnore
    public CollectionPage<AppListItem> getAppsLaunchBlockList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.appsLaunchBlockList, Optional.ofNullable(appsLaunchBlockListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to block Bluetooth.”</i>
     * 
     * @return property bluetoothBlocked
     */
    @Property(name="bluetoothBlocked")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlocked() {
        return Optional.ofNullable(bluetoothBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bluetoothBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block Bluetooth.”</i>
     * 
     * @param bluetoothBlocked
     *            new value of {@code bluetoothBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withBluetoothBlocked(Boolean bluetoothBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.bluetoothBlocked = bluetoothBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the use of the camera.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the use of the camera.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withCameraBlocked(Boolean cameraBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block data roaming.”</i>
     * 
     * @return property cellularBlockDataRoaming
     */
    @Property(name="cellularBlockDataRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockDataRoaming() {
        return Optional.ofNullable(cellularBlockDataRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockDataRoaming} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block data roaming.”</i>
     * 
     * @param cellularBlockDataRoaming
     *            new value of {@code cellularBlockDataRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockDataRoaming} field changed
     */
    public AndroidGeneralDeviceConfiguration withCellularBlockDataRoaming(Boolean cellularBlockDataRoaming) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockDataRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block SMS/MMS messaging.”</i>
     * 
     * @return property cellularBlockMessaging
     */
    @Property(name="cellularBlockMessaging")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockMessaging() {
        return Optional.ofNullable(cellularBlockMessaging);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockMessaging} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block SMS/MMS messaging.”</i>
     * 
     * @param cellularBlockMessaging
     *            new value of {@code cellularBlockMessaging} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockMessaging} field changed
     */
    public AndroidGeneralDeviceConfiguration withCellularBlockMessaging(Boolean cellularBlockMessaging) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockMessaging");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.cellularBlockMessaging = cellularBlockMessaging;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block voice roaming.”</i>
     * 
     * @return property cellularBlockVoiceRoaming
     */
    @Property(name="cellularBlockVoiceRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockVoiceRoaming() {
        return Optional.ofNullable(cellularBlockVoiceRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockVoiceRoaming} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block voice roaming.”</i>
     * 
     * @param cellularBlockVoiceRoaming
     *            new value of {@code cellularBlockVoiceRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockVoiceRoaming} field changed
     */
    public AndroidGeneralDeviceConfiguration withCellularBlockVoiceRoaming(Boolean cellularBlockVoiceRoaming) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockVoiceRoaming");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block syncing Wi-Fi tethering.”</i>
     * 
     * @return property cellularBlockWiFiTethering
     */
    @Property(name="cellularBlockWiFiTethering")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockWiFiTethering() {
        return Optional.ofNullable(cellularBlockWiFiTethering);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockWiFiTethering} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block syncing Wi-Fi tethering.”</i>
     * 
     * @param cellularBlockWiFiTethering
     *            new value of {@code cellularBlockWiFiTethering} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockWiFiTethering} field changed
     */
    public AndroidGeneralDeviceConfiguration withCellularBlockWiFiTethering(Boolean cellularBlockWiFiTethering) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockWiFiTethering");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
        return _x;
    }

    /**
     * <i>“Type of list that is in the CompliantAppsList.”</i>
     * 
     * @return property compliantAppListType
     */
    @Property(name="compliantAppListType")
    @JsonIgnore
    public Optional<AppListType> getCompliantAppListType() {
        return Optional.ofNullable(compliantAppListType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliantAppListType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of list that is in the CompliantAppsList.”</i>
     * 
     * @param compliantAppListType
     *            new value of {@code compliantAppListType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantAppListType} field changed
     */
    public AndroidGeneralDeviceConfiguration withCompliantAppListType(AppListType compliantAppListType) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("compliantAppListType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.compliantAppListType = compliantAppListType;
        return _x;
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code compliantAppsList
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @param compliantAppsList
     *            new value of {@code compliantAppsList} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliantAppsList} field changed
     */
    public AndroidGeneralDeviceConfiguration withCompliantAppsList(List<AppListItem> compliantAppsList) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("compliantAppsList");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.compliantAppsList = compliantAppsList;
        return _x;
    }

    /**
     * <i>“List of apps in the compliance (either allow list or block list, controlled by
     * CompliantAppListType). This collection can contain a maximum of 10000 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property compliantAppsList
     */
    @Property(name="compliantAppsList")
    @JsonIgnore
    public CollectionPage<AppListItem> getCompliantAppsList(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.compliantAppsList, Optional.ofNullable(compliantAppsListNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to block changing date and time while in KNOX Mode.”</i>
     * 
     * @return property dateAndTimeBlockChanges
     */
    @Property(name="dateAndTimeBlockChanges")
    @JsonIgnore
    public Optional<Boolean> getDateAndTimeBlockChanges() {
        return Optional.ofNullable(dateAndTimeBlockChanges);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dateAndTimeBlockChanges} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block changing date and time while in KNOX Mode.”</i>
     * 
     * @param dateAndTimeBlockChanges
     *            new value of {@code dateAndTimeBlockChanges} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dateAndTimeBlockChanges} field changed
     */
    public AndroidGeneralDeviceConfiguration withDateAndTimeBlockChanges(Boolean dateAndTimeBlockChanges) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dateAndTimeBlockChanges");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.dateAndTimeBlockChanges = dateAndTimeBlockChanges;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to allow device sharing mode.”</i>
     * 
     * @return property deviceSharingAllowed
     */
    @Property(name="deviceSharingAllowed")
    @JsonIgnore
    public Optional<Boolean> getDeviceSharingAllowed() {
        return Optional.ofNullable(deviceSharingAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceSharingAllowed} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to allow device sharing mode.”</i>
     * 
     * @param deviceSharingAllowed
     *            new value of {@code deviceSharingAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSharingAllowed} field changed
     */
    public AndroidGeneralDeviceConfiguration withDeviceSharingAllowed(Boolean deviceSharingAllowed) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("deviceSharingAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.deviceSharingAllowed = deviceSharingAllowed;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @return property diagnosticDataBlockSubmission
     */
    @Property(name="diagnosticDataBlockSubmission")
    @JsonIgnore
    public Optional<Boolean> getDiagnosticDataBlockSubmission() {
        return Optional.ofNullable(diagnosticDataBlockSubmission);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * diagnosticDataBlockSubmission} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block diagnostic data submission.”</i>
     * 
     * @param diagnosticDataBlockSubmission
     *            new value of {@code diagnosticDataBlockSubmission} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code diagnosticDataBlockSubmission} field changed
     */
    public AndroidGeneralDeviceConfiguration withDiagnosticDataBlockSubmission(Boolean diagnosticDataBlockSubmission) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("diagnosticDataBlockSubmission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block user performing a factory reset.”</i>
     * 
     * @return property factoryResetBlocked
     */
    @Property(name="factoryResetBlocked")
    @JsonIgnore
    public Optional<Boolean> getFactoryResetBlocked() {
        return Optional.ofNullable(factoryResetBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * factoryResetBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block user performing a factory reset.”</i>
     * 
     * @param factoryResetBlocked
     *            new value of {@code factoryResetBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code factoryResetBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withFactoryResetBlocked(Boolean factoryResetBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("factoryResetBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.factoryResetBlocked = factoryResetBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Google account auto sync.”</i>
     * 
     * @return property googleAccountBlockAutoSync
     */
    @Property(name="googleAccountBlockAutoSync")
    @JsonIgnore
    public Optional<Boolean> getGoogleAccountBlockAutoSync() {
        return Optional.ofNullable(googleAccountBlockAutoSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * googleAccountBlockAutoSync} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Google account auto sync.”</i>
     * 
     * @param googleAccountBlockAutoSync
     *            new value of {@code googleAccountBlockAutoSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code googleAccountBlockAutoSync} field changed
     */
    public AndroidGeneralDeviceConfiguration withGoogleAccountBlockAutoSync(Boolean googleAccountBlockAutoSync) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("googleAccountBlockAutoSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.googleAccountBlockAutoSync = googleAccountBlockAutoSync;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the Google Play store.”</i>
     * 
     * @return property googlePlayStoreBlocked
     */
    @Property(name="googlePlayStoreBlocked")
    @JsonIgnore
    public Optional<Boolean> getGooglePlayStoreBlocked() {
        return Optional.ofNullable(googlePlayStoreBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * googlePlayStoreBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the Google Play store.”</i>
     * 
     * @param googlePlayStoreBlocked
     *            new value of {@code googlePlayStoreBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code googlePlayStoreBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withGooglePlayStoreBlocked(Boolean googlePlayStoreBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("googlePlayStoreBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.googlePlayStoreBlocked = googlePlayStoreBlocked;
        return _x;
    }

    /**
     * <i>“A list of apps that will be allowed to run when the device is in Kiosk Mode.
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property kioskModeApps
     */
    @Property(name="kioskModeApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getKioskModeApps() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.kioskModeApps, Optional.ofNullable(kioskModeAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code kioskModeApps}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A list of apps that will be allowed to run when the device is in Kiosk Mode.
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param kioskModeApps
     *            new value of {@code kioskModeApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeApps} field changed
     */
    public AndroidGeneralDeviceConfiguration withKioskModeApps(List<AppListItem> kioskModeApps) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.kioskModeApps = kioskModeApps;
        return _x;
    }

    /**
     * <i>“A list of apps that will be allowed to run when the device is in Kiosk Mode.
     * This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property kioskModeApps
     */
    @Property(name="kioskModeApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getKioskModeApps(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.kioskModeApps, Optional.ofNullable(kioskModeAppsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to block the screen sleep button while in Kiosk Mode.”</i>
     * 
     * @return property kioskModeBlockSleepButton
     */
    @Property(name="kioskModeBlockSleepButton")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockSleepButton() {
        return Optional.ofNullable(kioskModeBlockSleepButton);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockSleepButton} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the screen sleep button while in Kiosk Mode.”</i>
     * 
     * @param kioskModeBlockSleepButton
     *            new value of {@code kioskModeBlockSleepButton} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockSleepButton} field changed
     */
    public AndroidGeneralDeviceConfiguration withKioskModeBlockSleepButton(Boolean kioskModeBlockSleepButton) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockSleepButton");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the volume buttons while in Kiosk Mode.”</i>
     * 
     * @return property kioskModeBlockVolumeButtons
     */
    @Property(name="kioskModeBlockVolumeButtons")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBlockVolumeButtons() {
        return Optional.ofNullable(kioskModeBlockVolumeButtons);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBlockVolumeButtons} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the volume buttons while in Kiosk Mode.”</i>
     * 
     * @param kioskModeBlockVolumeButtons
     *            new value of {@code kioskModeBlockVolumeButtons} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBlockVolumeButtons} field changed
     */
    public AndroidGeneralDeviceConfiguration withKioskModeBlockVolumeButtons(Boolean kioskModeBlockVolumeButtons) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBlockVolumeButtons");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block location services.”</i>
     * 
     * @return property locationServicesBlocked
     */
    @Property(name="locationServicesBlocked")
    @JsonIgnore
    public Optional<Boolean> getLocationServicesBlocked() {
        return Optional.ofNullable(locationServicesBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * locationServicesBlocked} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block location services.”</i>
     * 
     * @param locationServicesBlocked
     *            new value of {@code locationServicesBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code locationServicesBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withLocationServicesBlocked(Boolean locationServicesBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("locationServicesBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.locationServicesBlocked = locationServicesBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Near-Field Communication.”</i>
     * 
     * @return property nfcBlocked
     */
    @Property(name="nfcBlocked")
    @JsonIgnore
    public Optional<Boolean> getNfcBlocked() {
        return Optional.ofNullable(nfcBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code nfcBlocked} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to block Near-Field Communication.”</i>
     * 
     * @param nfcBlocked
     *            new value of {@code nfcBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nfcBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withNfcBlocked(Boolean nfcBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("nfcBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.nfcBlocked = nfcBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block fingerprint unlock.”</i>
     * 
     * @return property passwordBlockFingerprintUnlock
     */
    @Property(name="passwordBlockFingerprintUnlock")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockFingerprintUnlock() {
        return Optional.ofNullable(passwordBlockFingerprintUnlock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockFingerprintUnlock} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block fingerprint unlock.”</i>
     * 
     * @param passwordBlockFingerprintUnlock
     *            new value of {@code passwordBlockFingerprintUnlock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockFingerprintUnlock} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordBlockFingerprintUnlock(Boolean passwordBlockFingerprintUnlock) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockFingerprintUnlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Smart Lock and other trust agents.”</i>
     * 
     * @return property passwordBlockTrustAgents
     */
    @Property(name="passwordBlockTrustAgents")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockTrustAgents() {
        return Optional.ofNullable(passwordBlockTrustAgents);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockTrustAgents} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Smart Lock and other trust agents.”</i>
     * 
     * @param passwordBlockTrustAgents
     *            new value of {@code passwordBlockTrustAgents} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockTrustAgents} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordBlockTrustAgents(Boolean passwordBlockTrustAgents) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockTrustAgents");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordBlockTrustAgents = passwordBlockTrustAgents;
        return _x;
    }

    /**
     * <i>“Number of days before the password expires. Valid values 1 to 365”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before the password expires. Valid values 1 to 365”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordExpirationDays(Integer passwordExpirationDays) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Minimum length of passwords. Valid values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum length of passwords. Valid values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before the screen times out.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Number of previous passwords to block. Valid values 0 to 24”</i>
     * 
     * @return property passwordPreviousPasswordBlockCount
     */
    @Property(name="passwordPreviousPasswordBlockCount")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordBlockCount() {
        return Optional.ofNullable(passwordPreviousPasswordBlockCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordBlockCount} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Number of previous passwords to block. Valid values 0 to 24”</i>
     * 
     * @param passwordPreviousPasswordBlockCount
     *            new value of {@code passwordPreviousPasswordBlockCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordBlockCount} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordPreviousPasswordBlockCount(Integer passwordPreviousPasswordBlockCount) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordBlockCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require a password.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to require a password.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordRequired(Boolean passwordRequired) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Type of password that is required.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<AndroidRequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of password that is required.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordRequiredType(AndroidRequiredPasswordType passwordRequiredType) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Number of sign in failures allowed before factory reset. Valid values 1 to 16”</i>
     * 
     * @return property passwordSignInFailureCountBeforeFactoryReset
     */
    @Property(name="passwordSignInFailureCountBeforeFactoryReset")
    @JsonIgnore
    public Optional<Integer> getPasswordSignInFailureCountBeforeFactoryReset() {
        return Optional.ofNullable(passwordSignInFailureCountBeforeFactoryReset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordSignInFailureCountBeforeFactoryReset} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of sign in failures allowed before factory reset. Valid values 1 to 16”</i>
     * 
     * @param passwordSignInFailureCountBeforeFactoryReset
     *            new value of {@code passwordSignInFailureCountBeforeFactoryReset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordSignInFailureCountBeforeFactoryReset} field changed
     */
    public AndroidGeneralDeviceConfiguration withPasswordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block powering off the device.”</i>
     * 
     * @return property powerOffBlocked
     */
    @Property(name="powerOffBlocked")
    @JsonIgnore
    public Optional<Boolean> getPowerOffBlocked() {
        return Optional.ofNullable(powerOffBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code powerOffBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block powering off the device.”</i>
     * 
     * @param powerOffBlocked
     *            new value of {@code powerOffBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code powerOffBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withPowerOffBlocked(Boolean powerOffBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("powerOffBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.powerOffBlocked = powerOffBlocked;
        return _x;
    }

    /**
     * <i>“Indicates the required password complexity on Android. One of: NONE, LOW, MEDIUM
     * , HIGH. This is an API targeted to Android 11+.”</i>
     * 
     * @return property requiredPasswordComplexity
     */
    @Property(name="requiredPasswordComplexity")
    @JsonIgnore
    public Optional<AndroidRequiredPasswordComplexity> getRequiredPasswordComplexity() {
        return Optional.ofNullable(requiredPasswordComplexity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredPasswordComplexity} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates the required password complexity on Android. One of: NONE, LOW, MEDIUM
     * , HIGH. This is an API targeted to Android 11+.”</i>
     * 
     * @param requiredPasswordComplexity
     *            new value of {@code requiredPasswordComplexity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredPasswordComplexity} field changed
     */
    public AndroidGeneralDeviceConfiguration withRequiredPasswordComplexity(AndroidRequiredPasswordComplexity requiredPasswordComplexity) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("requiredPasswordComplexity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.requiredPasswordComplexity = requiredPasswordComplexity;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Require the Android Verify apps feature is turned on.”</i>
     * 
     * @return property securityRequireVerifyApps
     */
    @Property(name="securityRequireVerifyApps")
    @JsonIgnore
    public Optional<Boolean> getSecurityRequireVerifyApps() {
        return Optional.ofNullable(securityRequireVerifyApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityRequireVerifyApps} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require the Android Verify apps feature is turned on.”</i>
     * 
     * @param securityRequireVerifyApps
     *            new value of {@code securityRequireVerifyApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityRequireVerifyApps} field changed
     */
    public AndroidGeneralDeviceConfiguration withSecurityRequireVerifyApps(Boolean securityRequireVerifyApps) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityRequireVerifyApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.securityRequireVerifyApps = securityRequireVerifyApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Google Backup.”</i>
     * 
     * @return property storageBlockGoogleBackup
     */
    @Property(name="storageBlockGoogleBackup")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockGoogleBackup() {
        return Optional.ofNullable(storageBlockGoogleBackup);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockGoogleBackup} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Google Backup.”</i>
     * 
     * @param storageBlockGoogleBackup
     *            new value of {@code storageBlockGoogleBackup} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockGoogleBackup} field changed
     */
    public AndroidGeneralDeviceConfiguration withStorageBlockGoogleBackup(Boolean storageBlockGoogleBackup) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockGoogleBackup");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.storageBlockGoogleBackup = storageBlockGoogleBackup;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block removable storage usage.”</i>
     * 
     * @return property storageBlockRemovableStorage
     */
    @Property(name="storageBlockRemovableStorage")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockRemovableStorage() {
        return Optional.ofNullable(storageBlockRemovableStorage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockRemovableStorage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block removable storage usage.”</i>
     * 
     * @param storageBlockRemovableStorage
     *            new value of {@code storageBlockRemovableStorage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockRemovableStorage} field changed
     */
    public AndroidGeneralDeviceConfiguration withStorageBlockRemovableStorage(Boolean storageBlockRemovableStorage) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockRemovableStorage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require device encryption.”</i>
     * 
     * @return property storageRequireDeviceEncryption
     */
    @Property(name="storageRequireDeviceEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireDeviceEncryption() {
        return Optional.ofNullable(storageRequireDeviceEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireDeviceEncryption} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require device encryption.”</i>
     * 
     * @param storageRequireDeviceEncryption
     *            new value of {@code storageRequireDeviceEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireDeviceEncryption} field changed
     */
    public AndroidGeneralDeviceConfiguration withStorageRequireDeviceEncryption(Boolean storageRequireDeviceEncryption) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRequireDeviceEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to require removable storage encryption.”</i>
     * 
     * @return property storageRequireRemovableStorageEncryption
     */
    @Property(name="storageRequireRemovableStorageEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireRemovableStorageEncryption() {
        return Optional.ofNullable(storageRequireRemovableStorageEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireRemovableStorageEncryption} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to require removable storage encryption.”</i>
     * 
     * @param storageRequireRemovableStorageEncryption
     *            new value of {@code storageRequireRemovableStorageEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireRemovableStorageEncryption} field changed
     */
    public AndroidGeneralDeviceConfiguration withStorageRequireRemovableStorageEncryption(Boolean storageRequireRemovableStorageEncryption) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageRequireRemovableStorageEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.storageRequireRemovableStorageEncryption = storageRequireRemovableStorageEncryption;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the use of the Voice Assistant.”</i>
     * 
     * @return property voiceAssistantBlocked
     */
    @Property(name="voiceAssistantBlocked")
    @JsonIgnore
    public Optional<Boolean> getVoiceAssistantBlocked() {
        return Optional.ofNullable(voiceAssistantBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * voiceAssistantBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the use of the Voice Assistant.”</i>
     * 
     * @param voiceAssistantBlocked
     *            new value of {@code voiceAssistantBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code voiceAssistantBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withVoiceAssistantBlocked(Boolean voiceAssistantBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("voiceAssistantBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.voiceAssistantBlocked = voiceAssistantBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block voice dialing.”</i>
     * 
     * @return property voiceDialingBlocked
     */
    @Property(name="voiceDialingBlocked")
    @JsonIgnore
    public Optional<Boolean> getVoiceDialingBlocked() {
        return Optional.ofNullable(voiceDialingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * voiceDialingBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block voice dialing.”</i>
     * 
     * @param voiceDialingBlocked
     *            new value of {@code voiceDialingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code voiceDialingBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withVoiceDialingBlocked(Boolean voiceDialingBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("voiceDialingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.voiceDialingBlocked = voiceDialingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the web browser's auto fill feature.”</i>
     * 
     * @return property webBrowserBlockAutofill
     */
    @Property(name="webBrowserBlockAutofill")
    @JsonIgnore
    public Optional<Boolean> getWebBrowserBlockAutofill() {
        return Optional.ofNullable(webBrowserBlockAutofill);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * webBrowserBlockAutofill} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the web browser's auto fill feature.”</i>
     * 
     * @param webBrowserBlockAutofill
     *            new value of {@code webBrowserBlockAutofill} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webBrowserBlockAutofill} field changed
     */
    public AndroidGeneralDeviceConfiguration withWebBrowserBlockAutofill(Boolean webBrowserBlockAutofill) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webBrowserBlockAutofill");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.webBrowserBlockAutofill = webBrowserBlockAutofill;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the web browser.”</i>
     * 
     * @return property webBrowserBlocked
     */
    @Property(name="webBrowserBlocked")
    @JsonIgnore
    public Optional<Boolean> getWebBrowserBlocked() {
        return Optional.ofNullable(webBrowserBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code webBrowserBlocked
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block the web browser.”</i>
     * 
     * @param webBrowserBlocked
     *            new value of {@code webBrowserBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webBrowserBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withWebBrowserBlocked(Boolean webBrowserBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webBrowserBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.webBrowserBlocked = webBrowserBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block JavaScript within the web browser.”</i>
     * 
     * @return property webBrowserBlockJavaScript
     */
    @Property(name="webBrowserBlockJavaScript")
    @JsonIgnore
    public Optional<Boolean> getWebBrowserBlockJavaScript() {
        return Optional.ofNullable(webBrowserBlockJavaScript);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * webBrowserBlockJavaScript} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block JavaScript within the web browser.”</i>
     * 
     * @param webBrowserBlockJavaScript
     *            new value of {@code webBrowserBlockJavaScript} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webBrowserBlockJavaScript} field changed
     */
    public AndroidGeneralDeviceConfiguration withWebBrowserBlockJavaScript(Boolean webBrowserBlockJavaScript) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webBrowserBlockJavaScript");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.webBrowserBlockJavaScript = webBrowserBlockJavaScript;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block popups within the web browser.”</i>
     * 
     * @return property webBrowserBlockPopups
     */
    @Property(name="webBrowserBlockPopups")
    @JsonIgnore
    public Optional<Boolean> getWebBrowserBlockPopups() {
        return Optional.ofNullable(webBrowserBlockPopups);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * webBrowserBlockPopups} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block popups within the web browser.”</i>
     * 
     * @param webBrowserBlockPopups
     *            new value of {@code webBrowserBlockPopups} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webBrowserBlockPopups} field changed
     */
    public AndroidGeneralDeviceConfiguration withWebBrowserBlockPopups(Boolean webBrowserBlockPopups) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webBrowserBlockPopups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.webBrowserBlockPopups = webBrowserBlockPopups;
        return _x;
    }

    /**
     * <i>“Cookie settings within the web browser.”</i>
     * 
     * @return property webBrowserCookieSettings
     */
    @Property(name="webBrowserCookieSettings")
    @JsonIgnore
    public Optional<WebBrowserCookieSettings> getWebBrowserCookieSettings() {
        return Optional.ofNullable(webBrowserCookieSettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * webBrowserCookieSettings} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Cookie settings within the web browser.”</i>
     * 
     * @param webBrowserCookieSettings
     *            new value of {@code webBrowserCookieSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webBrowserCookieSettings} field changed
     */
    public AndroidGeneralDeviceConfiguration withWebBrowserCookieSettings(WebBrowserCookieSettings webBrowserCookieSettings) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("webBrowserCookieSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.webBrowserCookieSettings = webBrowserCookieSettings;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block syncing Wi-Fi.”</i>
     * 
     * @return property wiFiBlocked
     */
    @Property(name="wiFiBlocked")
    @JsonIgnore
    public Optional<Boolean> getWiFiBlocked() {
        return Optional.ofNullable(wiFiBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wiFiBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to block syncing Wi-Fi.”</i>
     * 
     * @param wiFiBlocked
     *            new value of {@code wiFiBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiBlocked} field changed
     */
    public AndroidGeneralDeviceConfiguration withWiFiBlocked(Boolean wiFiBlocked) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidGeneralDeviceConfiguration");
        _x.wiFiBlocked = wiFiBlocked;
        return _x;
    }

    public AndroidGeneralDeviceConfiguration withUnmappedField(String name, Object value) {
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidGeneralDeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidGeneralDeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidGeneralDeviceConfiguration _copy() {
        AndroidGeneralDeviceConfiguration _x = new AndroidGeneralDeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.appsBlockClipboardSharing = appsBlockClipboardSharing;
        _x.appsBlockCopyPaste = appsBlockCopyPaste;
        _x.appsBlockYouTube = appsBlockYouTube;
        _x.appsHideList = appsHideList;
        _x.appsInstallAllowList = appsInstallAllowList;
        _x.appsLaunchBlockList = appsLaunchBlockList;
        _x.bluetoothBlocked = bluetoothBlocked;
        _x.cameraBlocked = cameraBlocked;
        _x.cellularBlockDataRoaming = cellularBlockDataRoaming;
        _x.cellularBlockMessaging = cellularBlockMessaging;
        _x.cellularBlockVoiceRoaming = cellularBlockVoiceRoaming;
        _x.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
        _x.compliantAppListType = compliantAppListType;
        _x.compliantAppsList = compliantAppsList;
        _x.dateAndTimeBlockChanges = dateAndTimeBlockChanges;
        _x.deviceSharingAllowed = deviceSharingAllowed;
        _x.diagnosticDataBlockSubmission = diagnosticDataBlockSubmission;
        _x.factoryResetBlocked = factoryResetBlocked;
        _x.googleAccountBlockAutoSync = googleAccountBlockAutoSync;
        _x.googlePlayStoreBlocked = googlePlayStoreBlocked;
        _x.kioskModeApps = kioskModeApps;
        _x.kioskModeBlockSleepButton = kioskModeBlockSleepButton;
        _x.kioskModeBlockVolumeButtons = kioskModeBlockVolumeButtons;
        _x.locationServicesBlocked = locationServicesBlocked;
        _x.nfcBlocked = nfcBlocked;
        _x.passwordBlockFingerprintUnlock = passwordBlockFingerprintUnlock;
        _x.passwordBlockTrustAgents = passwordBlockTrustAgents;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordPreviousPasswordBlockCount = passwordPreviousPasswordBlockCount;
        _x.passwordRequired = passwordRequired;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        _x.powerOffBlocked = powerOffBlocked;
        _x.requiredPasswordComplexity = requiredPasswordComplexity;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.securityRequireVerifyApps = securityRequireVerifyApps;
        _x.storageBlockGoogleBackup = storageBlockGoogleBackup;
        _x.storageBlockRemovableStorage = storageBlockRemovableStorage;
        _x.storageRequireDeviceEncryption = storageRequireDeviceEncryption;
        _x.storageRequireRemovableStorageEncryption = storageRequireRemovableStorageEncryption;
        _x.voiceAssistantBlocked = voiceAssistantBlocked;
        _x.voiceDialingBlocked = voiceDialingBlocked;
        _x.webBrowserBlockAutofill = webBrowserBlockAutofill;
        _x.webBrowserBlocked = webBrowserBlocked;
        _x.webBrowserBlockJavaScript = webBrowserBlockJavaScript;
        _x.webBrowserBlockPopups = webBrowserBlockPopups;
        _x.webBrowserCookieSettings = webBrowserCookieSettings;
        _x.wiFiBlocked = wiFiBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidGeneralDeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("appsBlockClipboardSharing=");
        b.append(this.appsBlockClipboardSharing);
        b.append(", ");
        b.append("appsBlockCopyPaste=");
        b.append(this.appsBlockCopyPaste);
        b.append(", ");
        b.append("appsBlockYouTube=");
        b.append(this.appsBlockYouTube);
        b.append(", ");
        b.append("appsHideList=");
        b.append(this.appsHideList);
        b.append(", ");
        b.append("appsInstallAllowList=");
        b.append(this.appsInstallAllowList);
        b.append(", ");
        b.append("appsLaunchBlockList=");
        b.append(this.appsLaunchBlockList);
        b.append(", ");
        b.append("bluetoothBlocked=");
        b.append(this.bluetoothBlocked);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("cellularBlockDataRoaming=");
        b.append(this.cellularBlockDataRoaming);
        b.append(", ");
        b.append("cellularBlockMessaging=");
        b.append(this.cellularBlockMessaging);
        b.append(", ");
        b.append("cellularBlockVoiceRoaming=");
        b.append(this.cellularBlockVoiceRoaming);
        b.append(", ");
        b.append("cellularBlockWiFiTethering=");
        b.append(this.cellularBlockWiFiTethering);
        b.append(", ");
        b.append("compliantAppListType=");
        b.append(this.compliantAppListType);
        b.append(", ");
        b.append("compliantAppsList=");
        b.append(this.compliantAppsList);
        b.append(", ");
        b.append("dateAndTimeBlockChanges=");
        b.append(this.dateAndTimeBlockChanges);
        b.append(", ");
        b.append("deviceSharingAllowed=");
        b.append(this.deviceSharingAllowed);
        b.append(", ");
        b.append("diagnosticDataBlockSubmission=");
        b.append(this.diagnosticDataBlockSubmission);
        b.append(", ");
        b.append("factoryResetBlocked=");
        b.append(this.factoryResetBlocked);
        b.append(", ");
        b.append("googleAccountBlockAutoSync=");
        b.append(this.googleAccountBlockAutoSync);
        b.append(", ");
        b.append("googlePlayStoreBlocked=");
        b.append(this.googlePlayStoreBlocked);
        b.append(", ");
        b.append("kioskModeApps=");
        b.append(this.kioskModeApps);
        b.append(", ");
        b.append("kioskModeBlockSleepButton=");
        b.append(this.kioskModeBlockSleepButton);
        b.append(", ");
        b.append("kioskModeBlockVolumeButtons=");
        b.append(this.kioskModeBlockVolumeButtons);
        b.append(", ");
        b.append("locationServicesBlocked=");
        b.append(this.locationServicesBlocked);
        b.append(", ");
        b.append("nfcBlocked=");
        b.append(this.nfcBlocked);
        b.append(", ");
        b.append("passwordBlockFingerprintUnlock=");
        b.append(this.passwordBlockFingerprintUnlock);
        b.append(", ");
        b.append("passwordBlockTrustAgents=");
        b.append(this.passwordBlockTrustAgents);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordPreviousPasswordBlockCount=");
        b.append(this.passwordPreviousPasswordBlockCount);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordSignInFailureCountBeforeFactoryReset=");
        b.append(this.passwordSignInFailureCountBeforeFactoryReset);
        b.append(", ");
        b.append("powerOffBlocked=");
        b.append(this.powerOffBlocked);
        b.append(", ");
        b.append("requiredPasswordComplexity=");
        b.append(this.requiredPasswordComplexity);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("securityRequireVerifyApps=");
        b.append(this.securityRequireVerifyApps);
        b.append(", ");
        b.append("storageBlockGoogleBackup=");
        b.append(this.storageBlockGoogleBackup);
        b.append(", ");
        b.append("storageBlockRemovableStorage=");
        b.append(this.storageBlockRemovableStorage);
        b.append(", ");
        b.append("storageRequireDeviceEncryption=");
        b.append(this.storageRequireDeviceEncryption);
        b.append(", ");
        b.append("storageRequireRemovableStorageEncryption=");
        b.append(this.storageRequireRemovableStorageEncryption);
        b.append(", ");
        b.append("voiceAssistantBlocked=");
        b.append(this.voiceAssistantBlocked);
        b.append(", ");
        b.append("voiceDialingBlocked=");
        b.append(this.voiceDialingBlocked);
        b.append(", ");
        b.append("webBrowserBlockAutofill=");
        b.append(this.webBrowserBlockAutofill);
        b.append(", ");
        b.append("webBrowserBlocked=");
        b.append(this.webBrowserBlocked);
        b.append(", ");
        b.append("webBrowserBlockJavaScript=");
        b.append(this.webBrowserBlockJavaScript);
        b.append(", ");
        b.append("webBrowserBlockPopups=");
        b.append(this.webBrowserBlockPopups);
        b.append(", ");
        b.append("webBrowserCookieSettings=");
        b.append(this.webBrowserCookieSettings);
        b.append(", ");
        b.append("wiFiBlocked=");
        b.append(this.wiFiBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
