package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;
import odata.msgraph.client.beta.enums.SubjectNameFormat;


/**
 * <i>“Android For Work PKCS certificate profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certificateTemplateName", 
    "certificationAuthority", 
    "certificationAuthorityName", 
    "subjectAlternativeNameFormatString"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkPkcsCertificateProfile extends AndroidForWorkCertificateProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkPkcsCertificateProfile";
    }

    @JsonProperty("certificateTemplateName")
    protected String certificateTemplateName;

    @JsonProperty("certificationAuthority")
    protected String certificationAuthority;

    @JsonProperty("certificationAuthorityName")
    protected String certificationAuthorityName;

    @JsonProperty("subjectAlternativeNameFormatString")
    protected String subjectAlternativeNameFormatString;

    protected AndroidForWorkPkcsCertificateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidForWorkPkcsCertificateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private CertificateValidityPeriodScale certificateValidityPeriodScale;
        private Integer certificateValidityPeriodValue;
        private List<ExtendedKeyUsage> extendedKeyUsages;
        private String extendedKeyUsagesNextLink;
        private Integer renewalThresholdPercentage;
        private SubjectAlternativeNameType subjectAlternativeNameType;
        private SubjectNameFormat subjectNameFormat;
        private String certificateTemplateName;
        private String certificationAuthority;
        private String certificationAuthorityName;
        private String subjectAlternativeNameFormatString;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        public Builder certificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
            this.certificateValidityPeriodScale = certificateValidityPeriodScale;
            this.changedFields = changedFields.add("certificateValidityPeriodScale");
            return this;
        }

        public Builder certificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
            this.certificateValidityPeriodValue = certificateValidityPeriodValue;
            this.changedFields = changedFields.add("certificateValidityPeriodValue");
            return this;
        }

        public Builder extendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = extendedKeyUsages;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder extendedKeyUsages(ExtendedKeyUsage... extendedKeyUsages) {
            return extendedKeyUsages(Arrays.asList(extendedKeyUsages));
        }

        public Builder extendedKeyUsagesNextLink(String extendedKeyUsagesNextLink) {
            this.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder renewalThresholdPercentage(Integer renewalThresholdPercentage) {
            this.renewalThresholdPercentage = renewalThresholdPercentage;
            this.changedFields = changedFields.add("renewalThresholdPercentage");
            return this;
        }

        public Builder subjectAlternativeNameType(SubjectAlternativeNameType subjectAlternativeNameType) {
            this.subjectAlternativeNameType = subjectAlternativeNameType;
            this.changedFields = changedFields.add("subjectAlternativeNameType");
            return this;
        }

        public Builder subjectNameFormat(SubjectNameFormat subjectNameFormat) {
            this.subjectNameFormat = subjectNameFormat;
            this.changedFields = changedFields.add("subjectNameFormat");
            return this;
        }

        /**
         * <i>“PKCS Certificate Template Name”</i>
         * 
         * @param certificateTemplateName
         *            value of {@code certificateTemplateName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateTemplateName(String certificateTemplateName) {
            this.certificateTemplateName = certificateTemplateName;
            this.changedFields = changedFields.add("certificateTemplateName");
            return this;
        }

        /**
         * <i>“PKCS Certification Authority”</i>
         * 
         * @param certificationAuthority
         *            value of {@code certificationAuthority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthority(String certificationAuthority) {
            this.certificationAuthority = certificationAuthority;
            this.changedFields = changedFields.add("certificationAuthority");
            return this;
        }

        /**
         * <i>“PKCS Certification Authority Name”</i>
         * 
         * @param certificationAuthorityName
         *            value of {@code certificationAuthorityName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthorityName(String certificationAuthorityName) {
            this.certificationAuthorityName = certificationAuthorityName;
            this.changedFields = changedFields.add("certificationAuthorityName");
            return this;
        }

        /**
         * <i>“Custom String that defines the AAD Attribute.”</i>
         * 
         * @param subjectAlternativeNameFormatString
         *            value of {@code subjectAlternativeNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectAlternativeNameFormatString(String subjectAlternativeNameFormatString) {
            this.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
            this.changedFields = changedFields.add("subjectAlternativeNameFormatString");
            return this;
        }

        public AndroidForWorkPkcsCertificateProfile build() {
            AndroidForWorkPkcsCertificateProfile _x = new AndroidForWorkPkcsCertificateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidForWorkPkcsCertificateProfile";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
            _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
            _x.extendedKeyUsages = extendedKeyUsages;
            _x.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            _x.renewalThresholdPercentage = renewalThresholdPercentage;
            _x.subjectAlternativeNameType = subjectAlternativeNameType;
            _x.subjectNameFormat = subjectNameFormat;
            _x.certificateTemplateName = certificateTemplateName;
            _x.certificationAuthority = certificationAuthority;
            _x.certificationAuthorityName = certificationAuthorityName;
            _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“PKCS Certificate Template Name”</i>
     * 
     * @return property certificateTemplateName
     */
    @Property(name="certificateTemplateName")
    @JsonIgnore
    public Optional<String> getCertificateTemplateName() {
        return Optional.ofNullable(certificateTemplateName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateTemplateName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certificate Template Name”</i>
     * 
     * @param certificateTemplateName
     *            new value of {@code certificateTemplateName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateTemplateName} field changed
     */
    public AndroidForWorkPkcsCertificateProfile withCertificateTemplateName(String certificateTemplateName) {
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateTemplateName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkPkcsCertificateProfile");
        _x.certificateTemplateName = certificateTemplateName;
        return _x;
    }

    /**
     * <i>“PKCS Certification Authority”</i>
     * 
     * @return property certificationAuthority
     */
    @Property(name="certificationAuthority")
    @JsonIgnore
    public Optional<String> getCertificationAuthority() {
        return Optional.ofNullable(certificationAuthority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthority} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certification Authority”</i>
     * 
     * @param certificationAuthority
     *            new value of {@code certificationAuthority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthority} field changed
     */
    public AndroidForWorkPkcsCertificateProfile withCertificationAuthority(String certificationAuthority) {
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificationAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkPkcsCertificateProfile");
        _x.certificationAuthority = certificationAuthority;
        return _x;
    }

    /**
     * <i>“PKCS Certification Authority Name”</i>
     * 
     * @return property certificationAuthorityName
     */
    @Property(name="certificationAuthorityName")
    @JsonIgnore
    public Optional<String> getCertificationAuthorityName() {
        return Optional.ofNullable(certificationAuthorityName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthorityName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certification Authority Name”</i>
     * 
     * @param certificationAuthorityName
     *            new value of {@code certificationAuthorityName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthorityName} field changed
     */
    public AndroidForWorkPkcsCertificateProfile withCertificationAuthorityName(String certificationAuthorityName) {
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificationAuthorityName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkPkcsCertificateProfile");
        _x.certificationAuthorityName = certificationAuthorityName;
        return _x;
    }

    /**
     * <i>“Custom String that defines the AAD Attribute.”</i>
     * 
     * @return property subjectAlternativeNameFormatString
     */
    @Property(name="subjectAlternativeNameFormatString")
    @JsonIgnore
    public Optional<String> getSubjectAlternativeNameFormatString() {
        return Optional.ofNullable(subjectAlternativeNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectAlternativeNameFormatString} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Custom String that defines the AAD Attribute.”</i>
     * 
     * @param subjectAlternativeNameFormatString
     *            new value of {@code subjectAlternativeNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectAlternativeNameFormatString} field changed
     */
    public AndroidForWorkPkcsCertificateProfile withSubjectAlternativeNameFormatString(String subjectAlternativeNameFormatString) {
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectAlternativeNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkPkcsCertificateProfile");
        _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
        return _x;
    }

    public AndroidForWorkPkcsCertificateProfile withUnmappedField(String name, Object value) {
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Certificate state for devices. This collection can contain a maximum of
     * 2147483647 elements.”</i>
     * 
     * @return navigational property managedDeviceCertificateStates
     */
    @NavigationProperty(name="managedDeviceCertificateStates")
    @JsonIgnore
    public ManagedDeviceCertificateStateCollectionRequest getManagedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"), RequestHelper.getValue(unmappedFields, "managedDeviceCertificateStates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkPkcsCertificateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkPkcsCertificateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkPkcsCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkPkcsCertificateProfile _copy() {
        AndroidForWorkPkcsCertificateProfile _x = new AndroidForWorkPkcsCertificateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.subjectNameFormat = subjectNameFormat;
        _x.certificateTemplateName = certificateTemplateName;
        _x.certificationAuthority = certificationAuthority;
        _x.certificationAuthorityName = certificationAuthorityName;
        _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkPkcsCertificateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("certificateTemplateName=");
        b.append(this.certificateTemplateName);
        b.append(", ");
        b.append("certificationAuthority=");
        b.append(this.certificationAuthority);
        b.append(", ");
        b.append("certificationAuthorityName=");
        b.append(this.certificationAuthorityName);
        b.append(", ");
        b.append("subjectAlternativeNameFormatString=");
        b.append(this.subjectAlternativeNameFormatString);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
