package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AndroidPermissionAction;
import odata.msgraph.client.beta.enums.AndroidProfileApplicability;


/**
 * <i>“Contains properties, inherited properties and actions for AFW mobile app
 * configurations.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "connectedAppsEnabled", 
    "packageId", 
    "payloadJson", 
    "permissionActions", 
    "profileApplicability"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkMobileAppConfiguration extends ManagedDeviceMobileAppConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkMobileAppConfiguration";
    }

    @JsonProperty("connectedAppsEnabled")
    protected Boolean connectedAppsEnabled;

    @JsonProperty("packageId")
    protected String packageId;

    @JsonProperty("payloadJson")
    protected String payloadJson;

    @JsonProperty("permissionActions")
    protected List<AndroidPermissionAction> permissionActions;

    @JsonProperty("permissionActions@nextLink")
    protected String permissionActionsNextLink;

    @JsonProperty("profileApplicability")
    protected AndroidProfileApplicability profileApplicability;

    protected AndroidForWorkMobileAppConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidForWorkMobileAppConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private List<String> targetedMobileApps;
        private String targetedMobileAppsNextLink;
        private Integer version;
        private List<ManagedDeviceMobileAppConfigurationAssignment> assignments;
        private List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses;
        private ManagedDeviceMobileAppConfigurationDeviceSummary deviceStatusSummary;
        private List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses;
        private ManagedDeviceMobileAppConfigurationUserSummary userStatusSummary;
        private Boolean connectedAppsEnabled;
        private String packageId;
        private String payloadJson;
        private List<AndroidPermissionAction> permissionActions;
        private String permissionActionsNextLink;
        private AndroidProfileApplicability profileApplicability;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder targetedMobileApps(List<String> targetedMobileApps) {
            this.targetedMobileApps = targetedMobileApps;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        public Builder targetedMobileApps(String... targetedMobileApps) {
            return targetedMobileApps(Arrays.asList(targetedMobileApps));
        }

        public Builder targetedMobileAppsNextLink(String targetedMobileAppsNextLink) {
            this.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<ManagedDeviceMobileAppConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(ManagedDeviceMobileAppConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceStatuses(List<ManagedDeviceMobileAppConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(ManagedDeviceMobileAppConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusSummary(ManagedDeviceMobileAppConfigurationDeviceSummary deviceStatusSummary) {
            this.deviceStatusSummary = deviceStatusSummary;
            this.changedFields = changedFields.add("deviceStatusSummary");
            return this;
        }

        public Builder userStatuses(List<ManagedDeviceMobileAppConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(ManagedDeviceMobileAppConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusSummary(ManagedDeviceMobileAppConfigurationUserSummary userStatusSummary) {
            this.userStatusSummary = userStatusSummary;
            this.changedFields = changedFields.add("userStatusSummary");
            return this;
        }

        /**
         * <i>“Setting to specify whether to allow ConnectedApps experience for this app.”</i>
         * 
         * @param connectedAppsEnabled
         *            value of {@code connectedAppsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectedAppsEnabled(Boolean connectedAppsEnabled) {
            this.connectedAppsEnabled = connectedAppsEnabled;
            this.changedFields = changedFields.add("connectedAppsEnabled");
            return this;
        }

        /**
         * <i>“Android For Work app configuration package id.”</i>
         * 
         * @param packageId
         *            value of {@code packageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder packageId(String packageId) {
            this.packageId = packageId;
            this.changedFields = changedFields.add("packageId");
            return this;
        }

        /**
         * <i>“Android For Work app configuration JSON payload.”</i>
         * 
         * @param payloadJson
         *            value of {@code payloadJson} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder payloadJson(String payloadJson) {
            this.payloadJson = payloadJson;
            this.changedFields = changedFields.add("payloadJson");
            return this;
        }

        /**
         * <i>“List of Android app permissions and corresponding permission actions.”</i>
         * 
         * @param permissionActions
         *            value of {@code permissionActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissionActions(List<AndroidPermissionAction> permissionActions) {
            this.permissionActions = permissionActions;
            this.changedFields = changedFields.add("permissionActions");
            return this;
        }

        /**
         * <i>“List of Android app permissions and corresponding permission actions.”</i>
         * 
         * @param permissionActions
         *            value of {@code permissionActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissionActions(AndroidPermissionAction... permissionActions) {
            return permissionActions(Arrays.asList(permissionActions));
        }

        /**
         * <i>“List of Android app permissions and corresponding permission actions.”</i>
         * 
         * @param permissionActionsNextLink
         *            value of {@code permissionActions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissionActionsNextLink(String permissionActionsNextLink) {
            this.permissionActionsNextLink = permissionActionsNextLink;
            this.changedFields = changedFields.add("permissionActions");
            return this;
        }

        /**
         * <i>“Android Enterprise profile applicability (AndroidWorkProfile, DeviceOwner, or
         * default (applies to both)).”</i>
         * 
         * @param profileApplicability
         *            value of {@code profileApplicability} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder profileApplicability(AndroidProfileApplicability profileApplicability) {
            this.profileApplicability = profileApplicability;
            this.changedFields = changedFields.add("profileApplicability");
            return this;
        }

        public AndroidForWorkMobileAppConfiguration build() {
            AndroidForWorkMobileAppConfiguration _x = new AndroidForWorkMobileAppConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidForWorkMobileAppConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.targetedMobileApps = targetedMobileApps;
            _x.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusSummary = deviceStatusSummary;
            _x.userStatuses = userStatuses;
            _x.userStatusSummary = userStatusSummary;
            _x.connectedAppsEnabled = connectedAppsEnabled;
            _x.packageId = packageId;
            _x.payloadJson = payloadJson;
            _x.permissionActions = permissionActions;
            _x.permissionActionsNextLink = permissionActionsNextLink;
            _x.profileApplicability = profileApplicability;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Setting to specify whether to allow ConnectedApps experience for this app.”</i>
     * 
     * @return property connectedAppsEnabled
     */
    @Property(name="connectedAppsEnabled")
    @JsonIgnore
    public Optional<Boolean> getConnectedAppsEnabled() {
        return Optional.ofNullable(connectedAppsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectedAppsEnabled} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Setting to specify whether to allow ConnectedApps experience for this app.”</i>
     * 
     * @param connectedAppsEnabled
     *            new value of {@code connectedAppsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectedAppsEnabled} field changed
     */
    public AndroidForWorkMobileAppConfiguration withConnectedAppsEnabled(Boolean connectedAppsEnabled) {
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectedAppsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkMobileAppConfiguration");
        _x.connectedAppsEnabled = connectedAppsEnabled;
        return _x;
    }

    /**
     * <i>“Android For Work app configuration package id.”</i>
     * 
     * @return property packageId
     */
    @Property(name="packageId")
    @JsonIgnore
    public Optional<String> getPackageId() {
        return Optional.ofNullable(packageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code packageId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Android For Work app configuration package id.”</i>
     * 
     * @param packageId
     *            new value of {@code packageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code packageId} field changed
     */
    public AndroidForWorkMobileAppConfiguration withPackageId(String packageId) {
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("packageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkMobileAppConfiguration");
        _x.packageId = packageId;
        return _x;
    }

    /**
     * <i>“Android For Work app configuration JSON payload.”</i>
     * 
     * @return property payloadJson
     */
    @Property(name="payloadJson")
    @JsonIgnore
    public Optional<String> getPayloadJson() {
        return Optional.ofNullable(payloadJson);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payloadJson}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Android For Work app configuration JSON payload.”</i>
     * 
     * @param payloadJson
     *            new value of {@code payloadJson} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payloadJson} field changed
     */
    public AndroidForWorkMobileAppConfiguration withPayloadJson(String payloadJson) {
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("payloadJson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkMobileAppConfiguration");
        _x.payloadJson = payloadJson;
        return _x;
    }

    /**
     * <i>“List of Android app permissions and corresponding permission actions.”</i>
     * 
     * @return property permissionActions
     */
    @Property(name="permissionActions")
    @JsonIgnore
    public CollectionPage<AndroidPermissionAction> getPermissionActions() {
        return new CollectionPage<AndroidPermissionAction>(contextPath, AndroidPermissionAction.class, this.permissionActions, Optional.ofNullable(permissionActionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code permissionActions
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Android app permissions and corresponding permission actions.”</i>
     * 
     * @param permissionActions
     *            new value of {@code permissionActions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code permissionActions} field changed
     */
    public AndroidForWorkMobileAppConfiguration withPermissionActions(List<AndroidPermissionAction> permissionActions) {
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("permissionActions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkMobileAppConfiguration");
        _x.permissionActions = permissionActions;
        return _x;
    }

    /**
     * <i>“List of Android app permissions and corresponding permission actions.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property permissionActions
     */
    @Property(name="permissionActions")
    @JsonIgnore
    public CollectionPage<AndroidPermissionAction> getPermissionActions(HttpRequestOptions options) {
        return new CollectionPage<AndroidPermissionAction>(contextPath, AndroidPermissionAction.class, this.permissionActions, Optional.ofNullable(permissionActionsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Android Enterprise profile applicability (AndroidWorkProfile, DeviceOwner, or
     * default (applies to both)).”</i>
     * 
     * @return property profileApplicability
     */
    @Property(name="profileApplicability")
    @JsonIgnore
    public Optional<AndroidProfileApplicability> getProfileApplicability() {
        return Optional.ofNullable(profileApplicability);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * profileApplicability} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Android Enterprise profile applicability (AndroidWorkProfile, DeviceOwner, or
     * default (applies to both)).”</i>
     * 
     * @param profileApplicability
     *            new value of {@code profileApplicability} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code profileApplicability} field changed
     */
    public AndroidForWorkMobileAppConfiguration withProfileApplicability(AndroidProfileApplicability profileApplicability) {
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = changedFields.add("profileApplicability");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkMobileAppConfiguration");
        _x.profileApplicability = profileApplicability;
        return _x;
    }

    public AndroidForWorkMobileAppConfiguration withUnmappedField(String name, Object value) {
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkMobileAppConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkMobileAppConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkMobileAppConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkMobileAppConfiguration _copy() {
        AndroidForWorkMobileAppConfiguration _x = new AndroidForWorkMobileAppConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.targetedMobileApps = targetedMobileApps;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusSummary = deviceStatusSummary;
        _x.userStatuses = userStatuses;
        _x.userStatusSummary = userStatusSummary;
        _x.connectedAppsEnabled = connectedAppsEnabled;
        _x.packageId = packageId;
        _x.payloadJson = payloadJson;
        _x.permissionActions = permissionActions;
        _x.profileApplicability = profileApplicability;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkMobileAppConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("targetedMobileApps=");
        b.append(this.targetedMobileApps);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusSummary=");
        b.append(this.deviceStatusSummary);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusSummary=");
        b.append(this.userStatusSummary);
        b.append(", ");
        b.append("connectedAppsEnabled=");
        b.append(this.connectedAppsEnabled);
        b.append(", ");
        b.append("packageId=");
        b.append(this.packageId);
        b.append(", ");
        b.append("payloadJson=");
        b.append(this.payloadJson);
        b.append(", ");
        b.append("permissionActions=");
        b.append(this.permissionActions);
        b.append(", ");
        b.append("profileApplicability=");
        b.append(this.profileApplicability);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
