package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AndroidForWorkCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.AndroidUsernameSource;
import odata.msgraph.client.beta.enums.EasAuthenticationMethod;
import odata.msgraph.client.beta.enums.EmailSyncDuration;
import odata.msgraph.client.beta.enums.UserEmailSource;


/**
 * <i>“Base for Android For Work EAS Email profiles”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "authenticationMethod", 
    "durationOfEmailToSync", 
    "emailAddressSource", 
    "hostName", 
    "requireSsl", 
    "usernameSource"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkEasEmailProfileBase extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkEasEmailProfileBase";
    }

    @JsonProperty("authenticationMethod")
    protected EasAuthenticationMethod authenticationMethod;

    @JsonProperty("durationOfEmailToSync")
    protected EmailSyncDuration durationOfEmailToSync;

    @JsonProperty("emailAddressSource")
    protected UserEmailSource emailAddressSource;

    @JsonProperty("hostName")
    protected String hostName;

    @JsonProperty("requireSsl")
    protected Boolean requireSsl;

    @JsonProperty("usernameSource")
    protected AndroidUsernameSource usernameSource;

    protected AndroidForWorkEasEmailProfileBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Authentication method for Exchange ActiveSync.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<EasAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method for Exchange ActiveSync.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AndroidForWorkEasEmailProfileBase withAuthenticationMethod(EasAuthenticationMethod authenticationMethod) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkEasEmailProfileBase");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Duration of time email should be synced to.”</i>
     * 
     * @return property durationOfEmailToSync
     */
    @Property(name="durationOfEmailToSync")
    @JsonIgnore
    public Optional<EmailSyncDuration> getDurationOfEmailToSync() {
        return Optional.ofNullable(durationOfEmailToSync);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * durationOfEmailToSync} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Duration of time email should be synced to.”</i>
     * 
     * @param durationOfEmailToSync
     *            new value of {@code durationOfEmailToSync} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code durationOfEmailToSync} field changed
     */
    public AndroidForWorkEasEmailProfileBase withDurationOfEmailToSync(EmailSyncDuration durationOfEmailToSync) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = changedFields.add("durationOfEmailToSync");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkEasEmailProfileBase");
        _x.durationOfEmailToSync = durationOfEmailToSync;
        return _x;
    }

    /**
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property emailAddressSource
     */
    @Property(name="emailAddressSource")
    @JsonIgnore
    public Optional<UserEmailSource> getEmailAddressSource() {
        return Optional.ofNullable(emailAddressSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * emailAddressSource} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Email attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param emailAddressSource
     *            new value of {@code emailAddressSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code emailAddressSource} field changed
     */
    public AndroidForWorkEasEmailProfileBase withEmailAddressSource(UserEmailSource emailAddressSource) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = changedFields.add("emailAddressSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkEasEmailProfileBase");
        _x.emailAddressSource = emailAddressSource;
        return _x;
    }

    /**
     * <i>“Exchange location (URL) that the mail app connects to.”</i>
     * 
     * @return property hostName
     */
    @Property(name="hostName")
    @JsonIgnore
    public Optional<String> getHostName() {
        return Optional.ofNullable(hostName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hostName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Exchange location (URL) that the mail app connects to.”</i>
     * 
     * @param hostName
     *            new value of {@code hostName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hostName} field changed
     */
    public AndroidForWorkEasEmailProfileBase withHostName(String hostName) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = changedFields.add("hostName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkEasEmailProfileBase");
        _x.hostName = hostName;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @return property requireSsl
     */
    @Property(name="requireSsl")
    @JsonIgnore
    public Optional<Boolean> getRequireSsl() {
        return Optional.ofNullable(requireSsl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requireSsl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates whether or not to use SSL.”</i>
     * 
     * @param requireSsl
     *            new value of {@code requireSsl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireSsl} field changed
     */
    public AndroidForWorkEasEmailProfileBase withRequireSsl(Boolean requireSsl) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = changedFields.add("requireSsl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkEasEmailProfileBase");
        _x.requireSsl = requireSsl;
        return _x;
    }

    /**
     * <i>“Username attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @return property usernameSource
     */
    @Property(name="usernameSource")
    @JsonIgnore
    public Optional<AndroidUsernameSource> getUsernameSource() {
        return Optional.ofNullable(usernameSource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usernameSource}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Username attribute that is picked from AAD and injected into this profile before
     * installing on the device.”</i>
     * 
     * @param usernameSource
     *            new value of {@code usernameSource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usernameSource} field changed
     */
    public AndroidForWorkEasEmailProfileBase withUsernameSource(AndroidUsernameSource usernameSource) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = changedFields.add("usernameSource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkEasEmailProfileBase");
        _x.usernameSource = usernameSource;
        return _x;
    }

    public AndroidForWorkEasEmailProfileBase withUnmappedField(String name, Object value) {
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Identity certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public AndroidForWorkCertificateProfileBaseRequest getIdentityCertificate() {
        return new AndroidForWorkCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"), RequestHelper.getValue(unmappedFields, "identityCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkEasEmailProfileBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkEasEmailProfileBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkEasEmailProfileBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkEasEmailProfileBase _copy() {
        AndroidForWorkEasEmailProfileBase _x = new AndroidForWorkEasEmailProfileBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.authenticationMethod = authenticationMethod;
        _x.durationOfEmailToSync = durationOfEmailToSync;
        _x.emailAddressSource = emailAddressSource;
        _x.hostName = hostName;
        _x.requireSsl = requireSsl;
        _x.usernameSource = usernameSource;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkEasEmailProfileBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("durationOfEmailToSync=");
        b.append(this.durationOfEmailToSync);
        b.append(", ");
        b.append("emailAddressSource=");
        b.append(this.emailAddressSource);
        b.append(", ");
        b.append("hostName=");
        b.append(this.hostName);
        b.append(", ");
        b.append("requireSsl=");
        b.append(this.requireSsl);
        b.append(", ");
        b.append("usernameSource=");
        b.append(this.usernameSource);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
